/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.net.NetworkConnection;
import com.evermind.net.SocketNetworkConnection;
import com.evermind.security.User;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSProvider;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.JMSServerProxy;
import com.evermind.server.jms.JMSStats;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.NList;
import com.evermind.server.jms.SessionID;
import com.evermind.server.jms.Tset;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;

final class TCPHandler
implements Runnable {
    private final JMSServer server;
    private NetworkConnection connection = null;
    private final DataInputStream dinp;
    private final DataOutputStream dout;
    private final String hostName;
    private final int port;
    final NList.Node serverLink = new NList.Node(this);
    private static final int BUFSIZE = Math.max(8192, (Integer)JMSServerProxy.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.socketBufsize"));
    private final Tset isOpen = new Tset(true);
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(TCPHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TCPHandler(JMSServer server, NetworkConnection connection) throws IOException {
        this.server = server;
        this.connection = connection;
        this.hostName = connection.getInetAddress().getHostName();
        this.port = connection.getPort();
        boolean success = false;
        try {
            if (connection instanceof SocketNetworkConnection) {
                Socket socket = ((SocketNetworkConnection)connection).getSocket();
                socket.setReceiveBufferSize(BUFSIZE);
                socket.setSendBufferSize(BUFSIZE);
            }
            this.dinp = new DataInputStream(new BufferedInputStream(connection.getInputStream(), BUFSIZE));
            this.dout = new DataOutputStream(new BufferedOutputStream(connection.getOutputStream(), BUFSIZE));
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    TCPHandler(JMSServer server, String hostName, int port, DataInputStream dinp, DataOutputStream dout) {
        this.server = server;
        this.hostName = hostName;
        this.port = port;
        this.dinp = dinp;
        this.dout = dout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int protocol;
        try {
            protocol = this.protocol();
        }
        catch (Throwable ex) {
            s_traceLogger.fine("protocol", ex);
            this.close();
            return;
        }
        if (protocol == -559038634) {
            HTTPConnection httpConnection;
            String connectionID = "";
            try {
                connectionID = this.dinp.readUTF();
            }
            catch (Throwable ex) {
                s_traceLogger.fine("connectionID", ex);
                this.close();
                return;
            }
            if (connectionID.equals("")) {
                s_traceLogger.fine("connectionID is empty");
                this.close();
                return;
            }
            while (true) {
                httpConnection = null;
                Object object = this.server.httpHandlers;
                synchronized (object) {
                    httpConnection = (HTTPConnection)this.server.httpHandlers.get(connectionID);
                    if (httpConnection == null) {
                        httpConnection = new HTTPConnection();
                        this.server.httpHandlers.put(connectionID, httpConnection);
                    }
                }
                object = httpConnection;
                synchronized (object) {
                    if (httpConnection.isOpen) break;
                }
            }
            {
                if (httpConnection.handler == null) {
                    try {
                        httpConnection.handler = new JMSRequestHandler(this.server, this.hostName, this.port, httpConnection, -559038634);
                    }
                    catch (Throwable ex) {
                        s_traceLogger.fine("JMSRequestHandler", ex);
                        this.close();
                        return;
                    }
                }
                if (httpConnection.clientID != null && connectionID != null) {
                    JMSServerProxy.getProxy().setState(httpConnection.clientID, connectionID, false);
                }
                httpConnection.handler.process(this.dinp, this.dout);
                if (!httpConnection.isOpen) {
                    Map map = this.server.httpHandlers;
                    synchronized (map) {
                        this.server.httpHandlers.remove(connectionID);
                    }
                }
            }
        } else {
            try {
                JMSRequestHandler handler = new JMSRequestHandler(this.server, this.hostName, this.port, null, protocol);
                handler.process(this.dinp, this.dout);
            }
            catch (Throwable ex) {
                s_traceLogger.fine("JMSRequestHandler", ex);
                this.close();
                return;
            }
        }
        this.close();
    }

    void close() {
        if (this.isOpen.testAndSet(false)) {
            JMSUtils.closeIt(this.dout);
            JMSUtils.closeIt(this.dinp);
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (Throwable ex) {
                s_traceLogger.fine("close", ex);
            }
            this.server.removeTCPHandler(this);
        }
    }

    private int protocol() throws Throwable {
        int result = this.dinp.readInt();
        if (result != -559038634 && result != -559038734 && result != -559038735) {
            s_traceLogger.fine("JMS protocol incorrect");
            this.close();
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02402", this, "JMS protocol", new Integer(result)));
        }
        this.readCheck("JMS major version", 1);
        this.readCheck("JMS minor version", 0);
        this.dout.writeInt(result);
        this.dout.writeInt(1);
        this.dout.writeInt(0);
        this.dout.flush();
        return result;
    }

    private void readCheck(String what, int val) throws Throwable {
        int ret = this.dinp.readInt();
        if (ret != val) {
            JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02402", this, what, new Integer(val), new Integer(ret)));
        }
    }

    final class HTTPConnection {
        JMSRequestHandler handler;
        String clientID;
        long sequenceNumber;
        boolean isOpen = true;
        Reply reply;

        HTTPConnection() {
        }
    }

    private class Reply {
        int flag;
        byte format;
        Serializable value;
        static final byte FLAG_ONLY = 0;
        static final byte INT = 1;
        static final byte BOOL = 2;
        static final byte T_MESSAGE = 3;
        static final byte T_OBJECT = 4;
        static final byte OBJECT = 5;
        static final byte NOTHING = 6;

        private Reply() {
        }

        void send(DataOutputStream dout, HTTPConnection httpConnection) throws IOException {
            if (this.format == 6) {
                if (httpConnection != null) {
                    dout.writeInt(0);
                    dout.flush();
                }
                return;
            }
            DataOutputStream out = dout;
            ByteArrayOutputStream b_out = null;
            if (httpConnection != null) {
                httpConnection.reply = this;
                b_out = new ByteArrayOutputStream();
                out = new DataOutputStream(b_out);
            }
            out.writeInt(this.flag);
            switch (this.format) {
                case 1: {
                    out.writeInt((Integer)this.value);
                    break;
                }
                case 2: {
                    out.writeBoolean((Boolean)this.value);
                    break;
                }
                case 3: {
                    out.writeBoolean(true);
                    ((EvermindMessage)this.value).writeTo(out);
                    break;
                }
                case 4: {
                    out.writeBoolean(true);
                }
                case 5: {
                    JMSUtils.write(this.value, out);
                    break;
                }
            }
            if (httpConnection != null) {
                byte[] ba = b_out.toByteArray();
                dout.writeInt(ba.length);
                dout.write(ba);
            }
            dout.flush();
        }
    }

    private class JMSRequestHandler {
        private final JMSServer server;
        private final JMSProvider provider;
        private final JMSStats stats;
        private final String name;
        private final HTTPConnection httpConnection;
        private final int protocol;
        private DataInputStream dinp;
        private DataOutputStream dout;
        private boolean connectionRegistered;
        private boolean connectionAdded;
        private boolean connectionClosed;
        private boolean connectionFailed;

        JMSRequestHandler(JMSServer server, String hostName, int port, HTTPConnection httpConnection) throws JMSException {
            this(server, hostName, port, httpConnection, httpConnection != null ? -559038634 : -559038734);
        }

        JMSRequestHandler(JMSServer server, String hostName, int port, HTTPConnection httpConnection, int protocol) throws JMSException {
            this.server = server;
            this.httpConnection = httpConnection;
            this.protocol = protocol;
            this.provider = server.getProvider();
            int id = server.getNextID();
            String suffix = httpConnection == null ? "" : ".http";
            this.name = "" + id + ":" + hostName + ":" + port + suffix;
            String self = "RequestHandler." + this.name;
            InetAddress addr = null;
            try {
                addr = InetAddress.getByName(hostName);
            }
            catch (UnknownHostException ex) {
                JMSUtils.toJMSException("getJMSServer", ex);
            }
            this.stats = JMSStats.create("/JMS", self, "JMSRequestHandler");
            this.stats.setMBean(new oracle.oc4j.admin.management.mbeans.JMSRequestHandler(String.valueOf(id), addr, port));
            this.stats.state("address", addr, true);
            this.stats.state("host", JMSUtils.normalize(addr), true);
            this.stats.state("port", new Integer(port), true);
        }

        public String toString() {
            return "JMSRequestHandler[" + this.name + "]";
        }

        private void login(boolean includeName) throws Throwable {
            String username = this.dinp.readUTF();
            String password = this.dinp.readUTF();
            try {
                JMSServer.getJMSServer(username, password);
            }
            catch (JMSSecurityException ex) {
                this.dout.writeInt(-1);
                this.dout.flush();
                throw ex;
            }
            this.dout.writeInt(-1161901314);
            if (includeName) {
                JMSUtils.write((Serializable)((Object)JMSProvider.NAME), this.dout);
            }
            this.dout.flush();
            User user = this.server.getUser(username);
            oracle.oc4j.admin.management.mbeans.JMSRequestHandler mbean = (oracle.oc4j.admin.management.mbeans.JMSRequestHandler)this.stats.getMBean();
            if (mbean != null) {
                mbean.setuser(user.getName());
            }
            this.stats.state("user", username, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            if (this.connectionRegistered) {
                this.provider.closeConnection();
            }
            if (this.connectionAdded) {
                Map map = this.server.m_handlers;
                synchronized (map) {
                    Long token = (Long)this.server.m_handlers.remove(this);
                    if (token != null) {
                        this.server.getJMSStats().phase("activeHandlers", token);
                    }
                }
            }
            if (this.stats != null) {
                this.stats.close();
            }
            if (this.httpConnection != null) {
                this.httpConnection.isOpen = false;
            }
        }

        private void sendNothing() throws Throwable {
            Reply reply = new Reply();
            reply.flag = 1234;
            reply.format = (byte)6;
            reply.send(this.dout, this.httpConnection);
        }

        private void sendOK() throws Throwable {
            Reply reply = new Reply();
            reply.flag = 1234;
            reply.format = 0;
            reply.send(this.dout, this.httpConnection);
        }

        private void sendSequenceNumberTooLarge() throws Throwable {
            Reply reply = new Reply();
            reply.flag = -1234;
            reply.format = 0;
            reply.send(this.dout, this.httpConnection);
        }

        private void sendInt(int value) throws Throwable {
            Reply reply = new Reply();
            reply.flag = 1234;
            reply.format = 1;
            reply.value = new Integer(value);
            reply.send(this.dout, this.httpConnection);
        }

        private void sendData(Serializable data) throws Throwable {
            Reply reply = new Reply();
            reply.flag = 1234;
            reply.value = data;
            if (data == null) {
                reply.format = (byte)2;
                reply.value = Boolean.FALSE;
            } else {
                reply.format = data instanceof EvermindMessage ? (byte)3 : (byte)4;
            }
            reply.send(this.dout, this.httpConnection);
        }

        private void sendException(JMSException ex) {
            try {
                Reply reply = new Reply();
                reply.flag = 4321;
                reply.format = (byte)5;
                reply.value = ex;
                reply.send(this.dout, this.httpConnection);
            }
            catch (Throwable nex) {
                s_traceLogger.fine("sendException", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(DataInputStream dinp, DataOutputStream dout) {
            boolean firstTime;
            this.dinp = dinp;
            this.dout = dout;
            boolean bl = firstTime = this.httpConnection == null || this.httpConnection.sequenceNumber == 0L;
            if (firstTime) {
                this.stats.state("startTime", new Long(System.currentTimeMillis()), true);
            }
            Thread.currentThread().setName(this.toString());
            long sequenceNumber = 0L;
            if (this.httpConnection != null) {
                try {
                    sequenceNumber = dinp.readLong();
                }
                catch (Throwable ex) {
                    s_traceLogger.fine("JMSRequestHandler could not read sequenceNumber");
                    this.close();
                    return;
                }
            }
            try {
                this.login(this.httpConnection == null ? this.protocol != -559038735 : sequenceNumber == 1L);
            }
            catch (Throwable ex) {
                this.close();
                return;
            }
            if (firstTime) {
                Map ex = this.server.m_handlers;
                synchronized (ex) {
                    this.server.getJMSStats().event("requestHandlers");
                    this.server.m_handlers.put(this, new Long(this.server.getJMSStats().phase("activeHandlers")));
                }
                this.connectionAdded = true;
            }
            if (this.httpConnection != null) {
                if (sequenceNumber == this.httpConnection.sequenceNumber + 1L) {
                    this.httpConnection.sequenceNumber = sequenceNumber;
                } else if (sequenceNumber > this.httpConnection.sequenceNumber + 1L) {
                    try {
                        this.sendSequenceNumberTooLarge();
                    }
                    catch (Throwable ex) {
                        s_traceLogger.fine("sequence number to large", ex);
                        this.close();
                    }
                } else {
                    if (sequenceNumber == this.httpConnection.sequenceNumber) {
                        try {
                            this.httpConnection.reply.send(dout, this.httpConnection);
                        }
                        catch (Throwable ex) {
                            s_traceLogger.fine("resend", ex);
                            this.close();
                        }
                        return;
                    }
                    return;
                }
            }
            do {
                try {
                    this.processRequest();
                    Thread.yield();
                }
                catch (RuntimeException ex) {
                    this.sendException(JMSUtils.makeJMSException("run", ex));
                }
                catch (JMSException ex) {
                    this.sendException(ex);
                }
                catch (Throwable ex) {
                    this.connectionFailed = true;
                    s_traceLogger.fine("JMSRequestHandler connectionFailed ", ex);
                }
                if (!this.connectionClosed && !this.connectionFailed) continue;
                this.close();
                return;
            } while (this.httpConnection == null);
        }

        private void processRequest() throws Throwable {
            int opcode = this.dinp.readInt();
            switch (opcode) {
                case 1002: {
                    this.processCloseConnection();
                    break;
                }
                case 4001: {
                    this.processCloseConsumer();
                    break;
                }
                case 3000: {
                    this.processCommit();
                    break;
                }
                case 4000: {
                    this.processCreateConsumer();
                    break;
                }
                case 2002: {
                    this.processCreateTemporaryDestination();
                    break;
                }
                case 2003: {
                    this.processDeleteTemporaryDestination();
                    break;
                }
                case 6001: {
                    this.processDequeueMessage();
                    break;
                }
                case 6000: {
                    this.processEnqueueMessage();
                    break;
                }
                case 2000: {
                    this.processGetDestinations();
                    break;
                }
                case 2001: {
                    this.processGetDurables();
                    break;
                }
                case 1003: {
                    this.processGetKnobs();
                    break;
                }
                case 1004: {
                    this.processGetStats();
                    break;
                }
                case 5000: {
                    this.processListMessages();
                    break;
                }
                case 5001: {
                    this.processPeekMessage();
                    break;
                }
                case 1001: {
                    this.processPing();
                    break;
                }
                case 3002: {
                    this.processPrepareX();
                    break;
                }
                case 3003: {
                    this.processRecoverX();
                    break;
                }
                case 1000: {
                    this.processRegisterConnection();
                    break;
                }
                case 3001: {
                    this.processRollback();
                    break;
                }
                case 4002: {
                    this.processUnsubscribe();
                    break;
                }
                default: {
                    this.connectionFailed = true;
                    JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02404", this, "processRequest", new Integer(opcode)));
                }
            }
        }

        private void processCloseConnection() throws Throwable {
            this.connectionClosed = true;
            this.sendNothing();
        }

        private void processCloseConsumer() throws Throwable {
            int consID = this.dinp.readInt();
            this.provider.closeConsumer(consID);
            this.sendOK();
        }

        private void processCommit() throws Throwable {
            SessionID sessionID = SessionID.readSessionID(this.protocol, this.dinp);
            this.provider.commit(sessionID);
            this.sendOK();
        }

        private void processCreateConsumer() throws Throwable {
            String dName = this.dinp.readUTF();
            String name = this.dinp.readUTF();
            String selector = this.dinp.readUTF();
            boolean noLocal = this.dinp.readBoolean();
            this.sendInt(this.provider.createConsumer(dName, name, selector, noLocal));
        }

        private void processCreateTemporaryDestination() throws Throwable {
            String dName = this.dinp.readUTF();
            boolean isQ = this.dinp.readBoolean();
            int domain = this.dinp.readInt();
            this.provider.createTemporary(dName, isQ, domain);
            this.sendOK();
        }

        private void processDeleteTemporaryDestination() throws Throwable {
            String dName = this.dinp.readUTF();
            this.provider.deleteTemporary(dName);
            this.sendOK();
        }

        private void processDequeueMessage() throws Throwable {
            int consID = this.dinp.readInt();
            SessionID sessionID = SessionID.readSessionID(this.protocol, this.dinp);
            String txid = this.dinp.readUTF();
            boolean keepState = this.dinp.readBoolean();
            boolean isXA = this.dinp.readBoolean();
            this.sendData(this.provider.deqMessage(consID, sessionID, txid, keepState, isXA));
        }

        private void processEnqueueMessage() throws Throwable {
            String dName = this.dinp.readUTF();
            SessionID sessionID = SessionID.readSessionID(this.protocol, this.dinp);
            boolean keepState = this.dinp.readBoolean();
            EvermindMessage msg = EvermindMessage.readMessage(this.dinp);
            boolean isXA = this.dinp.readBoolean();
            this.provider.enqMessage(dName, sessionID, keepState, msg, isXA);
            this.sendOK();
        }

        private void processGetDestinations() throws Throwable {
            boolean forAPI = this.dinp.readBoolean();
            this.sendData((Serializable)((Object)this.provider.getDestinations(forAPI)));
        }

        private void processGetDurables() throws Throwable {
            this.sendData((Serializable)((Object)this.provider.getDurables()));
        }

        private void processGetKnobs() throws Throwable {
            this.sendData((Serializable)((Object)this.provider.getKnobs()));
        }

        private void processGetStats() throws Throwable {
            this.sendData((Serializable)((Object)this.provider.getStats()));
        }

        private void processListMessages() throws Throwable {
            String dName = this.dinp.readUTF();
            String name = this.dinp.readUTF();
            SessionID sessionID = SessionID.readSessionID(this.protocol, this.dinp);
            String selector = this.dinp.readUTF();
            this.sendData((Serializable)((Object)this.provider.listMessages(dName, name, sessionID, selector)));
        }

        private void processPeekMessage() throws Throwable {
            String dName = this.dinp.readUTF();
            String name = this.dinp.readUTF();
            String msgID = this.dinp.readUTF();
            this.sendData(this.provider.peekMessage(dName, name, msgID));
        }

        private void processPing() throws Throwable {
            this.sendOK();
        }

        private void processPrepareX() throws Throwable {
            SessionID sessionID = SessionID.readSessionID(this.protocol, this.dinp);
            this.provider.prepareX(sessionID);
            this.sendOK();
        }

        private void processRecoverX() throws Throwable {
            this.sendData((Serializable)this.provider.recoverX());
        }

        private void processRegisterConnection() throws Throwable {
            String clientID = this.dinp.readUTF();
            String connectionID = this.dinp.readUTF();
            String user = this.dinp.readUTF();
            if (clientID != null && connectionID != null) {
                JMSServerProxy.getProxy().setState(clientID, connectionID, false);
                if (this.httpConnection != null) {
                    this.httpConnection.clientID = clientID;
                }
            }
            this.provider.registerConnection(clientID, connectionID, user);
            this.connectionRegistered = true;
            this.stats.state("clientID", clientID, true);
            this.stats.state("connectionID", connectionID, true);
            this.stats.state("currentUser", user, true);
            this.sendOK();
        }

        private void processRollback() throws Throwable {
            SessionID sessionID = SessionID.readSessionID(this.protocol, this.dinp);
            this.provider.rollback(sessionID);
            this.sendOK();
        }

        private void processUnsubscribe() throws Throwable {
            String name = this.dinp.readUTF();
            this.provider.unsubscribe(name);
            this.sendOK();
        }
    }
}

