/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.ConsumerInfo;
import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.MessageSelector;
import com.evermind.server.jms.ServerDestination;
import com.evermind.server.jms.ServerFile;
import com.evermind.server.jms.ServerStore;
import com.evermind.server.jms.TxMap;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;

public final class ServerQueue
extends ServerDestination {
    private final ServerStore m_store = this.makeStore(null);
    private int m_consCnt = 0;

    ServerQueue(TxMap txMap, Queue queue) throws Exception {
        super(txMap, (Destination)queue);
        this.loadMessages();
        this.m_store.updateStats();
    }

    protected final void closeDestination() throws Exception {
        this.m_store.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void enq(String connID, Object sessionID, boolean keepState, EvermindMessage msg) throws JMSException {
        long tok = this.startPhase("enq");
        try {
            this.m_store.enq(connID, sessionID, keepState, msg);
        }
        finally {
            this.stopPhase("enq", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EvermindMessage deq(ConsumerInfo cons, Object sessionID, String txid, boolean keepState) throws JMSException {
        long tok = this.startPhase("deq");
        try {
            EvermindMessage evermindMessage = this.m_store.deq(cons, sessionID, txid, keepState);
            return evermindMessage;
        }
        finally {
            this.stopPhase("deq", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void expireMessages() {
        long tok = this.startPhase("expireMessages");
        try {
            this.m_store.expireMessages();
        }
        finally {
            this.stopPhase("expireMessages", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List listMessages(String name, Object sessionID, MessageSelector selector) throws JMSException {
        long tok = this.startPhase("listMessages");
        try {
            List list = this.m_store.listMessages(sessionID, selector);
            return list;
        }
        finally {
            this.stopPhase("listMessages", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EvermindMessage peekMessage(String name, String msgID) throws JMSException {
        long tok = this.startPhase("peekMessage");
        try {
            EvermindMessage evermindMessage = this.m_store.peekMessage(msgID);
            return evermindMessage;
        }
        finally {
            this.stopPhase("peekMessage", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(Object sessionID) throws JMSException {
        long tok = this.startPhase("commit");
        try {
            this.m_store.commit(sessionID);
            this.commitFile(sessionID);
        }
        finally {
            this.stopPhase("commit", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(Object sessionID) throws JMSException {
        long tok = this.startPhase("rollback");
        try {
            this.m_store.rollback(sessionID);
            this.rollbackFile(sessionID);
        }
        finally {
            this.stopPhase("rollback", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addConsumer(ConsumerInfo cons) throws JMSException {
        long tok = this.startPhase("addConsumer");
        try {
            ++this.m_consCnt;
        }
        finally {
            this.stopPhase("addConsumer", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeConsumer(ConsumerInfo cons) throws JMSException {
        long tok = this.startPhase("removeConsumer");
        try {
            --this.m_consCnt;
        }
        finally {
            this.stopPhase("removeConsumer", tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List listDurableConsumers() {
        long tok = this.startPhase("listDurableConsumers");
        try {
            ArrayList arrayList = new ArrayList();
            return arrayList;
        }
        finally {
            this.stopPhase("listDurableConsumers", tok);
        }
    }

    public synchronized boolean isActive() {
        return this.m_store.hasMessages() || this.m_consCnt > 0;
    }

    private void loadMessages() throws Exception {
        Integer[] objs = this.getFile().scanObjects();
        if (objs == null) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            Object obj = ServerFile.reconstruct(this.getFile().readObject(objs[i]));
            if (!(obj instanceof EvermindMessage)) {
                this.getFile().removeObject(objs[i], null);
                continue;
            }
            EvermindMessage msg = (EvermindMessage)obj;
            this.m_store.loadMessage(msg, objs[i]);
        }
        this.m_store.cleanMessages();
    }
}

