/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.ServerFile;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class PersistentSet
implements Serializable,
Set {
    private final String m_file;
    private final boolean m_doStrict;
    private final Set m_base = new HashSet();
    private final Map m_map = new HashMap();
    private transient ServerFile m_sfile = null;
    static final long serialVersionUID = -8999341005887198614L;

    PersistentSet(String file, boolean doStrict, boolean doLock, boolean doPriv) throws IOException {
        this.m_file = file;
        this.m_doStrict = doStrict;
        this.loadFile(doLock, doPriv);
    }

    public PersistentSet(String file, boolean doStrict) throws IOException {
        this(file, doStrict, true, false);
    }

    public PersistentSet(String file) throws IOException {
        this(file, true, true, false);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public String toString() {
        return "PersistentSet[" + this.m_file + "]";
    }

    private void loadFile(boolean doLock, boolean doPriv) throws IOException {
        this.m_sfile = new ServerFile(null, "/PersistentSet", this.m_file, 3, "PersistentSet", doLock, doPriv);
        Integer[] objs = this.m_sfile.scanObjects();
        if (objs == null) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            byte[] buf = this.m_sfile.readObject(objs[i]);
            if (buf[0] != 0) continue;
            Serializable val = JMSUtils.toSerializable(buf, 1, buf.length - 1);
            this.m_map.put(val, objs[i]);
            this.m_base.add(val);
        }
    }

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        inp.defaultReadObject();
        this.loadFile(true, false);
    }

    public synchronized boolean add(Object val) {
        this.addFile(val);
        return this.m_base.add(val);
    }

    public synchronized boolean addAll(Collection set) {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Object val = iter.next();
            this.addFile(val);
        }
        return this.m_base.addAll(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        try {
            this.m_sfile.rasa(this.m_map.values().iterator());
        }
        catch (Exception ex) {
            JMSUtils.toRuntimeException("clear", ex);
        }
        finally {
            this.m_map.clear();
            this.m_base.clear();
        }
    }

    public synchronized boolean contains(Object val) {
        return this.m_base.contains(val);
    }

    public synchronized boolean containsAll(Collection set) {
        return this.m_base.containsAll(set);
    }

    public synchronized boolean equals(Object obj) {
        return ((Object)this.m_base).equals(obj);
    }

    public synchronized int hashCode() {
        return ((Object)this.m_base).hashCode();
    }

    public synchronized boolean isEmpty() {
        return this.m_base.isEmpty();
    }

    public synchronized Iterator iterator() {
        return new JMSUtils.CollectionIterator(this, this.m_base.iterator());
    }

    public synchronized boolean remove(Object val) {
        this.removeFile(val);
        return this.m_base.remove(val);
    }

    public synchronized boolean removeAll(Collection set) {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Object val = iter.next();
            this.removeFile(val);
        }
        return this.m_base.removeAll(set);
    }

    public synchronized boolean retainAll(Collection set) {
        Object[] keys = this.m_map.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            Object val = keys[i];
            if (set.contains(val)) continue;
            this.removeFile(val);
        }
        return this.m_base.retainAll(set);
    }

    public synchronized int size() {
        return this.m_base.size();
    }

    public synchronized Object[] toArray() {
        return this.m_base.toArray();
    }

    public synchronized Object[] toArray(Object[] ret) {
        return this.m_base.toArray(ret);
    }

    public synchronized void close() throws IOException {
        this.m_sfile.close();
    }

    private void addFile(Object val) {
        if (!JMSUtils.check(this.m_doStrict, "value", val)) {
            return;
        }
        this.removeFile(val);
        try {
            this.m_map.put(val, this.m_sfile.writeObject(JMSUtils.toBytes((byte)0, (Serializable)val), null));
        }
        catch (Exception ex) {
            JMSUtils.toRuntimeException("add(" + val + ")", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFile(Object val) {
        try {
            if (this.m_map.containsKey(val)) {
                this.m_sfile.removeObject((Integer)this.m_map.get(val), null);
            }
        }
        catch (Exception ex) {
            JMSUtils.toRuntimeException("remove(" + val + ")", ex);
        }
        finally {
            this.m_map.remove(val);
        }
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 1) {
                System.err.println("Usage: PersistentSet <file>");
                return;
            }
            String file = argv[0];
            PersistentSet set = null;
            set = new PersistentSet(file);
            PersistentSet.basicTests(set);
            set.close();
            set = new PersistentSet(file);
            PersistentSet.basicTests(set);
            set.close();
            set = new PersistentSet(file);
            PersistentSet.iteratorTests(set);
            set.close();
            set = new PersistentSet(file);
            PersistentSet.iteratorTests(set);
            set.close();
            PersistentSet.strictTests(file);
            PersistentSet.serializationTests(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void pp(String msg, Set set) {
        System.out.print(msg + ": [");
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            System.out.print(" (" + iter.next() + ")");
        }
        System.out.println(" ]");
    }

    private static void basicTests(Set set) {
        System.out.println("basicTests");
        PersistentSet.pp("start", set);
        set.add(null);
        set.add("1");
        set.add(new Integer(2));
        PersistentSet.pp("add", set);
        HashSet<Object> nset = new HashSet<Object>();
        nset.add("3");
        nset.add(new Integer(4));
        set.addAll(nset);
        PersistentSet.pp("addAll", set);
        set.clear();
        PersistentSet.pp("clear", set);
        System.out.println("isEmpty: " + set.isEmpty());
        System.out.println("size: " + set.size());
        set.add(null);
        set.add("1");
        set.add(new Integer(2));
        System.out.println("contains(null): " + set.contains(null));
        System.out.println("contains(\"1\"): " + set.contains("1"));
        System.out.println("contains(Integer(2)): " + set.contains(new Integer(2)));
        System.out.println("contains(\"2\"): " + set.contains("2"));
        System.out.println("contains(\"3\"): " + set.contains("3"));
        System.out.println("containsAll(before): " + set.containsAll(nset));
        set.addAll(nset);
        System.out.println("containsAll(after): " + set.containsAll(nset));
        System.out.println("equals(self): " + ((Object)set).equals(set));
        System.out.println("equals(other): " + ((Object)set).equals(nset));
        HashSet<Object> nnset = new HashSet<Object>();
        nnset.addAll(set);
        System.out.println("equals(another): " + ((Object)set).equals(nnset));
        System.out.println("hashCode(self): " + ((Object)set).hashCode());
        System.out.println("hashCode(other): " + ((Object)nset).hashCode());
        System.out.println("hashCode(another): " + ((Object)nnset).hashCode());
        set.remove(null);
        PersistentSet.pp("remove(null)", set);
        set.remove("abcd");
        PersistentSet.pp("remove(\"abcd\")", set);
        set.removeAll(nset);
        PersistentSet.pp("removeAll(other)", set);
        nnset.clear();
        nnset.add(new Integer(2));
        nnset.add("2");
        set.retainAll(nnset);
        PersistentSet.pp("retainAll(another)", set);
        System.out.println("size: " + set.size());
        System.out.println("toArray: " + set.toArray());
        System.out.println("toArray[]: " + set.toArray(new Object[0]));
        System.out.println("same size: " + (set.toArray().length == set.size()));
        System.out.println("same size: " + (set.toArray(new Object[0]).length == set.size()));
        System.out.println("");
    }

    private static void iteratorTests(Set set) {
        Object o;
        System.out.println("iteratorTests");
        PersistentSet.pp("start", set);
        set.clear();
        PersistentSet.pp("clear", set);
        Iterator iter = null;
        iter = set.iterator();
        while (iter.hasNext()) {
            System.out.println("iter1: " + iter.next());
        }
        set.add(null);
        set.add("1");
        set.add(new Integer(2));
        PersistentSet.pp("add", set);
        iter = set.iterator();
        while (iter.hasNext()) {
            System.out.println("iter2: " + iter.next());
        }
        iter = set.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            if (!(o instanceof Integer)) continue;
            iter.remove();
        }
        PersistentSet.pp("remove", set);
        iter = set.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            iter.remove();
        }
        PersistentSet.pp("removeAll", set);
        set.add(null);
        PersistentSet.pp("finish", set);
        System.out.println("");
    }

    private static void strictTests(String file) throws IOException {
        System.out.println("strictTests");
        PersistentSet set = new PersistentSet(file, true);
        try {
            set.add(new Thread());
        }
        catch (Exception ex) {
            System.out.println("add: " + ex);
        }
        set.close();
        set = new PersistentSet(file, false);
        set.add(new Thread());
        PersistentSet.pp("add", set);
        set.close();
        set = new PersistentSet(file);
        PersistentSet.pp("new", set);
        set.close();
        System.out.println("");
    }

    private static void serializationTests(String file) throws IOException {
        System.out.println("serializationTests");
        PersistentSet set = new PersistentSet(file);
        PersistentSet.pp("start", set);
        byte[] data = JMSUtils.toBytes(set);
        System.out.println("toBytes: " + data);
        PersistentSet.pp("toBytes", set);
        try {
            JMSUtils.toSerializable(data);
        }
        catch (Exception ex) {
            System.out.println("toSerializable: " + ex);
        }
        set.close();
        set = (PersistentSet)JMSUtils.toSerializable(data);
        PersistentSet.pp("after", set);
        set.close();
        System.out.println("");
    }
}

