/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.ServerFile;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class PersistentMap
implements Serializable,
Map {
    private final String m_file;
    private final boolean m_doStrict;
    private final Map m_base = new HashMap();
    private final Map m_map = new HashMap();
    private transient ServerFile m_sfile = null;
    static final long serialVersionUID = 2549352319735865424L;

    PersistentMap(String file, boolean doStrict, boolean doLock, boolean doPriv) throws IOException {
        this.m_file = file;
        this.m_doStrict = doStrict;
        this.loadFile(doLock, doPriv);
    }

    public PersistentMap(String file, boolean doStrict) throws IOException {
        this(file, doStrict, true, false);
    }

    public PersistentMap(String file) throws IOException {
        this(file, true, true, false);
    }

    protected void finalize() throws Throwable {
        this.m_sfile.close();
    }

    public String toString() {
        return "PersistentMap[" + this.m_file + "]";
    }

    private void loadFile(boolean doLock, boolean doPriv) throws IOException {
        this.m_sfile = new ServerFile(null, "/PersistentMap", this.m_file, 3, "PersistentMap", doLock, doPriv, false);
        Integer[] objs = this.m_sfile.scanObjects();
        if (objs == null) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            byte[] buf = this.m_sfile.readObject(objs[i]);
            if (buf[0] != 0) continue;
            Tuple tup = (Tuple)JMSUtils.toSerializable(buf, 1, buf.length - 1);
            this.m_map.put(tup.getKey(), objs[i]);
            this.m_base.put(tup.getKey(), tup.getValue());
        }
    }

    private void readObject(ObjectInputStream inp) throws IOException, ClassNotFoundException {
        inp.defaultReadObject();
        this.loadFile(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        try {
            this.m_sfile.rasa(this.m_map.values().iterator());
        }
        catch (Exception ex) {
            JMSUtils.toRuntimeException("clear", ex);
        }
        finally {
            this.m_map.clear();
            this.m_base.clear();
        }
    }

    public synchronized boolean containsKey(Object key) {
        return this.m_base.containsKey(key);
    }

    public synchronized boolean containsValue(Object val) {
        return this.m_base.containsValue(val);
    }

    public synchronized Set entrySet() {
        return new MyCollection(this, this.m_base.entrySet(), 1111);
    }

    public synchronized boolean equals(Object obj) {
        return ((Object)this.m_base).equals(obj);
    }

    public synchronized Object get(Object obj) {
        return this.m_base.get(obj);
    }

    public synchronized int hashCode() {
        return ((Object)this.m_base).hashCode();
    }

    public synchronized boolean isEmpty() {
        return this.m_base.isEmpty();
    }

    public synchronized Set keySet() {
        return new MyCollection(this, this.m_base.keySet(), 2222);
    }

    public synchronized Object put(Object key, Object val) {
        this.putFile(key, val);
        return this.m_base.put(key, val);
    }

    public synchronized void putAll(Map map) {
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            Object val = entry.getValue();
            this.putFile(key, val);
        }
        this.m_base.putAll(map);
    }

    public synchronized Object remove(Object key) {
        this.removeFile(key);
        return this.m_base.remove(key);
    }

    public synchronized int size() {
        return this.m_base.size();
    }

    public synchronized Collection values() {
        return new MyCollection(this, this.m_base.values(), 3333);
    }

    public synchronized void close() throws IOException {
        this.m_sfile.close();
    }

    private static boolean isSame(Object val, Object obj) {
        return val == obj || val != null && val.equals(obj);
    }

    private boolean removeValues(Object obj) {
        boolean ret = false;
        Iterator iter = this.m_base.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (!PersistentMap.isSame(val, obj)) continue;
            iter.remove();
            this.removeFile(key);
            ret = true;
        }
        return ret;
    }

    private void putFile(Object key, Object val) {
        if (!JMSUtils.check(this.m_doStrict, "key", key)) {
            return;
        }
        if (!JMSUtils.check(this.m_doStrict, "value", val)) {
            return;
        }
        this.removeFile(key);
        try {
            this.m_map.put(key, this.m_sfile.writeObject(JMSUtils.toBytes((byte)0, new Tuple(key, val)), null));
        }
        catch (Exception ex) {
            JMSUtils.toRuntimeException("put(" + key + "," + val + ")", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFile(Object key) {
        try {
            if (this.m_map.containsKey(key)) {
                this.m_sfile.removeObject((Integer)this.m_map.get(key), null);
            }
        }
        catch (Exception ex) {
            JMSUtils.toRuntimeException("remove(" + key + ")", ex);
        }
        finally {
            this.m_map.remove(key);
        }
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 1) {
                System.err.println("Usage: PersistentMap <file>");
                return;
            }
            String file = argv[0];
            PersistentMap map = null;
            map = new PersistentMap(file);
            PersistentMap.basicTests(map);
            map.close();
            map = new PersistentMap(file);
            PersistentMap.basicTests(map);
            map.close();
            map = new PersistentMap(file);
            PersistentMap.entryIteratorTests(map);
            map.close();
            map = new PersistentMap(file);
            PersistentMap.keyIteratorTests(map);
            map.close();
            map = new PersistentMap(file);
            PersistentMap.valueIteratorTests(map);
            map.close();
            map = new PersistentMap(file);
            PersistentMap.entryIteratorTests(map);
            map.close();
            map = new PersistentMap(file);
            PersistentMap.keyIteratorTests(map);
            map.close();
            map = new PersistentMap(file);
            PersistentMap.valueIteratorTests(map);
            map.close();
            PersistentMap.strictTests(file);
            PersistentMap.serializationTests(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void pp(String msg, Map map) {
        System.out.print(msg + ": [");
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            Object val = entry.getValue();
            System.out.print(" (" + key + ")=(" + val + ")");
        }
        System.out.println(" ]");
    }

    private static void basicTests(Map map) {
        System.out.println("basicTests");
        PersistentMap.pp("start", map);
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        HashMap<Object, Object> nmap = new HashMap<Object, Object>();
        nmap.put("3", "4");
        nmap.put(new Integer(4), new Double(5.0));
        map.putAll(nmap);
        PersistentMap.pp("putAll", map);
        map.clear();
        PersistentMap.pp("clear", map);
        System.out.println("isEmpty: " + map.isEmpty());
        System.out.println("size: " + map.size());
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        System.out.println("containsKey(null): " + map.containsKey(null));
        System.out.println("containsKey(\"1\"): " + map.containsKey("1"));
        System.out.println("containsKey(Integer(2)): " + map.containsKey(new Integer(2)));
        System.out.println("containsKey(\"2\"): " + map.containsKey("2"));
        System.out.println("containsValue(null): " + map.containsValue(null));
        System.out.println("containsValue(\"2\"): " + map.containsValue("2"));
        System.out.println("containsValue(Double(3)): " + map.containsValue(new Double(3.0)));
        System.out.println("equals(self): " + ((Object)map).equals(map));
        System.out.println("equals(other): " + ((Object)map).equals(nmap));
        HashMap nnmap = new HashMap();
        nnmap.putAll(map);
        System.out.println("equals(another): " + ((Object)map).equals(nnmap));
        System.out.println("hashCode(self): " + ((Object)map).hashCode());
        System.out.println("hashCode(other): " + ((Object)nmap).hashCode());
        System.out.println("hashCode(another): " + ((Object)nnmap).hashCode());
        map.remove(null);
        PersistentMap.pp("remove(null)", map);
        map.remove("abcd");
        PersistentMap.pp("remove(\"abcd\")", map);
        map.remove("1");
        PersistentMap.pp("remove(\"1\")", map);
        System.out.println("size: " + map.size());
        System.out.println("");
    }

    private static void entryIteratorTests(Map map) {
        Object o;
        System.out.println("entryIteratorTests");
        PersistentMap.pp("start", map);
        map.clear();
        PersistentMap.pp("clear", map);
        Iterator iter = null;
        iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            System.out.println("iter1: " + iter.next());
        }
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            System.out.println("iter2: " + iter.next());
        }
        iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            o = iter.next().getKey();
            if (!(o instanceof Integer)) continue;
            iter.remove();
        }
        PersistentMap.pp("remove", map);
        iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            o = iter.next();
            iter.remove();
        }
        PersistentMap.pp("removeAll", map);
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        map.entrySet().clear();
        PersistentMap.pp("clear", map);
        HashMap<Integer, Object> nmap = new HashMap<Integer, Object>();
        nmap.put(null, "2");
        nmap.put(new Integer(2), new Double(3.0));
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        map.entrySet().removeAll(nmap.entrySet());
        PersistentMap.pp("removeAll", map);
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        map.entrySet().retainAll(nmap.entrySet());
        PersistentMap.pp("retainAll", map);
        map.put(null, null);
        PersistentMap.pp("finish", map);
        System.out.println("");
    }

    private static void keyIteratorTests(Map map) {
        Object o;
        System.out.println("keyIteratorTests");
        PersistentMap.pp("start", map);
        map.clear();
        PersistentMap.pp("clear", map);
        Iterator iter = null;
        iter = map.keySet().iterator();
        while (iter.hasNext()) {
            System.out.println("iter1: " + iter.next());
        }
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        iter = map.keySet().iterator();
        while (iter.hasNext()) {
            System.out.println("iter2: " + iter.next());
        }
        iter = map.keySet().iterator();
        while (iter.hasNext()) {
            o = iter.next();
            if (!(o instanceof Integer)) continue;
            iter.remove();
        }
        PersistentMap.pp("remove", map);
        iter = map.keySet().iterator();
        while (iter.hasNext()) {
            o = iter.next();
            iter.remove();
        }
        PersistentMap.pp("removeAll", map);
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        map.keySet().clear();
        PersistentMap.pp("clear", map);
        HashMap<Integer, Object> nmap = new HashMap<Integer, Object>();
        nmap.put(null, "2");
        nmap.put(new Integer(2), new Double(3.0));
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        map.keySet().removeAll(nmap.keySet());
        PersistentMap.pp("removeAll", map);
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        map.keySet().retainAll(nmap.keySet());
        PersistentMap.pp("retainAll", map);
        map.put(null, null);
        PersistentMap.pp("finish", map);
        System.out.println("");
    }

    private static void valueIteratorTests(Map map) {
        Object o;
        System.out.println("valueIteratorTests");
        PersistentMap.pp("start", map);
        map.clear();
        PersistentMap.pp("clear", map);
        Iterator iter = null;
        iter = map.values().iterator();
        while (iter.hasNext()) {
            System.out.println("iter1: " + iter.next());
        }
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        iter = map.values().iterator();
        while (iter.hasNext()) {
            System.out.println("iter2: " + iter.next());
        }
        iter = map.values().iterator();
        while (iter.hasNext()) {
            o = iter.next();
            if (!(o instanceof Double)) continue;
            iter.remove();
        }
        PersistentMap.pp("remove", map);
        iter = map.values().iterator();
        while (iter.hasNext()) {
            o = iter.next();
            iter.remove();
        }
        PersistentMap.pp("removeAll", map);
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        map.values().clear();
        PersistentMap.pp("clear", map);
        HashMap<Integer, Object> nmap = new HashMap<Integer, Object>();
        nmap.put(null, "2");
        nmap.put(new Integer(2), new Double(3.0));
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        map.values().removeAll(nmap.values());
        PersistentMap.pp("removeAll", map);
        map.put(null, null);
        map.put("1", null);
        map.put(null, "2");
        map.put(new Integer(2), new Double(3.0));
        PersistentMap.pp("put", map);
        map.values().retainAll(nmap.values());
        PersistentMap.pp("retainAll", map);
        map.put(null, null);
        PersistentMap.pp("finish", map);
        System.out.println("");
    }

    private static void strictTests(String file) throws IOException {
        System.out.println("strictTests");
        PersistentMap map = new PersistentMap(file, true);
        try {
            map.put(new Thread(), (Object)null);
        }
        catch (Exception ex) {
            System.out.println("put: " + ex);
        }
        try {
            map.put((Object)null, new Thread());
        }
        catch (Exception ex) {
            System.out.println("put: " + ex);
        }
        map.close();
        map = new PersistentMap(file, false);
        map.put(new Thread(), (Object)null);
        map.put((Object)null, new Thread());
        PersistentMap.pp("put", map);
        map.close();
        map = new PersistentMap(file);
        PersistentMap.pp("new", map);
        map.close();
        System.out.println("");
    }

    private static void serializationTests(String file) throws IOException {
        System.out.println("serializationTests");
        PersistentMap map = new PersistentMap(file);
        PersistentMap.pp("start", map);
        byte[] data = JMSUtils.toBytes(map);
        System.out.println("toBytes: " + data);
        PersistentMap.pp("toBytes", map);
        try {
            JMSUtils.toSerializable(data);
        }
        catch (Exception ex) {
            System.out.println("toSerializable: " + ex);
        }
        map.close();
        map = (PersistentMap)JMSUtils.toSerializable(data);
        PersistentMap.pp("after", map);
        map.close();
        System.out.println("");
    }

    private static final class MyCollection
    implements Set {
        private static final int ENTRIES = 1111;
        private static final int KEYS = 2222;
        private static final int VALUES = 3333;
        private final Map m_map;
        private final Collection m_col;
        private final int m_type;

        MyCollection(Map map, Collection col, int type) {
            this.m_map = map;
            this.m_col = col;
            this.m_type = type;
        }

        private String which() {
            return this.m_type == 1111 ? "ENTRIES" : (this.m_type == 2222 ? "KEYS" : "VALUES");
        }

        public String toString() {
            return "MyCollection[" + this.m_map + "," + this.which() + "]";
        }

        public synchronized boolean add(Object obj) {
            JMSUtils.notSupported(this, this.m_map, "add", obj);
            return false;
        }

        public synchronized boolean addAll(Collection col) {
            JMSUtils.notSupported(this, this.m_map, "addAll", col);
            return false;
        }

        public synchronized void clear() {
            this.m_col.clear();
            this.m_map.clear();
        }

        public synchronized boolean contains(Object obj) {
            return this.m_col.contains(obj);
        }

        public synchronized boolean containsAll(Collection col) {
            return this.m_col.containsAll(col);
        }

        public synchronized boolean equals(Object obj) {
            return ((Object)this.m_col).equals(obj);
        }

        public synchronized int hashCode() {
            return ((Object)this.m_col).hashCode();
        }

        public synchronized boolean isEmpty() {
            return this.m_col.isEmpty();
        }

        public synchronized Iterator iterator() {
            return new JMSUtils.CollectionIterator(this, this.m_col.iterator());
        }

        public synchronized boolean remove(Object obj) {
            boolean ret = false;
            if (this.m_type == 1111) {
                ret = this.m_col.remove(obj);
                this.m_map.remove(((Map.Entry)obj).getKey());
            } else if (this.m_type == 2222) {
                ret = this.m_col.remove(obj);
                this.m_map.remove(obj);
            } else {
                ret = ((PersistentMap)this.m_map).removeValues(obj);
                ret |= this.m_col.remove(obj);
            }
            return ret;
        }

        public synchronized boolean removeAll(Collection col) {
            boolean ret = false;
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                ret |= this.remove(iter.next());
            }
            return ret;
        }

        public synchronized boolean retainAll(Collection col) {
            boolean ret = false;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                if (col.contains(iter.next())) continue;
                iter.remove();
                ret = true;
            }
            return ret;
        }

        public synchronized int size() {
            return this.m_col.size();
        }

        public synchronized Object[] toArray() {
            return this.m_col.toArray();
        }

        public synchronized Object[] toArray(Object[] ret) {
            return this.m_col.toArray(ret);
        }
    }

    private static final class Tuple
    implements Serializable {
        private final Serializable m_key;
        private final Serializable m_val;

        Tuple(Object key, Object val) {
            this.m_key = (Serializable)key;
            this.m_val = (Serializable)val;
        }

        Object getKey() {
            return this.m_key;
        }

        Object getValue() {
            return this.m_val;
        }

        public String toString() {
            return "Tuple[(" + this.m_key + ") -> (" + this.m_val + ")]";
        }
    }
}

