/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ThreadState;
import com.evermind.server.jms.OrionServerSession;
import com.evermind.util.ServerProperties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import oracle.jms.AQjmsSession;

public class OrionServerSessionPool
implements ServerSessionPool {
    protected ApplicationServer server;
    private ServerSession[] sessions = new ServerSession[1];
    private int availableSessions;
    private Connection connection;
    private boolean transacted;
    private int acknowledgeMode;
    private boolean xa;
    private ServerSession pendingServerSession;
    private ConnectionFactory factory;
    protected boolean oneconnopt;
    protected int maxInstances;
    private int gotInstances;
    private Destination destination;
    private String destinationType;
    private String beanname;
    private String subscriptionName;
    private String messageSelector;
    private String factoryLocation;
    private String destinationLocation;
    private String userName = null;
    private String password = null;
    private boolean destroyed = false;
    private boolean isdurable = false;
    private long timeout = 0L;
    private int closeTimeout = 15;

    public OrionServerSessionPool(ApplicationServer server, Connection connection, boolean transacted, int acknowledgeMode, boolean xa) {
        this.server = server;
        this.connection = connection;
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.xa = xa;
    }

    protected void finalize() {
        if (ServerProperties.getApplicationServerDebug()) {
            this.Print("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::finalize: begin/end");
        }
    }

    public OrionServerSessionPool(ApplicationServer server, long timeout, int maxInstances, ConnectionFactory factory, boolean oneconnopt, Destination destination, boolean transacted, int acknowledgeMode, boolean xa, String destinationType, String beanname, boolean isdurable, String subscriptionName, String messageSelector, String factoryLocation, String destinationLocation) {
        this.server = server;
        this.timeout = timeout;
        this.maxInstances = maxInstances;
        this.factory = factory;
        this.oneconnopt = oneconnopt;
        this.destination = destination;
        this.transacted = transacted;
        this.beanname = beanname;
        this.isdurable = isdurable;
        this.subscriptionName = subscriptionName;
        this.destinationType = destinationType;
        this.acknowledgeMode = acknowledgeMode;
        this.messageSelector = messageSelector;
        this.factoryLocation = factoryLocation;
        this.destinationLocation = destinationLocation;
        this.xa = xa;
        this.closeTimeout = ServerProperties.getOracleMDBFastUndeploy();
    }

    public void setCredentials(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerSession getServerSession() throws JMSException {
        MessageConsumer new_consumer;
        Session new_session;
        Connection new_connection;
        ServerSession retServerSession;
        block57: {
            retServerSession = null;
            if (ServerProperties.getApplicationServerDebug()) {
                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: begin");
                this.Print("OrionServerSessionPool::getServerSession: begin");
            }
            OrionServerSessionPool orionServerSessionPool = this;
            synchronized (orionServerSessionPool) {
                block56: {
                    block8: while (true) {
                        if (this.destroyed) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: destroyed; ret null");
                            }
                            return null;
                        }
                        if (this.availableSessions > 0) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: found avail session from pool; curr availableSessions=" + this.availableSessions);
                            }
                            retServerSession = this.sessions[--this.availableSessions];
                            ((OrionServerSession)retServerSession).Print("OrionServerSessionPool::getServerSession:");
                            this.setPendingServerSession((OrionServerSession)retServerSession);
                            return retServerSession;
                        }
                        if (this.maxInstances <= 0 || this.gotInstances != this.maxInstances) break block56;
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: maxInstances reached; block");
                        }
                        while (true) {
                            if (this.destroyed || this.availableSessions != 0) continue block8;
                            this.wait();
                        }
                        break;
                    }
                    catch (Exception e) {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: exc=" + e.getMessage() + "; ret null");
                        }
                        return null;
                    }
                }
                ++this.gotInstances;
            }
            new_connection = null;
            new_session = null;
            new_consumer = null;
            try {
                if (this.destination instanceof Queue && this.destinationType.equalsIgnoreCase("javax.jms.Queue")) {
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: Queue");
                    }
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: get new JmsConnection");
                    }
                    if (this.factory instanceof QueueConnectionFactory) {
                        new_connection = this.userName != null ? ((QueueConnectionFactory)this.factory).createQueueConnection(this.userName, this.password) : ((QueueConnectionFactory)this.factory).createQueueConnection();
                        this.connection = new_connection;
                        if (this.transacted) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: transacted session");
                            }
                            new_session = ((QueueConnection)new_connection).createQueueSession(true, 0);
                        } else {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: !transacted session");
                            }
                            new_session = ((QueueConnection)new_connection).createQueueSession(false, this.acknowledgeMode);
                        }
                        new_consumer = ((QueueSession)new_session).createReceiver((Queue)this.destination, this.messageSelector);
                        new_connection.start();
                        break block57;
                    } else {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: jms1.1 semantics");
                        }
                        this.connection = new_connection = this.factory.createConnection();
                        if (this.transacted) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: transacted session");
                            }
                            new_session = new_connection.createSession(true, 0);
                        } else {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: !transacted session");
                            }
                            new_session = new_connection.createSession(false, this.acknowledgeMode);
                        }
                        new_consumer = new_session.createConsumer((Destination)((Queue)this.destination), this.messageSelector);
                        new_connection.start();
                    }
                    break block57;
                }
                if (this.destination instanceof Topic && this.destinationType.equalsIgnoreCase("javax.jms.Topic")) {
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: Topic");
                    }
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: get new JmsConnection");
                    }
                    if (this.factory instanceof TopicConnectionFactory) {
                        new_connection = this.userName != null ? ((TopicConnectionFactory)this.factory).createTopicConnection(this.userName, this.password) : ((TopicConnectionFactory)this.factory).createTopicConnection();
                        this.connection = new_connection;
                        if (this.transacted) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: transacted session");
                            }
                            new_session = ((TopicConnection)new_connection).createTopicSession(true, 0);
                        } else {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: !transacted session");
                            }
                            new_session = ((TopicConnection)new_connection).createTopicSession(false, this.acknowledgeMode);
                        }
                        if (this.isdurable) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: do getDurableSubscriber");
                            }
                            new_consumer = ((TopicSession)new_session).createDurableSubscriber((Topic)this.destination, this.subscriptionName, this.messageSelector, false);
                        } else {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: !durable subscriber");
                            }
                            new_consumer = ((TopicSession)new_session).createSubscriber((Topic)this.destination, this.messageSelector, false);
                        }
                        new_connection.start();
                        break block57;
                    } else {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: jms1.1 semantics");
                        }
                        this.connection = new_connection = this.factory.createConnection();
                        if (this.transacted) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: transacted session");
                            }
                            new_session = new_connection.createSession(true, 0);
                        } else {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: !transacted session");
                            }
                            new_session = new_connection.createSession(false, this.acknowledgeMode);
                        }
                        if (this.isdurable) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: do getDurableSubscriber");
                            }
                            new_consumer = new_session.createDurableSubscriber((Topic)this.destination, this.subscriptionName, this.messageSelector, false);
                        } else {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: !durable subscriber");
                            }
                            new_consumer = new_session.createConsumer((Destination)((Topic)this.destination), this.messageSelector, false);
                        }
                        new_connection.start();
                    }
                    break block57;
                }
                throw new InstantiationException("Destination Type and Connection mismatch for MessageDrivenBean " + this.beanname + ": they must either both be Topic or both be Queue");
            }
            catch (Exception e) {
                if (ServerProperties.getApplicationServerDebug()) {
                    JMSException jmsexc;
                    System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: exc=" + e.getMessage());
                    e.printStackTrace();
                    if (e instanceof JMSException && (jmsexc = (JMSException)((Object)e)).getLinkedException() != null) {
                        jmsexc.getLinkedException().printStackTrace();
                    }
                }
                OrionServerSession fakeServerSession = new OrionServerSession(this, null, new_connection, new_session, this.destination, new_consumer, this.messageSelector);
                fakeServerSession.destroy();
                OrionServerSessionPool orionServerSessionPool2 = this;
                synchronized (orionServerSessionPool2) {
                    --this.gotInstances;
                    throw new JMSException("Error: " + e.getMessage());
                }
            }
        }
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSession: end; ret ServerSession");
        }
        retServerSession = new OrionServerSession(this, null, new_connection, new_session, this.destination, new_consumer, this.messageSelector);
        this.setPendingServerSession((OrionServerSession)retServerSession);
        return retServerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerSession getServerSessionFull(String dsname) throws InstantiationException {
        block82: {
            retServerSession = null;
            if (ServerProperties.getApplicationServerDebug()) {
                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: begin");
                this.Print("OrionServerSessionPool::getServerSessionFull: begin");
            }
            var3_3 = this;
            synchronized (var3_3) {
                block81: {
                    block12: while (true) {
                        if (this.destroyed) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: destroyed; ret null");
                            }
                            return null;
                        }
                        if (this.availableSessions > 0) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: found avail session from pool; curr availableSessions=" + this.availableSessions);
                            }
                            retServerSession = this.sessions[--this.availableSessions];
                            ((OrionServerSession)retServerSession).Print("OrionServerSessionPool::getServerSessionFull:");
                            this.setPendingServerSession((OrionServerSession)retServerSession);
                            return retServerSession;
                        }
                        if (this.maxInstances <= 0 || this.gotInstances != this.maxInstances) break block81;
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: maxInstances reached; block");
                        }
                        while (true) {
                            if (this.destroyed || this.availableSessions != 0) continue block12;
                            this.wait();
                        }
                        break;
                    }
                    catch (Exception e) {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: exc=" + e.getMessage() + "; ret null");
                        }
                        return null;
                    }
                }
                ++this.gotInstances;
            }
            new_connection = null;
            new_session = null;
            new_consumer = null;
            try {
                if (this.destination instanceof Queue && this.destinationType.equalsIgnoreCase("javax.jms.Queue")) {
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: Queue");
                    }
                    if (this.factory instanceof QueueConnectionFactory) {
                        if (!this.oneconnopt || this.connection == null) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: get new JmsConnection");
                            }
                            new_connection = this.userName != null ? ((QueueConnectionFactory)this.factory).createQueueConnection(this.userName, this.password) : ((QueueConnectionFactory)this.factory).createQueueConnection();
                            if (this.oneconnopt) {
                                this.connection = new_connection;
                            }
                        } else {
                            new_connection = this.connection;
                        }
                        if (this.transacted) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: transacted session");
                            }
                            new_session = ((QueueConnection)new_connection).createQueueSession(true, 0);
                        } else {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: !transacted session");
                            }
                            new_session = ((QueueConnection)new_connection).createQueueSession(false, this.acknowledgeMode);
                        }
                        if (new_session.getClass().getName().equals("oracle.jms.AQjmsSession")) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: setting AQ closeCheckInterval=" + this.closeTimeout);
                            }
                            ((AQjmsSession)new_session).setCloseCheckInterval(this.closeTimeout);
                        }
                        new_consumer = new_session.createReceiver((Queue)this.destination, this.messageSelector);
                        new_connection.start();
                        break block82;
                    }
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: jms1.1 semantics");
                    }
                    if (!this.oneconnopt || this.connection == null) {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: get new JmsConnection");
                        }
                        new_connection = this.factory.createConnection();
                        if (this.oneconnopt) {
                            this.connection = new_connection;
                        }
                    } else {
                        new_connection = this.connection;
                    }
                    if (this.transacted) {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: transacted session");
                        }
                        new_session = new_connection.createSession(true, 0);
                    } else {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: !transacted session");
                        }
                        new_session = new_connection.createSession(false, this.acknowledgeMode);
                    }
                    if (new_session.getClass().getName().equals("oracle.jms.AQjmsSession")) {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: setting AQ closeCheckInterval=" + this.closeTimeout);
                        }
                        ((AQjmsSession)new_session).setCloseCheckInterval(this.closeTimeout);
                    }
                    new_consumer = new_session.createConsumer((Destination)((Queue)this.destination), this.messageSelector);
                    new_connection.start();
                    break block82;
                }
                if (this.destination instanceof Topic && this.destinationType.equalsIgnoreCase("javax.jms.Topic")) {
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: Topic");
                    }
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: get new JmsConnection");
                    }
                    if (this.factory instanceof TopicConnectionFactory) {
                        if (!this.oneconnopt || this.connection == null) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: get new JmsConnection");
                            }
                            new_connection = this.userName != null ? ((TopicConnectionFactory)this.factory).createTopicConnection(this.userName, this.password) : ((TopicConnectionFactory)this.factory).createTopicConnection();
                            if (this.oneconnopt) {
                                this.connection = new_connection;
                            }
                        } else {
                            new_connection = this.connection;
                        }
                        if (this.transacted) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: transacted session");
                            }
                            new_session = ((TopicConnection)new_connection).createTopicSession(true, 0);
                        } else {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: !transacted session");
                            }
                            new_session = ((TopicConnection)new_connection).createTopicSession(false, this.acknowledgeMode);
                        }
                        if (new_session.getClass().getName().equals("oracle.jms.AQjmsSession")) {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: setting AQ closeCheckInterval=" + this.closeTimeout);
                            }
                            ((AQjmsSession)new_session).setCloseCheckInterval(this.closeTimeout);
                        }
                        if (this.isdurable) {
                            try {
                                if (ServerProperties.getApplicationServerDebug()) {
                                    System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: do getDurableSubscriber");
                                }
                                new_consumer = ((AQjmsSession)new_session).getDurableSubscriber((Topic)this.destination, this.subscriptionName);
                            }
                            catch (JMSException jmsexc) {
                                if (new_session.getClass().getName().equals("oracle.jms.AQjmsSession")) ** GOTO lbl127
                                throw jmsexc;
                            }
                        } else {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: !durable subscriber");
                            }
                            new_consumer = ((TopicSession)new_session).createSubscriber((Topic)this.destination, this.messageSelector, false);
                        }
lbl127:
                        // 3 sources

                        new_connection.start();
                        break block82;
                    }
                    if (ServerProperties.getApplicationServerDebug()) {
                        System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: jms1.1 semantics");
                    }
                    if (!this.oneconnopt || this.connection == null) {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: get new JmsConnection");
                        }
                        new_connection = this.factory.createConnection();
                        if (this.oneconnopt) {
                            this.connection = new_connection;
                        }
                    } else {
                        new_connection = this.connection;
                    }
                    if (this.transacted) {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: transacted session");
                        }
                        new_session = new_connection.createSession(true, 0);
                    } else {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: !transacted session");
                        }
                        new_session = new_connection.createSession(false, this.acknowledgeMode);
                    }
                    if (new_session.getClass().getName().equals("oracle.jms.AQjmsSession")) {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: setting AQ closeCheckInterval=" + this.closeTimeout);
                        }
                        ((AQjmsSession)new_session).setCloseCheckInterval(this.closeTimeout);
                    }
                    if (this.isdurable) {
                        try {
                            if (ServerProperties.getApplicationServerDebug()) {
                                System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: do getDurableSubscriber");
                            }
                            new_consumer = ((AQjmsSession)new_session).getDurableSubscriber((Topic)this.destination, this.subscriptionName);
                        }
                        catch (JMSException jmsexc) {
                            if (new_session.getClass().getName().equals("oracle.jms.AQjmsSession")) ** GOTO lbl163
                            throw jmsexc;
                        }
                    } else {
                        if (ServerProperties.getApplicationServerDebug()) {
                            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: !durable subscriber");
                        }
                        new_consumer = new_session.createConsumer((Destination)((Topic)this.destination), this.messageSelector, false);
                    }
lbl163:
                    // 3 sources

                    new_connection.start();
                    break block82;
                }
                throw new InstantiationException("Destination Type and Connection mismatch for MessageDrivenBean " + this.beanname + ": they must either both be Topic or both be Queue");
            }
            catch (Exception e) {
                if (ServerProperties.getApplicationServerDebug()) {
                    System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: exc=" + e.getMessage());
                    e.printStackTrace();
                    if (e instanceof JMSException && (jmsexc = (JMSException)e).getLinkedException() != null) {
                        jmsexc.getLinkedException().printStackTrace();
                    }
                }
                fakeServerSession = new OrionServerSession(this, null, new_connection, (Session)new_session, this.destination, (MessageConsumer)new_consumer, this.messageSelector);
                fakeServerSession.destroy();
                var8_11 = this;
                synchronized (var8_11) {
                    --this.gotInstances;
                    throw new InstantiationException("Error: " + e.getMessage());
                }
            }
        }
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::getServerSessionFull: end; ret ServerSession");
        }
        retServerSession = new OrionServerSession(this, null, new_connection, (Session)new_session, this.destination, (MessageConsumer)new_consumer, this.messageSelector);
        this.setPendingServerSession((OrionServerSession)retServerSession);
        return retServerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPendingServerSession(OrionServerSession session) {
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::setPendingServerSession: begin; OrionServerSession=" + session);
        }
        OrionServerSessionPool orionServerSessionPool = this;
        synchronized (orionServerSessionPool) {
            this.pendingServerSession = session;
        }
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::setPendingServerSession: end");
        }
    }

    public void release(OrionServerSession session) {
        this.release(session, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(OrionServerSession session, boolean donotify, boolean donotreturnpool) {
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::release: begin; OrionServerSession=" + session);
        }
        OrionServerSessionPool orionServerSessionPool = this;
        synchronized (orionServerSessionPool) {
            if (!donotreturnpool) {
                if (this.sessions.length <= this.availableSessions) {
                    OrionServerSession[] newSessions = new OrionServerSession[this.sessions.length * 2];
                    System.arraycopy(this.sessions, 0, newSessions, 0, this.sessions.length);
                    this.sessions = newSessions;
                }
                this.sessions[this.availableSessions++] = session;
            }
            if (this.pendingServerSession != null && this.pendingServerSession == session) {
                if (ServerProperties.getApplicationServerDebug()) {
                    System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::release: pending session == released session");
                }
                this.pendingServerSession = null;
            }
            if (donotreturnpool) {
                --this.gotInstances;
            }
            if (donotify) {
                this.notify();
            }
            session.Print("OrionServerSessionPool::release:");
        }
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::release: end; new availableSessions=" + this.availableSessions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (ServerProperties.getApplicationServerDebug()) {
            this.Print("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::destroy: begin");
        }
        OrionServerSessionPool orionServerSessionPool = this;
        synchronized (orionServerSessionPool) {
            for (int ii = 0; ii < this.availableSessions; ++ii) {
                if (this.sessions[ii] == null) continue;
                if (ServerProperties.getApplicationServerDebug()) {
                    System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::destroy: pooled session-" + new Integer(ii).toString());
                }
                ((OrionServerSession)this.sessions[ii]).destroy();
                this.sessions[ii] = null;
            }
            this.sessions = null;
            if (this.pendingServerSession != null) {
                if (ServerProperties.getApplicationServerDebug()) {
                    System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::destroy: pending session");
                }
                ((OrionServerSession)this.pendingServerSession).destroy();
                this.pendingServerSession = null;
            }
        }
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::destroy: end");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDestroyed() {
        if (ServerProperties.getApplicationServerDebug()) {
            this.Print("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::markDestroyed: begin");
        }
        OrionServerSessionPool orionServerSessionPool = this;
        synchronized (orionServerSessionPool) {
            this.destroyed = true;
            this.notify();
            for (int ii = 0; ii < this.availableSessions; ++ii) {
                if (this.sessions[ii] == null) continue;
                ((OrionServerSession)this.sessions[ii]).markDestroyed();
            }
            if (this.pendingServerSession != null) {
                ((OrionServerSession)this.pendingServerSession).markDestroyed();
            }
        }
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::markDestroyed: end");
        }
    }

    public void Print(String str) {
        if (ServerProperties.getApplicationServerDebug()) {
            System.out.println("Thr[" + ThreadState.getCurrentState().toString() + "]-" + "OrionServerSessionPool::::Print: " + str + "| this=" + this + "\n factoryLocation    =" + this.factoryLocation + "\n destinationLocation=" + this.destinationLocation + "\n beanname           =" + this.beanname + "\n maxInstances       =" + this.maxInstances + "\n gotInstances       =" + this.gotInstances + "\n destinationType    =" + this.destinationType + "\n isDurable          =" + this.isdurable + "\n subscriptionName   =" + this.subscriptionName + "\n messageSelector    =" + this.messageSelector);
        }
    }
}

