/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;

public class JMSTraceLogger {
    private final Logger m_logger;
    private final String m_sourceClass;

    public JMSTraceLogger(Class clazz) {
        this.m_logger = TraceLogger.getLogger(clazz);
        this.m_sourceClass = clazz.getName();
    }

    public void fine(String message) {
        this.m_logger.log(Level.FINE, message);
    }

    public void fine(String message, Object[] args) {
        this.m_logger.log(Level.FINE, message, args);
    }

    public void fine(String message, Throwable thrown) {
        this.m_logger.log(Level.FINE, message, thrown);
    }

    public void fine(String message, Object[] args, Throwable thrown) {
        if (this.m_logger.isLoggable(Level.FINE)) {
            this.m_logger.log(Level.FINE, MessageFormat.format(message, args), thrown);
        }
    }

    public void finer(String message) {
        this.m_logger.log(Level.FINER, message);
    }

    public void finer(String message, Object[] args) {
        this.m_logger.log(Level.FINER, message, args);
    }

    public void finer(String message, Throwable thrown) {
        this.m_logger.log(Level.FINER, message, thrown);
    }

    public void finer(String message, Object[] args, Throwable thrown) {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.log(Level.FINER, MessageFormat.format(message, args), thrown);
        }
    }

    public void finest(String message) {
        this.m_logger.log(Level.FINEST, message);
    }

    public void finest(String message, Object[] args) {
        this.m_logger.log(Level.FINEST, message, args);
    }

    public void finest(String message, Throwable thrown) {
        this.m_logger.log(Level.FINEST, message, thrown);
    }

    public void finest(String message, Object[] args, Throwable thrown) {
        if (this.m_logger.isLoggable(Level.FINEST)) {
            this.m_logger.log(Level.FINEST, MessageFormat.format(message, args), thrown);
        }
    }

    public void entering(String souceMethod) {
        this.m_logger.entering(this.m_sourceClass, souceMethod);
    }

    public void entering(String souceMethod, Object[] params) {
        this.m_logger.entering(this.m_sourceClass, souceMethod, params);
    }

    public void exiting(String sourceMethod) {
        this.m_logger.exiting(this.m_sourceClass, sourceMethod);
    }

    public void exiting(String sourceMethod, Object result) {
        this.m_logger.exiting(this.m_sourceClass, sourceMethod, result);
    }

    public void throwing(String sourceMethod, Throwable thrown) {
        this.m_logger.throwing(this.m_sourceClass, sourceMethod, thrown);
    }
}

