/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.ServerDestination;
import com.evermind.server.jms.ServerFile;
import java.io.IOException;
import java.util.logging.Level;
import javax.jms.Destination;
import javax.jms.Message;
import javax.management.ObjectName;
import oracle.j2ee.jms.oc4j.v1.JMSServerConfig;

public class JMSServerMessages
extends JMSMessages {
    public static void warningInstanceNotFound(ObjectName objName) {
        JMSServerMessages.log(Level.WARNING, "J2EE JMS-03180", new Object[]{objName});
    }

    public static void severeServerInstantiation(Object appServer, Throwable thrown) throws InstantiationException {
        throw (InstantiationException)JMSServerMessages.log(Level.SEVERE, "J2EE JMS-02517", new Object[]{appServer}, thrown, InstantiationException.class);
    }

    public static void severeConfigUpdate(JMSServerConfig config, Throwable thrown) {
        JMSServerMessages.log(Level.SEVERE, "J2EE JMS-02518", new Object[]{config}, thrown);
    }

    public static void severeSetConfig(JMSServerConfig config, Throwable thrown) throws InstantiationException {
        throw (InstantiationException)JMSServerMessages.log(Level.SEVERE, "J2EE JMS-02518", new Object[]{config}, thrown, InstantiationException.class);
    }

    public static void severeStoreConfig(JMSServerConfig config, Throwable thrown) {
        JMSServerMessages.log(Level.SEVERE, "J2EE JMS-02519", new Object[]{config}, thrown);
    }

    public static void severeLockPersistenceFile(ServerFile sf, Throwable thrown) throws IOException {
        throw (IOException)JMSServerMessages.log(Level.SEVERE, "J2EE JMS-03011", new Object[]{sf}, thrown, IOException.class);
    }

    public static void warningPersistenceDisabled(JMSServer server, int cnt) {
        JMSServerMessages.log(Level.WARNING, "J2EE JMS-02508", new Object[]{server, new Integer(cnt)});
    }

    public static void warningPersistenceFileRemoval(JMSServer server, String file, String dest) {
        JMSServerMessages.log(Level.WARNING, "J2EE JMS-02516", new Object[]{server, file, dest});
    }

    public static void warningInvalidConsumer(ServerDestination dest, String consID, Message msg) {
        JMSServerMessages.log(Level.WARNING, "J2EE JMS-03101", new Object[]{dest, consID, dest.getFile(), msg});
    }

    public static void warningInvalidObjid(ServerFile file, Integer objid) {
        JMSServerMessages.log(Level.WARNING, "J2EE JMS-03000", new Object[]{file, objid});
    }

    public static void warningInvalidPageSize(ServerFile file, int psize, int page) {
        JMSServerMessages.log(Level.WARNING, "J2EE JMS-03006", new Object[]{file, new Integer(psize), new Integer(page)});
    }

    public static void warningInvalidObjSize(ServerFile file, int size, int page) {
        JMSServerMessages.log(Level.WARNING, "J2EE JMS-03007", new Object[]{file, new Integer(size), new Integer(page)});
    }

    public static void warningInvalidMagic(ServerFile file, String magic, int page) {
        JMSServerMessages.log(Level.WARNING, "J2EE JMS-03008", new Object[]{file, magic, new Integer(page)});
    }

    public static void warningRecoverError(ServerFile file, int page, Throwable thrown) {
        JMSServerMessages.log(Level.WARNING, "J2EE JMS-03009", new Object[]{file, new Integer(page)}, thrown);
    }

    public static void infoServerNotListening(JMSServer server) {
        JMSServerMessages.log(Level.INFO, "J2EE JMS-02521", new Object[]{server});
    }

    public static void infoRecoveringLocalTxns(JMSServer server, Destination dest) {
        JMSServerMessages.log(Level.INFO, "J2EE JMS-02522", new Object[]{server, dest});
    }

    public static void infoRecoveringTxns(JMSServer server, int commit, int rollback, int xaPrepared) {
        JMSServerMessages.log(Level.INFO, "J2EE JMS-02523", new Object[]{server, new Integer(commit), new Integer(rollback), new Integer(xaPrepared)});
    }
}

