/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.net.SocketNetworkConnection;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSProvider;
import com.evermind.server.jms.JMSServer;
import com.evermind.server.jms.JMSServerProxy;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import com.evermind.server.jms.SecureOperation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HTTPJMSRequestHandler
extends HttpServlet {
    private static final JMSServer jmsserver = JMSServer.getServer();
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(HTTPJMSRequestHandler.class);
    public static final int BUFSIZE = Math.max(8192, (Integer)JMSServerProxy.getProxy().getPropertiesController().getConfigProperty("oc4j.jms.socketBufsize"));
    private static final ArrayList verifiedServers = new ArrayList();
    private static int ERROR_DELAY = 5000;
    private static long errorSequence = 0L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        String requesterIp = request.getRemoteAddr();
        s_traceLogger.fine("HTTP JMS Tunneling not enabled, request from " + requesterIp + " ignored");
        try {
            response.sendError(404);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        long startTime = System.currentTimeMillis();
        String requesterIp = request.getRemoteAddr();
        String requesterHost = request.getRemoteHost();
        Streams server = new Streams();
        Streams client = new Streams();
        ServletInputStream servletInputStream = null;
        ServletOutputStream servletOutputStream = null;
        ByteArrayOutputStream bytesToServer = null;
        DataOutputStream dataToServer = null;
        Protocol protocol = new Protocol();
        long sequenceNumber = 0L;
        boolean loginValid = false;
        boolean loginChecked = false;
        boolean protocolValid = false;
        String targetAddress = "";
        String user = "";
        String password = "";
        String connectionID = "";
        try {
            if (!jmsserver.getHttpTunnelEnabled()) {
                s_traceLogger.fine("HTTP JMS Tunneling not enabled, request from " + requesterIp + " ignored");
                try {
                    response.sendError(404);
                    return;
                }
                catch (Throwable t) {
                    // empty catch block
                }
                return;
            }
            String contentType = request.getContentType();
            if (contentType != null) {
                response.setContentType(contentType);
            }
            servletInputStream = request.getInputStream();
            servletOutputStream = response.getOutputStream();
            client.open(new DataInputStream(new BufferedInputStream((InputStream)servletInputStream, BUFSIZE)), new DataOutputStream(new BufferedOutputStream((OutputStream)servletOutputStream, BUFSIZE)));
            bytesToServer = new ByteArrayOutputStream();
            dataToServer = new DataOutputStream(bytesToServer);
            protocol.read(client.in);
            InetAddress targetInet = (InetAddress)JMSUtils.read(client.in);
            int targetPort = client.in.readInt();
            connectionID = client.in.readUTF();
            sequenceNumber = client.in.readLong();
            user = client.in.readUTF();
            password = client.in.readUTF();
            loginValid = this.verifyLogin(user, password);
            loginChecked = true;
            targetAddress = targetInet.getCanonicalHostName() + ":" + targetPort;
            boolean useFilterList = jmsserver.getTcpRelayFilter().equals("list");
            if (useFilterList) {
                ArrayList configuredTargets = (ArrayList)jmsserver.getTcpRelayList();
                if (!configuredTargets.contains(targetAddress)) throw new JMSSecurityException(targetAddress + " does not appear on the tcp-relay target list");
                protocol.write(dataToServer);
            } else if (!verifiedServers.contains(targetAddress)) {
                this.initializeConnection(targetInet, targetPort, server, user, password);
                protocol.write(server.out);
                Protocol clientsProtocol = new Protocol();
                clientsProtocol.read(server.in);
                clientsProtocol.write(client.out);
                protocolValid = true;
                verifiedServers.add(targetAddress);
            } else {
                protocol.write(dataToServer);
            }
            dataToServer.writeUTF(connectionID);
            dataToServer.writeLong(sequenceNumber);
            dataToServer.writeUTF(user);
            dataToServer.writeUTF(password);
            byte[] ba = new byte[request.getContentLength()];
            int b_size = client.in.read(ba);
            dataToServer.write(ba, 0, b_size);
            dataToServer.flush();
            this.sendRequest(server, bytesToServer, targetInet, targetPort, user, password);
            this.relayResponse(server, client, sequenceNumber, protocolValid);
        }
        catch (Throwable t) {
            this.delay(startTime);
            String exceptionID = "HTTP-" + startTime + "-" + ++errorSequence;
            this.sendExceptionToClient(client.out, protocol, sequenceNumber, "HTTP JMS Tunnel request failed, search OC4J server log for error number " + exceptionID, protocolValid, loginValid, loginChecked);
            JMSMessages.infoHttpTunnelErrorCode(exceptionID, t);
        }
        client.close();
        server.close();
        try {
            servletOutputStream.close();
            servletInputStream.close();
            return;
        }
        catch (IOException ioex) {
            // empty catch block
        }
    }

    private void sendRequest(Streams server, ByteArrayOutputStream bytesToServer, InetAddress targetInet, int targetPort, String user, String password) throws Throwable {
        this.initializeConnection(targetInet, targetPort, server, user, password);
        server.out.write(bytesToServer.toByteArray(), 0, bytesToServer.size());
        server.out.flush();
    }

    private void relayResponse(Streams server, Streams client, long sequenceNumber, boolean protocolValid) throws Throwable {
        if (!protocolValid) {
            Protocol protocol = new Protocol();
            protocol.read(server.in);
            protocol.write(client.out);
        }
        int loginResultFlag = server.in.readInt();
        client.out.writeInt(loginResultFlag);
        if (loginResultFlag != -1) {
            boolean nameRelayed = sequenceNumber != 1L;
            boolean replyRelayed = false;
            do {
                int b_size = server.in.readInt();
                if (!nameRelayed) {
                    client.out.writeInt(b_size);
                    nameRelayed = true;
                } else {
                    replyRelayed = true;
                }
                byte[] ba = new byte[b_size];
                server.in.readFully(ba, 0, b_size);
                client.out.write(ba, 0, b_size);
            } while (!replyRelayed);
        }
        client.out.flush();
    }

    private long relaySequenceNumber(Streams client, DataOutputStream dataToServer) throws Exception {
        long ret = client.in.readLong();
        dataToServer.writeLong(ret);
        return ret;
    }

    private boolean verifyLogin(String username, String password) throws JMSSecurityException, JMSException, IOException {
        if (JMSServer.getServer().getHttpTunnelAuthentication().equals("required")) {
            JMSServer.getJMSServer(username, password);
        }
        return true;
    }

    private void sendExceptionToClient(DataOutputStream client, Protocol protocol, long sequenceNumber, String exMessage, boolean protocolValid, boolean loginValid, boolean loginChecked) {
        try {
            if (!protocolValid) {
                protocol.write(client);
            }
            if (loginChecked && !loginValid) {
                client.writeInt(-1);
            } else {
                client.writeInt(-1161901314);
                if (sequenceNumber < 2L) {
                    JMSUtils.write((Serializable)((Object)JMSProvider.NAME), client);
                }
                client.writeInt(4321);
                JMSUtils.write((Serializable)((Object)JMSUtils.makeJMSException(exMessage, new Exception())), client);
            }
            client.flush();
        }
        catch (IOException ex) {
            s_traceLogger.fine("sendExceptionToClient IO", ex);
        }
    }

    private void initializeConnection(InetAddress targetInet, int targetPort, Streams server, String user, String password) throws JMSException {
        if (server.isOpen) {
            return;
        }
        try {
            String hostName = targetInet.getCanonicalHostName();
            if (!JMSUtils.isNull(JMSServer.getJMSServer(targetInet, targetPort, user, password))) {
                PipedInputStream serverInp = new PipedInputStream();
                PipedOutputStream servletOut = new PipedOutputStream(serverInp);
                PipedInputStream servletInp = new PipedInputStream();
                PipedOutputStream serverOut = new PipedOutputStream(servletInp);
                server.open(new DataInputStream(new BufferedInputStream(servletInp, BUFSIZE)), new DataOutputStream(new BufferedOutputStream(servletOut, BUFSIZE)));
                jmsserver.requestFromHTTPTunnel(new DataInputStream(new BufferedInputStream(serverInp, BUFSIZE)), new DataOutputStream(new BufferedOutputStream(serverOut, BUFSIZE)), hostName, targetPort);
            } else {
                if (!jmsserver.getTcpRelayEnabled()) {
                    throw new Exception("TCP Relay not configured");
                }
                SocketNetworkConnection conn = new SocketNetworkConnection(this.makeSocket(targetInet, targetPort));
                if (conn instanceof SocketNetworkConnection) {
                    Socket s = conn.getSocket();
                    s.setReceiveBufferSize(BUFSIZE);
                    s.setSendBufferSize(BUFSIZE);
                    s.setSoTimeout(jmsserver.getTcpRelayTimeout());
                }
                server.open(new DataInputStream(new BufferedInputStream(conn.getInputStream(), BUFSIZE)), new DataOutputStream(new BufferedOutputStream(conn.getOutputStream(), BUFSIZE)));
            }
        }
        catch (Throwable ex) {
            throw new JMSSecurityException("TCP connect failed when using " + targetInet.toString() + " port " + targetPort);
        }
    }

    private Socket makeSocket(final InetAddress addr, final int port) throws IOException {
        Socket ret = null;
        try {
            ret = (Socket)JMSServerProxy.getProxy().doSecureOp(new SecureOperation(){

                public Object execute() throws Exception {
                    return new Socket(addr, port);
                }
            });
        }
        catch (Exception ex) {
            throw (IOException)ex;
        }
        ret.setTcpNoDelay(true);
        return ret;
    }

    private void delay(long startTime) {
        long timeLeft;
        long stopTime = startTime + (long)ERROR_DELAY;
        while ((timeLeft = stopTime - System.currentTimeMillis()) > 0L) {
            try {
                Thread.sleep(timeLeft);
            }
            catch (InterruptedException ignored) {}
        }
    }

    private static class Streams {
        public DataInputStream in = null;
        public DataOutputStream out = null;
        public boolean isOpen = false;

        private Streams() {
        }

        public void open(DataInputStream in, DataOutputStream out) {
            this.in = in;
            this.out = out;
            this.isOpen = true;
        }

        public void close() {
            try {
                if (this.isOpen) {
                    this.in.close();
                    this.out.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class Protocol {
        private int protocol = 0;
        private int major = 0;
        private int minor = 0;

        public void setProtocol(int protocol) {
            this.protocol = protocol;
        }

        public void setMajor(int major) {
            this.major = major;
        }

        public void setMinor(int minor) {
            this.minor = minor;
        }

        public int getProtocol() {
            return this.protocol;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public void write(DataOutputStream dout) throws IOException, EOFException {
            dout.writeInt(this.protocol);
            dout.writeInt(this.major);
            dout.writeInt(this.minor);
            dout.flush();
        }

        public void read(DataInputStream dinp) throws Throwable {
            this.setProtocol(this.readCheck(dinp, "JMS HTTP Protocol", -559038634));
            this.setMajor(this.readCheck(dinp, "JMS major version", 1));
            this.setMinor(this.readCheck(dinp, "JMS minor version", 0));
        }

        public String toString() {
            String ret = "Protocol:\n";
            ret = ret + "  protocol = " + this.getProtocol() + "\n";
            ret = ret + "  major = " + this.getMajor() + "\n";
            ret = ret + "  minor = " + this.getMinor() + "\n";
            return ret;
        }

        private int readCheck(DataInputStream dinp, String what, int val) throws Throwable {
            int ret = dinp.readInt();
            if (ret != val) {
                throw new JMSSecurityException(what + "expected " + val + " found " + ret);
            }
            return ret;
        }
    }
}

