/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindConnection;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSObject;
import com.evermind.server.jms.JMSUtils;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

public class EvermindTemporaryDestination
implements Serializable,
Destination {
    private final String m_name;
    private final String m_connID;
    private final int m_domain;
    private transient WeakReference m_conn = null;
    private transient Set m_readers = null;
    private static final Map s_map = JMSUtils.makeMap();
    static final long serialVersionUID = 2609554313067510663L;

    protected EvermindTemporaryDestination(String name, String connID, int domain) {
        this.m_name = name;
        this.m_connID = connID;
        this.m_domain = domain;
        this.m_conn = null;
        this.m_readers = null;
    }

    protected EvermindTemporaryDestination(String name, EvermindConnection conn, int domain) {
        this.m_name = name;
        this.m_connID = conn.getID();
        this.m_domain = domain;
        this.m_conn = new WeakReference<EvermindConnection>(conn);
        this.m_readers = new HashSet();
        s_map.put(this.m_name, this);
    }

    public boolean equals(Object obj) {
        return obj == null ? false : (obj instanceof EvermindTemporaryDestination ? ((EvermindTemporaryDestination)obj).m_name.equals(this.m_name) : false);
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public String toString() {
        String c = JMSUtils.isNull(this.m_connID) ? "" : "," + this.m_connID;
        return JMSUtils.pp(this) + "[" + this.m_name + c + "," + JMSUtils.pp(this.m_domain) + "]";
    }

    public final synchronized void delete() throws JMSException {
        if (this.m_conn == null || this.m_readers == null) {
            EvermindTemporaryDestination orig = (EvermindTemporaryDestination)s_map.get(this.m_name);
            if (orig == null || orig.m_conn == null || orig.m_readers == null) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02100", this));
            }
            orig.delete();
        } else {
            EvermindConnection conn;
            JMSUtils.sync(this.m_readers);
            if (this.m_readers.size() > 0) {
                JMSUtils.toJMSException(JMSMessages.getMessage("J2EE JMS-02101", this));
            }
            if ((conn = this.getConnection()) == null || conn.isClosed()) {
                JMSUtils.toInvalidDestinationException(JMSMessages.getMessage("J2EE JMS-02102", this));
            }
            conn.getServer().deleteTemporary(this.m_name);
            s_map.remove(this.m_name);
        }
    }

    final void assertConnection(String connID) throws InvalidDestinationException {
        if (!this.m_connID.equals(connID)) {
            JMSUtils.toInvalidDestinationException(JMSMessages.getMessage("J2EE JMS-02103", this, connID));
        }
    }

    final synchronized void attach(JMSObject reader) {
        this.m_readers.add(new WeakReference<JMSObject>(reader));
    }

    final String getName() {
        return this.m_name;
    }

    final String getConnectionID() {
        return this.m_connID;
    }

    final int getDomain() {
        return this.m_domain;
    }

    final EvermindConnection getConnection() {
        return (EvermindConnection)this.m_conn.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void purgeConnection(String connID) {
        Map map = s_map;
        synchronized (map) {
            Iterator iter = s_map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                EvermindTemporaryDestination td = (EvermindTemporaryDestination)entry.getValue();
                if (!td.m_connID.equals(connID)) continue;
                try {
                    EvermindConnection conn = td.getConnection();
                    if (conn != null) {
                        conn.getServer().deleteTemporary(td.getName());
                    }
                    iter.remove();
                }
                catch (Exception ex) {}
            }
        }
    }
}

