/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindMessage;
import com.evermind.server.jms.JMSUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;

public final class EvermindObjectMessage
extends EvermindMessage
implements ObjectMessage {
    private byte[] m_data = null;
    static final long serialVersionUID = -7343860040327066945L;

    EvermindObjectMessage() throws JMSException {
    }

    EvermindObjectMessage(Serializable data) throws JMSException {
        try {
            this.m_data = JMSUtils.toBytes(data);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("ctor", ex);
        }
    }

    protected final void xmlBody(PrintWriter out) {
        EvermindObjectMessage.xmlOctets(out, "objectbody", this.m_data);
    }

    protected final void writeBodyTo(DataOutput dout) throws IOException {
        if (this.m_data == null) {
            dout.writeInt(-1);
        } else {
            dout.writeInt(this.m_data.length);
            dout.write(this.m_data);
        }
    }

    protected final void readBodyFrom(DataInput dinp) throws IOException {
        int size = dinp.readInt();
        if (size < 0) {
            this.m_data = null;
        } else {
            this.m_data = new byte[size];
            dinp.readFully(this.m_data);
        }
    }

    public synchronized Serializable getObject() throws JMSException {
        Serializable ret = null;
        try {
            if (this.m_data != null) {
                ret = JMSUtils.toSerializable(this.m_data);
            }
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("getObject", ex);
        }
        return ret;
    }

    public synchronized void setObject(Serializable data) throws JMSException {
        this.assertWriteable();
        try {
            this.m_data = JMSUtils.toBytes(data);
        }
        catch (Throwable ex) {
            JMSUtils.toJMSException("setObject", ex);
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this.m_data = null;
    }

    public int getTypeID() {
        return 4;
    }

    protected EvermindMessage makeSelf() throws JMSException {
        return new EvermindObjectMessage();
    }

    protected synchronized void cloneBody(EvermindMessage ret) throws JMSException {
        ((EvermindObjectMessage)ret).m_data = this.m_data;
    }
}

