/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.EvermindQueue;
import com.evermind.server.jms.EvermindTemporaryQueue;
import com.evermind.server.jms.EvermindTemporaryTopic;
import com.evermind.server.jms.EvermindTopic;
import com.evermind.server.jms.JMSMessages;
import com.evermind.server.jms.JMSTraceLogger;
import com.evermind.server.jms.JMSUtils;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;

public class EvermindDestination
implements Serializable,
Destination {
    private final String m_name;
    private final String m_desc;
    private final boolean m_isSpecial;
    private final String m_loc;
    private String m_rfile = null;
    private String m_file = null;
    private static final JMSTraceLogger s_traceLogger = new JMSTraceLogger(EvermindDestination.class);
    public static final String DOMAIN = "domain";
    public static final String NAME = "name";
    public static final String LOCATION = "location";
    public static final String DESCRIPTION = "description";
    public static final String PERSISTENCE = "persistence-file";
    public static final String QUEUE = "queue";
    public static final String TOPIC = "topic";
    public static final String EXCEPTION_QUEUE = "jms/Oc4jJmsExceptionQueue";
    public static final String EXCEPTION_FILE = "Oc4jJmsExceptionQueue";
    static final long serialVersionUID = 4534439564919779477L;

    protected EvermindDestination(String name) {
        JMSUtils.checkNull("EvermindDestination", NAME, name);
        this.m_name = name;
        this.m_loc = null;
        this.m_desc = null;
        this.m_rfile = null;
        this.m_file = null;
        this.m_isSpecial = false;
    }

    protected EvermindDestination(String name, String loc, String file) {
        this.m_name = name;
        this.m_loc = loc;
        this.m_desc = null;
        this.m_rfile = file;
        this.m_file = file;
        this.m_isSpecial = true;
    }

    protected EvermindDestination(Map info, URL url) throws InstantiationException {
        this.m_name = (String)info.get(NAME);
        JMSUtils.noNull(info, NAME, this.m_name);
        String loc = (String)info.get(LOCATION);
        JMSUtils.noNull(info, LOCATION, loc);
        this.m_loc = loc;
        this.m_desc = (String)info.get(DESCRIPTION);
        this.m_rfile = (String)info.get(PERSISTENCE);
        this.m_file = JMSUtils.getAbsolutePath(this.m_rfile, url);
        this.m_isSpecial = false;
    }

    boolean isSpecial() {
        return this.m_isSpecial;
    }

    boolean isExceptionQueue() {
        return EXCEPTION_QUEUE.equals(this.m_name);
    }

    String getRelativePath() {
        return this.m_rfile;
    }

    public boolean equals(Object obj) {
        return obj instanceof EvermindDestination && this.compareTo((EvermindDestination)obj);
    }

    public int hashCode() {
        return this.m_name.hashCode() + (this.m_file == null ? 0 : this.m_file.hashCode());
    }

    public String toString() {
        return JMSUtils.pp(this) + "[" + this.m_name + "]";
    }

    final String getName() {
        return this.m_name;
    }

    final String getLocation() {
        return this.m_loc;
    }

    final String getDescription() {
        return this.m_desc;
    }

    final String getPersistenceFile() {
        return this.m_file;
    }

    public Map getAttributeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(NAME, this.m_name);
        map.put(LOCATION, this.m_loc);
        if (this.m_desc != null) {
            map.put(DESCRIPTION, this.m_desc);
        }
        if (this.m_file != null) {
            map.put(PERSISTENCE, this.m_file);
        }
        return map;
    }

    final void setPersistenceURL(URL newurl) throws InstantiationException {
        if (!JMSUtils.isNull(this.m_rfile)) {
            this.m_file = JMSUtils.getAbsolutePath(this.m_rfile, newurl);
        }
    }

    static void checkDestination(Destination d) throws InvalidDestinationException {
        if (d == null || d instanceof EvermindQueue || d instanceof EvermindTopic || d instanceof EvermindTemporaryQueue || d instanceof EvermindTemporaryTopic) {
            return;
        }
        JMSUtils.toInvalidDestinationException(JMSMessages.getMessage("J2EE JMS-01400", d, JMSUtils.getType(d)));
    }

    private boolean compareTo(EvermindDestination d) {
        return this.m_name.equals(d.m_name) && (this.m_file == null || this.m_file.equals(d.m_file));
    }
}

