/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.jms;

import com.evermind.server.jms.CMTSession;
import com.evermind.server.jms.CMTTopicSession;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XATopicConnection;

public final class CMTTopicConnection
implements TopicConnection {
    private final XATopicConnection m_conn;

    CMTTopicConnection(XATopicConnection conn) {
        this.m_conn = conn;
    }

    public XATopicConnection unwrap() {
        return this.m_conn;
    }

    public String toString() {
        return "CMTTopicConnection[" + this.m_conn + "]";
    }

    public void close() throws JMSException {
        this.m_conn.close();
    }

    public ConnectionConsumer createConnectionConsumer(Destination d, String selector, ServerSessionPool pool, int maxMsgs) throws JMSException {
        return this.m_conn.createConnectionConsumer(d, selector, pool, maxMsgs);
    }

    public ConnectionConsumer createConnectionConsumer(Topic t, String selector, ServerSessionPool pool, int maxMsgs) throws JMSException {
        return this.m_conn.createConnectionConsumer(t, selector, pool, maxMsgs);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic t, String name, String selector, ServerSessionPool pool, int maxMsgs) throws JMSException {
        return this.m_conn.createDurableConnectionConsumer(t, name, selector, pool, maxMsgs);
    }

    public Session createSession(boolean xact, int ackMode) throws JMSException {
        return xact ? new CMTSession(this.m_conn.createXASession()) : this.m_conn.createSession(xact, ackMode);
    }

    public TopicSession createTopicSession(boolean xact, int ackMode) throws JMSException {
        return xact ? new CMTTopicSession(this.m_conn.createXATopicSession()) : this.m_conn.createTopicSession(xact, ackMode);
    }

    public String getClientID() throws JMSException {
        return this.m_conn.getClientID();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.m_conn.getExceptionListener();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.m_conn.getMetaData();
    }

    public void setClientID(String id) throws JMSException {
        this.m_conn.setClientID(id);
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.m_conn.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.m_conn.start();
    }

    public void stop() throws JMSException {
        this.m_conn.stop();
    }
}

