/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceCollection
extends AbstractDescribable
implements XMLizable,
Serializable {
    public static final int METHOD_GET = 1;
    public static final int METHOD_POST = 2;
    public static final int METHOD_PUT = 4;
    public static final int METHOD_DELETE = 8;
    public static final int METHOD_HEAD = 16;
    public static final int METHOD_OPTIONS = 32;
    public static final int METHOD_TRACE = 64;
    public static final int METHOD_ALL = 128;
    protected List urlPatterns = new ArrayList();
    protected HashMap methods = new HashMap();

    public ResourceCollection() {
    }

    public ResourceCollection(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                String value;
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("web-resource-name")) {
                    this.setName(XMLUtils.getStringValue(node));
                    continue;
                }
                if (name.equals("url-pattern")) {
                    String urlPattern = XMLUtils.getUrlPatternValue(node);
                    if (urlPattern == null) continue;
                    if (!urlPattern.startsWith("/") && !urlPattern.startsWith("*.")) {
                        urlPattern = "/".concat(urlPattern);
                    }
                    this.addURLPattern(urlPattern);
                    continue;
                }
                if (name.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                if (!name.equals("http-method") || (value = XMLUtils.getStringValue(node)).equals("*")) continue;
                this.getMask(value);
                this.methods.put(value, value);
            }
        }
        if (this.getName() == null) {
            this.setName("Unnamed");
        }
    }

    public int getMask(String value) throws InstantiationException {
        if ("GET".equals(value)) {
            return 0;
        }
        if ("POST".equals(value)) {
            return 0;
        }
        if ("PUT".equals(value)) {
            return 0;
        }
        if ("DELETE".equals(value)) {
            return 0;
        }
        if ("HEAD".equals(value)) {
            return 0;
        }
        if ("OPTIONS".equals(value)) {
            return 0;
        }
        if ("TRACE".equals(value)) {
            return 0;
        }
        if ("*".equals(value)) {
            return 0;
        }
        this.getHttpExtensionMethodsMask(value);
        return 0;
    }

    public int getHttpExtensionMethodsMask(String value) throws InstantiationException {
        if ("PROPFIND".equals(value)) {
            return 0;
        }
        if ("PROPPATCH".equals(value)) {
            return 0;
        }
        if ("MKCOL".equals(value)) {
            return 0;
        }
        if ("GET".equals(value)) {
            return 0;
        }
        if ("HEAD".equals(value)) {
            return 0;
        }
        if ("POST".equals(value)) {
            return 0;
        }
        if ("DELETE".equals(value)) {
            return 0;
        }
        if ("PUT".equals(value)) {
            return 0;
        }
        if ("COPY".equals(value)) {
            return 0;
        }
        if ("MOVE".equals(value)) {
            return 0;
        }
        if ("LOCK".equals(value)) {
            return 0;
        }
        if ("UNLOCK".equals(value)) {
            return 0;
        }
        throw new InstantiationException("Unknown http-method: " + value + ", valid methods are: GET, POST, PUT, DELETE, HEAD, OPTIONS, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY, MOVE, LOCK, UNLOCK and *");
    }

    public HashMap getMethodMask() {
        return this.methods;
    }

    public void setMethodMask(HashMap mask) {
        this.methods.putAll(mask);
    }

    public void setMethodMask(String mask) {
        this.methods.put(mask.toUpperCase(), mask);
    }

    public List getURLPatterns() {
        return this.urlPatterns;
    }

    public void setURLPatterns(List patterns) {
        if (this.urlPatterns != null) {
            this.urlPatterns.clear();
        }
        if (patterns == null || patterns.isEmpty()) {
            return;
        }
        for (int i = 0; i < patterns.size(); ++i) {
            String urlPattern = (String)patterns.get(i);
            if (urlPattern == null) continue;
            if (!urlPattern.startsWith("/") && !urlPattern.startsWith("*.")) {
                urlPattern = "/".concat(urlPattern);
            }
            this.addURLPattern(urlPattern);
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<web-resource-collection>");
        if (this.getName() != null) {
            out.println(indention + "\t<web-resource-name>" + XMLUtils.encode(this.getName()) + "</web-resource-name>");
        }
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.urlPatterns != null) {
            XMLUtils.writeStrings(this.urlPatterns, "url-pattern", out, indention + "\t");
        }
        if (this.methods.isEmpty()) {
            out.println(indention + "\t<http-method>*</http-method>");
        } else {
            Collection c = this.methods.values();
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                out.println(indention + "\t<http-method>" + itr.next() + "</http-method>");
            }
        }
        out.println(indention + "</web-resource-collection>");
    }

    public void removeURLPattern(int pos) {
        this.firePropertyChangeEvent("urlPatterns", this.urlPatterns.remove(pos), null);
    }

    public void addURLPattern(String pattern) {
        this.urlPatterns.add(pattern);
        this.firePropertyChangeEvent("urlPatterns", null, pattern);
    }

    public String getURLPatternSpec() {
        String urlPatternSpec = new String();
        for (int i = 0; i < this.urlPatterns.size(); ++i) {
            if (i > 0) {
                urlPatternSpec = urlPatternSpec + ":";
            }
            String s = (String)this.urlPatterns.get(i);
            urlPatternSpec = urlPatternSpec + s;
        }
        return urlPatternSpec;
    }

    public String[] getUncheckedMethods() {
        Object sarray = null;
        ArrayList ms = new ArrayList();
        Collection c = this.methods.values();
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            ms.add(itr.next());
        }
        return ms.toArray(new String[0]);
    }

    public static String[] getMethodsFromMask(HashMap mask) {
        Object sarray = null;
        ArrayList ms = new ArrayList();
        Collection c = mask.values();
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            ms.add(itr.next());
        }
        return ms.toArray(new String[0]);
    }

    public String[] getMethods() {
        return ResourceCollection.getMethodsFromMask(this.methods);
    }

    public void setMethods(String[] httpMethods) throws InstantiationException {
        this.methods.clear();
        for (int i = 0; i < httpMethods.length; ++i) {
            this.methods.put(httpMethods[i].toUpperCase(), httpMethods[i]);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("web-resource      : ");
        buf.append("\n");
        buf.append("  web-resource-name      : ");
        buf.append(this.getName());
        buf.append("\n");
        buf.append("  description      : ");
        buf.append(this.getDescription());
        buf.append("\n");
        buf.append("  url-pattern      : ");
        buf.append(this.getURLPatterns());
        buf.append("\n");
        buf.append("  http-method      : ");
        buf.append(this.getMethods());
        buf.append("\n");
        return buf.toString();
    }
}

