/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http.deployment;

import com.evermind.naming.ContextUtils;
import com.evermind.naming.file.ContentFileContext;
import com.evermind.net.AccessRegionSet;
import com.evermind.security.UserManager;
import com.evermind.server.ApplicationServer;
import com.evermind.server.OC4JServer;
import com.evermind.server.ServerComponent;
import com.evermind.server.deployment.DestinationReference;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.deployment.EnvironmentEntry;
import com.evermind.server.deployment.EnvironmentEntryContainer;
import com.evermind.server.deployment.IconDescriptor;
import com.evermind.server.deployment.ResourceEnvironmentReference;
import com.evermind.server.deployment.ResourceReference;
import com.evermind.server.deployment.ResourceReferenceContainer;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.deployment.SecurityRoleContainer;
import com.evermind.server.deployment.SecurityRoleReference;
import com.evermind.server.deployment.WebModule;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.EJBReference;
import com.evermind.server.ejb.deployment.EJBReferenceContainer;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpApplicationConfig;
import com.evermind.server.http.deployment.ContextParam;
import com.evermind.server.http.deployment.ErrorPage;
import com.evermind.server.http.deployment.ExpirationSetting;
import com.evermind.server.http.deployment.FilterDescriptor;
import com.evermind.server.http.deployment.FilterMapping;
import com.evermind.server.http.deployment.JACCPropertyChangeListener;
import com.evermind.server.http.deployment.JspConfigDescriptor;
import com.evermind.server.http.deployment.ListenerDescriptor;
import com.evermind.server.http.deployment.MimeMapping;
import com.evermind.server.http.deployment.OJSPConfigDescriptor;
import com.evermind.server.http.deployment.OjspInitDescriptor;
import com.evermind.server.http.deployment.SecurityConstraint;
import com.evermind.server.http.deployment.ServletDescriptor;
import com.evermind.server.http.deployment.ServletMapping;
import com.evermind.server.http.deployment.SyntheticWebModuleDescriptor;
import com.evermind.server.http.deployment.TagLibraryUse;
import com.evermind.server.http.deployment.WebApp24Descriptor;
import com.evermind.server.http.deployment.WebComponentDescriptor;
import com.evermind.util.AbstractDescribable;
import com.evermind.util.ConfigUtils;
import com.evermind.util.HTTPProperties;
import com.evermind.util.ServerProperties;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import com.oracle.bricks.j2ee.JGroupConfig;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import oracle.classloader.util.FileUtils;
import oracle.j2ee.deployment.DeploymentMessages;
import oracle.j2ee.util.TraceLogger;
import oracle.j2ee.ws.server.WebServicesDescriptorFactory;
import oracle.j2ee.ws.server.deployment.ServiceReferenceContainer;
import oracle.j2ee.ws.server.deployment.ServiceReferenceDescriptor;
import oracle.j2ee.ws.server.deployment.oc4j.WebService;
import oracle.j2ee.ws.server.deployment.oc4j.WebServiceEndpoint;
import oracle.j2ee.ws.server.deployment.oc4j.WebServicesDescriptor;
import oracle.oc4j.admin.management.callbackinterfaces.OC4JWebModuleCallBackIf;
import oracle.oc4j.admin.management.callbackinterfaces.WebModuleCallBackIf;
import oracle.oc4j.admin.management.mbeans.Servlet;
import oracle.oc4j.admin.management.shared.WebModuleEjbRefMapping;
import oracle.oc4j.admin.management.shared.WebModuleEnvEntryMapping;
import oracle.oc4j.admin.management.shared.WebModuleJspConfig;
import oracle.oc4j.admin.management.shared.WebModuleLoginConfig;
import oracle.oc4j.admin.management.shared.WebModuleResourceRefMapping;
import oracle.oc4j.admin.management.shared.WebModuleSessionTracking;
import oracle.oc4j.configuration.J2EEContextConfigDelegate;
import oracle.oc4j.security.acc.JaccWrapper;
import oracle.security.jazn.JAZNWebAppConfig;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpApplicationDescriptor
extends ServerComponent
implements HttpApplicationConfig,
EnvironmentEntryContainer,
ResourceReferenceContainer,
SecurityRoleContainer,
EJBReferenceContainer,
WebModuleCallBackIf,
ServiceReferenceContainer,
OC4JWebModuleCallBackIf,
WebApp24Descriptor {
    protected HttpApplication application;
    private J2EEContextConfigDelegate m_configDelegate = new J2EEContextConfigDelegate(this);
    protected String shortName;
    protected String sourceDirectory;
    private HttpApplicationDescriptor parent;
    protected int jspTimeout;
    protected boolean simpleJspMapping;
    private boolean defaultJspPatternCheckDone;
    private String globalJspServletName;
    protected boolean enableJspDispatcherShortCut;
    private static final String defaultGlobalJspUrlPattern = "*.jsp*.JSP*.jspx*.sqljsp*.SQLJSP";
    private String definedGlobalJspUrlPattern = "";
    protected List filters;
    protected List filterMappings;
    protected List listeners;
    protected IconDescriptor icon;
    protected boolean distributable;
    protected List parameters;
    protected List servlets = null;
    protected List jsps = null;
    protected List welcomeFiles;
    protected List securityConstraints;
    protected List servletMappings;
    protected List mimeMappings;
    protected List errorPages;
    protected List environmentEntries;
    protected List securityRoles;
    protected String realmName;
    protected int authMethod = 1;
    protected boolean ssoAuth;
    protected Properties securityFilterProperties;
    protected int searchLocalClassesFirst = 0;
    protected int includeWarManifestClassPath = 0;
    protected String formLoginPage;
    protected String formErrorPage;
    protected int sessionTimeout = 1200;
    protected List tagLibraries;
    protected Properties virtualMappings;
    protected String defaultCharSet;
    protected boolean iso8859Convert;
    protected boolean wared;
    protected boolean development;
    protected boolean packaged;
    protected URL persistenceURL;
    protected String persistenceURLPath;
    protected URL jspCacheURL;
    protected String jspCacheURLPath;
    protected String jspCacheTlds;
    protected Object tldCache;
    protected String jspTaglibLocations;
    protected boolean jspPrintNull;
    protected int defaultBufferSize = 2048;
    protected String temporaryDirectoryString = "./temp";
    protected File temporaryDirectory;
    protected String resourceRoot = "./resources";
    protected String defaultContentType = "application/octet-stream";
    protected boolean explicitDefaultContentType = false;
    protected String servletDirectory = null;
    protected boolean autoJoinSession;
    protected long fileModificationCheckInterval = 1000L;
    protected List codebases;
    protected List privateRelativeClasspaths;
    protected List sessionTrackerServlets;
    protected List requestTrackerServlets;
    protected Properties servletChainings;
    protected boolean directoryBrowsingAllowed;
    protected boolean clustered;
    protected boolean sendSessionCookie = true;
    protected int sessionCookieMaxAge;
    protected String sessionCookieDomain;
    protected String sessionCookiePath;
    protected boolean sessionCookieIsSecure;
    protected boolean sessionCookieIsURLRewriting = true;
    protected boolean autoReloadDynamicPages = true;
    protected boolean autoReloadBeans = true;
    AccessRegionSet accessRegionSet;
    protected File mimeMappingsFile;
    protected long mimeMappingsLastModified;
    protected String mimeMappingsPath;
    protected EnterpriseArchive archive;
    protected boolean replicateServletContext;
    protected List expirationSettings;
    protected boolean broadcastSessionsEveryRequest;
    protected List webAppPermissions;
    protected List jspPermissions;
    protected boolean storeSourceUsingClassName;
    protected String contextRoot;
    protected boolean accessLog = false;
    protected JspConfigDescriptor jspConfig = null;
    protected OJSPConfigDescriptor ojspConfig = null;
    protected OjspInitDescriptor ojspInit = null;
    protected DocumentType webXMLDoctype = null;
    protected boolean synthetic = false;
    private final String JSPServletName = "oracle.jsp.runtimev2.JspServlet";
    protected HashMap localeEncodingMap;
    protected static final String SECURITY_CONSTRAINTS = "securityConstraints";
    protected static final String SECURITY_ROLES = "securityRoles";
    private JACCPropertyChangeListener listener;
    protected static final String SERVLETS = "servlets";
    protected static final String JSPS = "jsps";
    private boolean isSessionConfigSet = false;
    private boolean isLoginConfigSet = false;
    private boolean isParsingOrionXML = false;
    private boolean warVersion25 = false;
    private boolean warMetadataComplete = true;
    protected ArrayList propertyChangeList = null;
    private static Logger m_traceLogger = TraceLogger.getLogger(HttpApplicationDescriptor.class);
    protected Properties m_preDestroyConfig = null;
    protected Properties m_postConstructConfig = null;
    private boolean m_metadataParsed = false;

    public HttpApplicationDescriptor(EnterpriseArchive archive, String shortName, HttpApplicationDescriptor parent, UserManager parentUserManager, boolean wared) {
        this.parent = parent;
        this.shortName = shortName;
        this.archive = archive;
        this.wared = wared;
        this.createJACCListener();
        if (this.archive != null && this.archive.getCompatibility() >= 1) {
            this.warVersion25 = true;
        }
    }

    public HttpApplicationDescriptor(EnterpriseArchive archive, String shortName, HttpApplicationDescriptor parent, UserManager parentUserManager, boolean wared, boolean synthetic) {
        this.parent = parent;
        this.shortName = shortName;
        this.archive = archive;
        this.wared = wared;
        this.synthetic = synthetic;
        this.createJACCListener();
        if (this.archive != null && this.archive.getCompatibility() >= 1) {
            this.warVersion25 = true;
        }
    }

    private String createConfigId() {
        return this.archive.getName();
    }

    public String getConfigId() {
        if (this.listener != null) {
            return this.listener.configId;
        }
        return null;
    }

    public JGroupConfig getClusterConfig() {
        JGroupConfig jcfg = this.archive.getClusterConfig();
        if (jcfg != null) {
            return jcfg;
        }
        if (this.parent != null) {
            return this.parent.getClusterConfig();
        }
        return null;
    }

    private void createJACCListener() {
        if (this.listener != null) {
            return;
        }
        if (JaccWrapper.isJaccEnabled()) {
            this.listener = new JACCPropertyChangeListener(this.createConfigId());
            this.addPropertyChangeListener(this.listener);
        }
    }

    public synchronized void setAllowDirectoryBrowsing(boolean allowed) {
        this.directoryBrowsingAllowed = allowed;
    }

    protected void reset() {
        super.reset();
        this.application = null;
        this.defaultBufferSize = 2048;
        this.storeSourceUsingClassName = false;
        this.tagLibraries = null;
        this.setDescription(null);
        this.virtualMappings = null;
        this.authMethod = 1;
        this.formLoginPage = null;
        this.formErrorPage = null;
        this.icon = null;
        this.distributable = false;
        this.parameters = null;
        this.servlets = null;
        this.jsps = null;
        this.welcomeFiles = null;
        this.securityConstraints = null;
        this.m_configDelegate.clear();
        this.m_metadataParsed = false;
        this.securityRoles = null;
        this.servletMappings = null;
        this.mimeMappings = null;
        this.errorPages = null;
        this.sessionTimeout = 1200;
        this.ssoAuth = false;
        this.securityFilterProperties = null;
        this.searchLocalClassesFirst = 0;
        this.includeWarManifestClassPath = 0;
        this.development = false;
        this.iso8859Convert = true;
        this.sourceDirectory = null;
        this.temporaryDirectory = null;
        this.temporaryDirectoryString = "./temp";
        this.resourceRoot = this.packaged ? "" : "./resources";
        this.defaultContentType = "application/octet-stream";
        this.explicitDefaultContentType = false;
        this.servletDirectory = null;
        this.autoJoinSession = false;
        this.fileModificationCheckInterval = 1000L;
        this.codebases = null;
        this.privateRelativeClasspaths = null;
        this.sessionTrackerServlets = null;
        this.requestTrackerServlets = null;
        this.servletChainings = null;
        this.directoryBrowsingAllowed = false;
        this.clustered = false;
        this.mimeMappingsFile = null;
        this.mimeMappingsLastModified = 0L;
        this.mimeMappingsPath = null;
        this.sendSessionCookie = true;
        this.sessionCookieMaxAge = 0;
        this.sessionCookieDomain = null;
        this.sessionCookiePath = null;
        this.sessionCookieIsSecure = false;
        this.sessionCookieIsURLRewriting = true;
        this.persistenceURL = null;
        this.persistenceURLPath = null;
        this.jspCacheURL = null;
        this.jspCacheURLPath = null;
        this.jspCacheTlds = null;
        this.jspTaglibLocations = null;
        this.jspPrintNull = true;
        this.simpleJspMapping = true;
        this.defaultJspPatternCheckDone = false;
        this.enableJspDispatcherShortCut = true;
        this.autoReloadDynamicPages = true;
        this.autoReloadBeans = true;
        this.defaultCharSet = null;
        this.accessRegionSet = null;
        this.broadcastSessionsEveryRequest = false;
        this.jspConfig = null;
        this.ojspConfig = null;
        this.webXMLDoctype = null;
        if (this.localeEncodingMap != null) {
            this.localeEncodingMap.clear();
        }
        this.isSessionConfigSet = false;
        this.isLoginConfigSet = false;
        if (this.parent != null) {
            this.defaultCharSet = this.parent.defaultCharSet;
            this.defaultBufferSize = this.parent.defaultBufferSize;
            this.storeSourceUsingClassName = this.parent.storeSourceUsingClassName;
            this.jspTimeout = this.parent.jspTimeout;
            this.development = this.parent.development;
            this.iso8859Convert = this.parent.iso8859Convert;
            this.sourceDirectory = this.parent.sourceDirectory;
            this.sessionTimeout = this.parent.sessionTimeout;
            this.broadcastSessionsEveryRequest = this.parent.broadcastSessionsEveryRequest;
            this.sendSessionCookie = this.parent.sendSessionCookie;
            this.sessionCookieMaxAge = this.parent.sessionCookieMaxAge;
            this.sessionCookieDomain = this.parent.sessionCookieDomain;
            this.sessionCookiePath = this.parent.sessionCookiePath;
            this.sessionCookieIsSecure = this.parent.sessionCookieIsSecure;
            this.sessionCookieIsURLRewriting = this.parent.sessionCookieIsURLRewriting;
            if (this.parent.persistenceURLPath != null) {
                this.persistenceURLPath = this.parent.persistenceURLPath;
            }
            if (this.parent.jspCacheURLPath != null) {
                this.jspCacheURLPath = this.parent.jspCacheURLPath;
            }
            if (this.parent.jspCacheTlds != null) {
                this.jspCacheTlds = this.parent.jspCacheTlds;
            }
            if (this.parent.jspTaglibLocations != null) {
                this.jspTaglibLocations = this.parent.jspTaglibLocations;
            }
            this.jspPrintNull = this.parent.jspPrintNull;
            this.simpleJspMapping = this.parent.simpleJspMapping;
            this.enableJspDispatcherShortCut = this.parent.enableJspDispatcherShortCut;
            this.defaultContentType = this.parent.defaultContentType;
            this.explicitDefaultContentType = this.parent.explicitDefaultContentType;
            try {
                Properties tempProp;
                if (this.virtualMappings == null) {
                    this.virtualMappings = new Properties();
                }
                if ((tempProp = this.parent.getVirtualMappings()) != null && tempProp.size() > 0) {
                    this.virtualMappings.putAll((Map<?, ?>)tempProp);
                }
            }
            catch (InstantiationException e) {
                // empty catch block
            }
            List codebases = this.parent.getCodebases();
            if (codebases != null) {
                this.codebases = new ArrayList(codebases);
            }
            this.directoryBrowsingAllowed = this.parent.directoryBrowsingAllowed;
            this.parameters = this.parent.parameters;
        }
        this.propertyChangeList = null;
        this.m_preDestroyConfig = null;
        this.m_postConstructConfig = null;
    }

    public void parseMainNode(Node node) throws InstantiationException {
        this.webXMLDoctype = this.getDoctype();
        String name = node.getNodeName();
        if (this.m_configDelegate.parseNode(node)) {
            return;
        }
        if (name.equals("icon")) {
            this.icon = new IconDescriptor(node);
        } else if (name.equals("distributable")) {
            this.distributable = true;
        } else if (name.equals("context-param")) {
            this.parseContextParameter(node);
        } else if (name.equals("servlet")) {
            if (ServerProperties.getOracleCtsUseCtsFlags()) {
                if (this.listener != null && JaccWrapper.isJaccEnabled()) {
                    this.listener.createServletChangeListener();
                    ServletDescriptor servletDescriptor = new ServletDescriptor(node, this.getURL(), this.listener.createServletChangeListener(), this, this.isPre24WebXml());
                    if (this.isParsingOrionXML) {
                        servletDescriptor.setPartOfOrionWeb(true);
                    }
                    this.addServlet(servletDescriptor);
                } else {
                    ServletDescriptor servletDescriptor = new ServletDescriptor(node, this.getURL(), null, this, this.isPre24WebXml());
                    if (this.isParsingOrionXML) {
                        servletDescriptor.setPartOfOrionWeb(true);
                    }
                    this.addServlet(servletDescriptor);
                }
            } else if (this.listener != null && JaccWrapper.isJaccEnabled()) {
                this.listener.createServletChangeListener();
                ServletDescriptor servletDescriptor = new ServletDescriptor(node, this.getURL(), this.listener.createServletChangeListener(), this);
                if (this.isParsingOrionXML) {
                    servletDescriptor.setPartOfOrionWeb(true);
                }
                this.addServlet(servletDescriptor);
            } else {
                ServletDescriptor servletDescriptor = new ServletDescriptor(node, this.getURL(), null, this);
                if (this.isParsingOrionXML) {
                    servletDescriptor.setPartOfOrionWeb(true);
                }
                this.addServlet(servletDescriptor);
            }
        } else if (name.equals("filter")) {
            FilterDescriptor filterDescriptor = new FilterDescriptor(node);
            if (this.isParsingOrionXML) {
                filterDescriptor.setPartOfOrionWeb(true);
            }
            this.addFilter(filterDescriptor);
        } else if (name.equals("filter-mapping")) {
            this.addFilterMapping(new FilterMapping(node, this.isParsingOrionXML));
        } else if (name.equals("listener")) {
            this.addListener(new ListenerDescriptor(node));
        } else if (name.equals("servlet-mapping")) {
            ServletMapping mapping = new ServletMapping(node, this.isParsingOrionXML);
            String urlpattern = mapping.getURLPattern();
            if (this.parent == null && this.globalJspServletName != null && mapping.getServletName().equals(this.globalJspServletName)) {
                this.definedGlobalJspUrlPattern = this.definedGlobalJspUrlPattern + urlpattern;
            }
            if (this.simpleJspMapping && (urlpattern != null && urlpattern.endsWith("*") || this.parent != null && this.isJspUrlPattern(urlpattern))) {
                this.simpleJspMapping = false;
            }
            this.addServletMapping(mapping);
        } else if (name.equals("session-config")) {
            if (this.isSessionConfigSet && ServerProperties.getOracleCtsUseCtsFlags()) {
                throw new InstantiationException("Duplicate session-config");
            }
            this.parseSessionConfig(node);
            this.isSessionConfigSet = true;
        } else if (name.equals("mime-mapping")) {
            this.addMimeMapping(new MimeMapping(node));
        } else if (name.equals("welcome-file-list")) {
            this.parseWelcomeFiles(node);
        } else if (name.equals("error-page")) {
            this.parseErrorPage(node);
        } else if (name.equals("login-config")) {
            if (this.isLoginConfigSet && ServerProperties.getOracleCtsUseCtsFlags()) {
                throw new InstantiationException("Duplicate login-config");
            }
            this.parseLoginConfig(node);
            this.isLoginConfigSet = true;
        } else if (name.equals("security-role")) {
            this.addSecurityRole(new SecurityRole(node));
        } else if (name.equals("security-constraint")) {
            this.addSecurityConstraint(new SecurityConstraint(this, node));
        } else if (name.equals("taglib")) {
            this.addTagLibrary(new TagLibraryUse(node));
        } else if (name.equals("jsp-config")) {
            if (this.jspConfig != null && ServerProperties.getOracleCtsUseCtsFlags()) {
                throw new InstantiationException("Duplicate jsp-config");
            }
            this.jspConfig = new JspConfigDescriptor(this, node);
        } else if (name.equals("locale-encoding-mapping-list")) {
            this.parseLocaleEncodingMappingList(node);
        } else if (name.equals("pre-destroy")) {
            this.m_preDestroyConfig = this.parseLifecycleConfig(node, this.m_preDestroyConfig);
        } else if (name.equals("post-construct")) {
            this.m_postConstructConfig = this.parseLifecycleConfig(node, this.m_postConstructConfig);
        } else {
            super.parseMainNode(node);
        }
    }

    public void initWebServices() throws InstantiationException {
        this.initWebServices(null);
    }

    public void initWebServices(byte[] deplData) throws InstantiationException {
        if (!ContextUtils.isInContext(this.getContext(), "WEB-INF/webservices.xml")) {
            return;
        }
        try {
            this.webServicesDescriptor = WebServicesDescriptorFactory.getInstance().newWebServicesDescriptor(this);
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
        this.webServicesDescriptor.setDefaultDeploymentSubname("WEB-INF");
        ((ServerComponent)((Object)this.webServicesDescriptor)).setDeploymentContext(this.getDeploymentContext());
        ((ServerComponent)((Object)this.webServicesDescriptor)).init();
        if (deplData != null) {
            ((ServerComponent)((Object)this.webServicesDescriptor)).setDeploymentData(new String(deplData));
        }
        ((ServerComponent)((Object)this.webServicesDescriptor)).initDeployment();
    }

    public void init(SyntheticWebModuleDescriptor syntheticDescriptor) throws InstantiationException {
        if (syntheticDescriptor instanceof WebServicesDescriptor) {
            this.init((WebServicesDescriptor)syntheticDescriptor);
        }
    }

    public void init(WebServicesDescriptor webServicesDescriptor) throws InstantiationException {
        if (webServicesDescriptor == null) {
            return;
        }
        if (this.getSecurityRole("oc4j-administrators") == null) {
            this.addSecurityRole(new SecurityRole("oc4j-administrators"));
        }
        boolean needsSecurityLoginConfig = false;
        EJBPackage pkg = null;
        this.webServicesDescriptor = webServicesDescriptor;
        if (!webServicesDescriptor.isEjbWebService()) {
            webServicesDescriptor.setContextRoot(this.getContextRoot());
        } else {
            pkg = (EJBPackage)webServicesDescriptor.getBundleDescriptor();
        }
        Iterator i = webServicesDescriptor.getWebServices().iterator();
        while (i.hasNext()) {
            WebService ws = (WebService)i.next();
            Iterator j = ws.getEndpoints().iterator();
            while (j.hasNext()) {
                WebServiceEndpoint ep = (WebServiceEndpoint)j.next();
                boolean ejbEndpoint = ep.implementedByEjbComponent();
                String name = ep.getLinkName();
                ServletDescriptor servlet = this.getServletDescriptor(name, ejbEndpoint);
                if (servlet == null) {
                    throw new InstantiationException("no servlet by name :'" + name + "' found in web-app : " + this.getName());
                }
                String className = servlet.getClassName();
                servlet.setClassName(ep.getServletClassName());
                String uri = null;
                if (ejbEndpoint) {
                    this.setContextRoot(webServicesDescriptor.getContextRoot());
                    try {
                        this.setURL(new URL("http://dummy"));
                    }
                    catch (IOException io) {
                        throw new InstantiationException(io.getMessage());
                    }
                    boolean hasSecurity = false;
                    Iterator iterator = ep.getSecurityConstraints(this).iterator();
                    while (iterator.hasNext()) {
                        hasSecurity = true;
                        needsSecurityLoginConfig = true;
                        SecurityConstraint sc = (SecurityConstraint)iterator.next();
                        this.addSecurityConstraint(sc);
                    }
                    BeanDescriptor beanDesc = pkg.getBean(ep.getEjbLink());
                    if (beanDesc != null) {
                        AbstractDescribable newEntry;
                        iterator = beanDesc.getEnvironmentEntries().iterator();
                        while (iterator.hasNext()) {
                            newEntry = (EnvironmentEntry)iterator.next();
                            if (this.getEnvironmentEntry(newEntry.getName()) != null) continue;
                            this.addEnvironmentEntry((EnvironmentEntry)newEntry);
                        }
                        iterator = beanDesc.getResourceReferences().iterator();
                        while (iterator.hasNext()) {
                            newEntry = (ResourceReference)iterator.next();
                            if (this.getResourceReference(newEntry.getName()) != null) continue;
                            this.addResourceReference((ResourceReference)newEntry);
                        }
                        iterator = beanDesc.getResourceEnvironmentReferences().iterator();
                        while (iterator.hasNext()) {
                            newEntry = (ResourceEnvironmentReference)iterator.next();
                            if (this.getResourceEnvironmentReference(newEntry.getName()) != null) continue;
                            this.addResourceEnvironmentReference((ResourceEnvironmentReference)newEntry);
                        }
                        iterator = beanDesc.getDestinationReferences().iterator();
                        while (iterator.hasNext()) {
                            newEntry = (DestinationReference)iterator.next();
                            if (this.getDestinationReference(newEntry.getName()) != null) continue;
                            this.addDestinationReference((DestinationReference)newEntry);
                        }
                        if (hasSecurity) {
                            iterator = beanDesc.getSecurityRoleReferences().iterator();
                            while (iterator.hasNext()) {
                                newEntry = (SecurityRoleReference)iterator.next();
                                servlet.addSecurityRoleReference((SecurityRoleReference)newEntry);
                            }
                        }
                    }
                    uri = ep.getEndpointAddressSubContextUri();
                    ServletMapping mapping = new ServletMapping();
                    mapping.setServletName(name);
                    mapping.setURLPattern(uri);
                    this.addServletMapping(mapping);
                    EJBReference reference = new EJBReference(ep.getEjbName(), false, false);
                    reference.setRemoteName(ep.getServiceEndpointInterface());
                    reference.setEJBLink(ep.getEjbLink());
                    reference.setEndpoint(true);
                    this.addEJBReference(reference);
                    servlet.setLoadOnStartup(true);
                    this.addServlet(servlet);
                } else {
                    Iterator k = this.getServletMappings(name).iterator();
                    while (k.hasNext()) {
                        ServletMapping mapping = (ServletMapping)k.next();
                        uri = mapping.getURLPattern();
                        if (uri == null) continue;
                        if (!k.hasNext()) break;
                        DeploymentMessages.warningDuplicateServletMapping(name, uri);
                        break;
                    }
                    ep.setServletImplClassName(className);
                    ep.setEndpointAddressSubContextUri(uri);
                }
                this.mapWsdlImports();
            }
        }
        if (needsSecurityLoginConfig) {
            this.realmName = webServicesDescriptor.getRealm();
            this.authMethod = webServicesDescriptor.getAuthMethod();
            this.ssoAuth = webServicesDescriptor.getSSOAuth();
            Iterator roleIterator = pkg.getSecurityRoles().iterator();
            while (roleIterator.hasNext()) {
                SecurityRole newEntry = (SecurityRole)roleIterator.next();
                this.addSecurityRole(newEntry);
            }
        }
    }

    public void mapWsdlImports() throws InstantiationException {
        if (this.getWebServicesDescriptor() == null) {
            return;
        }
        Iterator i = this.getWebServicesDescriptor().getWebServices().iterator();
        while (i.hasNext()) {
            File wsdlDir;
            WebService ws = (WebService)i.next();
            if (!ws.getExposeWsdl() || (wsdlDir = ws.getWsdlDir()) == null) continue;
            Iterator epIt = ws.getEndpoints().iterator();
            while (epIt.hasNext()) {
                String uriMinusLastPart = "";
                WebServiceEndpoint wsEp = (WebServiceEndpoint)epIt.next();
                String endPointSubCtxUri = wsEp.getEndpointAddressSubContextUri();
                String[] splitUri = endPointSubCtxUri.split("/");
                for (int l = 1; l < splitUri.length - 1; ++l) {
                    uriMinusLastPart = uriMinusLastPart + "/" + splitUri[l];
                }
                int wsdlDirPathLength = wsdlDir.getAbsolutePath().length();
                ArrayList filesInWsdlDir = com.evermind.util.FileUtils.getFileList(wsdlDir);
                Iterator it = filesInWsdlDir.iterator();
                while (it.hasNext()) {
                    String filePath = (String)it.next();
                    String virtualDIrPath = filePath.substring(wsdlDirPathLength).replace(File.separatorChar, '/');
                    this.setVirtualMappings(uriMinusLastPart + virtualDIrPath, filePath);
                }
            }
        }
    }

    public synchronized void addFilter(FilterDescriptor filter) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        this.filters.add(filter);
        this.firePropertyChangeEvent("filters", null, filter);
    }

    public synchronized void addFilterMapping(FilterMapping filter) {
        if (this.filterMappings == null) {
            this.filterMappings = new ArrayList();
        }
        this.filterMappings.add(filter);
        this.firePropertyChangeEvent("filterMappings", null, filter);
    }

    public synchronized void addListener(ListenerDescriptor listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
        this.firePropertyChangeEvent("listeners", null, listener);
    }

    public synchronized void setListener(int pos, ListenerDescriptor listener) {
        ListenerDescriptor previous = this.listeners.set(pos, listener);
        this.firePropertyChangeEvent("listeners", previous, listener);
    }

    public synchronized List getFilters() {
        List parentFilters;
        if (this.filters == null) {
            return this.parent == null ? Collections.EMPTY_LIST : this.parent.getFilters();
        }
        List list = parentFilters = this.parent == null ? null : this.parent.getFilters();
        if (parentFilters == null || parentFilters == Collections.EMPTY_LIST) {
            return this.filters;
        }
        ArrayList list2 = new ArrayList(parentFilters);
        list2.addAll(this.filters);
        return list2;
    }

    public synchronized List getLocalFilters() {
        return this.filters == null ? Collections.EMPTY_LIST : this.filters;
    }

    public synchronized List getFilterMappings() {
        List parentFilterMappings;
        if (this.filterMappings == null) {
            return this.parent == null ? Collections.EMPTY_LIST : this.parent.getFilterMappings();
        }
        List list = parentFilterMappings = this.parent == null ? null : this.parent.getFilterMappings();
        if (parentFilterMappings == null || parentFilterMappings == Collections.EMPTY_LIST) {
            return this.filterMappings;
        }
        ArrayList list2 = new ArrayList(parentFilterMappings);
        list2.addAll(this.filterMappings);
        return list2;
    }

    public synchronized List getLocalFilterMappings() {
        if (this.filterMappings == null) {
            return Collections.EMPTY_LIST;
        }
        return this.filterMappings;
    }

    public synchronized void setFilterMappings(List filterMappings) {
        this.filterMappings = filterMappings;
        this.firePropertyChangeEvent("mbeanFilterMappings", null, filterMappings);
    }

    public synchronized void addFilterMapping(String filterName, String URLPattern, String servletName, String[] dispatchers) throws InstantiationException {
        this.addFilterMapping(new FilterMapping(filterName, URLPattern, servletName, dispatchers, this.isParsingOrionXML));
        this.firePropertyChangeEvent("mbeanFilterMappings", null, this.filterMappings);
    }

    public synchronized void removeFilterMapping(String filterName, String URLPattern, String servletName) {
        if (this.filterMappings != null) {
            for (int i = 0; i < this.filterMappings.size(); ++i) {
                FilterMapping fm = (FilterMapping)this.filterMappings.get(i);
                String _urlPattern = fm.getURLPattern();
                String _servletName = fm.getServletName();
                if (!fm.getFilterName().equals(filterName) || (URLPattern == null || !URLPattern.equals(_urlPattern)) && (servletName == null || !servletName.equals(_servletName))) continue;
                this.removeFilterMapping(i);
                --i;
                this.firePropertyChangeEvent("mbeanFilterMappings", null, this.filterMappings);
            }
        }
    }

    public synchronized List getListeners() {
        List parentListeners;
        if (this.listeners == null) {
            return this.parent == null ? Collections.EMPTY_LIST : this.parent.getListeners();
        }
        List list = parentListeners = this.parent == null ? null : this.parent.getListeners();
        if (parentListeners == null || parentListeners == Collections.EMPTY_LIST) {
            return this.listeners;
        }
        ArrayList list2 = new ArrayList(parentListeners);
        list2.addAll(this.listeners);
        return list2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.startsWith("#")) {
            return;
        }
        if (ApplicationServer.serverExtensionProviders != null) {
            for (int i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                if (!ApplicationServer.serverExtensionProviders[i].parseHttpApplicationMainNode(this, node)) continue;
                return;
            }
        }
        if (name.equals("context-param-mapping")) {
            ContextParam entry;
            String entryName = XMLUtils.getNodeAttribute(node, "name");
            if (entryName == null || (entry = this.getContextParameter(entryName)) == null) return;
            entry.parseOrionXML(node);
            return;
        } else if (name.equals("env-entry-mapping")) {
            String entryName = XMLUtils.getNodeAttribute(node, "name");
            if (entryName == null) throw new InstantiationException("env-entry-mapping with missing name attribute");
            EnvironmentEntry entry = this.getEnvironmentEntry(entryName);
            if (entry == null) return;
            entry.parseOrionXML(node);
            return;
        } else if (name.equals("security-role-mapping")) {
            SecurityRole parentRole;
            SecurityRole role;
            String roleName = XMLUtils.getNodeAttribute(node, "name");
            if (roleName == null || (role = this.getSecurityRole(roleName, false)) == null) return;
            role.parseOrionXML(node);
            if (this.archive == null || (parentRole = this.archive.getSecurityRole(roleName)) == null) return;
            parentRole.parseOrionXML(node);
            return;
        } else if (name.equals("web-app-class-loader")) {
            this.parseWebAppLoaderConfig(node);
            return;
        } else if (name.equals("jazn-web-app")) {
            this.parseJAZNConfig(node);
            return;
        } else if (name.equals("login-config-props")) {
            this.parseLoginConfigProps(node);
            return;
        } else if (name.equals("virtual-directory")) {
            this.parseVirtualDirectoryMapping(node);
            return;
        } else if (name.equals("development")) {
            this.development = !"false".equalsIgnoreCase(XMLUtils.getStringValue(node));
            return;
        } else if (name.equals("iso-8859-1-convert")) {
            this.iso8859Convert = !"false".equalsIgnoreCase(XMLUtils.getStringValue(node));
            return;
        } else if (name.equals("mime-mappings")) {
            if (this.mimeMappings == null) {
                this.mimeMappings = new ArrayList();
            }
            this.parseMimeMappings(XMLUtils.getNodeAttribute(node, "path"));
            return;
        } else if (name.equals("request-tracker")) {
            this.addRequestTracker(XMLUtils.getNodeAttribute(node, "servlet-name"));
            return;
        } else if (name.equals("classpath")) {
            String path = XMLUtils.getNodeAttribute(node, "path");
            if (path == null) {
                throw new InstantiationException("classpath tag with missing path attribute");
            }
            this.addClasspath(path);
            return;
        } else {
            if (name.equals("cluster-config")) return;
            if (name.equals("servlet-chaining")) {
                this.parseServletChainingNode(node);
                return;
            } else if (name.equals("session-tracking")) {
                this.parseSessionTrackingNode(node);
                return;
            } else if (name.equals("ejb-ref-mapping")) {
                EJBReference reference;
                String referenceName = XMLUtils.getNodeAttribute(node, "name");
                if (referenceName == null || (reference = this.getEJBReference(referenceName)) == null) return;
                reference.parseOrionXML(node);
                return;
            } else if (name.equals("service-ref-mapping")) {
                String referenceName = XMLUtils.getNodeAttribute(node, "name");
                if (referenceName == null) throw new InstantiationException("service-ref-mapping with missing name attribute");
                ServiceReferenceDescriptor reference = this.getServiceReference(referenceName);
                if (reference == null) throw new InstantiationException("service-ref '" + referenceName + "' referenced from service-ref-mapping not found");
                reference.parseOrionXML(node);
                return;
            } else if (name.equals("mime-mapping-deployment")) {
                this.parseMimeMappingDeployment(node);
                return;
            } else if (name.equals("resource-ref-mapping")) {
                String resName = XMLUtils.getNodeAttribute(node, "name");
                if (resName == null) return;
                ResourceReference reference = this.getResourceReference(resName);
                if (reference == null) throw new InstantiationException("resource-ref '" + resName + "' referenced from resource-ref-mapping not found");
                reference.parseOrionXML(node);
                return;
            } else if (name.equals("resource-env-ref-mapping")) {
                String envName = XMLUtils.getNodeAttribute(node, "name");
                if (envName == null) return;
                ResourceEnvironmentReference reference = this.getResourceEnvironmentReference(envName);
                if (reference == null) throw new InstantiationException("resource-env-ref '" + envName + "' referenced from resource-env-ref-mapping not found");
                reference.parseOrionXML(node);
                return;
            } else if (name.equals("message-destination-ref-mapping")) {
                String destName = XMLUtils.getNodeAttribute(node, "name");
                if (destName == null) return;
                DestinationReference reference = this.getDestinationReference(destName);
                if (reference == null) throw new InstantiationException("message-destination-ref '" + destName + "' referenced from message-destination-ref-mapping not found");
                reference.parseOrionXML(node);
                return;
            } else if (name.equals("access-mask")) {
                try {
                    this.accessRegionSet = AccessRegionSet.getSet(node);
                    return;
                }
                catch (Exception e) {
                    throw new InstantiationException("Error initializing AccessRegionSet: " + e.getMessage());
                }
            } else if (name.equals("persistence-path")) {
                this.persistenceURLPath = XMLUtils.getStringValue(node);
                return;
            } else if (name.equals("jsp-cache-directory")) {
                this.jspCacheURLPath = XMLUtils.getStringValue(node);
                return;
            } else if (name.equals("jsp-cache-tlds")) {
                this.jspCacheTlds = XMLUtils.getStringValue(node);
                return;
            } else if (name.equals("jsp-taglib-locations")) {
                this.jspTaglibLocations = XMLUtils.getStringValue(node);
                return;
            } else if (name.equals("jsp-print-null")) {
                this.jspPrintNull = !"false".equalsIgnoreCase(XMLUtils.getStringValue(node));
                return;
            } else if (name.equals("simple-jsp-mapping")) {
                this.simpleJspMapping = !"false".equalsIgnoreCase(XMLUtils.getStringValue(node));
                return;
            } else if (name.equals("enable-jsp-dispatcher-shortcut")) {
                this.enableJspDispatcherShortCut = !"false".equalsIgnoreCase(XMLUtils.getStringValue(node));
                return;
            } else if (name.equals("autoreload-jsp-beans")) {
                this.autoReloadDynamicPages = !"false".equalsIgnoreCase(XMLUtils.getStringValue(node));
                return;
            } else if (name.equals("expiration-setting")) {
                this.addExpirationSetting(new ExpirationSetting(node));
                return;
            } else if (name.equals("file-modification-check-interval")) {
                try {
                    this.fileModificationCheckInterval = Long.parseLong(XMLUtils.getStringValue(node));
                    return;
                }
                catch (Exception e) {}
                return;
            } else if (name.equals("servlet-webdir")) {
                String directory = XMLUtils.getStringValue(node);
                if (directory.length() == 0) {
                    directory = "";
                } else {
                    if (!directory.startsWith("/")) {
                        directory = '/' + directory;
                    }
                    if (!directory.endsWith("/")) {
                        directory = directory + '/';
                    }
                }
                this.servletDirectory = directory;
                return;
            } else if (name.equals("web-app") || name.equals("orion-web-app")) {
                this.parseRootNode(node, false);
                return;
            } else if (name.equals("ojsp-init")) {
                if (!this.isParsingOrionXML) return;
                this.ojspInit = new OjspInitDescriptor(this, node);
                return;
            } else if (name.equals("ojsp-config")) {
                if (!this.isParsingOrionXML) return;
                this.ojspConfig = new OJSPConfigDescriptor(this, node);
                return;
            } else {
                super.parseDeploymentMainNode(node);
            }
        }
    }

    public synchronized void addExpirationSetting(ExpirationSetting setting) {
        if (this.expirationSettings == null) {
            this.expirationSettings = new ArrayList();
        }
        this.expirationSettings.add(setting);
        this.firePropertyChangeEvent("expirationSettings", null, this.expirationSettings);
    }

    public synchronized List getExpirationSettings() {
        List parentSettings;
        if (this.expirationSettings == null) {
            if (this.parent != null) {
                return this.parent.getExpirationSettings();
            }
            return Collections.EMPTY_LIST;
        }
        List list = parentSettings = this.parent == null ? null : this.parent.getExpirationSettings();
        if (parentSettings == null) {
            return this.expirationSettings;
        }
        ArrayList settings = new ArrayList(parentSettings);
        settings.addAll(this.expirationSettings);
        return settings;
    }

    public synchronized List getLocalExpirationSettings() {
        return this.expirationSettings == null ? Collections.EMPTY_LIST : this.expirationSettings;
    }

    public synchronized void setExpirationSettings(List settings) {
        this.expirationSettings = settings;
        if (this.application != null) {
            this.application.initExpirationSettings();
        }
        this.firePropertyChangeEvent("expirationSettings", null, this.expirationSettings);
    }

    public synchronized void addExpirationSetting(String expires, String urlPattern) throws InstantiationException {
        if (this.expirationSettings == null) {
            this.expirationSettings = new ArrayList();
        }
        this.expirationSettings.add(new ExpirationSetting(expires, urlPattern));
        if (this.application != null) {
            this.application.initExpirationSettings();
        }
        this.firePropertyChangeEvent("expirationSettings", null, this.expirationSettings);
    }

    public synchronized void removeExpirationSetting(String expires, String urlPattern) {
        if (this.expirationSettings != null) {
            for (int i = 0; i < this.expirationSettings.size(); ++i) {
                ExpirationSetting setting = (ExpirationSetting)this.expirationSettings.get(i);
                if (!setting.getURLPattern().equals(urlPattern) || !setting.getExpires().equals(expires)) continue;
                this.expirationSettings.remove(i);
                if (this.application != null) {
                    this.application.initExpirationSettings();
                }
                this.firePropertyChangeEvent("expirationSettings", null, this.expirationSettings);
                break;
            }
        }
    }

    protected void parseRootNodeValue(String name, String value) throws InstantiationException {
        if (name.equals("xsi:schemaLocation")) {
            boolean bl = this.warVersion25 = value.indexOf("2_5") != -1;
        }
        if (name.equals("version")) {
            this.warVersion25 = value.equals("2.5");
        }
        boolean bl = this.warMetadataComplete = !this.warVersion25;
        if (this.warVersion25 && name.equals("metadata-complete")) {
            this.warMetadataComplete = !value.equals("false");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseDeploymentRootNodeValue(String name, String value) throws InstantiationException {
        if (name.equals("directory-browsing")) {
            if (value.equals("allow")) {
                this.directoryBrowsingAllowed = true;
                return;
            } else {
                if (!value.equals("deny")) throw new InstantiationException("Illegal directory-browsing attribute value: '" + value + "', legal values are 'allow' and 'deny'");
                this.directoryBrowsingAllowed = false;
            }
            return;
        } else if (name.equals("autoreload-jsp-pages")) {
            this.autoReloadDynamicPages = !"false".equalsIgnoreCase(value);
            return;
        } else if (name.equals("autoreload-jsp-beans")) {
            this.autoReloadBeans = !"false".equalsIgnoreCase(value);
            return;
        } else if (name.equals("autojoin-session")) {
            this.autoJoinSession = "true".equalsIgnoreCase(value);
            return;
        } else if (name.equals("temporary-directory")) {
            this.temporaryDirectoryString = value;
            return;
        } else if (name.equals("jsp-cache-directory")) {
            this.jspCacheURLPath = value;
            return;
        } else if (name.equals("jsp-cache-path")) {
            this.jspCacheURLPath = value;
            return;
        } else if (name.equals("jsp-cache-tlds")) {
            if (!value.equalsIgnoreCase("on") && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("standard") && !value.equalsIgnoreCase("off") && !value.equalsIgnoreCase("false")) throw new InstantiationException("Illegal jsp-cache-tlds attribute value: '" + value + "', legal values are 'standard', 'on' and 'off'");
            this.jspCacheTlds = value;
            return;
        } else if (name.equals("jsp-taglib-locations")) {
            this.jspTaglibLocations = value;
            return;
        } else if (name.equals("jsp-print-null")) {
            this.jspPrintNull = !"false".equalsIgnoreCase(value);
            return;
        } else if (name.equals("simple-jsp-mapping")) {
            this.simpleJspMapping = !"false".equalsIgnoreCase(value);
            return;
        } else if (name.equals("enable-jsp-dispatcher-shortcut")) {
            this.enableJspDispatcherShortCut = !"false".equalsIgnoreCase(value);
            return;
        } else if (name.equals("development")) {
            this.development = "true".equalsIgnoreCase(value);
            return;
        } else if (name.equals("replicate-servlet-context")) {
            this.replicateServletContext = "true".equalsIgnoreCase(value);
            return;
        } else if (name.equals("source-directory")) {
            this.sourceDirectory = value;
            return;
        } else if (name.equals("servlet-webdir")) {
            this.servletDirectory = value;
            return;
        } else if (name.equals("persistence-path")) {
            this.persistenceURLPath = value;
            return;
        } else if (name.equals("default-charset")) {
            this.defaultCharSet = value;
            return;
        } else if (name.equals("iso-8859-1-convert")) {
            this.iso8859Convert = !"false".equalsIgnoreCase(value);
            return;
        } else if (name.equals("default-mime-type")) {
            this.defaultContentType = value;
            this.explicitDefaultContentType = true;
            return;
        } else if (name.equals("store-source-by-classname")) {
            this.storeSourceUsingClassName = "true".equalsIgnoreCase(value);
            return;
        } else if (name.equals("file-modification-check-interval")) {
            try {
                this.fileModificationCheckInterval = Long.parseLong(value);
                return;
            }
            catch (Exception e) {}
            return;
        } else if (name.equals("default-buffer-size")) {
            try {
                this.defaultBufferSize = Integer.parseInt(value);
                if (this.defaultBufferSize >= 0) return;
                this.defaultBufferSize = 0;
                return;
            }
            catch (Exception e) {}
            return;
        } else if (name.equals("jsp-timeout")) {
            try {
                this.jspTimeout = Integer.parseInt(value);
                return;
            }
            catch (Exception e) {}
            return;
        } else if (name.equals("context-root")) {
            try {
                this.setContextRoot(value);
                return;
            }
            catch (Exception e) {}
            return;
        } else if (name.equals("access-log")) {
            try {
                this.setAccessLog(value);
                return;
            }
            catch (Exception exception) {}
            return;
        } else {
            super.parseDeploymentRootNodeValue(name, value);
        }
    }

    private void parseContextParameter(Node node) throws InstantiationException {
        NodeList nodes = node.getChildNodes();
        String paramName = null;
        String paramValue = null;
        String description = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            String name = nodes.item(i).getNodeName();
            if (name.startsWith("#")) continue;
            if (name.equals("param-name")) {
                paramName = XMLUtils.getStringValue(nodes.item(i));
                continue;
            }
            if (name.equals("param-value")) {
                paramValue = XMLUtils.getStringValue(nodes.item(i));
                continue;
            }
            if (name.equals("description")) {
                description = XMLUtils.getStringValue(nodes.item(i));
                continue;
            }
            throw new InstantiationException("Unknown context-param subtag: " + name);
        }
        if (paramName == null) {
            throw new InstantiationException("context-param with missing param-name subtag");
        }
        if (paramValue == null) {
            throw new InstantiationException("context-param with missing param-value subtag");
        }
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(new ContextParam(paramName, paramValue, description));
    }

    public synchronized void addServlet(ServletDescriptor servlet) throws InstantiationException {
        if (servlet.getClassName() != null) {
            if (servlet.getClassName().equals("oracle.jsp.runtimev2.JspServlet")) {
                if (this.parent != null) {
                    this.simpleJspMapping = false;
                } else {
                    this.globalJspServletName = servlet.getName();
                }
            }
            if (this.servlets == null) {
                this.servlets = new ArrayList();
            }
            boolean _set = false;
            String servletName = servlet.getName();
            for (int i = 0; i < this.servlets.size(); ++i) {
                if (!((ServletDescriptor)this.servlets.get(i)).getName().equals(servletName)) continue;
                this.servlets.set(i, servlet);
                _set = true;
                break;
            }
            if (!_set) {
                this.servlets.add(servlet);
            }
            this.firePropertyChangeEvent(SERVLETS, null, servlet);
        } else {
            if (this.jsps == null) {
                this.jsps = new ArrayList();
            }
            this.jsps.add(servlet);
            this.firePropertyChangeEvent(JSPS, null, servlet);
        }
    }

    public synchronized void addServletMapping(ServletMapping mapping) {
        if (this.servletMappings == null) {
            this.servletMappings = new ArrayList();
        }
        this.servletMappings.add(mapping);
        this.firePropertyChangeEvent("servletMappings", null, mapping);
    }

    private boolean isJspUrlPattern(String urlpattern) {
        return urlpattern != null && (urlpattern.endsWith("jsp") || urlpattern.endsWith("jspx"));
    }

    private void parseVirtualDirectoryMapping(Node node) throws InstantiationException {
        NodeList nodes = node.getChildNodes();
        String paramName = XMLUtils.getNodeAttribute(node, "virtual-path");
        String paramValue = XMLUtils.getNodeAttribute(node, "real-path");
        if (this.virtualMappings == null) {
            this.virtualMappings = new Properties();
        }
        if (paramName == null) {
            throw new InstantiationException("Missing 'virtual-path' attribute in virtual-directory tag");
        }
        if (paramValue == null) {
            throw new InstantiationException("Missing 'real-path' attribute in virtual-directory tag");
        }
        this.virtualMappings.put(paramName, paramValue);
    }

    private void parseServletChainingNode(Node node) throws InstantiationException {
        NodeList nodes = node.getChildNodes();
        String mimeType = XMLUtils.getNodeAttribute(node, "mime-type");
        String servletName = XMLUtils.getNodeAttribute(node, "servlet-name");
        if (this.servletChainings == null) {
            this.servletChainings = new Properties();
        }
        if (mimeType == null) {
            throw new InstantiationException("Missing 'mime-type' attribute in servlet-chaining tag");
        }
        if (servletName == null) {
            throw new InstantiationException("Missing 'servlet-name' attribute in servlet-chaining tag");
        }
        this.servletChainings.put(mimeType, servletName);
    }

    private void parseSessionConfig(Node node) throws InstantiationException {
        NodeList nodes = node.getChildNodes();
        String sessionTimeout = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            String name = nodes.item(i).getNodeName();
            if (name.startsWith("#")) continue;
            if (name.equals("session-timeout")) {
                sessionTimeout = XMLUtils.getStringValue(nodes.item(i)).trim();
                continue;
            }
            throw new InstantiationException("Unknown session-config subtag: " + name);
        }
        if (sessionTimeout != null) {
            try {
                if (sessionTimeout.endsWith("s")) {
                    sessionTimeout = sessionTimeout.substring(0, sessionTimeout.length() - 1);
                    this.sessionTimeout = Integer.parseInt(sessionTimeout);
                } else {
                    if (sessionTimeout.endsWith("m")) {
                        sessionTimeout = sessionTimeout.substring(0, sessionTimeout.length() - 1);
                    }
                    this.sessionTimeout = Integer.parseInt(sessionTimeout) * 60;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public synchronized void addWelcomeFile(String file) {
        if (this.welcomeFiles == null) {
            this.welcomeFiles = new ArrayList();
        }
        this.welcomeFiles.add(file);
        this.firePropertyChangeEvent("welcomeFiles", null, file);
    }

    public void parseMimeMappingDeployment(Node node) throws InstantiationException {
        MimeMapping mapping;
        String keyName = XMLUtils.getNodeAttribute(node, "extension");
        if (keyName == null) {
            return;
        }
        MimeMapping mimeMapping = mapping = this.mimeMappings != null ? this.getMimeMapping(keyName) : null;
        if (mapping == null) {
            mapping = new MimeMapping();
            mapping.setKey(keyName);
            mapping.setValue(keyName);
            mapping.parseDeploymentXML(node);
            this.addMimeMapping(mapping);
        } else {
            mapping.parseDeploymentXML(node);
        }
    }

    public MimeMapping getMimeMapping(String extension) {
        if (this.mimeMappings != null) {
            for (int i = 0; i < this.mimeMappings.size(); ++i) {
                MimeMapping mapping = (MimeMapping)this.mimeMappings.get(i);
                if (!extension.equals(mapping.getKey())) continue;
                return mapping;
            }
        }
        return null;
    }

    public synchronized void addMimeMapping(MimeMapping mapping) {
        boolean existed = false;
        if (this.mimeMappings == null) {
            this.mimeMappings = new ArrayList();
        } else {
            MimeMapping oldMapping = this.getMimeMapping((String)mapping.getKey());
            if (oldMapping != null) {
                existed = true;
                oldMapping.setKey((String)mapping.getKey());
                oldMapping.setValue(mapping.getValue());
                if (mapping.getRequestHandler() != null) {
                    oldMapping.setRequestHandler(mapping.getRequestHandler());
                }
            }
        }
        if (!existed) {
            this.mimeMappings.add(mapping);
        }
        this.firePropertyChangeEvent("mimeMappings", null, mapping);
    }

    private void parseWelcomeFiles(Node parent) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.startsWith("#") || !name.equals("welcome-file")) continue;
            String file = XMLUtils.getStringValue(node);
            if (file.indexOf(10) > 0) {
                file = file.replace('\n', ' ');
            }
            if (file.indexOf(13) > 0) {
                file = file.replace('\r', ' ');
            }
            if (file.indexOf(9) > 0) {
                file = file.replace('\t', ' ');
            }
            if ((file = file.trim()).startsWith("/")) {
                file = file.substring(1);
            }
            if (file == null || file.length() <= 0) continue;
            this.addWelcomeFile(file);
        }
    }

    private void parseWebAppLoaderConfig(Node node) {
        this.searchLocalClassesFirst = XMLUtils.getBooleanNodeAttribute(node, "search-local-classes-first");
        this.includeWarManifestClassPath = XMLUtils.getBooleanNodeAttribute(node, "include-war-manifest-class-path");
    }

    private void parseJAZNConfig(Node parent) throws InstantiationException {
        try {
            this.securityFilterProperties = JAZNWebAppConfig.parseJAZNWebAppConfig((Node)parent);
        }
        catch (IllegalArgumentException e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    private void parseLoginConfigProps(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node childNode;
                String value;
                Node node = list.item(i);
                String name = node.getNodeName();
                if (!name.equals("auth-method") || !(value = (childNode = node.getFirstChild()).getNodeValue()).equalsIgnoreCase("SSO")) continue;
                this.ssoAuth = true;
            }
        }
    }

    public boolean getSearchLocalClassesFirst() {
        if (this.searchLocalClassesFirst == 0) {
            if (this.parent != null) {
                return this.parent.getSearchLocalClassesFirst();
            }
            return false;
        }
        return this.searchLocalClassesFirst == 1;
    }

    public boolean getIncludeWarManifestClassPath() {
        if (this.includeWarManifestClassPath == 0) {
            if (this.parent != null) {
                return this.parent.getIncludeWarManifestClassPath();
            }
            return true;
        }
        return this.includeWarManifestClassPath == 1;
    }

    public void setSearchLocalClassesFirst(boolean set) {
        this.searchLocalClassesFirst = set ? 1 : 2;
        this.firePropertyChangeEvent("searchLocalClassesFirst", null, null);
    }

    public void setIncludeWarManifestClassPath(boolean set) {
        this.includeWarManifestClassPath = set ? 1 : 2;
        this.firePropertyChangeEvent("includeWarManifestClassPath", null, null);
    }

    public boolean getSSOAuth() {
        return this.ssoAuth;
    }

    public Properties getSecurityFilterProperties() {
        return this.securityFilterProperties;
    }

    public JAZNWebAppConfig getJAZNWebAppConfig() {
        if (this.securityFilterProperties == null) {
            return null;
        }
        return new JAZNWebAppConfig(this.securityFilterProperties);
    }

    private void parseLoginConfig(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("#text")) continue;
                if (name.equals("realm-name")) {
                    this.realmName = XMLUtils.getStringValue(node);
                }
                if (name.equals("form-login-config")) {
                    NodeList subNodes = node.getChildNodes();
                    if (subNodes == null) continue;
                    for (int x = 0; x < subNodes.getLength(); ++x) {
                        Node subNode = subNodes.item(x);
                        if (subNode.getNodeName().equals("form-login-page")) {
                            this.formLoginPage = XMLUtils.getStringValue(subNode);
                            continue;
                        }
                        if (!subNode.getNodeName().equals("form-error-page")) continue;
                        this.formErrorPage = XMLUtils.getStringValue(subNode);
                    }
                    continue;
                }
                if (!name.equals("auth-method")) continue;
                String type = XMLUtils.getStringValue(node);
                if (type != null) {
                    type = type.trim();
                }
                if ("BASIC".equalsIgnoreCase(type)) {
                    this.authMethod = 1;
                    continue;
                }
                if ("DIGEST".equalsIgnoreCase(type)) {
                    this.authMethod = 2;
                    continue;
                }
                if ("FORM".equalsIgnoreCase(type)) {
                    this.authMethod = 4;
                    continue;
                }
                if ("CLIENT-CERT".equalsIgnoreCase(type)) {
                    this.authMethod = 8;
                    continue;
                }
                throw new InstantiationException("Unknown auth-method: " + type + ", valid methods are: BASIC, DIGEST, FORM, CLIENT-CERT");
            }
            if (this.authMethod == 4 && this.formLoginPage == null) {
                throw new InstantiationException("form-login-page must be specified when using form-auth");
            }
        }
        if (this.formLoginPage != null && !this.formLoginPage.startsWith("/")) {
            this.formLoginPage = "/" + this.formLoginPage;
        }
        if (this.formErrorPage != null && !this.formErrorPage.startsWith("/")) {
            this.formErrorPage = "/" + this.formErrorPage;
        }
    }

    private void parseErrorPage(Node node) throws InstantiationException {
        NodeList nodes = node.getChildNodes();
        String errorCode = null;
        String exceptionType = null;
        String location = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            String name = nodes.item(i).getNodeName();
            if (name.startsWith("#")) continue;
            if (name.equals("error-code")) {
                errorCode = XMLUtils.getStringValue(nodes.item(i));
            }
            if (name.equals("exception-type")) {
                exceptionType = XMLUtils.getStringValue(nodes.item(i));
                continue;
            }
            if (!name.equals("location")) continue;
            location = XMLUtils.getStringValue(nodes.item(i));
        }
        if (errorCode != null) {
            try {
                this.addErrorPage(new ErrorPage(Integer.parseInt(errorCode), null, location));
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Invalid error-code value in error-page tag: " + errorCode + " (must be numeric)");
            }
        } else {
            this.addErrorPage(new ErrorPage(-1, exceptionType, location));
        }
    }

    public synchronized List getDefaultDocuments() {
        if (this.welcomeFiles != null && !this.welcomeFiles.isEmpty()) {
            if (this.parent == null || this.parent.getDefaultDocuments().isEmpty()) {
                return this.welcomeFiles;
            }
            ArrayList documents = new ArrayList();
            documents.addAll(this.welcomeFiles);
            documents.addAll(this.parent.getDefaultDocuments());
            return documents;
        }
        if (this.parent != null) {
            return this.parent.getDefaultDocuments();
        }
        if (this.welcomeFiles == null) {
            this.welcomeFiles = new ArrayList();
        }
        return this.welcomeFiles;
    }

    public synchronized List getWelcomeFiles() {
        if (this.welcomeFiles == null) {
            this.welcomeFiles = new ArrayList();
        }
        return this.welcomeFiles;
    }

    public synchronized void setWelcomeFiles(List files) {
        this.welcomeFiles = files;
        if (this.application != null) {
            this.application.setDefaultDocuments(this.getDefaultDocuments());
        }
        this.firePropertyChangeEvent("mbeanWelcomeFiles", null, files);
    }

    public synchronized void removeWelcomeFile(String file) {
        if (this.welcomeFiles != null) {
            this.welcomeFiles.remove(file);
        }
        if (this.application != null) {
            this.application.setDefaultDocuments(this.getDefaultDocuments());
        }
        this.firePropertyChangeEvent("mbeanWelcomeFiles", null, file);
    }

    public synchronized void addNewWelcomeFile(String file) {
        if (this.welcomeFiles == null) {
            this.welcomeFiles = new ArrayList();
        }
        this.welcomeFiles.add(file);
        if (this.application != null) {
            this.application.setDefaultDocuments(this.getDefaultDocuments());
        }
        this.firePropertyChangeEvent("mbeanWelcomeFiles", null, file);
    }

    public synchronized List getErrorPages() {
        if (this.errorPages == null) {
            try {
                if (this.parent.errorPages != null) {
                    return this.parent.errorPages;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return Collections.EMPTY_LIST;
        }
        return this.errorPages;
    }

    public synchronized List getLocalErrorPages() {
        if (this.errorPages == null) {
            return Collections.EMPTY_LIST;
        }
        return this.errorPages;
    }

    public synchronized void addErrorPage(ErrorPage page) {
        if (this.errorPages == null) {
            this.errorPages = new ArrayList();
        }
        this.errorPages.add(page);
    }

    public synchronized ServletDescriptor getServletDescriptor(String name, boolean autoCreate) {
        ServletDescriptor descriptor;
        int i;
        if (this.servlets != null) {
            for (i = 0; i < this.servlets.size(); ++i) {
                descriptor = (ServletDescriptor)this.servlets.get(i);
                if (!descriptor.getName().equals(name)) continue;
                return descriptor;
            }
        }
        if (this.jsps != null) {
            for (i = 0; i < this.jsps.size(); ++i) {
                descriptor = (ServletDescriptor)this.jsps.get(i);
                if (!descriptor.getName().equals(name)) continue;
                return descriptor;
            }
        }
        if (this.parent != null) {
            return this.parent.getServletDescriptor(name, autoCreate);
        }
        if (autoCreate) {
            ServletDescriptor descriptor2 = new ServletDescriptor(this, this.getURL());
            if (this.listener != null) {
                descriptor2.addPropertyChangeListener(this.listener);
            }
            descriptor2.setName(name);
            descriptor2.setClassName(name);
            return descriptor2;
        }
        return null;
    }

    public synchronized ServletDescriptor getJSPDescriptorByPath(String path) {
        if (path == null) {
            throw new NullPointerException("Path was null");
        }
        if (this.jsps != null) {
            for (int i = 0; i < this.jsps.size(); ++i) {
                ServletDescriptor descriptor = (ServletDescriptor)this.jsps.get(i);
                if (!path.equals(descriptor.getJSPPage())) continue;
                return descriptor;
            }
        }
        return null;
    }

    public synchronized ServletDescriptor getJSPDescriptor(String name) {
        if (this.jsps != null) {
            for (int i = 0; i < this.jsps.size(); ++i) {
                ServletDescriptor descriptor = (ServletDescriptor)this.jsps.get(i);
                if (!name.equals(descriptor.getName())) continue;
                return descriptor;
            }
        }
        return null;
    }

    public synchronized Map getInitParameters() {
        if (this.parameters == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ContextParam param = (ContextParam)iterator.next();
            map.put(param.getName(), param.getValue());
        }
        return map;
    }

    public synchronized boolean getAutoReloadDynamicPages() {
        return this.autoReloadDynamicPages;
    }

    public synchronized boolean getAutoJoinSession() {
        return this.autoJoinSession;
    }

    public synchronized void setAutoJoinSession(boolean join) {
        this.autoJoinSession = join;
        this.firePropertyChangeEvent("sessionTracking", null, null);
    }

    public synchronized int getSessionCookieMaxAge() {
        return this.sessionCookieMaxAge;
    }

    public synchronized void setUseSessionCookies(boolean cookies) {
        this.sendSessionCookie = cookies;
        this.firePropertyChangeEvent("sessionTracking", null, null);
    }

    public synchronized boolean isClustered() {
        return this.clustered || this.parent != null && this.parent.isClustered() || this.getClusterConfig() != null && this.getClusterConfig().isEnabled();
    }

    public synchronized List getMimeMappings() {
        if (this.parent != null && !this.parent.getMimeMappings().isEmpty()) {
            if (this.mimeMappings == null) {
                return this.parent.getMimeMappings();
            }
            ArrayList list = new ArrayList();
            list.addAll(this.parent.getMimeMappings());
            list.removeAll(this.mimeMappings);
            list.addAll(this.mimeMappings);
            return list;
        }
        if (this.mimeMappings == null) {
            return Collections.EMPTY_LIST;
        }
        return this.mimeMappings;
    }

    public synchronized List getLocalMimeMappings() {
        if (this.mimeMappings == null) {
            return Collections.EMPTY_LIST;
        }
        return this.mimeMappings;
    }

    public synchronized long getLastModifiedCheckInterval() {
        return this.fileModificationCheckInterval;
    }

    public synchronized void setLastModifiedCheckInterval(long interval) throws IllegalArgumentException {
        if (interval < 0L) {
            throw new IllegalArgumentException("file-modification-check-interval cannot be negative.");
        }
        this.fileModificationCheckInterval = interval;
        if (this.application != null) {
            this.application.setLastModifiedCheckExpires(interval);
        }
        this.firePropertyChangeEvent("file-modification-check-interval", null, null);
    }

    public synchronized boolean getAutoReloadBeans() {
        return this.autoReloadBeans;
    }

    public synchronized URL getResourceRootURL() throws InstantiationException {
        if (this.getURL() == null) {
            return null;
        }
        try {
            if (this.resourceRoot == null) {
                return ConfigUtils.getURL(this.getURL(), "");
            }
            return ConfigUtils.getURL(this.getURL(), this.resourceRoot);
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Incorrect resource URL specified in " + this);
        }
        catch (IOException e) {
            throw new InstantiationException("Incorrect resource URL specified in " + this);
        }
    }

    public synchronized String getSessionCookieDomain() {
        return this.sessionCookieDomain;
    }

    public synchronized String getSessionCookiePath() {
        return this.sessionCookiePath;
    }

    public synchronized boolean getSessionCookieIsSecure() {
        return this.sessionCookieIsSecure;
    }

    public synchronized boolean getSessionCookieIsURLRewriting() {
        return this.sessionCookieIsURLRewriting;
    }

    public synchronized Properties getChainingProperties() {
        if (this.parent != null && this.parent.getChainingProperties() != null) {
            if (this.servletChainings == null) {
                return this.parent.getChainingProperties();
            }
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.parent.getChainingProperties());
            properties.putAll((Map<?, ?>)this.servletChainings);
            return properties;
        }
        return this.servletChainings;
    }

    public synchronized List getServletMappings() {
        if (this.parent != null && !this.parent.getServletMappings().isEmpty()) {
            if (this.servletMappings == null) {
                return this.parent.getServletMappings();
            }
            ArrayList list = new ArrayList();
            list.addAll(this.servletMappings);
            list.addAll(this.parent.getServletMappings());
            return list;
        }
        if (this.servletMappings == null) {
            return Collections.EMPTY_LIST;
        }
        return this.servletMappings;
    }

    public synchronized List getLocalServletMappings() {
        if (this.servletMappings == null) {
            return Collections.EMPTY_LIST;
        }
        return this.servletMappings;
    }

    public synchronized List getServletMappings(String name) {
        ArrayList<ServletMapping> list = new ArrayList<ServletMapping>();
        Iterator i = this.getServletMappings().iterator();
        while (i.hasNext()) {
            ServletMapping mapping = (ServletMapping)i.next();
            if (!name.equals(mapping.getServletName())) continue;
            list.add(mapping);
        }
        return list;
    }

    public synchronized String getDefaultContentType() {
        return this.defaultContentType;
    }

    public boolean isExplicitDefaultContentType() {
        return this.explicitDefaultContentType;
    }

    public boolean getStoreSourceByClassname() {
        return this.storeSourceUsingClassName;
    }

    public synchronized Context getDocumentRoot() throws InstantiationException {
        if (this.getContext() != null || this.synthetic) {
            return this.getContext();
        }
        if (this.getURL() != null) {
            return new ContentFileContext(new File(this.getURL().getFile()), null);
        }
        return null;
    }

    public synchronized String getServletDirectory() {
        if (this.servletDirectory != null) {
            return this.servletDirectory;
        }
        return this.getDefaultServletDirectory();
    }

    public synchronized void setServletDirectory(String path) {
        this.servletDirectory = path;
        this.application.initServletDir(this);
        this.firePropertyChangeEvent("servletWebDir", null, path);
    }

    public synchronized List getCodebases() {
        if (this.codebases == null) {
            return Collections.EMPTY_LIST;
        }
        return this.codebases;
    }

    private void parseMimeMappings(String path) throws InstantiationException {
        if (path == null) {
            throw new InstantiationException("Missing 'path' attribute in <mime-mappings> tag");
        }
        if (this.mimeMappings == null) {
            this.mimeMappings = new ArrayList();
        }
        this.mimeMappingsPath = path;
        try {
            URL url = ConfigUtils.getURL(this.getDeploymentURL(), path);
            if (url.getProtocol().equals("file")) {
                try {
                    this.mimeMappingsFile = new File(url.getFile()).getCanonicalFile();
                    this.mimeMappingsLastModified = this.mimeMappingsFile.lastModified();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            Properties properties = ConfigUtils.readMultipleEntryProperties(url);
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                MimeMapping mapping = new MimeMapping();
                mapping.setKey(entry.getKey().toString());
                mapping.setValue(entry.getValue().toString());
                this.mimeMappings.remove(mapping);
                this.mimeMappings.add(mapping);
            }
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Invalid URL: " + path);
        }
        catch (IOException e) {
            throw new InstantiationException("Could not read mime-mappings config file: " + path);
        }
    }

    public synchronized boolean isUpdated() {
        if (this.mimeMappingsLastModified > 0L && this.mimeMappingsFile.lastModified() != this.mimeMappingsLastModified) {
            return true;
        }
        return super.isUpdated();
    }

    public synchronized void addClasspath(String path) throws InstantiationException {
        if (this.privateRelativeClasspaths == null) {
            this.privateRelativeClasspaths = new ArrayList();
        }
        if (this.codebases == null) {
            this.codebases = new ArrayList();
        }
        StringTokenizer tokenizer = new StringTokenizer(path, ";,");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            this.privateRelativeClasspaths.add(token);
            try {
                token = FileUtils.doPropertyReplacement((String)token);
                URL url = ConfigUtils.getURL(this.getDeploymentURL(), token);
                String urlString = url.toExternalForm();
                if (!(urlString.endsWith("/") || urlString.endsWith(".jar") || urlString.endsWith(".zip"))) {
                    url = new URL(urlString + '/');
                }
                if (this.codebases.contains(url)) continue;
                this.codebases.add(url);
            }
            catch (MalformedURLException e) {
                throw new InstantiationException("Malformed URL: " + token);
            }
            catch (IOException e) {
                throw new InstantiationException("Error reading path: " + token);
            }
        }
    }

    public synchronized List getServlets() {
        if (this.parent != null) {
            if (this.servlets == null) {
                return this.parent.getServlets();
            }
            ArrayList servlets = new ArrayList(this.parent.getServlets());
            servlets.addAll(this.servlets);
            return servlets;
        }
        if (this.servlets == null) {
            return Collections.EMPTY_LIST;
        }
        return this.servlets;
    }

    public synchronized void removeServlet(int pos) {
        this.firePropertyChangeEvent(SERVLETS, this.servlets.remove(pos), null);
    }

    public synchronized void removeFilter(int pos) {
        this.firePropertyChangeEvent("filters", this.filters.remove(pos), null);
    }

    public synchronized void removeJSP(int pos) {
        this.jsps.remove(pos);
    }

    public synchronized List getLocallyDefinedServlets() {
        if (this.servlets == null) {
            return Collections.EMPTY_LIST;
        }
        return this.servlets;
    }

    public synchronized List getJSPs() {
        if (this.parent != null) {
            if (this.jsps == null) {
                return this.parent.getJSPs();
            }
            ArrayList jsps = new ArrayList(this.parent.getJSPs());
            jsps.addAll(this.jsps);
            return jsps;
        }
        if (this.jsps == null) {
            return Collections.EMPTY_LIST;
        }
        return this.jsps;
    }

    public synchronized void addSessionTracker(String name) throws InstantiationException {
        if (name == null) {
            throw new InstantiationException("<session-tracker> node with missing servlet-name attribute");
        }
        if (this.sessionTrackerServlets == null) {
            this.sessionTrackerServlets = new ArrayList();
        }
        this.sessionTrackerServlets.add(name);
        this.firePropertyChangeEvent("sessionTracking", null, name);
    }

    public synchronized List getSessionTrackers() {
        if (this.sessionTrackerServlets == null) {
            return Collections.EMPTY_LIST;
        }
        return this.sessionTrackerServlets;
    }

    public synchronized void addRequestTracker(String name) throws InstantiationException {
        if (name == null) {
            throw new InstantiationException("<request-tracker> node with missing servlet-name attribute");
        }
        if (this.requestTrackerServlets == null) {
            this.requestTrackerServlets = new ArrayList();
        }
        this.requestTrackerServlets.add(name);
    }

    public synchronized List getRequestTrackers() {
        if (this.requestTrackerServlets == null) {
            return Collections.EMPTY_LIST;
        }
        return this.requestTrackerServlets;
    }

    public synchronized boolean getDirectoryBrowsingAllowed() {
        return this.directoryBrowsingAllowed;
    }

    public synchronized void setDirectoryBrowsingAllowed(boolean allow) {
        this.directoryBrowsingAllowed = allow;
        if (this.application != null) {
            this.application.setDirectoryBrowsing(allow);
        }
        this.firePropertyChangeEvent("directoryBrowsing", null, null);
    }

    private void parseSessionTrackingNode(Node parent) throws InstantiationException {
        String useCookie = XMLUtils.getNodeAttribute(parent, "cookies");
        boolean bl = this.sendSessionCookie = !"disabled".equalsIgnoreCase(useCookie);
        if (XMLUtils.getNodeAttribute(parent, "cookie-max-age") != null) {
            try {
                this.sessionCookieMaxAge = Integer.parseInt(XMLUtils.getNodeAttribute(parent, "cookie-max-age"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.sessionCookieDomain = XMLUtils.getNodeAttribute(parent, "cookie-domain");
        this.sessionCookiePath = XMLUtils.getNodeAttribute(parent, "cookie-path");
        this.sessionCookieIsSecure = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "set-secure"));
        this.sessionCookieIsURLRewriting = XMLUtils.getBooleanNodeAttribute(parent, "url-rewriting", true);
        NodeList subNodes = parent.getChildNodes();
        if (subNodes != null) {
            for (int i = 0; i < subNodes.getLength(); ++i) {
                Node node = subNodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("session-tracker")) continue;
                this.addSessionTracker(XMLUtils.getNodeAttribute(node, "servlet-name"));
            }
        }
    }

    public synchronized AccessRegionSet getAccessRegionSet() {
        if (this.accessRegionSet != null) {
            return this.accessRegionSet;
        }
        if (this.parent != null) {
            return this.parent.getAccessRegionSet();
        }
        return null;
    }

    public synchronized List getSecurityConstraints() {
        if (this.securityConstraints == null) {
            return Collections.EMPTY_LIST;
        }
        return this.securityConstraints;
    }

    public synchronized Properties getVirtualMappings() throws InstantiationException {
        if (this.virtualMappings != null) {
            Properties properties = new Properties();
            Iterator<Map.Entry<Object, Object>> iterator = this.virtualMappings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                try {
                    String realPath = (String)entry.getValue();
                    if (realPath.indexOf(":/") < 0 && !new File(realPath).isAbsolute()) {
                        URL url;
                        URL uRL = url = this.isSeparateDeploymentContext() ? ContextUtils.getURL(this.getDeploymentContext(), false) : ContextUtils.getURL(this.getContext(), false);
                        if (url == null) {
                            url = this.archive.getURL();
                        }
                        if (HTTPProperties.getHttpVirtualdirectoryDebug() && m_traceLogger.isLoggable(Level.FINE)) {
                            m_traceLogger.log(Level.FINE, "Turning relative virtual directory '" + realPath + "' into '" + ConfigUtils.getURL(url, realPath).toExternalForm() + "' for virtual path '" + entry.getKey() + "'");
                        }
                        properties.put(entry.getKey(), ConfigUtils.getURL(url, realPath).toExternalForm());
                        continue;
                    }
                    properties.put(entry.getKey(), realPath);
                }
                catch (IOException e) {
                    throw new InstantiationException("Bad real-path attribute value for virtual-path " + entry.getKey() + ": " + e.getMessage());
                }
                catch (InstantiationException e) {
                    throw new InstantiationException("Bad real-path attribute value for virtual-path " + entry.getKey() + ": " + e.getMessage());
                }
            }
            return properties;
        }
        return null;
    }

    public synchronized String getRealm() {
        if (this.realmName != null) {
            return this.realmName;
        }
        return this.getName();
    }

    protected void postInit() throws InstantiationException {
        super.postInit();
        if (this.listener != null) {
            this.listener.postInit(this);
            this.listener.persist();
        }
    }

    public void setURL(URL url) throws InstantiationException {
        if (this.listener != null) {
            this.listener.reset();
        }
        super.setURL(url);
    }

    protected void writeOrionConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\"?>");
        out.println();
        this.writeOrionXML(out, "");
    }

    protected void writeConfig(PrintWriter out) throws IOException {
        if (this.isPre24WebXml()) {
            out.println("<?xml version=\"1.0\"?>");
            out.println("<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/j2ee/dtds/web-app_2_3.dtd\">");
            out.println();
            this.writeXML(out, "");
        } else {
            out.println("<?xml version=\"1.0\"?>");
            out.println();
            this.writeWebApp24XML(out, "");
        }
    }

    public void writeWebApp24XML(PrintWriter out, String indention) throws IOException {
        XMLizable mapping;
        Iterator i;
        out.println(indention + "<web-app xmlns=\"http://java.sun.com/xml/ns/j2ee\"");
        out.println(indention + " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        out.println(indention + " xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee" + " http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\"");
        out.println(indention + " version=\"2.4\">");
        this.writeXMLElement(out, indention, "description", this.getDescription());
        this.writeXMLElement(out, indention, "display-name", this.getDisplayName());
        if (this.icon != null) {
            this.icon.writeXML(out, indention + "\t");
        }
        if (this.distributable) {
            out.println(indention + "\t<distributable />");
        }
        this.writeAllXMLElements(out, indention, this.parameters);
        this.writeAllXMLElements(out, indention, this.filters);
        if (this.filterMappings != null) {
            i = this.filterMappings.iterator();
            while (i.hasNext()) {
                mapping = (FilterMapping)i.next();
                if (((FilterMapping)mapping).isPartOfOrionWeb()) continue;
                ((FilterMapping)mapping).writeXML(out, indention + "\t");
            }
        }
        this.writeAllXMLElements(out, indention, this.listeners);
        this.writeAllXMLElements(out, indention, this.servlets);
        this.writeAllXMLElements(out, indention, this.jsps);
        if (this.servletMappings != null) {
            i = this.servletMappings.iterator();
            while (i.hasNext()) {
                mapping = (ServletMapping)i.next();
                if (((ServletMapping)mapping).isPartOfOrionWeb()) continue;
                ((ServletMapping)mapping).writeXML(out, indention + "\t");
            }
        }
        if (this.sessionTimeout != 1200) {
            out.println(indention + "\t<session-config>");
            this.writeXMLElement(out, indention + "\t", "session-timeout", "" + this.sessionTimeout / 60);
            out.println(indention + "\t</session-config>");
        }
        this.writeAllXMLElements(out, indention, this.mimeMappings);
        if (this.welcomeFiles != null) {
            out.println(indention + "\t<welcome-file-list>");
            XMLUtils.writeStrings(this.welcomeFiles, "welcome-file", out, indention + "\t\t");
            out.println(indention + "\t</welcome-file-list>");
        }
        this.writeAllXMLElements(out, indention, this.errorPages);
        if (this.jspConfig != null) {
            this.jspConfig.writeXML(out, indention + "\t");
        }
        this.writeAllXMLElements(out, indention, this.securityConstraints);
        if (this.authMethod != 0 || this.realmName != null) {
            out.println("\t<login-config>");
            if (this.authMethod != 0) {
                if (this.authMethod == 1) {
                    out.println(indention + "\t\t<auth-method>BASIC</auth-method>");
                } else if (this.authMethod == 8) {
                    out.println(indention + "\t\t<auth-method>CLIENT-CERT</auth-method>");
                } else if (this.authMethod == 2) {
                    out.println(indention + "\t\t<auth-method>DIGEST</auth-method>");
                } else if (this.authMethod == 4) {
                    out.println(indention + "\t\t<auth-method>FORM</auth-method>");
                }
            }
            this.writeXMLElement(out, indention + "\t", "realm-name", this.realmName);
            if (this.formErrorPage != null || this.formLoginPage != null) {
                out.println(indention + "\t\t<form-login-config>");
                this.writeXMLElement(out, indention + "\t\t", "form-login-page", this.formLoginPage);
                this.writeXMLElement(out, indention + "\t\t", "form-error-page", this.formErrorPage);
                out.println("\t\t</form-login-config>");
            }
            out.println("\t</login-config>");
        }
        this.writeAllXMLElements(out, indention, this.securityRoles);
        this.writeAllXMLElements(out, indention, this.m_configDelegate.getEnvironmentEntries());
        List ejbReferences = this.getEJBReferences();
        if (!ejbReferences.isEmpty()) {
            Collections.sort(ejbReferences);
            this.writeAllXMLElements(out, indention, ejbReferences);
        }
        this.writeAllXMLElements(out, indention, this.getResourceReferences());
        this.writeAllXMLElements(out, indention, this.getResourceEnvironmentReferences());
        this.writeAllXMLElements(out, indention, this.getDestinationReferences());
        this.writeLocaleEncodingMap(out, indention);
        out.println("</web-app>");
    }

    protected void writeXML(PrintWriter out, String indention) throws IOException {
        String methodName;
        String clsName;
        Enumeration<Object> keys;
        List serviceReferences;
        List ejbReferences;
        XMLizable mapping;
        Iterator i;
        out.println(indention + "<web-app>");
        if (this.icon != null) {
            this.icon.writeXML(out, indention + "\t");
        }
        if (this.getDisplayName() != null) {
            out.println(indention + "\t<display-name>" + XMLUtils.encode(this.getDisplayName()) + "</display-name>");
        }
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.isDistributable()) {
            out.println(indention + "\t<distributable />");
        }
        if (this.parameters != null) {
            XMLUtils.writeAll(this.parameters, out, indention + "\t");
        }
        if (this.filters != null) {
            XMLUtils.writeAll(this.filters, out, indention + "\t");
        }
        if (this.filterMappings != null) {
            i = this.filterMappings.iterator();
            while (i.hasNext()) {
                mapping = (FilterMapping)i.next();
                if (((FilterMapping)mapping).isPartOfOrionWeb()) continue;
                ((FilterMapping)mapping).writeXML(out, indention + "\t");
            }
        }
        if (this.listeners != null) {
            XMLUtils.writeAll(this.listeners, out, indention + "\t");
        }
        if (this.servlets != null) {
            XMLUtils.writeAll(this.servlets, out, indention + "\t");
        }
        if (this.jsps != null) {
            XMLUtils.writeAll(this.jsps, out, indention + "\t");
        }
        if (this.servletMappings != null) {
            i = this.servletMappings.iterator();
            while (i.hasNext()) {
                mapping = (ServletMapping)i.next();
                if (((ServletMapping)mapping).isPartOfOrionWeb()) continue;
                ((ServletMapping)mapping).writeXML(out, indention + "\t");
            }
        }
        if (this.sessionTimeout != 1200) {
            out.println(indention + "\t<session-config>");
            if (this.sessionTimeout % 60 == 0) {
                out.println(indention + "\t\t<session-timeout>" + this.sessionTimeout / 60 + "</session-timeout>");
            } else {
                out.println(indention + "\t\t<session-timeout>" + this.sessionTimeout + "s</session-timeout>");
            }
            out.println(indention + "\t</session-config>");
        }
        if (this.mimeMappings != null) {
            XMLUtils.writeAll(this.mimeMappings, out, indention + "\t");
        }
        if (this.welcomeFiles != null) {
            out.println(indention + "\t<welcome-file-list>");
            XMLUtils.writeStrings(this.welcomeFiles, "welcome-file", out, indention + "\t\t");
            out.println(indention + "\t</welcome-file-list>");
        }
        if (this.errorPages != null) {
            XMLUtils.writeAll(this.errorPages, out, indention + "\t");
        }
        if (this.tagLibraries != null) {
            XMLUtils.writeAll(this.tagLibraries, out, "\t");
        }
        if (!this.getResourceReferences().isEmpty()) {
            XMLUtils.writeAll(this.getResourceReferences(), out, "\t");
        }
        if (!this.getResourceEnvironmentReferences().isEmpty()) {
            XMLUtils.writeAll(this.getResourceEnvironmentReferences(), out, "\t");
        }
        if (!this.getDestinationReferences().isEmpty()) {
            XMLUtils.writeAll(this.getDestinationReferences(), out, "\t");
        }
        if (this.securityConstraints != null) {
            XMLUtils.writeAll(this.securityConstraints, out, "\t");
        }
        if (this.authMethod != 0 || this.realmName != null) {
            out.println("\t<login-config>");
            if (this.authMethod != 0) {
                if (this.authMethod == 1) {
                    out.println(indention + "\t\t<auth-method>BASIC</auth-method>");
                } else if (this.authMethod == 8) {
                    out.println(indention + "\t\t<auth-method>CLIENT-CERT</auth-method>");
                } else if (this.authMethod == 2) {
                    out.println(indention + "\t\t<auth-method>DIGEST</auth-method>");
                } else if (this.authMethod == 4) {
                    out.println(indention + "\t\t<auth-method>FORM</auth-method>");
                }
            }
            if (this.realmName != null) {
                out.println(indention + "\t\t<realm-name>" + XMLUtils.encode(this.realmName) + "</realm-name>");
            }
            if (this.formErrorPage != null || this.formLoginPage != null) {
                out.println(indention + "\t\t<form-login-config>");
                if (this.formLoginPage != null) {
                    out.println(indention + "\t\t\t<form-login-page>" + XMLUtils.encode(this.formLoginPage) + "</form-login-page>");
                }
                if (this.formErrorPage != null) {
                    out.println(indention + "\t\t\t<form-error-page>" + XMLUtils.encode(this.formErrorPage) + "</form-error-page>");
                }
                out.println("\t\t</form-login-config>");
            }
            out.println("\t</login-config>");
        }
        if (this.ssoAuth) {
            out.println("\t\t<login-config-props>");
            out.println("\t\t\t<auth-method>SSO</auth-method>");
            out.println("\t\t</login-config-props>");
        }
        if (this.securityRoles != null) {
            XMLUtils.writeAll(this.securityRoles, out, "\t");
        }
        if (!this.m_configDelegate.getEnvironmentEntries().isEmpty()) {
            XMLUtils.writeAll(this.m_configDelegate.getEnvironmentEntries(), out, "\t");
        }
        if (!(ejbReferences = this.getEJBReferences()).isEmpty()) {
            Collections.sort(ejbReferences);
            XMLUtils.writeAll(ejbReferences, out, "\t");
        }
        if (!(serviceReferences = this.getServiceReferences()).isEmpty()) {
            Collections.sort(serviceReferences);
            XMLUtils.writeAll(serviceReferences, out, "\t");
        }
        if (this.jspConfig != null) {
            this.jspConfig.writeXML(out, indention + "\t");
        }
        if (this.localeEncodingMap != null && !this.localeEncodingMap.isEmpty()) {
            out.println(indention + "\t<locale-encoding-mapping-list>");
            XMLUtils.writeExtendedMap(this.localeEncodingMap, "locale-encoding-mapping", out, "locale", "encoding", indention + "\t\t");
            out.println(indention + "\t</locale-encoding-mapping-list>");
        }
        if (this.m_preDestroyConfig != null && !this.m_preDestroyConfig.isEmpty()) {
            keys = this.m_preDestroyConfig.keys();
            while (keys.hasMoreElements()) {
                clsName = (String)keys.nextElement();
                methodName = this.m_preDestroyConfig.getProperty(clsName);
                out.println(indention + "\t<pre-destroy>");
                out.println(indention + "\t\t<lifecycle-callback-class>" + XMLUtils.encode(clsName) + "</lifecycle-callback-class>");
                out.println(indention + "\t\t<lifecycle-callback-method>" + XMLUtils.encode(methodName) + "</lifecycle-callback-method>");
                out.println(indention + "\t</pre-destroy>");
            }
        }
        if (this.m_postConstructConfig != null && !this.m_postConstructConfig.isEmpty()) {
            keys = this.m_postConstructConfig.keys();
            while (keys.hasMoreElements()) {
                clsName = (String)keys.nextElement();
                methodName = this.m_postConstructConfig.getProperty(clsName);
                out.println(indention + "\t<post-construct>");
                out.println(indention + "\t\t<lifecycle-callback-class>" + XMLUtils.encode(clsName) + "</lifecycle-callback-class>");
                out.println(indention + "\t\t<lifecycle-callback-method>" + XMLUtils.encode(methodName) + "</lifecycle-callback-method>");
                out.println(indention + "\t</post-construct>");
            }
        }
        out.println("</web-app>");
    }

    public String getOrionRootAttributes(String indention) {
        StringBuffer buffer = new StringBuffer();
        this.deploymentTime = System.currentTimeMillis() + 2000L;
        buffer.append(indention + "\tdeployment-version=\"" + this.getDeploymentVersion() + "\"\n");
        buffer.append(indention + "\tdeployment-time=\"" + this.deploymentTime + "\"\n");
        if (this.alwaysRedeploy) {
            buffer.append(indention + "\talways-redeploy=\"true\"");
        }
        if (this.development) {
            buffer.append(indention + "\tdevelopment=\"" + this.development + "\"\n");
        }
        if (this.sourceDirectory != null) {
            buffer.append(indention + "\tsource-directory=\"" + XMLUtils.encode(this.sourceDirectory) + "\"\n");
        }
        if (this.parent != null && this.defaultBufferSize != this.parent.defaultBufferSize || this.parent == null && this.defaultBufferSize != 2048) {
            buffer.append(indention + "\tdefault-buffer-size=\"" + this.defaultBufferSize + "\"\n");
        }
        if (this.persistenceURLPath != null) {
            buffer.append(indention + "\tpersistence-path=\"" + XMLUtils.encode(this.persistenceURLPath) + "\"\n");
        }
        if (!(this.defaultCharSet == null || this.parent != null && this.defaultCharSet.equals(this.parent.defaultCharSet))) {
            buffer.append(indention + "\tdefault-charset=\"" + XMLUtils.encode(this.defaultCharSet) + "\"\n");
        }
        if (this.jspTimeout != 0) {
            buffer.append(indention + "\tjsp-timeout=\"" + this.jspTimeout + "\"\n");
        }
        if (this.jspCacheURLPath != null) {
            buffer.append(indention + "\tjsp-cache-directory=\"" + XMLUtils.encode(this.jspCacheURLPath) + "\"\n");
        }
        if (this.jspCacheTlds != null) {
            buffer.append(indention + "\tjsp-cache-tlds=\"" + this.jspCacheTlds + "\"\n");
        }
        if (this.jspTaglibLocations != null) {
            buffer.append(indention + "\tjsp-taglib-locations=\"" + this.jspTaglibLocations + "\"\n");
        }
        if (this.parent != null ? this.parent.jspPrintNull != this.jspPrintNull : !this.jspPrintNull) {
            buffer.append(indention + "\tjsp-print-null=\"" + this.jspPrintNull + "\"\n");
        }
        if (this.parent != null ? this.parent.iso8859Convert != this.iso8859Convert : !this.iso8859Convert) {
            buffer.append(indention + "\tiso-8859-1-convert=\"" + this.iso8859Convert + "\"\n");
        }
        if (this.parent != null ? this.parent.simpleJspMapping != this.simpleJspMapping : !this.simpleJspMapping) {
            buffer.append(indention + "\tsimple-jsp-mapping=\"" + this.simpleJspMapping + "\"\n");
        }
        if (this.parent != null ? this.parent.enableJspDispatcherShortCut != this.enableJspDispatcherShortCut : !this.enableJspDispatcherShortCut) {
            buffer.append(indention + "\tenable-jsp-dispatcher-shortcut=\"" + this.enableJspDispatcherShortCut + "\"\n");
        }
        if (this.temporaryDirectoryString != null) {
            buffer.append(indention + "\ttemporary-directory=\"" + XMLUtils.encode(this.temporaryDirectoryString) + "\"\n");
        }
        if (this.parent != null ? this.parent.autoJoinSession != this.autoJoinSession : this.autoJoinSession) {
            buffer.append(indention + "\tautojoin-session=\"" + this.autoJoinSession + "\"\n");
        }
        if (this.parent != null ? this.directoryBrowsingAllowed != this.parent.directoryBrowsingAllowed : this.directoryBrowsingAllowed) {
            buffer.append(indention + "\tdirectory-browsing=\"" + (this.directoryBrowsingAllowed ? "allow" : "deny") + "\"\n");
        }
        if (this.parent != null ? this.autoReloadDynamicPages != this.parent.autoReloadDynamicPages : !this.autoReloadDynamicPages) {
            buffer.append(indention + "\tautoreload-jsp-pages=\"" + this.autoReloadDynamicPages + "\"\n");
        }
        if (this.parent == null || !this.parent.getDefaultContentType().equals(this.getDefaultContentType())) {
            buffer.append(indention + "\tdefault-mime-type=\"" + XMLUtils.encode(this.getDefaultContentType()) + "\"\n");
        }
        if (this.parent != null ? this.storeSourceUsingClassName != this.parent.storeSourceUsingClassName : this.storeSourceUsingClassName) {
            buffer.append(indention + "\tstore-source-by-classname=\"" + this.storeSourceUsingClassName + "\"\n");
        }
        if (this.servletDirectory != null) {
            buffer.append(indention + "\tservlet-webdir=\"" + XMLUtils.encode(this.servletDirectory) + "\"\n");
        }
        if (this.fileModificationCheckInterval != 1000L) {
            buffer.append(indention + "\tfile-modification-check-interval=\"" + this.fileModificationCheckInterval + "\"\n");
        }
        if (this.getContextRoot() != null) {
            buffer.append(indention + "\tcontext-root=\"" + XMLUtils.encode(this.getContextRoot()) + "\"\n");
        }
        if (this.isAccessLog()) {
            buffer.append(indention + "\taccess-log=\"true\"\n");
        }
        return buffer.toString();
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
        XMLizable mapping;
        Iterator iterator;
        List serviceReferences;
        List destinationReferences;
        List resourceEnvironmentReferences;
        block55: {
            block54: {
                int i;
                out.println(indention + "<orion-web-app\n" + "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://xmlns.oracle.com/oracleas/schema/orion-web-10_0.xsd\" " + this.getOrionRootAttributes(indention) + indention + " schema-major-version=\"10\" schema-minor-version=\"0\" >");
                if (this.privateRelativeClasspaths != null) {
                    for (i = 0; i < this.privateRelativeClasspaths.size(); ++i) {
                        out.println(indention + "\t<classpath path=\"" + XMLUtils.encode((String)this.privateRelativeClasspaths.get(i)) + "\" />");
                    }
                }
                if (this.parameters != null) {
                    for (i = 0; i < this.parameters.size(); ++i) {
                        ContextParam entry = (ContextParam)this.parameters.get(i);
                        if (!entry.hasRuntimeValue()) continue;
                        entry.writeOrionXML(out, indention + "\t");
                    }
                }
                if (this.mimeMappingsPath != null) {
                    out.println(indention + "\t<mime-mappings path=\"" + XMLUtils.encode(this.mimeMappingsPath) + "\" />");
                }
                if (this.virtualMappings != null) {
                    XMLUtils.writeCompressedMap(this.virtualMappings, "virtual-directory", out, "virtual-path", "real-path", indention + "\t");
                }
                if (this.accessRegionSet != null) {
                    this.accessRegionSet.writeXML(out, indention + "\t");
                }
                if (this.servletChainings != null) {
                    XMLUtils.writeCompressedMap(this.servletChainings, "servlet-chaining", out, "mime-type", "servlet-name", indention + "\t");
                }
                if (this.requestTrackerServlets != null) {
                    XMLUtils.writeAttributeTags(this.requestTrackerServlets, "request-tracker", "servlet-name", out, indention + "\t");
                }
                if (this.expirationSettings != null) {
                    XMLUtils.writeAll(this.expirationSettings, out, indention + "\t");
                }
                if (this.parent == null ? !this.sendSessionCookie : this.sendSessionCookie != this.parent.sendSessionCookie) break block54;
                if (this.sessionCookieDomain == null && this.sessionCookieMaxAge == 0 && this.sessionCookiePath == null && !this.sessionCookieIsSecure && this.sessionCookieIsURLRewriting && (this.sessionTrackerServlets == null || this.sessionTrackerServlets.isEmpty())) break block55;
            }
            out.print(indention + "\t<session-tracking");
            if (this.parent != null ? this.sendSessionCookie != this.parent.sendSessionCookie : !this.sendSessionCookie) {
                out.print(" cookies=\"" + (this.sendSessionCookie ? "enabled" : "disabled") + "\"");
            }
            if (this.sessionCookieDomain != null) {
                out.print(" cookie-domain=\"" + XMLUtils.encode(this.sessionCookieDomain) + "\"");
            }
            if (this.sessionCookieMaxAge != 0) {
                out.print(" cookie-max-age=\"" + this.sessionCookieMaxAge + "\"");
            }
            if (this.sessionCookiePath != null) {
                out.print(" cookie-path=\"" + XMLUtils.encode(this.sessionCookiePath) + "\"");
            }
            if (this.sessionCookieIsSecure) {
                out.print(" set-secure=\"true\"");
            }
            if (!this.sessionCookieIsURLRewriting) {
                out.print(" url-rewriting=\"false\"");
            }
            if (this.sessionTrackerServlets != null) {
                out.println(">");
                XMLUtils.writeAttributeTags(this.sessionTrackerServlets, "session-tracker", "servlet-name", out, indention + "\t\t");
                out.println(indention + "\t</session-tracking>");
            } else {
                out.println(" />");
            }
        }
        if (this.securityFilterProperties != null) {
            new JAZNWebAppConfig(this.securityFilterProperties).writeXML(indention == null ? 2 : indention.length() + 2, (Writer)out);
        }
        if (this.searchLocalClassesFirst == 0 && this.includeWarManifestClassPath == 0) {
            out.println(indention + "\t<!-- Uncomment this element to control web application class loader behavior.");
            out.println(indention + "\t\t<web-app-class-loader search-local-classes-first=\"true\"  include-war-manifest-class-path=\"true\" />");
            out.println(indention + "\t-->");
        } else {
            out.print(indention + "\t<web-app-class-loader");
            if (this.searchLocalClassesFirst != 0) {
                out.print(" search-local-classes-first=\"");
                out.print(this.searchLocalClassesFirst == 1);
                out.print("\"");
            }
            if (this.includeWarManifestClassPath != 0) {
                out.print(" include-war-manifest-class-path=\"");
                out.print(this.includeWarManifestClassPath == 1);
                out.print("\"");
            }
            out.println(" />");
        }
        List resourceReferences = this.getResourceReferences();
        if (!resourceReferences.isEmpty()) {
            Iterator iterator2 = resourceReferences.iterator();
            while (iterator2.hasNext()) {
                ((ResourceReference)iterator2.next()).writeOrionXML(out, "\t");
            }
        }
        if (!(resourceEnvironmentReferences = this.getResourceEnvironmentReferences()).isEmpty()) {
            Iterator env_iterator = resourceEnvironmentReferences.iterator();
            while (env_iterator.hasNext()) {
                ((ResourceEnvironmentReference)env_iterator.next()).writeOrionXML(out, "\t");
            }
        }
        if (!(destinationReferences = this.getDestinationReferences()).isEmpty()) {
            Iterator dest_iterator = destinationReferences.iterator();
            while (dest_iterator.hasNext()) {
                ((DestinationReference)dest_iterator.next()).writeOrionXML(out, "\t");
            }
        }
        if (this.securityRoles != null) {
            Iterator iterator3 = this.securityRoles.iterator();
            while (iterator3.hasNext()) {
                SecurityRole role = (SecurityRole)iterator3.next();
                role.writeOrionXML(out, indention + "\t");
            }
        }
        List environmentEntries = this.getEnvironmentEntries();
        for (int i = 0; i < environmentEntries.size(); ++i) {
            EnvironmentEntry entry = (EnvironmentEntry)environmentEntries.get(i);
            if (!entry.hasRuntimeValue()) continue;
            entry.writeOrionXML(out, indention + "\t");
        }
        List ejbReferences = this.getEJBReferences();
        if (ejbReferences != null) {
            Iterator iterator4 = ejbReferences.iterator();
            while (iterator4.hasNext()) {
                EJBReference ejbRef = (EJBReference)iterator4.next();
                if (ejbRef.getName() == null || ejbRef.getLocation() == null) continue;
                ejbRef.writeOrionXML(out, indention + "\t");
            }
        }
        if (!(serviceReferences = this.getServiceReferences()).isEmpty()) {
            iterator = serviceReferences.iterator();
            while (iterator.hasNext()) {
                ((ServiceReferenceDescriptor)iterator.next()).writeOrionXML(out, indention + "\t");
            }
        }
        if (this.mimeMappings != null) {
            iterator = this.mimeMappings.iterator();
            while (iterator.hasNext()) {
                mapping = (MimeMapping)iterator.next();
                if (((MimeMapping)mapping).getRequestHandler() == null) continue;
                ((MimeMapping)mapping).writeDeploymentXML(out, indention + "\t");
            }
        }
        if (this.getContext() == null) {
            this.writeXML(out, "\t");
        }
        if (ApplicationServer.serverExtensionProviders != null) {
            for (int i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                ApplicationServer.serverExtensionProviders[i].writeHttpApplicationMainNodes(this, out, indention + "\t");
            }
        }
        if (this.ojspInit != null) {
            this.ojspInit.writeXML(out, indention + "\t");
        }
        if (this.ojspConfig != null) {
            this.ojspConfig.writeXML(out, indention + "\t");
        }
        out.println(indention + "\t<web-app>");
        this.writeChangedXML(out, indention + "\t");
        if (this.filters != null) {
            Iterator i = this.filters.iterator();
            while (i.hasNext()) {
                FilterDescriptor filter = (FilterDescriptor)i.next();
                if (!filter.isPartOfOrionWeb()) continue;
                filter.writeXML(out, indention + "\t\t");
            }
        }
        if (this.filterMappings != null) {
            Iterator i = this.filterMappings.iterator();
            while (i.hasNext()) {
                mapping = (FilterMapping)i.next();
                if (!((FilterMapping)mapping).isPartOfOrionWeb()) continue;
                ((FilterMapping)mapping).writeXML(out, indention + "\t\t");
            }
        }
        if (this.servlets != null) {
            Iterator i = this.servlets.iterator();
            while (i.hasNext()) {
                ServletDescriptor servlet = (ServletDescriptor)i.next();
                if (!servlet.isPartOfOrionWeb()) continue;
                servlet.writeXML(out, indention + "\t\t");
            }
        }
        if (this.servletMappings != null) {
            Iterator i = this.servletMappings.iterator();
            while (i.hasNext()) {
                mapping = (ServletMapping)i.next();
                if (!((ServletMapping)mapping).isPartOfOrionWeb()) continue;
                ((ServletMapping)mapping).writeXML(out, indention + "\t\t");
            }
        }
        out.println(indention + "\t</web-app>");
        out.println(indention + "</orion-web-app>");
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
        if (!name.equals("web-app") && !name.equals("orion-web-app")) {
            throw new InstantiationException(this.getName() + " contained a " + name + " file, not an orion-web-app or a web-app file as expected");
        }
    }

    public synchronized File getTemporaryDirectory() {
        if (this.temporaryDirectory == null) {
            try {
                this.temporaryDirectory = new File(ConfigUtils.getURL(this.getDeploymentURL(), this.temporaryDirectoryString).getFile());
            }
            catch (Throwable e) {
                this.temporaryDirectory = new File("./temp");
            }
        }
        return this.temporaryDirectory;
    }

    public synchronized void setTemporaryDirectory(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Directory path cannnot be null");
        }
        try {
            this.temporaryDirectory = new File(ConfigUtils.getURL(this.getDeploymentURL(), path).getFile());
            this.temporaryDirectoryString = path;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public synchronized String getTemporaryDirectoryPath() {
        return this.temporaryDirectoryString;
    }

    public synchronized void setTemporaryDirectoryPath(String path) {
        this.temporaryDirectoryString = path;
        this.firePropertyChangeEvent("temporaryDirectory", null, path);
    }

    public synchronized void setJSPCacheDirectory(String path) {
        this.jspCacheURLPath = path;
    }

    public List getEnvironmentEntries() {
        return this.m_configDelegate.getEnvironmentEntries();
    }

    public List getResourceReferences() {
        return this.m_configDelegate.getResourceReferences();
    }

    public List getResourceEnvironmentReferences() {
        return this.m_configDelegate.getResourceEnvironmentReferences();
    }

    public List getDestinationReferences() {
        return this.m_configDelegate.getDestinationReferences();
    }

    public void addResourceReference(ResourceReference reference) {
        this.m_configDelegate.addResourceReference(reference);
    }

    public void addResourceEnvironmentReference(ResourceEnvironmentReference reference) {
        this.m_configDelegate.addResourceEnvironmentReference(reference);
    }

    public void addDestinationReference(DestinationReference reference) {
        this.m_configDelegate.addDestinationReference(reference);
    }

    public void removeResourceReference(ResourceReference reference) {
        this.m_configDelegate.removeResourceReference(reference);
    }

    public void removeResourceEnvironmentReference(ResourceEnvironmentReference reference) {
        this.m_configDelegate.removeResourceEnvironmentReference(reference);
    }

    public void removeDestinationReference(DestinationReference reference) {
        this.m_configDelegate.removeDestinationReference(reference);
    }

    public synchronized List getSecurityRoles() {
        if (this.securityRoles == null) {
            return Collections.EMPTY_LIST;
        }
        return this.securityRoles;
    }

    public SecurityRole getSecurityRole(String name) {
        return this.getSecurityRole(name, true);
    }

    public synchronized SecurityRole getSecurityRole(String name, boolean getParent) {
        if (this.securityRoles == null) {
            return null;
        }
        for (int i = 0; i < this.securityRoles.size(); ++i) {
            SecurityRole role = (SecurityRole)this.securityRoles.get(i);
            if (!role.getName().equals(name)) continue;
            if (getParent) {
                SecurityRole parentRole;
                SecurityRole securityRole = parentRole = this.archive == null ? null : this.archive.getSecurityRole(name);
                if (parentRole != null) {
                    return parentRole;
                }
            }
            return role;
        }
        return null;
    }

    public synchronized void addSecurityRole(SecurityRole role) {
        if (this.securityRoles == null) {
            this.securityRoles = new ArrayList();
        }
        this.securityRoles.add(role);
        this.firePropertyChangeEvent(SECURITY_ROLES, null, role);
    }

    public void addEnvironmentEntry(EnvironmentEntry entry) {
        this.m_configDelegate.addEnvironmentEntry(entry);
    }

    public void removeEnvironmentEntry(int pos) {
        this.m_configDelegate.removeEnvironmentEntry(pos);
    }

    public List getEJBReferences() {
        return this.m_configDelegate.getEJBReferences();
    }

    public List getServiceReferences() {
        return this.m_configDelegate.getServiceReferences();
    }

    public synchronized String getFormLoginPage() {
        return this.formLoginPage;
    }

    public List getPersistenceUnitReferences() {
        return this.m_configDelegate.getPersistenceUnitReferences();
    }

    public List getPersistenceContextReferences() {
        return this.m_configDelegate.getPersistenceContextReferences();
    }

    public J2EEContextConfigDelegate getConfigDelegate() {
        return this.m_configDelegate;
    }

    public synchronized String getFormErrorPage() {
        if (this.formErrorPage == null) {
            return this.formLoginPage;
        }
        return this.formErrorPage;
    }

    public synchronized int getAuthMethod() {
        return this.authMethod;
    }

    public synchronized int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public synchronized void setSessionTimeout(int timeout) {
        this.sessionTimeout = timeout;
        this.firePropertyChangeEvent("session-timeout", null, new Integer(timeout));
    }

    public synchronized void addEJBReference(EJBReference reference) {
        this.m_configDelegate.addEJBReference(reference);
    }

    public synchronized void removeEJBReference(EJBReference reference) {
        this.m_configDelegate.removeEJBReference(reference);
    }

    public void addServiceReference(ServiceReferenceDescriptor serviceReference) {
        this.m_configDelegate.addServiceReference(serviceReference);
    }

    public void removeServiceReference(ServiceReferenceDescriptor reference) {
        this.m_configDelegate.removeServiceReference(reference);
    }

    public synchronized void removeSecurityConstraint(int pos) {
        if (this.securityConstraints == null) {
            return;
        }
        SecurityConstraint constraint = (SecurityConstraint)this.securityConstraints.remove(pos);
        this.firePropertyChangeEvent(SECURITY_CONSTRAINTS, constraint, null);
    }

    public synchronized void addSecurityConstraint(SecurityConstraint constraint) {
        if (this.securityConstraints == null) {
            this.securityConstraints = new ArrayList();
        }
        this.securityConstraints.add(constraint);
        this.firePropertyChangeEvent(SECURITY_CONSTRAINTS, null, constraint);
    }

    public synchronized void setPackaged(boolean packaged) {
        this.packaged = packaged;
    }

    public synchronized URL getPersistenceURL() {
        if (this.persistenceURL != null) {
            return this.persistenceURL;
        }
        String path = this.getPersistencePath();
        try {
            if (path != null && !this.isWARed()) {
                this.persistenceURL = ConfigUtils.getURL(this.getDeploymentURL(), path);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid persistence-path " + path + " : " + e.getMessage());
        }
        return this.persistenceURL;
    }

    public synchronized String getPersistencePath() {
        if (OC4JServer.getInstanceId() != null && this.persistenceURLPath != null && this.persistenceURLPath.indexOf(OC4JServer.getInstanceId()) == -1) {
            this.persistenceURLPath = this.persistenceURLPath + "." + OC4JServer.getInstanceId();
        }
        return this.persistenceURLPath;
    }

    public synchronized void setPersistencePath(String path) {
        this.persistenceURLPath = path;
        this.getPersistencePath();
        this.persistenceURL = null;
        this.getPersistenceURL();
        this.firePropertyChangeEvent("persistencePath", null, path);
    }

    public synchronized String getJSPCacheDirectoryPath() {
        return this.jspCacheURLPath;
    }

    public synchronized URL getJSPCacheDirectoryURL() {
        if (this.jspCacheURL != null) {
            return this.jspCacheURL;
        }
        try {
            if (this.jspCacheURLPath != null && !this.isWARed()) {
                this.jspCacheURL = ConfigUtils.getURL(this.getDeploymentURL(), this.jspCacheURLPath);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid jsp-cache-directory path " + this.jspCacheURLPath + " : " + e.getMessage());
        }
        return this.jspCacheURL;
    }

    public synchronized String getJspCacheTlds() {
        return this.jspCacheTlds;
    }

    public synchronized void setJspCacheTlds(String jspCacheTlds) {
        this.jspCacheTlds = jspCacheTlds;
    }

    public synchronized String getTaglibLocations() {
        return this.jspTaglibLocations;
    }

    public synchronized void setTaglibLocations(String jspTaglibLocations) {
        this.jspTaglibLocations = jspTaglibLocations;
    }

    public synchronized Object getTldCache() {
        return this.tldCache;
    }

    public synchronized void setTldCache(Object tldCache) {
        this.tldCache = tldCache;
    }

    public synchronized boolean getJspPrintNull() {
        return this.jspPrintNull;
    }

    public synchronized void setJspPrintNull(boolean jspPrintNull) {
        this.jspPrintNull = jspPrintNull;
    }

    public synchronized boolean getSimpleJspMapping() {
        if (this.parent != null && !this.parent.defaultJspPatternCheckDone && this.simpleJspMapping) {
            if (!this.checkWhetherJspDefaultPattern()) {
                this.simpleJspMapping = false;
            }
            this.parent.defaultJspPatternCheckDone = true;
        }
        return this.simpleJspMapping;
    }

    private boolean checkWhetherJspDefaultPattern() {
        if (this.parent.definedGlobalJspUrlPattern != null) {
            return defaultGlobalJspUrlPattern.equals(this.parent.definedGlobalJspUrlPattern);
        }
        return false;
    }

    public synchronized boolean getEnableJSPDispatcherShortCut() {
        return this.enableJspDispatcherShortCut;
    }

    public synchronized boolean isDevelopment() {
        return this.development;
    }

    public synchronized boolean isISO8859Convert() {
        return this.iso8859Convert;
    }

    public synchronized void setDevelopment(boolean development) {
        this.development = development;
    }

    public synchronized void setAutoReloadDynamicPages(boolean reload) {
        this.autoReloadDynamicPages = reload;
    }

    public synchronized void setAutoReloadBeans(boolean reload) {
        this.autoReloadBeans = reload;
    }

    public synchronized List getTagLibraries() {
        if (this.tagLibraries == null) {
            return Collections.EMPTY_LIST;
        }
        return this.tagLibraries;
    }

    public synchronized void addTagLibrary(TagLibraryUse lib) {
        if (this.tagLibraries == null) {
            this.tagLibraries = new ArrayList();
        }
        this.tagLibraries.add(lib);
        this.firePropertyChangeEvent("taglibs", null, lib);
    }

    public void setWARed(boolean wared) {
        this.wared = wared;
    }

    public boolean isWARed() {
        return this.wared;
    }

    public String getShortName() {
        return this.shortName;
    }

    private EJBReference getEJBReference(String name) {
        return this.m_configDelegate.getEJBReference(name);
    }

    private ServiceReferenceDescriptor getServiceReference(String name) {
        return this.m_configDelegate.getServiceReference(name);
    }

    public synchronized int getJSPTimeout() {
        return this.jspTimeout;
    }

    public synchronized void setJSPTimeout(int timeout) {
        this.jspTimeout = timeout;
    }

    public ResourceReference getResourceReference(String name) {
        return this.m_configDelegate.getResourceReference(name);
    }

    private ResourceEnvironmentReference getResourceEnvironmentReference(String name) {
        return this.m_configDelegate.getResourceEnvironmentReference(name);
    }

    private DestinationReference getDestinationReference(String name) {
        return this.m_configDelegate.getDestinationReference(name);
    }

    protected String getAssemblyDescriptorPath() {
        return "WEB-INF/web.xml";
    }

    public String getDeploymentDescriptorPath() {
        return "orion-web.xml";
    }

    protected String getDefaultDeploymentSubname() {
        return "WEB-INF";
    }

    public boolean isPackaged() {
        return this.packaged;
    }

    public boolean getSendSessionCookie() {
        return this.sendSessionCookie;
    }

    public synchronized void addContextParameter(ContextParam parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parameter);
    }

    public synchronized ContextParam getContextParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        Iterator iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            ContextParam param = (ContextParam)iterator.next();
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public synchronized ContextParam getContextParameter(int index) {
        if (this.parameters == null) {
            return null;
        }
        return (ContextParam)this.parameters.get(index);
    }

    public synchronized int getContextParameterCount() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public synchronized void setAuthMethod(int authMethod) {
        this.authMethod = authMethod;
    }

    public EnvironmentEntry getEnvironmentEntry(String name) {
        return this.m_configDelegate.getEnvironmentEntry(name);
    }

    public synchronized void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public synchronized void setWelcomeFile(int pos, String name) {
        if (this.welcomeFiles == null) {
            this.welcomeFiles = new ArrayList();
        }
        if (pos >= this.welcomeFiles.size()) {
            this.addWelcomeFile(name);
        } else {
            this.welcomeFiles.set(pos, name);
        }
    }

    public synchronized void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public synchronized void setFormLoginPage(String loginPage) {
        this.formLoginPage = loginPage;
    }

    public synchronized void setFormErrorPage(String errorPage) {
        this.formErrorPage = errorPage;
    }

    public synchronized Properties getVirtualDirectories() {
        return this.virtualMappings;
    }

    public synchronized void setVirtualDirectories(Properties prop) throws InstantiationException {
        try {
            Properties tempProp;
            if (this.virtualMappings == null) {
                this.virtualMappings = new Properties();
            }
            if ((tempProp = this.parent.getVirtualMappings()) != null && tempProp.size() > 0) {
                this.virtualMappings.putAll((Map<?, ?>)tempProp);
            }
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (prop != null) {
            this.virtualMappings.putAll((Map<?, ?>)prop);
        }
        if (this.application != null) {
            this.application.initVirtualDirectories(this.getVirtualMappings());
        }
        this.firePropertyChangeEvent("virtualDirectories", null, null);
    }

    public synchronized void addVirtualDirectory(String virtualPath, String realPath) throws InstantiationException {
        this.setVirtualMappings(virtualPath, realPath);
        if (this.application != null) {
            this.application.initVirtualDirectories(this.getVirtualMappings());
        }
        this.firePropertyChangeEvent("virtualDirectories", null, null);
    }

    public synchronized void removeVirtualDirectory(String virtualPath, String realPath) throws InstantiationException {
        if (this.virtualMappings != null) {
            Properties parentVirtualMappings = this.parent.getVirtualDirectories();
            if (parentVirtualMappings != null && parentVirtualMappings.get(virtualPath).equals(realPath)) {
                throw new IllegalArgumentException("The mapping is defined in parent web module.");
            }
            this.virtualMappings.remove(virtualPath);
            if (this.application != null) {
                this.application.initVirtualDirectories(this.getVirtualMappings());
            }
            this.firePropertyChangeEvent("virtualDirectories", null, null);
        }
    }

    public synchronized void setVirtualMappings(String paramName, String paramValue) throws InstantiationException {
        if (paramName == null) {
            throw new InstantiationException("Missing 'virtual-path' attribute in virtual-directory tag");
        }
        if (paramValue == null) {
            throw new InstantiationException("Missing 'real-path' attribute in virtual-directory tag");
        }
        if (this.virtualMappings == null) {
            this.virtualMappings = new Properties();
        }
        this.virtualMappings.setProperty(paramName, paramValue);
    }

    public synchronized void removeTagLib(int pos) {
        this.firePropertyChangeEvent("taglibs", this.tagLibraries.remove(pos), null);
    }

    public synchronized void removeServletMapping(int pos) {
        this.firePropertyChangeEvent("servletMappings", this.servletMappings.remove(pos), null);
    }

    public synchronized void removeFilterMapping(int pos) {
        this.firePropertyChangeEvent("filterMappings", this.filterMappings.remove(pos), null);
    }

    public synchronized void removeMimeMapping(int pos) {
        this.firePropertyChangeEvent("mimeMappings", this.mimeMappings.remove(pos), null);
    }

    public synchronized int getDefaultBufferSize() {
        return this.defaultBufferSize;
    }

    public synchronized void setDefaultBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("default-buffer-size cannot be negative.");
        }
        this.defaultBufferSize = size;
        if (this.application != null) {
            this.application.setResponseBufferSize(size);
        }
        this.firePropertyChangeEvent("defaultBufferSize", null, new Integer(size));
    }

    public synchronized URL getSourceURL() throws IOException {
        if (this.sourceDirectory != null) {
            return ConfigUtils.getURL(this.getURL(), this.sourceDirectory);
        }
        return null;
    }

    public synchronized String getDefaultCharSet() {
        return this.defaultCharSet;
    }

    public synchronized void setDefaultCharSet(String charset) {
        this.defaultCharSet = charset;
    }

    public synchronized void removeSecurityRole(SecurityRole role) {
        if (this.securityRoles == null) {
            return;
        }
        this.securityRoles.remove(role);
        this.firePropertyChangeEvent(SECURITY_ROLES, role, null);
    }

    public synchronized FilterDescriptor getFilter(String name) {
        if (this.filters != null) {
            for (int i = 0; i < this.filters.size(); ++i) {
                FilterDescriptor filter = (FilterDescriptor)this.filters.get(i);
                if (!filter.getName().equals(name)) continue;
                return filter;
            }
        }
        if (this.parent != null) {
            return this.parent.getFilter(name);
        }
        return null;
    }

    public synchronized boolean getReplicateServletContext() {
        return this.replicateServletContext;
    }

    public synchronized boolean isDistributable() {
        return this.distributable;
    }

    public synchronized void setDistributable(boolean distributable) throws IOException {
        this.setDistributable(distributable, false);
    }

    public synchronized void setDistributable(boolean distributable, boolean persist) throws IOException {
        this.distributable = distributable;
        if (persist) {
            this.store();
        }
    }

    public synchronized boolean getBroadcastSessionsEveryRequest() {
        return this.broadcastSessionsEveryRequest;
    }

    public void setSessionCookieDomain(String domain) {
        this.sessionCookieDomain = domain == null || domain.length() == 0 ? null : domain;
        this.firePropertyChangeEvent("sessionTracking", null, domain);
    }

    public void setSessionCookiePath(String path) {
        this.sessionCookiePath = path == null || path.length() == 0 ? null : path;
        this.firePropertyChangeEvent("sessionTracking", null, path);
    }

    public void setSessionCookieIsSecure(boolean secure) {
        this.sessionCookieIsSecure = secure;
        this.firePropertyChangeEvent("sessionTracking", null, new Boolean(secure));
    }

    public void setSessionCookieIsURLRewriting(boolean urlRewriting) {
        this.sessionCookieIsURLRewriting = urlRewriting;
        this.firePropertyChangeEvent("sessionTracking", null, new Boolean(urlRewriting));
    }

    public void setSessionCookieMaxAge(int age) {
        this.sessionCookieMaxAge = age;
        this.firePropertyChangeEvent("sessionTracking", null, new Integer(age));
    }

    public final String getwsDeploymentDescriptor() {
        if (this.webServicesDescriptor != null) {
            return ((ServerComponent)((Object)this.webServicesDescriptor)).getdeploymentDescriptor();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String getproprietaryWsDeploymentDescriptor() {
        if (this.webServicesDescriptor == null) return null;
        URL deployment_dir = ((ServerComponent)((Object)this.webServicesDescriptor)).getDeploymentURL();
        String path = ((ServerComponent)((Object)this.webServicesDescriptor)).getDeploymentDescriptorPath();
        if (deployment_dir == null || path == null) return null;
        InputStream fis = null;
        String dir = deployment_dir.toString();
        File f = new File(new File(new URI(dir)), path);
        fis = new BufferedInputStream(new FileInputStream(f));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int count = fis.read(buf);
        while (count > 0) {
            baos.write(buf, 0, count);
            count = fis.read(buf);
        }
        String string = baos.toString("UTF-8");
        Object var12_12 = null;
        if (fis == null) return string;
        try {
            fis.close();
            return string;
        }
        catch (IOException e2) {
            m_traceLogger.log(Level.FINE, "Error occured while closing file.", e2);
        }
        return string;
        {
            catch (UnsupportedEncodingException unsEx) {
                String string2 = baos.toString();
                Object var12_13 = null;
                if (fis == null) return string2;
                try {
                    fis.close();
                    return string2;
                }
                catch (IOException e2) {
                    m_traceLogger.log(Level.FINE, "Error occured while closing file.", e2);
                }
                return string2;
                catch (Exception e) {
                    try {
                        Object var12_14 = null;
                        if (fis == null) return null;
                    }
                    catch (Throwable throwable) {
                        Object var12_15 = null;
                        if (fis == null) throw throwable;
                        try {
                            fis.close();
                            throw throwable;
                        }
                        catch (IOException e2) {
                            m_traceLogger.log(Level.FINE, "Error occured while closing file.", e2);
                        }
                        throw throwable;
                    }
                    try {
                        fis.close();
                        return null;
                    }
                    catch (IOException e2) {
                        m_traceLogger.log(Level.FINE, "Error occured while closing file.", e2);
                    }
                    return null;
                }
            }
        }
    }

    public final String getWebURL() {
        try {
            WebModule webModule = this.archive.getWebApplication(this.shortName);
            return webModule.getContextRoot();
        }
        catch (Throwable t) {
            m_traceLogger.log(Level.FINE, "Error in getWebuRL()", t);
            return "";
        }
    }

    public WebComponentDescriptor getWebComponentByName(String name) {
        Iterator itr = this.getServlets().iterator();
        while (itr.hasNext()) {
            WebComponentDescriptor next = (WebComponentDescriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public WebComponentDescriptor getWebComponentByCanonicalName(String name) {
        Iterator itr = this.getServlets().iterator();
        while (itr.hasNext()) {
            WebComponentDescriptor next = (WebComponentDescriptor)itr.next();
            if (!next.getCanonicalName().equals(name)) continue;
            return next;
        }
        return null;
    }

    public String getContextRoot() {
        if (this.getModuleDescriptor() != null) {
            return this.getModuleDescriptor().getContextRoot();
        }
        if (this.contextRoot == null) {
            this.contextRoot = "/";
        }
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        WebModule webModule = this.getModuleDescriptor();
        if (webModule != null) {
            webModule.setContextRoot(contextRoot);
        }
        this.contextRoot = contextRoot;
    }

    public boolean isAccessLog() {
        if (this.getModuleDescriptor() != null) {
            return this.getModuleDescriptor().getAccessLog();
        }
        return this.accessLog;
    }

    public void setAccessLog(String value) {
        WebModule webModule = this.getModuleDescriptor();
        if (webModule != null && value != null) {
            webModule.setAccessLog(value.equals("true"));
            this.accessLog = value.equals("true");
        }
    }

    public WebModule getModuleDescriptor() {
        if (this.archive == null) {
            return null;
        }
        return this.archive.getWebApplication(this.shortName);
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public DocumentType getWebXMLDoctype() {
        return this.webXMLDoctype;
    }

    private synchronized void parseLocaleEncodingMappingList(Node parent) {
        NodeList nodes = parent.getChildNodes();
        Node node = null;
        String name = null;
        String locale = null;
        String encoding = null;
        if (this.localeEncodingMap == null) {
            this.localeEncodingMap = new HashMap();
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            name = node.getNodeName();
            if (name.startsWith("#") || !name.equals("locale-encoding-mapping")) continue;
            encoding = null;
            locale = null;
            NodeList subnodes = node.getChildNodes();
            Node subnode = null;
            for (int j = 0; j < subnodes.getLength(); ++j) {
                subnode = subnodes.item(j);
                name = subnode.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("locale")) {
                    locale = XMLUtils.getStringValue(subnode);
                    continue;
                }
                if (!name.equals("encoding")) continue;
                encoding = XMLUtils.getStringValue(subnode);
            }
            if (locale == null || encoding == null) continue;
            this.localeEncodingMap.put(locale.toUpperCase(), encoding);
        }
    }

    public String getEncoding(String locale) {
        String encoding = null;
        if (this.localeEncodingMap != null) {
            encoding = (String)this.localeEncodingMap.get(locale.toUpperCase());
        }
        if (encoding == null && this.parent != null) {
            encoding = this.parent.getEncoding(locale);
        }
        return encoding;
    }

    public List getContextParams() {
        return this.parameters;
    }

    public HashMap getLocaleEncodingMappingList() {
        return this.localeEncodingMap;
    }

    public String getSourceDirectory() {
        if (this.sourceDirectory == null) {
            File srcDir;
            File webRootDir = null;
            try {
                webRootDir = ContextUtils.getFile(this.getDocumentRoot(), false);
            }
            catch (InstantiationException e) {
            }
            catch (Exception e) {
                // empty catch block
            }
            if (webRootDir != null) {
                webRootDir = FileUtils.getCanonicalFile((File)webRootDir);
            }
            if ((srcDir = new File(webRootDir, "WEB-INF/src")) != null && srcDir.exists()) {
                return new String("WEB-INF/src");
            }
            return new String("WEB-INF/classes");
        }
        return this.sourceDirectory;
    }

    public void setSourceDirectory(String path) {
        this.sourceDirectory = path;
        this.firePropertyChangeEvent("sourceDirectory", null, path);
    }

    public String getClasspath() {
        if (this.privateRelativeClasspaths != null) {
            String classpath = "";
            for (int i = 0; i < this.privateRelativeClasspaths.size(); ++i) {
                if (i != 0) {
                    classpath = classpath + ",";
                }
                classpath = classpath + (String)this.privateRelativeClasspaths.get(i);
            }
            return classpath;
        }
        return null;
    }

    public synchronized void setClasspath(String path) throws InstantiationException {
        if (this.privateRelativeClasspaths != null) {
            this.privateRelativeClasspaths.clear();
        }
        if (this.codebases != null) {
            this.codebases.clear();
        }
        this.addClasspath(path);
        this.firePropertyChangeEvent("classpath", null, path);
    }

    public synchronized List getEJBReferenceMappings() {
        List ejbReferences = this.getEJBReferences();
        if (ejbReferences != null) {
            ArrayList<WebModuleEjbRefMapping> ejbRefMappings = new ArrayList<WebModuleEjbRefMapping>();
            for (int i = 0; i < ejbReferences.size(); ++i) {
                EJBReference ref = (EJBReference)ejbReferences.get(i);
                if (ref.getLocation() == null) continue;
                ejbRefMappings.add(new WebModuleEjbRefMapping(ref.getName(), ref.getLocation()));
            }
            return ejbRefMappings;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized void setEJBReferenceMappings(List mappings) {
        List ejbReferences = this.getEJBReferences();
        if (ejbReferences != null && mappings != null) {
            for (int j = 0; j < ejbReferences.size(); ++j) {
                EJBReference ref = (EJBReference)ejbReferences.get(j);
                ref.setLocation(null);
            }
            if (mappings == null) {
                return;
            }
            block1: for (int i = 0; i < mappings.size(); ++i) {
                WebModuleEjbRefMapping newValue = (WebModuleEjbRefMapping)mappings.get(i);
                for (int j = 0; j < ejbReferences.size(); ++j) {
                    EJBReference oldValue = (EJBReference)ejbReferences.get(j);
                    if (!newValue.getName().equals(oldValue.getName())) continue;
                    oldValue.setLocation(newValue.getLocation());
                    continue block1;
                }
            }
            this.firePropertyChangeEvent("ejbReferenceMappings", null, ejbReferences);
        }
    }

    public synchronized void setEJBReferenceMapping(String name, String location) {
        EJBReference ref = this.getEJBReference(name);
        if (ref != null) {
            ref.setLocation(location);
            this.firePropertyChangeEvent("ejbReferenceMappings", null, ref);
        }
    }

    public synchronized List getEnvironmentEntryMappings() {
        List environmentEntries = this.getEnvironmentEntries();
        if (environmentEntries != null) {
            ArrayList<WebModuleEnvEntryMapping> envEntries = new ArrayList<WebModuleEnvEntryMapping>();
            for (int i = 0; i < environmentEntries.size(); ++i) {
                EnvironmentEntry entry = (EnvironmentEntry)environmentEntries.get(i);
                if (entry.getRuntimeValue() == null) continue;
                envEntries.add(new WebModuleEnvEntryMapping(entry.getName(), entry.getRuntimeValue()));
            }
            return envEntries;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized void setEnvironmentEntryMappings(List mappings) {
        List environmentEntries = this.getEnvironmentEntries();
        if (environmentEntries != null && mappings != null) {
            for (int j = 0; j < environmentEntries.size(); ++j) {
                EnvironmentEntry entry = (EnvironmentEntry)environmentEntries.get(j);
                entry.setRuntimeValue(null);
            }
            block1: for (int i = 0; i < mappings.size(); ++i) {
                WebModuleEnvEntryMapping newValue = (WebModuleEnvEntryMapping)mappings.get(i);
                for (int j = 0; j < environmentEntries.size(); ++j) {
                    EnvironmentEntry oldValue = (EnvironmentEntry)environmentEntries.get(j);
                    if (!newValue.getName().equals(oldValue.getName())) continue;
                    oldValue.setRuntimeValue(newValue.getValue());
                    continue block1;
                }
            }
            this.firePropertyChangeEvent("environmentEntries", null, environmentEntries);
        }
    }

    public synchronized void setEnvironmentEntry(String name, String location) {
        EnvironmentEntry entry = this.getEnvironmentEntry(name);
        if (entry != null) {
            entry.setRuntimeValue(location);
            this.firePropertyChangeEvent("environmentEntries", null, this.environmentEntries);
        }
    }

    public WebModuleLoginConfig getLoginConfig() {
        if (this.authMethod != 0 || this.realmName != null) {
            String authMethod = null;
            if (this.authMethod == 1) {
                authMethod = "BASIC";
            } else if (this.authMethod == 8) {
                authMethod = "CLIENT-CERT";
            } else if (this.authMethod == 2) {
                authMethod = "DIGEST";
            } else if (this.authMethod == 4) {
                authMethod = "FORM";
            }
            return new WebModuleLoginConfig(authMethod, this.realmName, this.formLoginPage, this.formErrorPage);
        }
        return null;
    }

    public WebModuleJspConfig getJspConfig() {
        return new WebModuleJspConfig(this.jspConfig);
    }

    public List getRemoteEJBReferences() {
        List ejbReferences = this.getEJBReferences();
        if (ejbReferences == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EJBReference> list = new ArrayList<EJBReference>();
        Iterator refs = ejbReferences.iterator();
        while (refs.hasNext()) {
            EJBReference ref = (EJBReference)refs.next();
            if (ref.isLocal()) continue;
            list.add(ref);
        }
        return list;
    }

    public List getLocalEJBReferences() {
        List ejbReferences = this.getEJBReferences();
        if (ejbReferences == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EJBReference> list = new ArrayList<EJBReference>();
        Iterator refs = ejbReferences.iterator();
        while (refs.hasNext()) {
            EJBReference ref = (EJBReference)refs.next();
            if (!ref.isLocal()) continue;
            list.add(ref);
        }
        return list;
    }

    public void setHttpApplication(HttpApplication application) {
        this.application = application;
    }

    public WebModuleSessionTracking getSessionTracking() {
        WebModuleSessionTracking st = new WebModuleSessionTracking();
        st.setUseCookies(this.sendSessionCookie ? "enabled" : "disabled");
        st.setCookieMaxAge(String.valueOf(this.sessionCookieMaxAge));
        st.setCookieDomain(this.sessionCookieDomain);
        st.setCookiePath(this.sessionCookiePath);
        st.setIsSecure(this.sessionCookieIsSecure);
        st.setIsURLRewriting(this.sessionCookieIsURLRewriting);
        st.setAutoJoinSession(this.autoJoinSession);
        st.setSessionTrackers(this.getSessionTrackers());
        System.out.println("getSessionTracking.sessionCookieIsSecure=" + this.sessionCookieIsSecure);
        return st;
    }

    public synchronized void setSessionTracking(WebModuleSessionTracking st) {
        this.sendSessionCookie = st.getUseCookies().equals("enabled");
        this.sessionCookieMaxAge = Integer.parseInt(st.getCookieMaxAge());
        this.sessionCookieDomain = st.getCookieDomain();
        this.sessionCookiePath = st.getCookiePath();
        this.autoJoinSession = st.getAutoJoinSession();
        this.sessionTrackerServlets = st.getSessionTrackers();
        this.sessionCookieIsSecure = st.getIsSecure();
        this.sessionCookieIsURLRewriting = st.getIsURLRewriting();
        System.out.println("setSessionTracking.sessionCookieIsSecure=" + this.sessionCookieIsSecure);
        this.firePropertyChangeEvent("sessionTracking", null, st);
    }

    public synchronized void setSessionTrackers(List servletNames) {
        this.sessionTrackerServlets = servletNames;
        this.firePropertyChangeEvent("sessionTracking", null, null);
    }

    public synchronized void removeSessionTracker(String name) throws InstantiationException {
        if (name == null) {
            throw new InstantiationException("<session-tracker> node with missing servlet-name attribute");
        }
        if (this.sessionTrackerServlets != null) {
            this.sessionTrackerServlets.remove(name);
        }
        this.firePropertyChangeEvent("sessionTracking", null, name);
    }

    public List getResourceRefMappings() {
        List resourceReferences = this.getResourceReferences();
        if (resourceReferences == null || resourceReferences.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WebModuleResourceRefMapping> mappings = new ArrayList<WebModuleResourceRefMapping>();
        for (int i = 0; i < resourceReferences.size(); ++i) {
            ResourceReference ref = (ResourceReference)resourceReferences.get(i);
            Properties ctxAttrs = ref.getContextAttributes();
            if (ref.getLocation() == null && (ctxAttrs == null || ctxAttrs.isEmpty())) continue;
            mappings.add(new WebModuleResourceRefMapping(ref));
        }
        return mappings;
    }

    public void setResourceRefMappings(List mappings) {
        List resRefs = this.getResourceReferences();
        ArrayList<String> oldLocations = new ArrayList<String>(resRefs.size());
        ArrayList<Properties> oldContextAttributes = new ArrayList<Properties>(resRefs.size());
        if (resRefs != null) {
            for (int i = 0; i < resRefs.size(); ++i) {
                ResourceReference ref = (ResourceReference)resRefs.get(i);
                oldLocations.add(ref.getLocation());
                oldContextAttributes.add(ref.getContextAttributes());
                ref.setLocation(null);
                ref.resetContextAttributes();
            }
        } else {
            return;
        }
        try {
            if (mappings != null) {
                for (int j = 0; j < mappings.size(); ++j) {
                    WebModuleResourceRefMapping mapping = (WebModuleResourceRefMapping)mappings.get(j);
                    ResourceReference ref = this.getResourceReference(mapping.getName());
                    if (ref == null) continue;
                    ref.setResourceRefMapping(mapping);
                }
            }
            this.firePropertyChangeEvent("resourceReferenceMappings", null, null);
        }
        catch (Exception e) {
            for (int i = 0; i < resRefs.size(); ++i) {
                ResourceReference ref = (ResourceReference)resRefs.get(i);
                ref.setLocation((String)oldLocations.get(i));
                ref.setContextAttributes((Properties)oldContextAttributes.get(i));
            }
        }
    }

    public void setResourceRefMappingLocation(String name, String location) {
        ResourceReference ref = this.getResourceReference(name);
        if (ref != null) {
            if (location == null || location.length() == 0) {
                ref.setLocation(null);
            } else {
                ref.setLocation(location);
            }
        }
        this.firePropertyChangeEvent("resourceRefMappings", null, ref);
    }

    public void setResourceRefMappingContextLocation(String name, String location) {
        ResourceReference ref = this.getResourceReference(name);
        if (ref != null) {
            if (location == null || location.length() == 0) {
                ref.removeContextAttribute("context-location");
            } else {
                ref.addContextAttribute("context-location", location);
            }
        }
        this.firePropertyChangeEvent("resourceRefMappings", null, ref);
    }

    public void addResourceRefMappingContextAttribute(String refName, String attrName, String attrValue) {
        ResourceReference ref = this.getResourceReference(refName);
        if (ref != null) {
            ref.addContextAttribute(attrName, attrValue);
        }
        this.firePropertyChangeEvent("resourceRefMappings", null, ref);
    }

    public void removeResourceRefMappingContextAttribute(String refName, String attrName) {
        ResourceReference ref = this.getResourceReference(refName);
        if (ref != null) {
            ref.removeContextAttribute(attrName);
        }
        this.firePropertyChangeEvent("resourceRefMappings", null, ref);
    }

    public void loadAllServletMBeans(String appName, String warName) {
        if (this.servlets != null && !this.servlets.isEmpty()) {
            for (int i = 0; i < this.servlets.size(); ++i) {
                ServletDescriptor servlet = (ServletDescriptor)this.servlets.get(i);
                Servlet.addServletMBean(servlet, servlet.getName(), appName, warName);
            }
        }
    }

    public void loadServletMBean(String appName, String warName, String name) {
        Servlet.addServletMBean(this.getServletDescriptor(name, true), name, appName, warName);
    }

    private String getDefaultServletDirectory() {
        if (this.parent != null) {
            return this.parent.getServletDirectory();
        }
        if (this.servletDirectory != null) {
            return this.servletDirectory;
        }
        return "";
    }

    public void persistUpdates() throws IOException, InstantiationException {
        this.storeDeployment();
    }

    public void firePropertyChangeEvent(String property, Object value, Object newValue) {
        if (this.propertyChangeList == null) {
            this.propertyChangeList = new ArrayList();
        }
        if (!this.propertyChangeList.contains(property)) {
            this.propertyChangeList.add(property);
        }
        super.firePropertyChangeEvent(property, value, newValue);
    }

    protected void writeChangedXML(PrintWriter out, String indention) throws IOException {
        if (this.propertyChangeList == null || this.propertyChangeList.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.propertyChangeList.size(); ++i) {
            String property = (String)this.propertyChangeList.get(i);
            if (property.equals("mbeanFilterMappings")) {
                if (this.filterMappings == null || this.filterMappings.size() <= 0) continue;
                XMLUtils.writeAll(this.filterMappings, out, indention + "\t");
                continue;
            }
            if (property.equals("mbeanWelcomeFiles")) {
                if (this.welcomeFiles == null || this.welcomeFiles.size() <= 0) continue;
                out.println(indention + "\t<welcome-file-list>");
                XMLUtils.writeStrings(this.welcomeFiles, "welcome-file", out, indention + "\t\t");
                out.println(indention + "\t</welcome-file-list>");
                continue;
            }
            if (property.equals("servlet-loadOnStartup")) {
                if (this.servlets == null || this.servlets.size() <= 0) continue;
                for (int j = 0; j < this.servlets.size(); ++j) {
                    ServletDescriptor desc = (ServletDescriptor)this.servlets.get(j);
                    ArrayList _list = desc.getPropertyChangeList();
                    if (_list == null || _list.isEmpty() || !_list.contains("loadOnStartup")) continue;
                    desc.writeXML(out, indention + "\t");
                }
                continue;
            }
            if (!property.equals("session-timeout")) continue;
            out.println(indention + "\t<session-config>");
            if (this.sessionTimeout % 60 == 0) {
                out.println(indention + "\t\t<session-timeout>" + this.sessionTimeout / 60 + "</session-timeout>");
            } else {
                out.println(indention + "\t\t<session-timeout>" + this.sessionTimeout + "s</session-timeout>");
            }
            out.println(indention + "\t</session-config>");
        }
    }

    public boolean isPre24WebXml() {
        if (this.getWebXMLDoctype() == null) {
            return false;
        }
        String publicId = this.getWebXMLDoctype().getPublicId();
        return publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN") || publicId.equals("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN");
    }

    public void setParsingOrionXML(boolean parsingOrionXML) {
        this.isParsingOrionXML = parsingOrionXML;
    }

    public boolean isJspPropertyGroupDefined() {
        if (this.jspConfig != null) {
            return this.jspConfig.getProperties() != null && !this.jspConfig.getProperties().isEmpty();
        }
        return false;
    }

    public boolean isOJSPPropertyGroupDefined() {
        if (this.ojspConfig != null) {
            return this.ojspConfig.getProperties() != null && !this.ojspConfig.getProperties().isEmpty();
        }
        return false;
    }

    public OjspInitDescriptor getOjspInitDescriptor() {
        return this.ojspInit;
    }

    protected ServletDescriptor getServletDescriptor(Class cls) {
        Iterator servlets = this.getServlets().iterator();
        while (servlets.hasNext()) {
            ServletDescriptor servletDesc = (ServletDescriptor)servlets.next();
            if (!servletDesc.getClassName().equals(cls.getName())) continue;
            return servletDesc;
        }
        return null;
    }

    protected FilterDescriptor getFilterDescriptor(Class cls) {
        Iterator filters = this.getFilters().iterator();
        while (filters.hasNext()) {
            FilterDescriptor filterDesc = (FilterDescriptor)filters.next();
            if (!filterDesc.getClassName().equals(cls.getName())) continue;
            return filterDesc;
        }
        return null;
    }

    public ListenerDescriptor getListenerDescriptor(Class cls) {
        Iterator listeners = this.getListeners().iterator();
        while (listeners.hasNext()) {
            ListenerDescriptor listenerDesc = (ListenerDescriptor)listeners.next();
            if (!listenerDesc.getClassName().equals(cls.getName())) continue;
            return listenerDesc;
        }
        return null;
    }

    public boolean isWarFull() {
        return this.warMetadataComplete;
    }

    public boolean isWarVersion25() {
        return this.warVersion25;
    }

    private void writeXMLElement(PrintWriter out, String indention, String tag, String value) {
        if (value != null) {
            out.println(indention + "\t<" + tag + ">" + XMLUtils.encode(value) + "</" + tag + ">");
        }
    }

    private void writeAllXMLElements(PrintWriter out, String indention, List list) throws IOException {
        if (list != null && !list.isEmpty()) {
            if (list.get(0) instanceof WebApp24Descriptor) {
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    ((WebApp24Descriptor)it.next()).writeWebApp24XML(out, indention + "\t");
                }
            } else {
                XMLUtils.writeAll(list, out, indention + "\t");
            }
        }
    }

    private void writeLocaleEncodingMap(PrintWriter out, String indention) {
        if (this.localeEncodingMap != null && !this.localeEncodingMap.isEmpty()) {
            out.println(indention + "\t<locale-encoding-mapping-list>");
            Iterator it = this.localeEncodingMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String locale = (String)entry.getKey();
                int index = locale.indexOf(95);
                locale = index != -1 ? locale.substring(0, index).toLowerCase() + locale.substring(index) : locale.toLowerCase();
                out.println(indention + "\t\t<locale-encoding-mapping>");
                this.writeXMLElement(out, indention + "\t\t", "locale", locale);
                this.writeXMLElement(out, indention + "\t\t", "encoding", (String)entry.getValue());
                out.println(indention + "\t\t</locale-encoding-mapping>");
            }
            out.println(indention + "\t</locale-encoding-mapping-list>");
        }
    }

    public Properties getPreDestroyConfig() {
        return this.m_preDestroyConfig;
    }

    public Properties getPostConstructConfig() {
        return this.m_postConstructConfig;
    }

    private Properties parseLifecycleConfig(Node parent, Properties type) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        String className = null;
        String methodName = null;
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("life-cycle-callback-class")) {
                    className = XMLUtils.getStringValue(node);
                    continue;
                }
                if (!name.equals("life-cycle-callback-method")) continue;
                methodName = XMLUtils.getStringValue(node);
            }
        }
        if (className != null && methodName != null) {
            if (type == null) {
                type = new Properties();
            }
            if (type.put(className, methodName) != null) {
                throw new InstantiationException("Duplicate life-cycle-callback-method for : " + className);
            }
        } else {
            throw new InstantiationException("life-cycle-callback-class or life-cycle-callback-name is missing.");
        }
        return type;
    }

    public void setMetadataParsed(boolean set) {
        this.m_metadataParsed = set;
    }

    public boolean getMetadataParsed() {
        return this.m_metadataParsed;
    }
}

