/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerThread;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.http.AJPHttpServletResponse;
import com.evermind.server.http.EvermindFilterChain;
import com.evermind.server.http.EvermindFilterConfig;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.EvermindHttpSession;
import com.evermind.server.http.FileInformation;
import com.evermind.server.http.FileRequestDispatcher;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.JspServletInstanceInfo;
import com.evermind.server.http.OC4JRequestDispatcher;
import com.evermind.server.http.ResourceFilterChain;
import com.evermind.server.http.RuntimeFilterMapping;
import com.evermind.server.http.ServletInstanceInfo;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import oracle.dms.console.DMSConsole;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.TransTraceIntf;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JSecurity;
import oracle.oc4j.security.SensitiveDataHidden;
import oracle.security.jazn.oc4j.JAZNServletResponse;

class ServletRequestDispatcher
extends OC4JRequestDispatcher {
    private static final ByteString EMPTY_BYTESTRING = new ByteString("");
    private static final boolean FILTER_ON_DISPATCHERS = HTTPProperties.getFilterOnDispatch();
    ServletInstanceInfo info;
    ByteString servletPath;
    boolean servletPathChecked = false;
    FileInformation fileInformation;
    File requestedFile;
    private static TransactionManager m_tm = ApplicationServer.getInstance().getTransactionManager();
    private static Logger m_traceLogger = TraceLogger.getLogger(ServletRequestDispatcher.class);

    public ServletRequestDispatcher() {
    }

    public ServletRequestDispatcher(HttpApplication application) {
        if (application == null) {
            throw new NullPointerException("application was null");
        }
        this.application = application;
    }

    public ServletRequestDispatcher(HttpApplication application, boolean named) {
        this(application);
        this.m_isNamedDispatcher = named;
    }

    public void include(final ServletRequest request, final ServletResponse response) throws ServletException, IOException {
        OC4JPrivilegedAction action = new OC4JPrivilegedAction(){

            public Object oc4jRun() throws ServletException, IOException {
                ServletRequestDispatcher.this.unprivileged_include(request, response);
                return null;
            }
        };
        try {
            OC4JSecurity.doPrivileged(action);
        }
        catch (ServletException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unprivileged_include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpApplication previousApplication = this.application;
        byte previousInputStatus = 0;
        byte previousOutputStatus = 0;
        EvermindHttpServletRequest req = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : EvermindHttpServletRequest.getThreadRequest();
        EvermindHttpServletResponse res = response instanceof EvermindHttpServletResponse ? (EvermindHttpServletResponse)response : EvermindHttpServletResponse.getThreadResponse();
        previousApplication = req.originalApplication;
        req.originalApplication = req.application;
        req.application = this.application;
        EvermindHttpSession localSession = req.session;
        byte[] _sessionCookiePrefix = res.sessionCookiePrefix;
        byte[] _sessionCookieValue = res.sessionCookieValue;
        if (req.application != req.originalApplication) {
            req.session = null;
            res.sessionCookiePrefix = null;
            res.sessionCookieValue = null;
        }
        previousInputStatus = req.inputFetchStatus;
        previousOutputStatus = res.outputFetchStatus;
        if (this.requestedFile != null) {
            req.localize(this.requestedFile, this.fileInformation, true);
        }
        this.m_type = TYPE_INCLUDE;
        req.pushDispatcher(this);
        try {
            this.invoke(request, response);
            Object var12_11 = null;
            if (localSession != req.session) {
                if (req.session != null) {
                    res.addSessionCookie(req.session);
                    req.session.endRequest();
                }
                req.session = localSession;
                res.sessionCookiePrefix = _sessionCookiePrefix;
                res.sessionCookieValue = _sessionCookieValue;
            }
            req.inputFetchStatus = previousInputStatus;
            if (previousOutputStatus != 0) {
                res.outputFetchStatus = previousOutputStatus;
            }
            req.application = req.originalApplication;
            req.originalApplication = previousApplication;
            req.popDispatcher(this);
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            if (localSession != req.session) {
                if (req.session != null) {
                    res.addSessionCookie(req.session);
                    req.session.endRequest();
                }
                req.session = localSession;
                res.sessionCookiePrefix = _sessionCookiePrefix;
                res.sessionCookieValue = _sessionCookieValue;
            }
            req.inputFetchStatus = previousInputStatus;
            if (previousOutputStatus != 0) {
                res.outputFetchStatus = previousOutputStatus;
            }
            req.application = req.originalApplication;
            req.originalApplication = previousApplication;
            req.popDispatcher(this);
            throw throwable;
        }
    }

    public void forward(final ServletRequest request, final ServletResponse genericResponse) throws ServletException, IOException {
        OC4JPrivilegedAction action = new OC4JPrivilegedAction(){

            public Object oc4jRun() throws ServletException, IOException {
                ServletRequestDispatcher.this.unprivileged_forward(request, genericResponse);
                return null;
            }
        };
        try {
            OC4JSecurity.doPrivileged(action);
        }
        catch (ServletException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void unprivileged_forward(ServletRequest request, ServletResponse genericResponse) throws ServletException, IOException {
        HttpServletResponse response;
        try {
            response = (HttpServletResponse)genericResponse;
        }
        catch (ClassCastException e) {
            throw new ServletException("This resource only accepts HttpServletResponse instances");
        }
        EvermindHttpServletRequest req = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : EvermindHttpServletRequest.getThreadRequest();
        this.m_type = TYPE_FORWARD;
        if (response instanceof JAZNServletResponse) {
            response = (HttpServletResponse)((HttpServletResponseWrapper)response).getResponse();
        }
        if (response instanceof EvermindHttpServletResponse) {
            EvermindHttpServletResponse res = (EvermindHttpServletResponse)response;
            res.contentLocation = this.requestURI;
            res.resetBuffer();
            res.resetPrintWriter();
            this.forwardInternal(request, response);
            res.flushBuffer();
            if (res.getCurrentWriter() != null) {
                res.writer.close();
            }
            if (res.out != null) {
                res.out.closeFinally();
            }
            if (res instanceof AJPHttpServletResponse) {
                ((AJPHttpServletResponse)res).setCloseBuffer(true);
            }
        } else {
            response.setHeader("Content-Location", this.requestURI.toString());
            response.resetBuffer();
            this.forwardInternal(request, response);
            response.flushBuffer();
            try {
                PrintWriter writer = response.getWriter();
                writer.close();
            }
            catch (IllegalStateException e) {
                ServletOutputStream outstream = response.getOutputStream();
                outstream.close();
            }
        }
    }

    void forwardInternal(ServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        EvermindHttpServletResponse res;
        boolean includeIsContextRootRemovedInURI = false;
        EvermindHttpServletRequest req = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : EvermindHttpServletRequest.getThreadRequest();
        EvermindHttpServletResponse evermindHttpServletResponse = res = response instanceof EvermindHttpServletResponse ? (EvermindHttpServletResponse)response : EvermindHttpServletResponse.getThreadResponse();
        if (this.application != req.application) {
            if (req.session != null) {
                req.session.endRequest();
            }
            req.session = null;
        }
        ByteString includeRequestURI = req.requestURI;
        includeIsContextRootRemovedInURI = req.isContextRootRemovedInURI;
        byte previousFetchStatus = res.outputFetchStatus;
        res.outputFetchStatus = 0;
        req.pushDispatcher(this);
        if (!this.isNamedRequestDispatcher()) {
            req.requestURI = this.requestURI;
            req.isContextRootRemovedInURI = req.isContextRootRemovedInURI && this.requestURI.data == req.input;
            this.convertServletPath();
            req.servletPath = this.servletPath;
            req.servletName = this.info.getName();
            req.pathInfo = this.pathInfo;
            req.application = this.application;
            req.queryString = this.queryString;
        }
        if (res.contentTypeHeader == null && res.contentType == null && this.application.getConfig().isExplicitDefaultContentType()) {
            res.setContentType(this.application.getConfig().getDefaultContentType());
        }
        if (this.requestedFile != null) {
            req.localize(this.requestedFile, this.fileInformation, true);
        }
        try {
            try {
                if (this.application.autoJoinSession) {
                    ((HttpServletRequest)request).getSession(true);
                }
                this.invoke(request, (ServletResponse)response);
            }
            catch (ServletException e) {
                if (previousFetchStatus != 0) {
                    res.outputFetchStatus = previousFetchStatus;
                }
                throw e;
            }
            catch (IOException e) {
                if (previousFetchStatus != 0) {
                    res.outputFetchStatus = previousFetchStatus;
                }
                throw e;
            }
            Object var10_8 = null;
            if (includeRequestURI != null) {
                req.requestURI = includeRequestURI;
            }
            req.isContextRootRemovedInURI = includeIsContextRootRemovedInURI;
            req.popDispatcher(this);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (includeRequestURI != null) {
                req.requestURI = includeRequestURI;
            }
            req.isContextRootRemovedInURI = includeIsContextRootRemovedInURI;
            req.popDispatcher(this);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invoke(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        boolean _isDirectRequest;
        boolean _listenerEventSent;
        ContextContainer previousContainer;
        ServletInstanceInfo previousInfo;
        block84: {
            if (ApplicationServer.DMS_GATE && request instanceof HttpServletRequest) {
                DMSConsole cons = ApplicationServer.dmsConsole;
                TransTraceIntf tt = cons.getTransTrace();
                tt.servletRequestStart((HttpServletRequest)request, (HttpServletResponse)response);
            }
            if (this.info.unavailable) {
                long systemTime = System.currentTimeMillis();
                if (this.info.unavailableTime == -1L || this.info.unavailableTime > systemTime) {
                    ((HttpServletResponse)response).setHeader("Retry-After", String.valueOf((this.info.unavailableTime - systemTime) / 1000L));
                    ((HttpServletResponse)response).sendError(503, this.info.unavailableReason);
                    return;
                }
                this.info.unavailable = false;
                this.info.unavailableReason = null;
                this.info.unavailableTime = 0L;
            }
            ApplicationServerThread thread = ThreadState.getInheritableCurrentState().getApplicationServerThread();
            previousInfo = thread.servletInfo;
            thread.servletInfo = this.info;
            previousContainer = thread.state.getContextContainer();
            thread.state.contextContainer = this.application;
            RuntimeFilterMapping[] filterMappings = null;
            _listenerEventSent = false;
            _isDirectRequest = false;
            try {
                try {
                    EvermindHttpServletRequest evermindRequest = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : EvermindHttpServletRequest.getThreadRequest();
                    if (EvermindHttpServletRequest.executeBreakpointMethods) {
                        EvermindHttpServletRequest.debugBreakpointMethod();
                    }
                    if (evermindRequest != null) {
                        _isDirectRequest = evermindRequest.isDirectCall();
                    }
                    if (this.application.requestListeners != null && _isDirectRequest) {
                        _listenerEventSent = true;
                        for (int i = 0; i < this.application.requestListeners.length; ++i) {
                            this.application.requestListeners[i].requestInitialized(new ServletRequestEvent((ServletContext)this.application, request));
                        }
                    }
                    if (FILTER_ON_DISPATCHERS) {
                        filterMappings = this.application.filterMappings;
                    }
                    Filter securityFilter = this.application.securityFilter;
                    if (filterMappings != null || securityFilter != null) {
                        boolean appliedFilters = false;
                        ByteString requestURI = this.requestURI;
                        evermindRequest = request instanceof EvermindHttpServletRequest ? (EvermindHttpServletRequest)request : EvermindHttpServletRequest.getThreadRequest();
                        if (securityFilter != null && !this.application.securityFilterInited) {
                            Properties parameters = this.application.getConfig().getSecurityFilterProperties();
                            EvermindFilterConfig config = new EvermindFilterConfig(this.application, parameters, "JAZNFilter", null);
                            securityFilter.init((FilterConfig)config);
                            this.application.securityFilterInited = true;
                        }
                        Filter firstFilter = securityFilter;
                        EvermindFilterChain firstChain = null;
                        EvermindFilterChain currentChain = null;
                        int numOfFilterMappings = filterMappings == null ? 0 : filterMappings.length;
                        for (int i = 0; i < numOfFilterMappings; ++i) {
                            try {
                                RuntimeFilterMapping mapping = filterMappings[i];
                                if (!ServletRequestDispatcher.checkFilterDispatcher(mapping, evermindRequest) || mapping.start != null && !requestURI.startsWith(mapping.start) || mapping.end != null && !requestURI.endsWith(mapping.end) || mapping.servletName != null && !this.info.name.equals(mapping.servletName)) continue;
                                if (firstFilter == null) {
                                    firstFilter = mapping.instance;
                                    if (firstFilter == null) {
                                        mapping.config = this.application.getFilterConfig(mapping.filter);
                                        firstFilter = mapping.instance = mapping.config.instance;
                                    }
                                    if (!this.application.development || mapping.config.isUpToDate()) continue;
                                    this.application.reset();
                                    mapping.config = this.application.getFilterConfig(mapping.filter);
                                    firstFilter = mapping.instance = mapping.config.instance;
                                    continue;
                                }
                                if (firstChain == null) {
                                    firstChain = evermindRequest.filterChainCacheCount == 0 ? (currentChain = new EvermindFilterChain()) : (currentChain = evermindRequest.filterChainCache[--evermindRequest.filterChainCacheCount]);
                                    if (mapping.instance == null) {
                                        mapping.config = this.application.getFilterConfig(mapping.filter);
                                        mapping.instance = mapping.config.instance;
                                    }
                                    if (this.application.development && !mapping.config.isUpToDate()) {
                                        this.application.reset();
                                        mapping.config = this.application.getFilterConfig(mapping.filter);
                                        mapping.instance = mapping.config.instance;
                                    }
                                    firstChain.filter = mapping.instance;
                                    continue;
                                }
                                if (evermindRequest.filterChainCacheCount == 0) {
                                    currentChain = currentChain.next = new EvermindFilterChain();
                                } else {
                                    currentChain.next = currentChain = evermindRequest.filterChainCache[--evermindRequest.filterChainCacheCount];
                                }
                                if (mapping.instance == null) {
                                    mapping.config = this.application.getFilterConfig(mapping.filter);
                                    mapping.instance = mapping.config.instance;
                                }
                                if (this.application.development && !mapping.config.isUpToDate()) {
                                    this.application.reset();
                                    mapping.config = this.application.getFilterConfig(mapping.filter);
                                    mapping.instance = mapping.config.instance;
                                }
                                currentChain.filter = mapping.instance;
                                continue;
                            }
                            catch (InstantiationException e) {
                                throw new ServletException(e.getMessage());
                            }
                        }
                        if (firstFilter != null) {
                            Servlet currentServlet;
                            FileRequestDispatcher previousFile;
                            Servlet previousServlet;
                            block83: {
                                previousServlet = evermindRequest.currentPostFilterServlet;
                                previousFile = evermindRequest.currentPostFilterFile;
                                currentServlet = this.info.singleThreaded ? this.info.getInstance() : this.info.servlet;
                                PhaseEventIntf pe = null;
                                long token = -1L;
                                try {
                                    try {
                                        evermindRequest.currentPostFilterServlet = currentServlet;
                                        evermindRequest.currentPostFilterFile = null;
                                        if (ApplicationServer.DMS_GATE) {
                                            pe = this.getServiceMetric();
                                            token = pe.start();
                                        }
                                        if (EvermindHttpServletRequest.executeBreakpointMethods) {
                                            EvermindHttpServletRequest.debugBreakpointMethod();
                                        }
                                        if (currentChain != null) {
                                            currentChain.next = null;
                                            firstFilter.doFilter(request, response, (FilterChain)firstChain);
                                        } else {
                                            firstFilter.doFilter(request, response, (FilterChain)ResourceFilterChain.INSTANCE);
                                        }
                                    }
                                    catch (AccessControlException ace) {
                                        throw this.convertSecuritySensitiveData(ace);
                                    }
                                    Object var26_34 = null;
                                    if (!ApplicationServer.DMS_GATE || pe == null) break block83;
                                }
                                catch (Throwable throwable) {
                                    Object var26_35 = null;
                                    if (ApplicationServer.DMS_GATE && pe != null) {
                                        pe.stop(token);
                                        pe = null;
                                    }
                                    evermindRequest.currentPostFilterServlet = previousServlet;
                                    evermindRequest.currentPostFilterFile = previousFile;
                                    if (this.info.singleThreaded) {
                                        this.info.releaseInstance(currentServlet);
                                    }
                                    if (firstChain == null) throw throwable;
                                    while (true) {
                                        if (evermindRequest.filterChainCacheCount == 0) {
                                            if (evermindRequest.filterChainCache == null) {
                                                evermindRequest.filterChainCache = new EvermindFilterChain[2];
                                            }
                                            evermindRequest.filterChainCache[0] = firstChain;
                                            evermindRequest.filterChainCacheCount = 1;
                                        } else {
                                            if (evermindRequest.filterChainCacheCount >= evermindRequest.filterChainCache.length) {
                                                EvermindFilterChain[] newCache = new EvermindFilterChain[evermindRequest.filterChainCache.length * 2];
                                                System.arraycopy(evermindRequest.filterChainCache, 0, newCache, 0, evermindRequest.filterChainCache.length);
                                                evermindRequest.filterChainCache = newCache;
                                            }
                                            evermindRequest.filterChainCache[evermindRequest.filterChainCacheCount++] = firstChain;
                                        }
                                        if (firstChain == currentChain) {
                                            throw throwable;
                                        }
                                        firstChain = firstChain.next;
                                    }
                                }
                                pe.stop(token);
                                pe = null;
                            }
                            evermindRequest.currentPostFilterServlet = previousServlet;
                            evermindRequest.currentPostFilterFile = previousFile;
                            if (this.info.singleThreaded) {
                                this.info.releaseInstance(currentServlet);
                            }
                            if (firstChain != null) {
                                while (true) {
                                    if (evermindRequest.filterChainCacheCount == 0) {
                                        if (evermindRequest.filterChainCache == null) {
                                            evermindRequest.filterChainCache = new EvermindFilterChain[2];
                                        }
                                        evermindRequest.filterChainCache[0] = firstChain;
                                        evermindRequest.filterChainCacheCount = 1;
                                    } else {
                                        if (evermindRequest.filterChainCacheCount >= evermindRequest.filterChainCache.length) {
                                            EvermindFilterChain[] newCache = new EvermindFilterChain[evermindRequest.filterChainCache.length * 2];
                                            System.arraycopy(evermindRequest.filterChainCache, 0, newCache, 0, evermindRequest.filterChainCache.length);
                                            evermindRequest.filterChainCache = newCache;
                                        }
                                        evermindRequest.filterChainCache[evermindRequest.filterChainCacheCount++] = firstChain;
                                    }
                                    if (firstChain == currentChain) break;
                                    firstChain = firstChain.next;
                                }
                            }
                            Object var32_40 = null;
                            thread.servletInfo = previousInfo;
                            thread.state.contextContainer = previousContainer;
                            if (_listenerEventSent) {
                                for (int i = 0; i < this.application.requestListeners.length; ++i) {
                                    this.application.requestListeners[i].requestDestroyed(new ServletRequestEvent((ServletContext)this.application, request));
                                }
                            }
                            if (!_isDirectRequest) return;
                            this.closeOpenTransactionFromServlet();
                            return;
                        }
                    }
                    if (EvermindHttpServletRequest.executeBreakpointMethods) {
                        EvermindHttpServletRequest.debugBreakpointMethod();
                    }
                    this.setJSPRequest(request, this.info instanceof JspServletInstanceInfo);
                    if (this.info.singleThreaded) {
                        Servlet instance = this.info.getInstance();
                        if (ApplicationServer.DMS_GATE) {
                            PhaseEventIntf pe = this.getServiceMetric();
                            long token = pe.start();
                            try {
                                instance.service(request, response);
                                break block84;
                            }
                            finally {
                                pe.stop(token);
                                this.info.releaseInstance(instance);
                            }
                        }
                        try {
                            instance.service(request, response);
                            break block84;
                        }
                        finally {
                            this.info.releaseInstance(instance);
                        }
                    }
                    if (ApplicationServer.DMS_GATE) {
                        PhaseEventIntf pe = this.getServiceMetric();
                        long token = pe.start();
                        try {
                            this.info.servlet.service(request, response);
                            break block84;
                        }
                        finally {
                            pe.stop(token);
                        }
                    }
                    this.info.servlet.service(request, response);
                }
                catch (UnavailableException e) {
                    int seconds = e.getUnavailableSeconds();
                    if (seconds > 0) {
                        this.info.unavailableTime = System.currentTimeMillis() + (long)(seconds * 1000);
                        this.info.unavailableReason = e.getLocalizedMessage();
                        this.info.unavailable = true;
                        ((HttpServletResponse)response).setIntHeader("Retry-After", seconds);
                    } else if (seconds == -1) {
                        this.info.unavailableReason = e.getLocalizedMessage();
                        this.info.unavailable = true;
                        this.info.unavailableTime = -1L;
                    }
                    try {
                        int status = 404;
                        if (!e.isPermanent()) {
                            status = 503;
                        }
                        ((HttpServletResponse)response).sendError(status, this.info.unavailableReason);
                    }
                    catch (ClassCastException cce) {
                        m_traceLogger.log(Level.FINEST, "Exception: " + cce.getMessage(), cce);
                    }
                    Object var32_42 = null;
                    thread.servletInfo = previousInfo;
                    thread.state.contextContainer = previousContainer;
                    if (_listenerEventSent) {
                        for (int i = 0; i < this.application.requestListeners.length; ++i) {
                            this.application.requestListeners[i].requestDestroyed(new ServletRequestEvent((ServletContext)this.application, request));
                        }
                    }
                    if (!_isDirectRequest) return;
                    this.closeOpenTransactionFromServlet();
                    return;
                }
                catch (Throwable t) {
                    if (request instanceof EvermindHttpServletRequest) {
                        EvermindHttpServletRequest cfr_ignored_0 = (EvermindHttpServletRequest)request;
                        if (EvermindHttpServletRequest.executeBreakpointMethods) {
                            EvermindHttpServletRequest.debugBreakpointMethod();
                        }
                    }
                    if (t instanceof ServletException) {
                        throw (ServletException)t;
                    }
                    if (!(t instanceof IOException)) throw new ServletException("Error in servlet", t);
                    throw (IOException)t;
                }
            }
            catch (Throwable throwable) {
                Object var32_43 = null;
                thread.servletInfo = previousInfo;
                thread.state.contextContainer = previousContainer;
                if (_listenerEventSent) {
                    for (int i = 0; i < this.application.requestListeners.length; ++i) {
                        this.application.requestListeners[i].requestDestroyed(new ServletRequestEvent((ServletContext)this.application, request));
                    }
                }
                if (!_isDirectRequest) throw throwable;
                this.closeOpenTransactionFromServlet();
                throw throwable;
            }
        }
        Object var32_41 = null;
        thread.servletInfo = previousInfo;
        thread.state.contextContainer = previousContainer;
        if (_listenerEventSent) {
            for (int i = 0; i < this.application.requestListeners.length; ++i) {
                this.application.requestListeners[i].requestDestroyed(new ServletRequestEvent((ServletContext)this.application, request));
            }
        }
        if (!_isDirectRequest) return;
        this.closeOpenTransactionFromServlet();
    }

    protected void setJSPRequest(ServletRequest request, boolean flag) {
        if (request instanceof EvermindHttpServletRequest) {
            ((EvermindHttpServletRequest)request).setJSPRequest(flag);
        }
    }

    public String toString() {
        return "Servlet: " + this.info.name;
    }

    public HttpApplication getApplication() {
        return this.application;
    }

    public void setApplication(HttpApplication application) {
        if (application == null) {
            throw new NullPointerException("application was null");
        }
        this.application = application;
    }

    AccessControlException convertSecuritySensitiveData(AccessControlException ace) {
        if (ace.getPermission() instanceof FilePermission) {
            FilePermission fp = (FilePermission)ace.getPermission();
            SensitiveDataHidden.FilePermission convertedFilePerm = new SensitiveDataHidden.FilePermission(this.convertSecuritySensitiveFileName(fp.getName()), fp);
            return new SensitiveDataHidden.AccessControlException(this.createSecuritySensitiveMessage(convertedFilePerm), convertedFilePerm, ace);
        }
        return ace;
    }

    String convertSecuritySensitiveFileName(String fileName) {
        String contextPath;
        if (null == fileName) {
            return null;
        }
        String string = contextPath = null == this.getContextPath() ? null : this.getContextPath().toString();
        if (null != contextPath && fileName.startsWith(contextPath)) {
            return "./" + fileName.substring(contextPath.length());
        }
        File file = new File(fileName);
        return file.getName();
    }

    String createSecuritySensitiveMessage(SensitiveDataHidden.FilePermission permission) {
        return "access denied (java.io.FilePermission " + permission.getName() + ' ' + permission.getActions() + ')';
    }

    public PhaseEventIntf getServiceMetric() {
        if (this.info.servicePhase == null) {
            try {
                this.info.servicePhase = ApplicationServer.phaseEventFactory().create(this.getNoun(), "service", "servlet_metric");
                this.info.servicePhase.deriveMetric(511);
            }
            catch (Exception e) {
                this.getApplication().log("Unable to create phase sensor", e);
            }
        }
        return this.info.servicePhase;
    }

    private NounIntf getNoun() {
        if (this.info.servletNoun == null) {
            try {
                if (this.info.servletNoun == null) {
                    NounIntf parentNoun = this.getApplication().getServletsNoun();
                    this.info.servletNoun = ApplicationServer.nounFactory().create(parentNoun, this.info.name.toString(), "oc4j_servlet");
                }
            }
            catch (Exception e) {
                this.getApplication().log("Unable to create servlet noun", e);
            }
        }
        return this.info.servletNoun;
    }

    public static boolean checkFilterDispatcher(RuntimeFilterMapping mapping, EvermindHttpServletRequest request) {
        if (request.getAttribute("javax.servlet.error.status_code") != null) {
            return mapping.doesDispatchError();
        }
        boolean isFormAuth = request.isPerformingFormAuth();
        if (request.isPerformingFormAuth()) {
            return mapping.doesDispatcherFormAuth();
        }
        return mapping.doesDispatchRequest() && request.isDirectCall() || mapping.doesDispatchForward() && request.isForwarded() || mapping.doesDispatchInclude() && request.isIncluded();
    }

    public ByteString getServletPath() {
        this.convertServletPath();
        return this.servletPath;
    }

    public void reset() {
        super.reset();
        this.info = null;
        this.servletPath = null;
        this.servletPathChecked = false;
        this.fileInformation = null;
        this.requestedFile = null;
    }

    protected static ServletRequestDispatcher getDispatcher(HttpApplication app) {
        return ServletRequestDispatcher.getDispatcher(app, false);
    }

    protected static ServletRequestDispatcher getDispatcher(HttpApplication app, boolean named) {
        return new ServletRequestDispatcher(app, named);
    }

    void closeOpenTransactionFromServlet() {
        block5: {
            Transaction transaction = null;
            try {
                transaction = m_tm.getTransaction();
            }
            catch (SystemException e) {
                // empty catch block
            }
            if (transaction != null) {
                try {
                    this.application.log("Servlet has not completed its transaction: " + this.info.getName());
                    m_tm.rollback();
                    this.application.log("Transaction rolled back by system");
                }
                catch (Throwable t) {
                    if (this.application == null) break block5;
                    this.application.log("Error rolling back transaction by system", t);
                }
            }
        }
    }

    private void convertServletPath() {
        if (this.m_type != TYPE_DIRECT && !this.servletPathChecked) {
            byte[] servletPathByteArray = this.servletPath.getBytes();
            int currentPos = 0;
            int bytePos = 0;
            int length = servletPathByteArray.length;
            boolean converted = false;
            while (bytePos < this.servletPath.length) {
                byte currentChar;
                servletPathByteArray[currentPos] = currentChar = servletPathByteArray[bytePos];
                converted = false;
                if (currentChar == 47) {
                    if (bytePos + 1 < this.servletPath.length && servletPathByteArray[bytePos + 1] == 47) {
                        --length;
                        ++bytePos;
                        converted = true;
                    } else if (bytePos + 2 < this.servletPath.length && servletPathByteArray[bytePos + 1] == 46 && servletPathByteArray[bytePos + 2] == 47) {
                        length -= 2;
                        bytePos += 2;
                        converted = true;
                    } else if (bytePos + 3 < this.servletPath.length && servletPathByteArray[bytePos + 1] == 46 && servletPathByteArray[bytePos + 2] == 46 && servletPathByteArray[bytePos + 3] == 47) {
                        bytePos += 3;
                        int prevSegmentStart = 0;
                        if (currentPos > 0) {
                            for (prevSegmentStart = currentPos - 1; prevSegmentStart >= 0 && servletPathByteArray[prevSegmentStart] != 47; --prevSegmentStart) {
                            }
                        }
                        if (prevSegmentStart >= 0 || currentPos == 0) {
                            length -= currentPos - prevSegmentStart + 3;
                            currentPos = prevSegmentStart;
                            converted = true;
                        } else {
                            currentPos = bytePos;
                        }
                    }
                }
                if (converted) continue;
                ++currentPos;
                ++bytePos;
            }
            if (this.servletPath.length > length) {
                this.servletPath.data = servletPathByteArray;
                this.servletPath.length = length;
                this.servletPath.offset = 0;
            }
            this.servletPathChecked = true;
        }
    }
}

