/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.JSPPage;
import com.evermind.server.http.deployment.ServletDescriptor;
import com.evermind.util.ByteString;
import java.io.File;
import java.io.Serializable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;

public class ServletInstanceInfo
implements Serializable {
    public Servlet servlet;
    public Servlet[] pool;
    public Class type;
    public int availableCount;
    public ServletConfig config;
    public File file;
    public long binaryLastModified;
    public File sourceFile;
    public long sourceLastModified;
    public long lastModifiedCheck;
    public boolean invalidated;
    public boolean autoReload;
    public HttpApplication application;
    public ByteString name;
    private ByteString nameCache;
    private String nameString;
    public boolean shared;
    public boolean singleThreaded;
    public boolean sandboxed;
    public boolean destroyed;
    public boolean active;
    public boolean unavailable;
    public long unavailableTime;
    public String unavailableReason;
    public JSPPage page;
    public String runAsRoleName;
    public NounIntf servletNoun;
    public PhaseEventIntf servicePhase;
    public ServletDescriptor descriptor;

    public ServletInstanceInfo() {
    }

    public ServletInstanceInfo(HttpApplication application) {
        this.application = application;
    }

    public String getName() {
        if (this.nameCache == null || this.nameCache.data != this.name.data || this.nameCache.offset != this.name.offset || this.nameCache.length != this.name.length) {
            this.nameString = this.name.toString();
            this.nameCache = this.name;
        }
        return this.nameString;
    }

    public synchronized Servlet getInstance() throws ServletException, ClassNotFoundException {
        if (this.availableCount > 0) {
            return this.pool[--this.availableCount];
        }
        if (this.servlet != null) {
            Servlet servlet = this.servlet;
            this.servlet = null;
            return servlet;
        }
        try {
            Servlet newInstance = (Servlet)this.type.newInstance();
            newInstance.init(this.config);
            return newInstance;
        }
        catch (ClassCastException e) {
            throw new ClassNotFoundException(this.type.toString() + " does not implement Servlet", e);
        }
        catch (Exception e) {
            throw new ClassNotFoundException(this.type.toString(), e);
        }
    }

    public synchronized void releaseInstance(Servlet instance) {
        if (this.pool == null || this.availableCount >= this.pool.length) {
            Servlet[] newPool = new Servlet[this.pool == null ? 4 : this.pool.length * 2];
            if (this.pool != null) {
                System.arraycopy(this.pool, 0, newPool, 0, this.availableCount);
            }
            this.pool = newPool;
        }
        this.pool[this.availableCount++] = instance;
    }

    public void finalize() {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (this.servlet != null) {
            if (!this.destroyed) {
                this.servlet.destroy();
            }
            this.destroyed = true;
        }
        if (this.pool != null) {
            try {
                for (int i = 0; i < this.availableCount; ++i) {
                    this.pool[i].destroy();
                }
                Object var3_2 = null;
                this.pool = null;
                this.availableCount = 0;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.pool = null;
                this.availableCount = 0;
                throw throwable;
            }
        }
    }

    public ServletDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = this.application.config.getServletDescriptor(this.getName(), true);
        }
        return this.descriptor;
    }
}

