/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.JspInterface;
import com.evermind.server.http.ServletInstanceInfo;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class JspServletInstanceInfo
extends ServletInstanceInfo
implements JspInterface {
    protected JspInterface jsp;
    public static final int TLD_CACHE_LEVEL_ON = 0;
    public static final int TLD_CACHE_LEVEL_STANDARD = 1;
    public static final int TLD_CACHE_LEVEL_OFF = 2;
    public static final int TLD_CACHE_LEVEL_STANDARD_WITH_ANNOTATIONS = -1;
    public static final int TLD_CACHE_LEVEL_ON_WITH_ANNOTATIONS = -2;

    public JspServletInstanceInfo() {
    }

    public JspServletInstanceInfo(HttpApplication application) {
        super(application);
    }

    protected static JspInterface getJspInterfaceInstance() throws InstantiationException {
        try {
            return (JspInterface)Class.forName("oracle.jsp.runtimev2.JspServlet").newInstance();
        }
        catch (ClassNotFoundException e) {
            IllegalStateException ex = new IllegalStateException("Must have JSP in order to initialize the Tld Cache");
            ex.initCause(e);
            throw ex;
        }
        catch (IllegalAccessException e) {
            IllegalStateException ex = new IllegalStateException("Cannot access no argument constructor on the JspServlet");
            ex.initCause(e);
            throw ex;
        }
    }

    public static File[] listUnjarredTldFiles(File webInfDir, int level) {
        ArrayList al = new ArrayList();
        if (!webInfDir.isDirectory() || !webInfDir.exists()) {
            return null;
        }
        JspServletInstanceInfo.findTldFiles(webInfDir, al, level);
        File[] flist = new File[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            flist[i] = new File(((File)al.get(i)).getPath());
        }
        return flist;
    }

    private static void findTldFiles(File dir, ArrayList al, int level) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir, files[i].getName());
            if (f.isDirectory()) {
                if (level == 0 || level == -2) {
                    JspServletInstanceInfo.findTldFiles(f, al, level);
                    continue;
                }
                if ("classes".equalsIgnoreCase(f.getName()) || "lib".equalsIgnoreCase(f.getName())) continue;
                JspServletInstanceInfo.findTldFiles(f, al, level);
                continue;
            }
            if (!files[i].getName().endsWith(".tld") && !files[i].getName().endsWith(".otld") && !files[i].getName().endsWith(".TLD")) continue;
            al.add(files[i]);
        }
    }

    protected void initializeJsp() {
        this.jsp = (JspInterface)this.servlet;
    }

    public Object newApplicationCache(String realPath, ClassLoader loader, URL jspCacheDir, int verbosity, int searchLevel) throws IOException, InterruptedException, MalformedURLException {
        return this.jsp.newApplicationCache(realPath, loader, jspCacheDir, verbosity, searchLevel);
    }

    public List getTldListeners(Object cache) throws IOException {
        return this.jsp.getTldListeners(cache);
    }

    public Class getJspClass(HttpServletRequest request, String s) throws ServletException, ClassNotFoundException, IOException {
        return this.jsp.getJspClass(request, s);
    }

    public String insertJspLineInfo(String s) {
        return this.jsp.insertJspLineInfo(s);
    }

    public File getJspClassFile(HttpServletRequest request, String s) throws ServletException, ClassNotFoundException, IOException {
        return this.jsp.getJspClassFile(request, s);
    }

    public boolean isJspPageExists(String servletpath) throws ServletException {
        return this.jsp.isJspPageExists(servletpath);
    }

    public Object getGlobalTldCacheInstance(String realPath, ClassLoader loader, int verbosity, String globalResources, String globalCacheLocBase, int searchLevel) throws IOException, InterruptedException, MalformedURLException {
        return this.jsp.getGlobalTldCacheInstance(realPath, loader, verbosity, globalResources, globalCacheLocBase, searchLevel);
    }

    public List getJspTaglibListeners(String realPath, ClassLoader loader, Map tagClassMap) {
        return this.jsp.getJspTaglibListeners(realPath, loader, tagClassMap);
    }

    public Map getTagClassMap() {
        return this.jsp.getTagClassMap();
    }

    public static boolean jspTldCacheIsUsed(int jspCacheLevel) {
        return jspCacheLevel < 2;
    }
}

