/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.ThreadState;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class HttpDateFormat
extends GregorianCalendar {
    static final String[] WEEKDAY = new String[]{"Unknown", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final byte[][] MONTH = new byte[][]{"Jan".getBytes(), "Feb".getBytes(), "Mar".getBytes(), "Apr".getBytes(), "May".getBytes(), "Jun".getBytes(), "Jul".getBytes(), "Aug".getBytes(), "Sep".getBytes(), "Oct".getBytes(), "Nov".getBytes(), "Dec".getBytes()};
    public static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT+00:00");
    private static String currentTime;
    static byte[] dateHeader;
    static byte[] ajpDateHeader;
    private static String neverExpiresTime;
    static byte[] neverExpiresHeader;
    static long currentTimeLong;
    static long lastExpiresNeverUpdate;
    public static final Object lock;
    public static final String[] WEEKDAY2;

    private static Calendar getCachedCalendar() {
        return ThreadState.getInheritableCurrentState().getCalendarCache();
    }

    private static void resetMilli(Calendar c) {
        c.set(14, 0);
    }

    public static long currentTimeMillis() {
        return currentTimeLong;
    }

    public static String getCurrentTime() {
        return currentTime;
    }

    public static byte[] getDateHeader() {
        return dateHeader;
    }

    public static byte[] getAjpDateHeader() {
        return ajpDateHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCurrentTime() {
        Calendar cachedCal = HttpDateFormat.getCachedCalendar();
        Object object = lock;
        synchronized (object) {
            currentTimeLong = System.currentTimeMillis();
            cachedCal.setTime(new Date(currentTimeLong));
        }
        currentTime = HttpDateFormat.format(cachedCal);
        dateHeader = ("Date: " + currentTime + "\r\n").getBytes();
        ajpDateHeader = currentTime.getBytes();
        if (currentTimeLong - lastExpiresNeverUpdate >= 100000000L) {
            lastExpiresNeverUpdate = currentTimeLong + 315360000L;
            neverExpiresTime = HttpDateFormat.format(currentTimeLong + 31536000000L);
            neverExpiresHeader = ("Expires: " + neverExpiresTime + "\r\n").getBytes();
        }
    }

    public static String format(long date) {
        return HttpDateFormat.format(date, HttpDateFormat.getCachedCalendar());
    }

    public static String format(long date, Calendar calendar) {
        calendar.setTime(new Date(date));
        return HttpDateFormat.format(calendar);
    }

    private static String format(Calendar calendar) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(WEEKDAY[calendar.get(7)]);
        buffer.append(", ");
        int value = calendar.get(5);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(String.valueOf(value));
        buffer.append(' ');
        int monthID = calendar.get(2);
        buffer.append((char)MONTH[monthID][0]);
        buffer.append((char)MONTH[monthID][1]);
        buffer.append((char)MONTH[monthID][2]);
        buffer.append(' ');
        buffer.append(String.valueOf(calendar.get(1)));
        buffer.append(' ');
        value = calendar.get(11);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(String.valueOf(value));
        buffer.append(':');
        value = calendar.get(12);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(String.valueOf(value));
        buffer.append(':');
        value = calendar.get(13);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(String.valueOf(value));
        buffer.append(" GMT");
        return buffer.toString();
    }

    public static String format3(long date) {
        return HttpDateFormat.format3(date, HttpDateFormat.getCachedCalendar());
    }

    public static String format3(long date, Calendar calendar) {
        calendar.setTime(new Date(date));
        return HttpDateFormat.format3(calendar);
    }

    public static String format3(Calendar calendar) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(WEEKDAY[calendar.get(7)]);
        buffer.append(", ");
        int value = calendar.get(5);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(String.valueOf(value));
        buffer.append('-');
        int monthID = calendar.get(2);
        buffer.append((char)MONTH[monthID][0]);
        buffer.append((char)MONTH[monthID][1]);
        buffer.append((char)MONTH[monthID][2]);
        buffer.append('-');
        value = calendar.get(1);
        buffer.append(String.valueOf(value));
        buffer.append(' ');
        value = calendar.get(11);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(String.valueOf(value));
        buffer.append(':');
        value = calendar.get(12);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(String.valueOf(value));
        buffer.append(':');
        value = calendar.get(13);
        if (value < 10) {
            buffer.append('0');
        }
        buffer.append(String.valueOf(value));
        buffer.append(" GMT");
        return buffer.toString();
    }

    public static Date parse(String name) throws ParseException {
        return HttpDateFormat.parse(name, HttpDateFormat.getCachedCalendar());
    }

    public static Date parse(String name, Calendar calendar) throws ParseException {
        if (name.length() < 5) {
            throw new ParseException("Invalid length", 0);
        }
        if (name.charAt(3) != ',') {
            if (name.charAt(3) == ' ') {
                return HttpDateFormat.parseFormat3(name);
            }
            return HttpDateFormat.parseFormat2(name, calendar);
        }
        HttpDateFormat.resetMilli(calendar);
        int date = (name.charAt(5) - 48) * 10;
        date += name.charAt(6) - 48;
        int year = (name.charAt(12) - 48) * 1000;
        year += (name.charAt(13) - 48) * 100;
        year += (name.charAt(14) - 48) * 10;
        year += name.charAt(15) - 48;
        int hour = (name.charAt(17) - 48) * 10;
        hour += name.charAt(18) - 48;
        int minute = (name.charAt(20) - 48) * 10;
        minute += name.charAt(21) - 48;
        int second = (name.charAt(23) - 48) * 10;
        second += name.charAt(24) - 48;
        int month = -1;
        for (int i = 0; i < 12; ++i) {
            if (name.charAt(8) != MONTH[i][0] || name.charAt(9) != MONTH[i][1] || name.charAt(10) != MONTH[i][2]) continue;
            month = i;
            break;
        }
        if (month < 0) {
            throw new ParseException("Illegal month name: " + name.substring(8, 11) + ", total HttpDate string: '" + name + "'", 8);
        }
        calendar.set(year, month, date, hour, minute, second);
        return calendar.getTime();
    }

    public static Date parse(byte[] name, int offset, int length) throws ParseException {
        return HttpDateFormat.parse(name, offset, length, HttpDateFormat.getCachedCalendar());
    }

    public static Date parse(byte[] name, int offset, int length, Calendar calendar) throws ParseException {
        if (length < 5) {
            throw new ParseException("Invalid length", 0);
        }
        if (name[offset + 3] != 44) {
            if (name[offset + 3] == 32) {
                return HttpDateFormat.parseFormat3(name, offset, length);
            }
            return HttpDateFormat.parseFormat2(name, offset, length, calendar);
        }
        if (length < 29) {
            throw new ParseException("Invalid length", length);
        }
        HttpDateFormat.resetMilli(calendar);
        int date = (name[offset + 5] - 48) * 10;
        date += name[offset + 6] - 48;
        int year = (name[offset + 12] - 48) * 1000;
        year += (name[offset + 13] - 48) * 100;
        year += (name[offset + 14] - 48) * 10;
        year += name[offset + 15] - 48;
        int hour = (name[offset + 17] - 48) * 10;
        hour += name[offset + 18] - 48;
        int minute = (name[offset + 20] - 48) * 10;
        minute += name[offset + 21] - 48;
        int second = (name[offset + 23] - 48) * 10;
        second += name[offset + 24] - 48;
        int month = -1;
        for (int i = 0; i < 12; ++i) {
            if (name[offset + 8] != MONTH[i][0] || name[offset + 9] != MONTH[i][1] || name[offset + 10] != MONTH[i][2]) continue;
            month = i;
            break;
        }
        if (month < 0) {
            throw new ParseException("Illegal month name: " + new String(name, offset + 8, 3) + ", total HttpDate string: '" + name + "'", 8);
        }
        calendar.set(year, month, date, hour, minute, second);
        return calendar.getTime();
    }

    public static Date parseFormat2(String name) throws ParseException {
        return HttpDateFormat.parseFormat2(name, HttpDateFormat.getCachedCalendar());
    }

    public static Date parseFormat2(String name, Calendar calendar) throws ParseException {
        HttpDateFormat.resetMilli(calendar);
        try {
            int pos = name.indexOf(44) + 2;
            int date = (name.charAt(pos++) - 48) * 10;
            date += name.charAt(pos++) - 48;
            ++pos;
            int month = -1;
            for (int i = 0; i < 12; ++i) {
                if (name.charAt(pos) != MONTH[i][0] || name.charAt(pos + 1) != MONTH[i][1] || name.charAt(pos + 2) != MONTH[i][2]) continue;
                month = i;
                break;
            }
            if (month < 0) {
                throw new ParseException("Illegal month name: " + name.substring(pos, pos + 4) + ", total HttpDate string: '" + name + "'", pos);
            }
            pos += 4;
            int year = (name.charAt(pos++) - 48) * 10;
            year = (year += name.charAt(pos++) - 48) > 50 ? (year += 1900) : (year += 2000);
            int n = ++pos;
            int hour = (name.charAt(n) - 48) * 10;
            int n2 = ++pos;
            ++pos;
            hour += name.charAt(n2) - 48;
            int n3 = ++pos;
            int minute = (name.charAt(n3) - 48) * 10;
            int n4 = ++pos;
            ++pos;
            minute += name.charAt(n4) - 48;
            int n5 = ++pos;
            int second = (name.charAt(n5) - 48) * 10;
            int n6 = ++pos;
            ++pos;
            ++pos;
            calendar.set(year, month, date, hour, minute, second += name.charAt(n6) - 48);
            return calendar.getTime();
        }
        catch (Exception e) {
            throw new ParseException("Invalid date format", 0);
        }
    }

    public static Date parseFormat3(String name) throws ParseException {
        return HttpDateFormat.parseFormat3(name, HttpDateFormat.getCachedCalendar());
    }

    public static Date parseFormat3(String name, Calendar calendar) throws ParseException {
        HttpDateFormat.resetMilli(calendar);
        try {
            int month = -1;
            for (int i = 0; i < 12; ++i) {
                if (name.charAt(4) != MONTH[i][0] || name.charAt(5) != MONTH[i][1] || name.charAt(6) != MONTH[i][2]) continue;
                month = i;
                break;
            }
            if (month < 0) {
                throw new ParseException("Illegal month name: " + name.substring(4, 7) + ", total HttpDate string: '" + name + "'", 4);
            }
            int date = name.charAt(8) == ' ' ? 0 : (name.charAt(8) - 48) * 10;
            date += name.charAt(9) - 48;
            int hour = (name.charAt(11) - 48) * 10;
            hour += name.charAt(12) - 48;
            int minute = (name.charAt(14) - 48) * 10;
            int second = (name.charAt(17) - 48) * 10;
            int year = (name.charAt(20) - 48) * 1000;
            year += (name.charAt(21) - 48) * 100;
            year += (name.charAt(22) - 48) * 10;
            calendar.set(year += name.charAt(23) - 48, month, date, hour, minute += name.charAt(15) - 48, second += name.charAt(18) - 48);
            return calendar.getTime();
        }
        catch (Exception e) {
            throw new ParseException("Invalid date format", 0);
        }
    }

    public static Date parseFormat2(byte[] name, int offset, int length) throws ParseException {
        return HttpDateFormat.parseFormat2(name, offset, length, HttpDateFormat.getCachedCalendar());
    }

    public static Date parseFormat2(byte[] name, int offset, int length, Calendar calendar) throws ParseException {
        HttpDateFormat.resetMilli(calendar);
        try {
            int pos = 0;
            while (name[offset + pos] != 44) {
                if (++pos != length) continue;
                throw new ParseException("No ',' in the string", pos);
            }
            if (length < pos + 17) {
                throw new ParseException("Illegal length", 0);
            }
            int date = (name[offset + pos++] - 48) * 10;
            date += name[offset + pos++] - 48;
            ++pos;
            int month = -1;
            for (int i = 0; i < 12; ++i) {
                if (name[offset + pos] != MONTH[i][0] || name[offset + pos + 1] != MONTH[i][1] || name[offset + pos + 2] != MONTH[i][2]) continue;
                month = i;
                break;
            }
            if (month < 0) {
                throw new ParseException("Illegal month name: " + new String(name, pos, 4) + ", total HttpDate string: '" + name + "'", pos);
            }
            pos += 4;
            int year = (name[offset + pos++] - 48) * 10;
            year = (year += name[offset + pos++] - 48) > 50 ? (year += 1900) : (year += 2000);
            int n = ++pos;
            int hour = (name[offset + n] - 48) * 10;
            int n2 = ++pos;
            ++pos;
            hour += name[offset + n2] - 48;
            int n3 = ++pos;
            int minute = (name[offset + n3] - 48) * 10;
            int n4 = ++pos;
            ++pos;
            minute += name[offset + n4] - 48;
            int n5 = ++pos;
            int second = (name[offset + n5] - 48) * 10;
            int n6 = ++pos;
            ++pos;
            ++pos;
            calendar.set(year, month, date, hour, minute, second += name[offset + n6] - 48);
            return calendar.getTime();
        }
        catch (Exception e) {
            throw new ParseException("Invalid date format", 0);
        }
    }

    public static Date parseFormat3(byte[] name, int offset, int length) throws ParseException {
        return HttpDateFormat.parseFormat3(name, offset, length, HttpDateFormat.getCachedCalendar());
    }

    public static Date parseFormat3(byte[] name, int offset, int length, Calendar calendar) throws ParseException {
        HttpDateFormat.resetMilli(calendar);
        if (length < 24) {
            throw new ParseException("Illegal length", 0);
        }
        try {
            int month = -1;
            for (int i = 0; i < 12; ++i) {
                if (name[offset + 4] != MONTH[i][0] || name[offset + 5] != MONTH[i][offset + 1] || name[offset + 6] != MONTH[i][offset + 2]) continue;
                month = i;
                break;
            }
            if (month < 0) {
                throw new ParseException("Illegal month name: " + new String(name, 4, 3) + ", total HttpDate string: '" + name + "'", 4);
            }
            int date = name[offset + 8] == 32 ? 0 : (name[offset + 8] - 48) * 10;
            date += name[offset + 9] - 48;
            int hour = (name[offset + 11] - 48) * 10;
            hour += name[offset + 12] - 48;
            int minute = (name[offset + 14] - 48) * 10;
            int second = (name[offset + 17] - 48) * 10;
            int year = (name[offset + 20] - 48) * 1000;
            year += (name[offset + 21] - 48) * 100;
            year += (name[offset + 22] - 48) * 10;
            calendar.set(year += name[offset + 23] - 48, month, date, hour, minute += name[offset + 15] - 48, second += name[offset + 18] - 48);
            return calendar.getTime();
        }
        catch (Exception e) {
            throw new ParseException("Invalid date format", 0);
        }
    }

    static {
        lock = new Object();
        HttpDateFormat.updateCurrentTime();
        WEEKDAY2 = new String[]{"Unknown", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    }
}

