/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import com.evermind.net.NetUtils;
import com.evermind.server.ApplicationServer;
import com.evermind.server.OC4JServiceInfo;
import com.evermind.server.http.HttpMessages;
import com.evermind.server.http.HttpRequestHandler;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.HttpSiteConfig;
import com.evermind.ssl.SSLConfig;
import com.evermind.util.HTTPProperties;
import com.evermind.util.ThreadPool;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSocketFactory;
import oracle.dms.console.DMSConsole;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.network.NIOServerSocketDriver;
import oracle.oc4j.network.ServerSocketAcceptHandler;
import oracle.oc4j.network.ServerSocketReadHandler;
import oracle.oc4j.security.OC4JSSLSocketFactory;
import oracle.oc4j.server.InternalDispatcher;

public class HttpConnectionListener
implements Runnable,
InternalDispatcher.InternalListener {
    private static BoundedBuffer handlerBuffer = null;
    private static int maxFreeHandlers = 10;
    public Object statLock = new Object();
    private boolean httpUseNonBlockingAccept = Boolean.getBoolean("http.useNonBlockingAccept");
    private static final byte[] SERVER_BUSY_MESSAGE = "HTTP/1.1 503 Service Unavailable\r\n\r\n<HTML><HEAD><TITLE>503 Server too busy</TITLE></HEAD><BODY><H1>503 Server too busy</H1></BODY></HTML>".getBytes();
    protected NIOServerSocketDriver nioDriver;
    protected ServerSocketAcceptHandler httpNIOAcceptHandler;
    HttpServer server;
    HttpSiteConfig config;
    ServerSocket socket;
    HttpSite[] sites;
    InetAddress address;
    int port;
    boolean secure;
    boolean alive = true;
    int listeningHandlers;
    public static final int DEFAULT_BACKLOG = 30;
    private static Logger m_traceLogger = TraceLogger.getLogger(HttpConnectionListener.class);
    private static Logger logger = Logger.getLogger(HttpConnectionListener.class.getName());

    protected ServerSocketAcceptHandler getAcceptHandler(NIOServerSocketDriver _nioDriver, SocketAddress _endpoint, int backlog) {
        return new HttpNIOAcceptHandler(_nioDriver, (InetSocketAddress)_endpoint, backlog);
    }

    public HttpConnectionListener(HttpServer server, InetAddress address, HttpSiteConfig config) throws IOException, InstantiationException {
        this.server = server;
        this.config = config;
        this.address = address;
        this.port = this.getPort(config);
        this.secure = config.isSecure();
        this.nioDriver = new NIOServerSocketDriver();
        this.initHandlers(config.getSSLConfig());
        InternalDispatcher.addListener(String.valueOf(config.getPort()), this);
        DMSConsole.getConsole().setProcessID(this.port);
        this.nioDriver.connect();
        if (this.port == 0) {
            this.port = this.httpNIOAcceptHandler.getLocalPort();
            config.setPort(this.port);
        }
    }

    private void initHandlers(SSLConfig sslConfig) throws IOException, InstantiationException {
        long _maxWait;
        InetSocketAddress address = this.config.getAddress() == NetUtils.ZERO_ADDRESS ? new InetSocketAddress(this.port) : new InetSocketAddress(this.config.getAddress(), this.port);
        this.httpNIOAcceptHandler = this.getAcceptHandler(this.nioDriver, address, this.server.getConfig().getSocketBacklog());
        this.httpNIOAcceptHandler.setMaxConnection(this.server.maxConnections);
        if (this.secure) {
            try {
                if (null == sslConfig) {
                    throw new InstantiationException("web-site with secure=\"true\" must define a ssl-config");
                }
                this.httpNIOAcceptHandler.setSSLSocketFactory((SSLSocketFactory)OC4JSSLSocketFactory.createSSLSocketFactory(sslConfig), sslConfig);
            }
            catch (Throwable t) {
                HttpMessages.severeCouldNotCreateSecureHttpListener(t);
                IOException e = new IOException("SSL setup failure: " + t.getMessage());
                e.initCause(t);
                throw e;
            }
        }
        if ((_maxWait = (long)this.server.getConfig().getConnectionLimitWaitTimeout()) <= 0L) {
            _maxWait = 4611686018427387L;
        }
        this.httpNIOAcceptHandler.setMaxWaitingTimeSeconds(_maxWait);
        ThreadPool tp = null;
        if (this.config.getThreadPoolNm() != null && (tp = ApplicationServer.getInstance().getCustomThreadPool(this.config.getThreadPoolNm())) == null && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Custom Thread Pool " + this.config.getThreadPoolNm() + " not found");
        }
        if (tp == null) {
            tp = ApplicationServer.getInstance().getRequestThreadPool();
        }
        this.httpNIOAcceptHandler.setThreadPool(tp);
        this.httpNIOAcceptHandler.setEmergencyThreadPool(ApplicationServer.getInstance().getThreadPool());
        this.httpNIOAcceptHandler.setConnectionThreadPool(ApplicationServer.getInstance().getThreadPool());
        if (this.httpUseNonBlockingAccept) {
            this.httpNIOAcceptHandler.setBlockingAccept(false);
        } else {
            this.httpNIOAcceptHandler.setBlockingAccept(true);
        }
        this.setRequestHandlerPool();
        this.nioDriver.addAcceptHandler(this.httpNIOAcceptHandler);
    }

    protected void setRequestHandlerPool() {
        this.httpNIOAcceptHandler.setPoolOptions(true, "HTTP_AND_HTTPS", 0, 30);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSites(Collection siteCollection) {
        ArrayList siteList = new ArrayList(siteCollection);
        Collections.sort(siteList);
        HttpSite[] sites = siteCollection.toArray(new HttpSite[siteCollection.size()]);
        this.sites = sites;
    }

    public synchronized void destroy() {
        this.alive = false;
        this.nioDriver.setAlive(false);
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        InternalDispatcher.removeListener(String.valueOf(this.port));
    }

    public void run() {
        this.nioDriver.run();
    }

    public void internalDispatch(Socket internalSocket) {
        IllegalStateException _ie = new IllegalStateException("THIS CALL SHOULD NOT BE INVOKED");
        m_traceLogger.log(Level.FINEST, "Exception: ", _ie);
        throw _ie;
    }

    public void remove(HttpSite site) {
        for (int i = 0; i < this.sites.length; ++i) {
            if (this.sites[i] != site) continue;
            HttpSite[] newSites = new HttpSite[this.sites.length - 1];
            System.arraycopy(this.sites, 0, newSites, 0, i);
            System.arraycopy(this.sites, i + 1, newSites, i, newSites.length - i);
            this.sites = newSites;
        }
    }

    public void remove(HttpSiteConfig siteConfig) {
        for (int i = 0; this.sites != null && i < this.sites.length; ++i) {
            if (!this.sites[i].getConfig().equals(siteConfig)) continue;
            HttpSite[] newSites = new HttpSite[this.sites.length - 1];
            System.arraycopy(this.sites, 0, newSites, 0, i);
            System.arraycopy(this.sites, i + 1, newSites, i, newSites.length - i);
            this.sites = newSites;
        }
    }

    protected void addFirst(HttpSite site) {
        HttpSite[] newSites = new HttpSite[this.sites == null ? 1 : this.sites.length + 1];
        if (this.sites != null) {
            System.arraycopy(this.sites, 0, newSites, 1, this.sites.length);
        }
        newSites[0] = site;
        this.sites = newSites;
    }

    protected void addLast(HttpSite site) {
        HttpSite[] newSites;
        if (this.sites == null) {
            newSites = new HttpSite[1];
        } else {
            newSites = new HttpSite[this.sites.length + 1];
            System.arraycopy(this.sites, 0, newSites, 0, this.sites.length);
        }
        newSites[newSites.length - 1] = site;
        this.sites = newSites;
    }

    public void add(HttpSite site) {
        if (site.hostNameHeader != null) {
            this.addFirst(site);
        } else if (site.particularAddress != null && this.sites != null && this.sites.length > 0 && this.sites[0].hostNameHeader == null) {
            this.addFirst(site);
        } else {
            this.addLast(site);
        }
    }

    public static void releaseHandler(HttpRequestHandler handler) {
    }

    public int getPort(HttpSiteConfig config) {
        return config.getPort();
    }

    public ServerSocket getSocket() {
        return this.socket;
    }

    public HttpSiteConfig getConfig() {
        return this.config;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public int getPort() {
        return this.config.getPort();
    }

    public String getProtocol() {
        if (this.isSecure()) {
            return OC4JServiceInfo.HTTPS;
        }
        return OC4JServiceInfo.HTTP;
    }

    public class HttpNIOAcceptHandler
    extends ServerSocketAcceptHandler {
        public HttpNIOAcceptHandler(NIOServerSocketDriver nioDriver, InetSocketAddress address, int backlog) {
            super(nioDriver, address, backlog);
            HttpConnectionListener.this.server.getTaskManager().addTask(new AcceptHandlerTask());
        }

        public boolean waitForAlive() {
            try {
                while (HttpConnectionListener.this.alive && (HttpConnectionListener.this.sites == null || HttpConnectionListener.this.sites.length < 1)) {
                    Thread.yield();
                    Thread.sleep(250L);
                }
                if (!HttpConnectionListener.this.alive) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }

        protected ServerSocketReadHandler getReadHandler() {
            HttpRequestHandler handler = new HttpRequestHandler(HttpConnectionListener.this.server);
            return handler;
        }

        HttpConnectionListener getListener() {
            return HttpConnectionListener.this;
        }

        public long getIdleSocketTimeout() {
            return HTTPProperties.getHttpSocketTimeout();
        }

        protected boolean overwriteHandleDelayedAccepted() {
            return true;
        }

        protected void handleDelayedAccepted(OutputStream os) {
            try {
                if (HttpConnectionListener.this.server.maxConnectionsRedirectReply != null) {
                    os.write(HttpConnectionListener.this.server.maxConnectionsRedirectReply);
                } else {
                    HttpNIOAcceptHandler httpNIOAcceptHandler = this;
                    os.write(SERVER_BUSY_MESSAGE);
                }
            }
            catch (Throwable t) {
                m_traceLogger.log(Level.FINEST, "Exception: ", t);
            }
        }

        public class AcceptHandlerTask
        implements Runnable {
            public void run() {
                HttpNIOAcceptHandler.this.housekeeping();
            }
        }
    }
}

