/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.HttpApplication;
import com.evermind.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Date;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class DirectoryRequestDispatcher
implements RequestDispatcher {
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance();
    private File file;
    private HttpApplication application;
    private boolean appRoot;

    public DirectoryRequestDispatcher(File file, HttpApplication application, boolean appRoot) {
        this.file = file;
        this.application = application;
        this.appRoot = appRoot;
    }

    public void include(ServletRequest genericRequest, ServletResponse genericResponse) throws IOException, ServletException {
        String requestURI;
        HttpServletRequest request = (HttpServletRequest)genericRequest;
        HttpServletResponse response = (HttpServletResponse)genericResponse;
        String _charset = "UTF-8";
        response.setContentType("text/html;charset=" + _charset);
        try {
            requestURI = request.getRequestURI();
        }
        catch (ClassCastException e) {
            requestURI = request.getServletPath();
        }
        if (requestURI.endsWith("/WEB-INF/") && requestURI.substring(request.getContextPath().length()).equals("/WEB-INF/")) {
            response.sendError(404);
            return;
        }
        boolean appendDelimeter = !requestURI.endsWith("/");
        boolean isRoot = requestURI.equals("/");
        File[] files = this.file.listFiles();
        StringBuffer buffer = new StringBuffer();
        response.setContentType("text/html");
        buffer.append("<HTML><HEAD><TITLE>Index of ");
        buffer.append(URLDecoder.decode(requestURI, _charset));
        buffer.append("</TITLE></HEAD><BODY>");
        buffer.append("<H1>Index of ");
        buffer.append(URLDecoder.decode(requestURI, _charset));
        buffer.append("</H1>");
        buffer.append("<TABLE COLS=3>");
        requestURI = StringUtils.replace(requestURI, '+', "%20");
        if (!isRoot) {
            String uri = requestURI;
            if (!appendDelimeter) {
                uri = uri.substring(0, uri.length() - 1);
            }
            uri = uri.substring(0, uri.lastIndexOf("/") + 1);
            buffer.append("<TR><TD WIDTH=150><A HREF=\"");
            buffer.append(uri);
            buffer.append("\">..</A></TD><TD WIDTH=100 ALIGN=RIGHT></TD><TD WIDTH=200 ALIGN=RIGHT></TD></TR>");
        }
        for (int i = 0; i < files.length; ++i) {
            if (this.appRoot && files[i].getName().equals("WEB-INF")) continue;
            boolean directory = files[i].isDirectory();
            buffer.append("<TR><TD WIDTH=150><A HREF=\"");
            buffer.append(requestURI);
            if (appendDelimeter) {
                buffer.append('/');
            }
            String filename = URLEncoder.encode(files[i].getName(), _charset);
            buffer.append(StringUtils.replace(filename, '+', "%20"));
            if (directory) {
                buffer.append('/');
            }
            buffer.append("\">");
            buffer.append(files[i].getName());
            buffer.append("</A></TD><TD WIDTH=100 ALIGN=RIGHT>");
            if (!directory) {
                buffer.append((files[i].length() + 999L) / 1000L);
                buffer.append("kB");
            }
            buffer.append("</TD><TD WIDTH=200 ALIGN=RIGHT>");
            buffer.append(dateFormat.format(new Date(files[i].lastModified())));
            buffer.append("</TD></TR>");
        }
        buffer.append("</TABLE></BODY></HTML>");
        PrintWriter out = response.getWriter();
        out.print(buffer.toString());
        out.flush();
    }

    public void forward(ServletRequest genericRequest, ServletResponse genericResponse) throws IOException, ServletException {
        try {
            ((EvermindHttpServletRequest)genericRequest).application = this.application;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (this.application.autoJoinSession) {
            ((HttpServletRequest)genericRequest).getSession(true);
        }
        this.include(genericRequest, genericResponse);
    }
}

