/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class CookieValueCoder {
    public static boolean USE_QUOTES;
    private static String OC4J_ENCODED;
    private static byte[] oc4jEncodedBytes;
    private static String OC4J_CODER_VERSION;
    private static byte[] hexVal;
    private static short[] decodeHexMap;
    private static short NO_ENCODING;
    private static short[][] decodeMap;
    private static short[] firstBytes;
    private static short[] secondBytes;
    private static CookieValueCoder defaultInstance;
    private static String quotedCoderVersion;

    private CookieValueCoder() {
    }

    public static CookieValueCoder defaultInstance() {
        return defaultInstance;
    }

    public int getCoderVersion() {
        return 1;
    }

    public String getQuotedCoderVersion() {
        if (quotedCoderVersion == null) {
            quotedCoderVersion = "\"" + this.getCoderVersion() + "\"";
        }
        return quotedCoderVersion;
    }

    public String decode(String encodedString) {
        if (encodedString == null) {
            return null;
        }
        ByteBuffer decodedBuf = this.decode(ByteBuffer.wrap(encodedString.getBytes()));
        try {
            String decodedString = decodedBuf == null ? null : new String(decodedBuf.array(), 0, decodedBuf.limit(), "US-ASCII");
            return decodedString;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public ByteBuffer decode(ByteBuffer byteBuf) {
        int byteCount = byteBuf.limit();
        byteBuf.flip();
        byte[] bytes = byteBuf.array();
        ByteBuffer resultBuffer = ByteBuffer.allocate(byteCount);
        byte[] resultBytes = resultBuffer.array();
        int j = 0;
        for (int i = 0; i < byteCount; ++i) {
            byte b = bytes[i];
            if (b == 37) {
                short second;
                short first;
                if (i + 1 >= byteCount) {
                    return null;
                }
                if ((first = decodeHexMap[bytes[++i]]) == NO_ENCODING || i + 1 >= byteCount) {
                    return null;
                }
                if ((second = decodeHexMap[bytes[++i]]) == NO_ENCODING) {
                    return null;
                }
                short decodedByte = decodeMap[first][second];
                if (decodedByte == NO_ENCODING) {
                    return null;
                }
                resultBytes[j++] = (byte)decodedByte;
                continue;
            }
            resultBytes[j++] = b;
        }
        resultBuffer.limit(j);
        return resultBuffer;
    }

    public String encode(String decodedString) {
        if (decodedString == null) {
            return null;
        }
        ByteBuffer encodedBuf = this.encode(ByteBuffer.wrap(decodedString.getBytes()));
        try {
            String encodedString = new String(encodedBuf.array(), 0, encodedBuf.limit(), "US-ASCII");
            return encodedString;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public ByteBuffer encode(ByteBuffer byteBuf) {
        int byteCount = byteBuf.limit();
        ByteBuffer resultBuffer = ByteBuffer.allocate(byteCount * 3);
        byte[] resultBytes = resultBuffer.array();
        byteBuf.flip();
        byte[] bytes = byteBuf.array();
        int j = 0;
        for (int i = 0; i < byteCount; ++i) {
            int cb;
            int b = bytes[i];
            int n = cb = b < 0 ? 256 + b : b;
            if (firstBytes[cb] == NO_ENCODING) {
                resultBytes[j++] = b;
                continue;
            }
            resultBytes[j++] = 37;
            resultBytes[j++] = (byte)firstBytes[cb];
            resultBytes[j++] = (byte)secondBytes[cb];
        }
        resultBuffer.limit(j);
        return resultBuffer;
    }

    public boolean isOc4jEncodedName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("A name must be specified");
        }
        if (name.length() <= oc4jEncodedBytes.length) {
            return false;
        }
        byte[] nameBytes = name.getBytes();
        for (int i = 0; i < oc4jEncodedBytes.length; ++i) {
            if (nameBytes[i] == oc4jEncodedBytes[i]) continue;
            return false;
        }
        return true;
    }

    public String originalName(String oc4jName) {
        if (oc4jName == null || oc4jName.length() <= oc4jEncodedBytes.length) {
            throw new IllegalArgumentException("oc4jName must be specified and it must start with " + OC4J_ENCODED);
        }
        return oc4jName.substring(oc4jEncodedBytes.length);
    }

    public String responseRepresentation(String name, String value) {
        return this.responseRepresentation(name, value, !USE_QUOTES);
    }

    public String responseRepresentation(String name, String value, boolean useQuotes) {
        StringBuffer sb = new StringBuffer();
        sb.setLength(0);
        String responseString = this.encode(value);
        if (value == null || responseString.length() == value.length()) {
            sb.append(name).append(useQuotes ? "=\"" : "=");
            if (value != null) {
                sb.append(value);
            }
            if (useQuotes) {
                sb.append("\"");
            }
            responseString = sb.toString();
        } else {
            sb.append(OC4J_ENCODED).append(name).append(useQuotes ? "=\"" : "=").append(responseString);
            sb.append(useQuotes ? "\"; " : "; ").append(OC4J_CODER_VERSION).append(this.getCoderVersion());
            responseString = sb.toString();
        }
        return responseString;
    }

    static {
        int i;
        USE_QUOTES = true;
        OC4J_ENCODED = "$OC4J_ENCODED_";
        oc4jEncodedBytes = OC4J_ENCODED.getBytes();
        OC4J_CODER_VERSION = "$OC4J_CODER_VERSION=";
        hexVal = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        decodeHexMap = new short[256];
        NO_ENCODING = Short.MAX_VALUE;
        decodeMap = new short[16][16];
        firstBytes = new short[256];
        secondBytes = new short[256];
        for (i = 0; i < 256; ++i) {
            CookieValueCoder.decodeHexMap[i] = NO_ENCODING;
        }
        for (i = 0; i < 16; ++i) {
            CookieValueCoder.decodeHexMap[CookieValueCoder.hexVal[i]] = (byte)i;
            for (int j = 0; j < 16; ++j) {
                int asciiValue = 16 * i + j;
                if (asciiValue <= 32 || asciiValue >= 127 || asciiValue == 59 || asciiValue == 44 || asciiValue == 37) {
                    CookieValueCoder.firstBytes[asciiValue] = hexVal[i];
                    CookieValueCoder.secondBytes[asciiValue] = hexVal[j];
                    CookieValueCoder.decodeMap[i][j] = (byte)asciiValue;
                    continue;
                }
                CookieValueCoder.decodeMap[i][j] = NO_ENCODING;
                CookieValueCoder.firstBytes[asciiValue] = CookieValueCoder.secondBytes[asciiValue] = NO_ENCODING;
            }
        }
        defaultInstance = new CookieValueCoder();
    }
}

