/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.ApplicationServerThread;
import com.evermind.server.http.AJPHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.HttpRequestHandler;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AJPTunnelServlet
extends HttpServlet {
    protected static final String CONTENT_LENGTH_HEADER = "Content-Length";
    protected static final String TARGET_ROOT = "targetRoot";
    protected static final String DEBUG_PARAM = "debug";
    protected static final byte[] closeString = "Connection: Close\r\n".getBytes();
    private String host;
    private int port;
    private String root;
    private boolean disableKeepAlive = true;
    protected boolean DEBUG = HTTPProperties.getOracleAjptunnelDebug();
    protected PrintStream DEBUG_OUT = null;

    public void init() {
        try {
            URL url = new URL(this.getInitParameter(TARGET_ROOT));
            this.host = url.getHost();
            this.port = url.getPort();
            if (this.port == -1) {
                this.port = 80;
            }
            this.root = url.getFile();
        }
        catch (MalformedURLException e) {
            this.log("TunnelServlet: targetRoot property not pointing to a valid URL", e);
        }
        this.disableKeepAlive = true;
        boolean bl = this.DEBUG = this.DEBUG || "true".equalsIgnoreCase(this.getInitParameter(DEBUG_PARAM));
        if (this.DEBUG && this.DEBUG_OUT == null) {
            this.DEBUG_OUT = System.out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(HttpServletRequest genericRequest, HttpServletResponse genericResponse) throws IOException {
        OutputStream socketOut;
        Socket socket;
        block11: {
            socket = null;
            InputStream in = null;
            socketOut = null;
            EvermindHttpServletRequest request = this.getThreadRequest();
            EvermindHttpServletResponse response = this.getThreadResponse();
            if (request.defaultRequestURI.endsWith(HttpRequestHandler.FORM_LOGIN_STRING)) {
                ByteString referer = request.getByteHeader(EvermindHttpServletRequest.REFERER_HEADER);
                response.sendRedirect(referer.toString());
                return;
            }
            try {
                socket = new Socket(InetAddress.getByName(this.host), this.port);
                socketOut = socket.getOutputStream();
                BufferedOutputStream bufferOut = null;
                if (this.DEBUG) {
                    bufferOut = new DebugOutputStream(socketOut);
                    this.DEBUG_OUT.println("**** Request ****");
                } else {
                    bufferOut = new BufferedOutputStream(socketOut);
                }
                this.sendRequest(request, bufferOut);
                bufferOut.flush();
                socketOut.flush();
                in = socket.getInputStream();
                ServletOutputStream out = genericResponse.getOutputStream();
                if (this.DEBUG) {
                    this.DEBUG_OUT.println("**** Response ****");
                }
                this.pickOffReturnStatus(genericResponse, in);
                if (!this.addHeaders(genericResponse, in)) {
                    this.setDummyHeaders(genericResponse);
                }
                this.pipeResponseBody(in, (OutputStream)out, response.contentLength);
                Object var11_11 = null;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (in != null) {
                    in.close();
                }
                if (socketOut != null) {
                    socketOut.close();
                    throw throwable;
                } else {
                    if (socket == null) throw throwable;
                    socket.close();
                }
                throw throwable;
            }
            in.close();
        }
        if (socketOut != null) {
            socketOut.close();
            return;
        }
        if (socket == null) return;
        socket.close();
    }

    protected void setDummyHeaders(HttpServletResponse resp) {
        resp.addHeader("Tunnel-Mode", "normal");
        resp.addHeader("Dummy", "normal");
    }

    protected final void sendRequest(EvermindHttpServletRequest request, OutputStream out) throws IOException {
        try {
            int lineLength;
            this.writeRequestLine(request, out);
            this.writeln(out);
            int lineStart = request.headerLineLength;
            int pos = lineStart + 2;
            byte[] input = request.getInput();
            while ((lineLength = ((char)input[lineStart] & 0xFF) + input[lineStart + 1] * 256) != 0) {
                boolean isConnection = this.isConnectionHeader(input, pos, lineLength);
                boolean isKeepAlive = this.isKeepAliveHeader(input, pos, lineLength);
                if (isConnection && this.disableKeepAlive) {
                    out.write(closeString);
                } else if (!isKeepAlive || !this.disableKeepAlive) {
                    out.write(input, pos, lineLength - 2);
                    this.writeln(out);
                }
                pos = (lineStart += lineLength) + 2;
            }
            this.writeln(out);
            if (request.method.equalsIgnoreCase("POST")) {
                AJPTunnelServlet.pipePostData((InputStream)request.getInputStream(), out);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected int readLine(InputStream in, byte[] b, int offset, int length) throws IOException {
        int c;
        if (length <= 0) {
            return 0;
        }
        int count = 0;
        while ((c = in.read()) != -1) {
            b[offset++] = (byte)c;
            if (c != 10 && ++count != length) continue;
        }
        return count > 0 ? count : -1;
    }

    protected void pickOffReturnStatus(HttpServletResponse resp, InputStream in) throws IOException {
        try {
            byte[] t_buf = new byte[1024];
            int read = this.readLine(in, t_buf, 0, t_buf.length);
            if (read > 0) {
                String statusLine = new String(t_buf, 0, read);
                int begin = statusLine.indexOf(32) + 1;
                int end = statusLine.indexOf(32, begin);
                String code = statusLine.substring(begin, end);
                String msg = statusLine.substring(end + 1, statusLine.length() - 2);
                resp.setStatus(Integer.parseInt(code), msg);
                if (this.DEBUG) {
                    this.DEBUG_OUT.print("original status line: '" + statusLine);
                    this.DEBUG_OUT.println("setStatus(" + code + ", " + msg + ")");
                }
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        resp.setStatus(500);
    }

    protected boolean addHeaders(HttpServletResponse resp, InputStream in) throws IOException {
        byte[] buf = new byte[4096];
        int read = 0;
        boolean headersSet = false;
        while ((read = this.readLine(in, buf, 0, buf.length)) > 2) {
            String headerLine = new String(buf, 0, read);
            headersSet = this.addHeader(resp, headerLine) || headersSet;
        }
        if (this.DEBUG) {
            this.writeln(this.DEBUG_OUT);
        }
        return headersSet;
    }

    protected boolean addHeader(HttpServletResponse resp, String headerLine) {
        int div = headerLine.indexOf(58);
        if (div < 0) {
            return false;
        }
        String name = headerLine.substring(0, div).trim();
        String value = headerLine.substring(div + 2, headerLine.length() - 2);
        if (CONTENT_LENGTH_HEADER.equalsIgnoreCase(name)) {
            try {
                resp.setContentLength(Integer.parseInt(value));
            }
            catch (NumberFormatException ex) {
                resp.addHeader(name, value);
            }
        } else {
            resp.addHeader(name, value);
        }
        if (this.DEBUG) {
            this.DEBUG_OUT.print(headerLine);
        }
        return true;
    }

    protected void pipeResponseBody(InputStream in, OutputStream out, int contentLength) throws IOException {
        byte[] buffer = null;
        if (contentLength == 0) {
            return;
        }
        if (contentLength < 0) {
            AJPTunnelServlet.pipeData(in, out, this.DEBUG ? this.DEBUG_OUT : null);
            return;
        }
        buffer = contentLength < 10240 ? new byte[contentLength] : new byte[10240];
        int lengthRead = 0;
        int totalRead = 0;
        while ((lengthRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, lengthRead);
            if (this.DEBUG) {
                this.DEBUG_OUT.write(buffer, 0, lengthRead);
            }
            if (lengthRead > 0 && (totalRead += lengthRead) < contentLength) continue;
            break;
        }
    }

    protected static void pipePostData(InputStream in, OutputStream out) throws IOException {
        AJPTunnelServlet.pipeData(in, out, null);
    }

    protected static void pipeData(InputStream in, OutputStream out, OutputStream debugOut) throws IOException {
        int lengthRead;
        byte[] buffer = new byte[10240];
        while ((lengthRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, lengthRead);
            if (debugOut == null) continue;
            debugOut.write(buffer, 0, lengthRead);
        }
    }

    protected void writeln(OutputStream out) throws IOException {
        out.write(13);
        out.write(10);
    }

    protected int getQueryStringIndex(EvermindHttpServletRequest request) {
        byte[] input = request.getInput();
        if (request instanceof AJPHttpServletRequest && request.queryString != null && request.queryString.length != 0) {
            for (int i = request.headerLineRealLength - 1; i > request.headerStartPos; --i) {
                if (input[request.headerStartPos + i] != 32) continue;
                return i;
            }
        }
        return -1;
    }

    protected void writeRequestLine(EvermindHttpServletRequest request, OutputStream out) throws IOException {
        byte[] input = request.getInput();
        int queryStringIndex = this.getQueryStringIndex(request);
        if (queryStringIndex < 0) {
            out.write(input, request.headerStartPos, request.headerLineRealLength);
        } else {
            out.write(input, request.headerStartPos, queryStringIndex);
            out.write(63);
            out.write(request.queryString.data, request.queryString.offset, request.queryString.length);
            out.write(input, request.headerStartPos + queryStringIndex, request.headerLineRealLength - queryStringIndex);
        }
    }

    protected boolean isConnectionHeader(byte[] input, int pos, int len) {
        if (len < 11) {
            return false;
        }
        return !(input[pos] != 67 && input[pos] != 99 || input[pos + 1] != 79 && input[pos + 1] != 111 || input[pos + 2] != 78 && input[pos + 2] != 110 || input[pos + 3] != 78 && input[pos + 3] != 110 || input[pos + 4] != 69 && input[pos + 4] != 101 || input[pos + 5] != 67 && input[pos + 5] != 99 || input[pos + 6] != 84 && input[pos + 6] != 116 || input[pos + 7] != 73 && input[pos + 7] != 105 || input[pos + 8] != 79 && input[pos + 8] != 111 || input[pos + 9] != 78 && input[pos + 9] != 110 || input[pos + 10] != 32 && input[pos + 10] != 58);
    }

    protected boolean isKeepAliveHeader(byte[] input, int pos, int len) {
        if (len < 11) {
            return false;
        }
        return !(input[pos] != 75 && input[pos] != 107 || input[pos + 1] != 69 && input[pos + 1] != 101 || input[pos + 2] != 69 && input[pos + 2] != 101 || input[pos + 3] != 80 && input[pos + 3] != 112 || input[pos + 4] != 45 && input[pos + 4] != 45 || input[pos + 5] != 65 && input[pos + 5] != 97 || input[pos + 6] != 76 && input[pos + 6] != 108 || input[pos + 7] != 73 && input[pos + 7] != 105 || input[pos + 8] != 86 && input[pos + 8] != 111 || input[pos + 9] != 69 && input[pos + 9] != 101 || input[pos + 10] != 32 && input[pos + 10] != 58);
    }

    protected EvermindHttpServletRequest getThreadRequest() {
        return ((ApplicationServerThread)Thread.currentThread()).httpHandler.request;
    }

    protected EvermindHttpServletResponse getThreadResponse() {
        return ((ApplicationServerThread)Thread.currentThread()).httpHandler.response;
    }

    protected class DebugOutputStream
    extends BufferedOutputStream {
        DebugOutputStream(OutputStream out) {
            super(out);
        }

        public synchronized void write(int i) throws IOException {
            AJPTunnelServlet.this.DEBUG_OUT.write(i);
            super.write(i);
        }

        public synchronized void write(byte[] input, int off, int length) throws IOException {
            AJPTunnelServlet.this.DEBUG_OUT.write(input, off, length);
            super.write(input, off, length);
        }
    }
}

