/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.AJPBodyInputStream;
import com.evermind.server.http.AJPRequestHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;

public class AJPOutputStream
extends OutputStream {
    public static final byte END_REQUEST = 5;
    public static final byte SEND_HEADERS = 4;
    public static final byte SEND_BODY_CHUNK = 3;
    public static final byte GET_BODY_CHUNK = 6;
    private static final int MAX_SEND_SIZE = AJPBodyInputStream.MAX_READ_SIZE;
    private OutputStream ajpOut;
    private byte[] outputBuffer;
    private boolean closed = false;
    private static Logger m_traceLogger = TraceLogger.getLogger(AJPOutputStream.class);

    public AJPOutputStream(OutputStream ajpOut, byte[] outputBuffer) {
        this.ajpOut = ajpOut;
        this.outputBuffer = outputBuffer;
        this.closed = false;
    }

    void setNewState(OutputStream ajpOut) {
        this.ajpOut = ajpOut;
        this.closed = false;
    }

    void setCloseBuffer(boolean flag) {
        this.closed = flag;
    }

    public void write(int i) throws IOException {
        this.write(new byte[]{(byte)i}, 0, 1);
    }

    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        int to_send;
        if (this.closed) {
            return;
        }
        if (AJPRequestHandler.AJP_IO_DEBUG) {
            m_traceLogger.log(Level.FINE, "AJP: AJPOutputStream::write() of " + length);
        }
        for (int sent = 0; sent < length; sent += to_send) {
            to_send = length - sent;
            to_send = to_send > MAX_SEND_SIZE ? MAX_SEND_SIZE : to_send;
            this.writeChunk(data, offset + sent, to_send);
        }
    }

    private void writeChunk(byte[] data, int offset, int length) throws IOException {
        if (AJPRequestHandler.AJP_IO_DEBUG) {
            m_traceLogger.log(Level.FINE, "AJP: AJPOutputStream::writeChunk():  " + length);
        }
        byte[] output = this.outputBuffer;
        output[0] = 65;
        output[1] = 66;
        output[2] = (byte)(length + 3 >> 8);
        output[3] = (byte)(length + 3 & 0xFF);
        output[4] = 3;
        output[5] = (byte)(length >> 8);
        output[6] = (byte)(length & 0xFF);
        this.ajpOut.write(output, 0, 7);
        this.ajpOut.write(data, offset, length);
        this.ajpOut.flush();
    }

    public void flush() throws IOException {
        this.ajpOut.flush();
    }

    public void endRequest() throws IOException {
        if (AJPRequestHandler.AJP_IO_DEBUG) {
            m_traceLogger.log(Level.FINE, "AJP: AJPOutputStream::endRequest()");
        }
        byte[] output = this.outputBuffer;
        output[0] = 65;
        output[1] = 66;
        output[2] = 0;
        output[3] = 2;
        output[4] = 5;
        output[5] = 1;
        this.ajpOut.write(output, 0, 6);
        this.ajpOut.flush();
    }
}

