/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.http.AJPHttpServletRequest;
import com.evermind.server.http.AJPOutputStream;
import com.evermind.server.http.AJPRequestHandler;
import com.evermind.server.http.EvermindHttpServletResponse;
import com.evermind.server.http.HttpApplication;
import com.evermind.server.http.HttpDateFormat;
import com.evermind.server.http.HttpIOException;
import com.evermind.server.http.HttpMessages;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.ServletInstanceInfo;
import com.evermind.util.ArrayUtils;
import com.evermind.util.ByteString;
import com.evermind.util.HTTPProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import oracle.j2ee.util.TraceLogger;

public class AJPHttpServletResponse
extends EvermindHttpServletResponse {
    public static final byte AJP_PREFIX = -96;
    public static final byte AJP_CONTENT_TYPE = 1;
    public static final byte AJP_CONTENT_LANGUAGE = 2;
    public static final byte AJP_CONTENT_LENGTH = 3;
    public static final byte AJP_DATE = 4;
    public static final byte AJP_LAST_MODIFIED = 5;
    public static final byte AJP_LOCATION = 6;
    public static final byte AJP_SET_COOKIE = 7;
    public static final byte AJP_SET_COOKIE2 = 8;
    public static final byte AJP_SERVLET_ENGINE = 9;
    public static final byte AJP_STATUS = 10;
    public static final byte AJP_WWW_AUTHENTICATE = 11;
    AJPHttpServletRequest ajpRequest;
    OutputStream socketOut;
    AJPOutputStream ajpOut;
    private static Logger m_traceLogger = TraceLogger.getLogger(AJPHttpServletResponse.class);

    protected String getSessionId() {
        if (this.request.jvmRoute == null) {
            return super.getSessionId();
        }
        return super.getSessionId() + "." + this.request.jvmRoute;
    }

    void commit() throws HttpIOException {
        HttpApplication application = this.request.application;
        try {
            Object handler;
            boolean hasBody;
            boolean bl = hasBody = this.request.method != "HEAD" && this.status != 204 && (this.status < 100 || this.status >= 200);
            if (this.isLoginOrErrorPage) {
                this.lastModifiedHeader = null;
                this.setHeader("Last-Modified", null);
            }
            if (this.committed) {
                if (this.out.out == null) {
                    throw new RuntimeException("Internal Server Error, out was null");
                }
                return;
            }
            if (this.request.isDispatcherChainEmpty()) {
                this.out.checkSetContentLength();
            }
            this.committed = true;
            byte[] buffer = this.getResponseHeaderBuffer();
            int bufferPos = 0;
            if (!(application == null || application.chainingHandlers == null || this.status != 0 && this.status != 200 || this.contentType == null || this.request.method == "HEAD" || this.status == 204 || this.status >= 100 && this.status < 200 || (handler = application.chainingHandlers.get(this.contentType)) == null)) {
                ServletInstanceInfo info;
                if (handler instanceof ByteString) {
                    try {
                        info = application.findServlet((ByteString)handler);
                    }
                    catch (ServletException e) {
                        info = null;
                    }
                } else {
                    info = (ServletInstanceInfo)handler;
                }
                if (info != null && (info.invalidated || info.autoReload && info.file != null && (info.file.lastModified() > info.binaryLastModified || info.sourceFile != null && info.sourceFile.lastModified() > info.sourceLastModified))) {
                    application.flushServlet(info.name, true);
                    handler = info.name;
                    info = null;
                }
                if (info == null) {
                    try {
                        info = application.findServlet((ByteString)handler);
                    }
                    catch (ServletException e) {
                        // empty catch block
                    }
                    if (info != null) {
                        application.chainingHandlers.put(this.contentType, info);
                    }
                }
                if (info == null) {
                    this.sendError(500, "Failed to initialize chaining servlet for contenttype " + this.contentType + " (" + handler + ")");
                    if (this.out.contentLength == 0) {
                        this.out.contentLength = -1;
                    }
                } else if (!(this.request.in instanceof ByteArrayInputStream) || this.contentType == null || !this.contentType.equals(this.request.contentType)) {
                    this.chainingHandler = info;
                    if (this.contentLength >= 0) {
                        this.out.contentLength = this.contentLength;
                        this.out.out = new ByteArrayOutputStream(this.contentLength);
                    } else {
                        this.out.out = new ByteArrayOutputStream();
                        this.out.contentLength = -1;
                    }
                    return;
                }
            }
            if (application != null && application.requestTracker != null) {
                this.handleRequestTrackers(application);
            }
            buffer[0] = 65;
            buffer[1] = 66;
            buffer[4] = 4;
            if (this.status == 0) {
                buffer[5] = 0;
                buffer[6] = -56;
                buffer[7] = 0;
                buffer[8] = 2;
                buffer[9] = 79;
                buffer[10] = 75;
                buffer[11] = 0;
                bufferPos = 12;
            } else if (this.status == 304) {
                buffer[5] = 1;
                buffer[6] = 48;
                buffer[7] = 0;
                buffer[8] = 12;
                buffer[9] = 78;
                buffer[10] = 111;
                buffer[11] = 116;
                buffer[12] = 32;
                buffer[13] = 77;
                buffer[14] = 111;
                buffer[15] = 100;
                buffer[16] = 105;
                buffer[17] = 102;
                buffer[18] = 105;
                buffer[19] = 101;
                buffer[20] = 100;
                buffer[21] = 0;
                bufferPos = 22;
                hasBody = false;
            } else {
                buffer[5] = (byte)(this.status >> 8);
                buffer[6] = (byte)this.status;
                bufferPos = 7;
                String statusMessage = this.getStatusMessage();
                if (statusMessage != null) {
                    bufferPos = this.writeAJPString(buffer, bufferPos, statusMessage);
                } else {
                    byte[] statusMessageBA = HttpServer.getStatusCodeDescriptionByteArray(this.status, null);
                    if (statusMessageBA != null) {
                        bufferPos = this.writeAJPString(buffer, bufferPos, statusMessageBA, 0, statusMessageBA.length);
                    } else {
                        buffer[7] = 0;
                        buffer[8] = 0;
                        buffer[9] = 0;
                        bufferPos = 10;
                    }
                }
            }
            try {
                if (!hasBody) {
                    this.out.contentLength = -2;
                    this.out.out = this.basicOut;
                } else if (!(this.contentLength >= 0 && this.contentLength <= 50000 || this.status == 206 || this.request.getVersion() < 11 || this.containsHeader("Transfer-Encoding"))) {
                    this.out.out = this.basicOut;
                    this.out.contentLength = -1;
                } else {
                    this.out.out = this.basicOut;
                    this.out.contentLength = this.contentLength;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.out.out = this.basicOut;
                this.out.contentLength = this.contentLength;
            }
            int headerCountPos = bufferPos;
            int totalHeaderCount = 0;
            bufferPos += 2;
            byte[] statusMessageArray = HttpDateFormat.ajpDateHeader;
            buffer[bufferPos++] = -96;
            buffer[bufferPos++] = 4;
            bufferPos = this.writeAJPString(buffer, bufferPos, statusMessageArray, 0, statusMessageArray.length - 2);
            ++totalHeaderCount;
            if (this.contentLocation != null) {
                ByteString contentLocation = this.contentLocation;
                int contentLocationLength = contentLocation.length;
                if (contentLocationLength < 400) {
                    buffer[bufferPos++] = 0;
                    buffer[bufferPos++] = 16;
                    buffer[bufferPos++] = 67;
                    buffer[bufferPos++] = 111;
                    buffer[bufferPos++] = 110;
                    buffer[bufferPos++] = 116;
                    buffer[bufferPos++] = 101;
                    buffer[bufferPos++] = 110;
                    buffer[bufferPos++] = 116;
                    buffer[bufferPos++] = 45;
                    buffer[bufferPos++] = 76;
                    buffer[bufferPos++] = 111;
                    buffer[bufferPos++] = 99;
                    buffer[bufferPos++] = 97;
                    buffer[bufferPos++] = 116;
                    buffer[bufferPos++] = 105;
                    buffer[bufferPos++] = 111;
                    buffer[bufferPos++] = 110;
                    buffer[bufferPos++] = 0;
                    int startPos = bufferPos += 2;
                    buffer[bufferPos++] = 104;
                    buffer[bufferPos++] = 116;
                    buffer[bufferPos++] = 116;
                    buffer[bufferPos++] = 112;
                    if (this.request.isSecure()) {
                        buffer[bufferPos++] = 115;
                    }
                    buffer[bufferPos++] = 58;
                    buffer[bufferPos++] = 47;
                    buffer[bufferPos++] = 47;
                    ByteString hostHeader = this.request.getHostnameHeader();
                    if (hostHeader == null) {
                        hostHeader = this.request.site.host;
                    }
                    System.arraycopy(hostHeader.data, hostHeader.offset, buffer, bufferPos, hostHeader.length);
                    bufferPos += hostHeader.length;
                    if (this.request.isSecure() ? this.ajpRequest.port != 443 : this.ajpRequest.port != 80) {
                        buffer[bufferPos++] = 58;
                        int contentLocationPort = this.request.site.getConfig().getPosingAsPort();
                        if (contentLocationPort < 0) {
                            contentLocationPort = this.ajpRequest.port;
                        }
                        bufferPos = ArrayUtils.writeInt(buffer, bufferPos, contentLocationPort);
                    }
                    if (application.root != null) {
                        System.arraycopy(application.root.data, application.root.offset, buffer, bufferPos, application.root.length);
                        bufferPos += application.root.length;
                    }
                    System.arraycopy(contentLocation.data, contentLocation.offset, buffer, bufferPos, contentLocationLength);
                    buffer[startPos - 2] = (byte)((bufferPos += contentLocationLength) - startPos >> 8);
                    buffer[startPos - 1] = (byte)(bufferPos - startPos & 0xFF);
                    buffer[bufferPos++] = 0;
                    ++totalHeaderCount;
                }
            }
            if (this.lastModifiedHeader != null) {
                buffer[bufferPos++] = -96;
                buffer[bufferPos++] = 5;
                bufferPos = this.writeAJPString(buffer, bufferPos, this.lastModifiedHeader, 15, this.lastModifiedHeader.length - 15);
                buffer[bufferPos++] = 0;
                buffer[bufferPos++] = 13;
                buffer[bufferPos++] = 65;
                buffer[bufferPos++] = 99;
                buffer[bufferPos++] = 99;
                buffer[bufferPos++] = 101;
                buffer[bufferPos++] = 112;
                buffer[bufferPos++] = 116;
                buffer[bufferPos++] = 45;
                buffer[bufferPos++] = 82;
                buffer[bufferPos++] = 97;
                buffer[bufferPos++] = 110;
                buffer[bufferPos++] = 103;
                buffer[bufferPos++] = 101;
                buffer[bufferPos++] = 115;
                buffer[bufferPos++] = 0;
                buffer[bufferPos++] = 0;
                buffer[bufferPos++] = 5;
                buffer[bufferPos++] = 98;
                buffer[bufferPos++] = 121;
                buffer[bufferPos++] = 116;
                buffer[bufferPos++] = 101;
                buffer[bufferPos++] = 115;
                buffer[bufferPos++] = 0;
                totalHeaderCount += 2;
            }
            if (this.expiresHeader != null) {
                buffer[bufferPos++] = 0;
                buffer[bufferPos++] = 7;
                buffer[bufferPos++] = 69;
                buffer[bufferPos++] = 120;
                buffer[bufferPos++] = 112;
                buffer[bufferPos++] = 105;
                buffer[bufferPos++] = 114;
                buffer[bufferPos++] = 101;
                buffer[bufferPos++] = 115;
                buffer[bufferPos++] = 0;
                bufferPos = this.writeAJPString(buffer, bufferPos, this.expiresHeader, 9, this.expiresHeader.length - 9);
                ++totalHeaderCount;
            }
            if (this.eTagHeader != null) {
                buffer[bufferPos++] = 0;
                buffer[bufferPos++] = 4;
                buffer[bufferPos++] = 69;
                buffer[bufferPos++] = 84;
                buffer[bufferPos++] = 97;
                buffer[bufferPos++] = 103;
                buffer[bufferPos++] = 0;
                bufferPos = this.writeAJPString(buffer, bufferPos, this.eTagHeader, 6, this.eTagHeader.length - 6);
                ++totalHeaderCount;
            }
            if (this.contentType == null && application.getConfig().isExplicitDefaultContentType()) {
                this.contentType = application.defaultContentType;
            }
            if (this.contentTypeHeader != null || this.contentType != null) {
                buffer[bufferPos++] = -96;
                buffer[bufferPos++] = 1;
                ++totalHeaderCount;
                bufferPos = this.contentTypeHeader != null ? this.writeAJPString(buffer, bufferPos, this.contentTypeHeader) : this.writeAJPString(buffer, bufferPos, this.contentType);
            }
            if (this.contentLength >= 0) {
                buffer[bufferPos++] = -96;
                buffer[bufferPos++] = 3;
                ++totalHeaderCount;
                bufferPos = this.writeAJPString(buffer, bufferPos, String.valueOf(this.contentLength));
            }
            if (this.sessionCookieValue != null) {
                buffer[bufferPos++] = -96;
                buffer[bufferPos++] = 7;
                boolean isSecureCookie = this.request.isSecure() && !this.request.isApplicationShared() || application.getConfig().getSessionCookieIsSecure();
                byte[] sessionCookieSuffix = application.getSessionCookieSuffix();
                int length = this.sessionCookiePrefix.length - 12 + this.sessionCookieValue.length + sessionCookieSuffix.length + (this.request.jvmRoute == null ? 0 : this.request.jvmRoute.length() + 1) + (isSecureCookie ? HttpApplication.SECURE_COOKIE_ATTRIBUTE.length : 0);
                buffer[bufferPos++] = (byte)(length >> 8);
                buffer[bufferPos++] = (byte)(length & 0xFF);
                System.arraycopy(this.sessionCookiePrefix, 12, buffer, bufferPos, this.sessionCookiePrefix.length - 12);
                System.arraycopy(this.sessionCookieValue, 0, buffer, bufferPos += this.sessionCookiePrefix.length - 12, this.sessionCookieValue.length);
                bufferPos += this.sessionCookieValue.length;
                if (this.request.jvmRoute != null) {
                    buffer[bufferPos++] = 46;
                    byte[] jvmRouteIdBytes = this.request.jvmRoute.getBytes();
                    System.arraycopy(jvmRouteIdBytes, 0, buffer, bufferPos, jvmRouteIdBytes.length);
                    bufferPos += jvmRouteIdBytes.length;
                }
                System.arraycopy(sessionCookieSuffix, 0, buffer, bufferPos, sessionCookieSuffix.length);
                bufferPos += sessionCookieSuffix.length;
                if (isSecureCookie) {
                    System.arraycopy(HttpApplication.SECURE_COOKIE_ATTRIBUTE, 0, buffer, bufferPos, HttpApplication.SECURE_COOKIE_ATTRIBUTE.length);
                    bufferPos += HttpApplication.SECURE_COOKIE_ATTRIBUTE.length;
                }
                buffer[bufferPos++] = 0;
                ++totalHeaderCount;
            }
            if (this.getCookies() != null) {
                Cookie[] cookies = this.getCookies();
                totalHeaderCount += cookies.length;
                StringBuffer cookieBuffer = new StringBuffer(128);
                for (int i = 0; i < cookies.length; ++i) {
                    Cookie cookie = cookies[i];
                    buffer[bufferPos++] = -96;
                    buffer[bufferPos++] = 7;
                    this.writeCookieValue(cookieBuffer, cookie);
                    int _length = cookieBuffer.length();
                    buffer[bufferPos++] = (byte)(_length >> 8);
                    buffer[bufferPos++] = (byte)(_length & 0xFF);
                    for (int x = 0; x < _length; ++x) {
                        buffer[bufferPos++] = (byte)cookieBuffer.charAt(x);
                    }
                    buffer[bufferPos++] = 0;
                    cookieBuffer.setLength(0);
                }
            }
            if ((this.getHeaderCount() == 0 || !this.containsHeader("Cache-Control")) && HTTPProperties.getCacheControlAttribute()) {
                buffer[bufferPos++] = 0;
                buffer[bufferPos++] = 13;
                buffer[bufferPos++] = 67;
                buffer[bufferPos++] = 97;
                buffer[bufferPos++] = 99;
                buffer[bufferPos++] = 104;
                buffer[bufferPos++] = 101;
                buffer[bufferPos++] = 45;
                buffer[bufferPos++] = 67;
                buffer[bufferPos++] = 111;
                buffer[bufferPos++] = 110;
                buffer[bufferPos++] = 116;
                buffer[bufferPos++] = 114;
                buffer[bufferPos++] = 111;
                buffer[bufferPos++] = 108;
                buffer[bufferPos++] = 0;
                buffer[bufferPos++] = 0;
                buffer[bufferPos++] = 7;
                buffer[bufferPos++] = 112;
                buffer[bufferPos++] = 114;
                buffer[bufferPos++] = 105;
                buffer[bufferPos++] = 118;
                buffer[bufferPos++] = 97;
                buffer[bufferPos++] = 116;
                buffer[bufferPos++] = 101;
                buffer[bufferPos++] = 0;
                ++totalHeaderCount;
            }
            if (this.getHeaderCount() > 0) {
                bufferPos = this.writeUserDefinedHeaders(this.getHeaders(), buffer, bufferPos);
                totalHeaderCount += this.getWrittenHeaderCount(this.getHeaders());
            }
            buffer[2] = (byte)(bufferPos - 4 >> 8);
            buffer[3] = (byte)(bufferPos - 4);
            buffer[headerCountPos] = (byte)(totalHeaderCount >> 8);
            buffer[headerCountPos + 1] = (byte)totalHeaderCount;
            if (AJPRequestHandler.AJP_DEBUG && m_traceLogger.isLoggable(Level.FINE)) {
                StringBuffer buf = new StringBuffer();
                buf.append("*********** RESPONSE *****************\n");
                for (int i = 0; i < bufferPos; ++i) {
                    if (Character.isLetterOrDigit((char)buffer[i])) {
                        buf.append((char)buffer[i]);
                        continue;
                    }
                    buf.append(".");
                }
                buf.append("\n");
                buf.append("Response header length: " + bufferPos);
                buf.append("\nTotal no. of headers: " + totalHeaderCount + "\n");
                if (this.sessionCookieValue != null) {
                    buf.append("Sending Session Cookie: " + this.sessionCookieValue);
                }
                buf.append("\n*********** RESPONSE DONE ************\n");
                m_traceLogger.log(Level.FINE, buf.toString());
            }
            this.socketOut.write(buffer, 0, bufferPos);
        }
        catch (IOException e) {
            this.committed = false;
            throw new HttpIOException(e.getMessage());
        }
        catch (Throwable t2) {
            ArrayIndexOutOfBoundsException t2;
            if (t2 instanceof ArrayIndexOutOfBoundsException) {
                t2 = new ArrayIndexOutOfBoundsException("Exceeded response header buffer size: " + t2.getMessage());
            }
            HttpMessages.internalErrorWhileCommitting(t2);
            throw (RuntimeException)t2;
        }
    }

    protected int writeAJPString(byte[] buffer, int bufferPos, ByteString value) throws IOException {
        return this.writeAJPString(buffer, bufferPos, value.data, value.offset, value.length);
    }

    protected int writeAJPString(byte[] buffer, int bufferPos, byte[] data, int offset, int length) throws IOException {
        if (bufferPos + length + 3 >= buffer.length) {
            m_traceLogger.log(Level.FINEST, "Error: Max response header buffer size exceeded " + buffer.length);
            throw new IOException("Max response header buffer size exceeded");
        }
        buffer[bufferPos] = (byte)(length >> 8);
        buffer[bufferPos + 1] = (byte)(length & 0xFF);
        System.arraycopy(data, offset, buffer, bufferPos + 2, length);
        buffer[(bufferPos += length + 3) - 1] = 0;
        return bufferPos;
    }

    protected int writeAJPString(byte[] buffer, int bufferPos, String string) throws IOException {
        int length = string.length();
        if (bufferPos + length + 3 >= buffer.length) {
            m_traceLogger.log(Level.FINEST, "Error: Max response header buffer size exceeded " + buffer.length);
            throw new IOException("Max response header buffer size exceeded");
        }
        buffer[bufferPos] = (byte)(length >> 8);
        buffer[bufferPos + 1] = (byte)(length & 0xFF);
        bufferPos += 2;
        for (int i = 0; i < length; ++i) {
            buffer[bufferPos++] = (byte)string.charAt(i);
        }
        buffer[bufferPos++] = 0;
        return bufferPos;
    }

    private int getWrittenHeaderCount(String[] headers) {
        int headerCount = this.getHeaderCount();
        int writtenHeaders = 0;
        for (int i = 0; i < headerCount; ++i) {
            if (headers[i * 2 + 1] == null) continue;
            ++writtenHeaders;
        }
        return writtenHeaders;
    }

    private int writeUserDefinedHeaders(String[] headers, byte[] buffer, int bufferPos) throws IOException {
        int headerCount = this.getHeaderCount();
        for (int i = 0; i < headerCount; ++i) {
            if (headers[i * 2 + 1] == null) continue;
            String key = headers[i * 2];
            String value = headers[i * 2 + 1];
            bufferPos = this.writeAJPString(buffer, bufferPos, key);
            bufferPos = this.writeAJPString(buffer, bufferPos, value);
        }
        return bufferPos;
    }

    void setCloseBuffer(boolean flag) {
        this.ajpOut.setCloseBuffer(flag);
    }
}

