/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.server.OC4JServiceInfo;
import com.evermind.server.http.AJPRequestHandler;
import com.evermind.server.http.HttpConnectionListener;
import com.evermind.server.http.HttpServer;
import com.evermind.server.http.HttpSite;
import com.evermind.server.http.HttpSiteConfig;
import com.evermind.util.HTTPProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import oracle.oc4j.network.NIOServerSocketDriver;
import oracle.oc4j.network.ServerSocketAcceptHandler;
import oracle.oc4j.network.ServerSocketReadHandler;

public class AJPConnectionListener
extends HttpConnectionListener {
    public AJPConnectionListener(HttpServer server, InetAddress address, HttpSiteConfig config) throws IOException, InstantiationException {
        super(server, address, config);
        HTTPProperties.setAjpConnectionListenerState("up");
    }

    protected ServerSocketAcceptHandler getAcceptHandler(NIOServerSocketDriver _nioDriver, SocketAddress _endpoint, int backlog) {
        return new AJPNIOAcceptHandler(_nioDriver, (InetSocketAddress)_endpoint, backlog);
    }

    protected void setRequestHandlerPool() {
        this.httpNIOAcceptHandler.setPoolOptions(false, "AJP", -1, 30);
    }

    public void add(HttpSite site) {
        if (site == null) {
            return;
        }
        if (this.sites != null) {
            for (int i = 0; i < this.sites.length; ++i) {
                if (!site.equalsAjp(this.sites[i])) continue;
                this.sites[i] = site;
                return;
            }
        }
        super.add(site);
    }

    public String getProtocol() {
        if (this.isSecure()) {
            return OC4JServiceInfo.AJPS;
        }
        return OC4JServiceInfo.AJP;
    }

    public class AJPNIOAcceptHandler
    extends HttpConnectionListener.HttpNIOAcceptHandler {
        public AJPNIOAcceptHandler(NIOServerSocketDriver nioDriver, InetSocketAddress address, int i) {
            super(AJPConnectionListener.this, nioDriver, address, i);
        }

        protected ServerSocketReadHandler getReadHandler() {
            AJPRequestHandler _readHandler = new AJPRequestHandler(AJPConnectionListener.this.server);
            _readHandler.site = AJPConnectionListener.this.sites;
            return _readHandler;
        }

        public long getIdleSocketTimeout() {
            return HTTPProperties.getAjpSoTimeout();
        }
    }
}

