/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.http;

import com.evermind.io.IOUtils;
import com.evermind.server.http.AJPRequestHandler;
import com.evermind.server.http.EvermindHttpServletRequest;
import com.evermind.util.HTTPProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;

class AJPBodyInputStream
extends InputStream {
    private static final int HDR_SIZE = 4;
    private static final int LEN_SIZE = 2;
    static final int MAX_READ_SIZE = HTTPProperties.getAjpPacketSize() - 4 - 2;
    private InputStream ajpIn;
    private OutputStream ajpOut;
    private EvermindHttpServletRequest request;
    private int blen = 0;
    private int pos = 0;
    private byte[] bodyBuff = null;
    private boolean firstBuffer = true;
    private static Logger m_traceLogger = TraceLogger.getLogger(AJPBodyInputStream.class);
    private static byte[] bytesGetBodyChunk;

    AJPBodyInputStream(EvermindHttpServletRequest req, InputStream ajpIn, OutputStream ajpOut, byte[] buffer) {
        if (AJPRequestHandler.AJP_IO_DEBUG) {
            m_traceLogger.log(Level.FINEST, "AJPBodyInputStream constructor");
        }
        this.ajpIn = ajpIn;
        this.ajpOut = ajpOut;
        this.request = req;
        this.bodyBuff = buffer;
        this.resetState();
    }

    void resetState() {
        if (AJPRequestHandler.AJP_IO_DEBUG) {
            m_traceLogger.log(Level.FINEST, "AJPBodyInputStream.resetState()");
        }
        this.pos = 0;
        this.blen = 0;
        this.firstBuffer = true;
    }

    void setNewState(EvermindHttpServletRequest req, InputStream ajpIn, OutputStream ajpOut) {
        if (AJPRequestHandler.AJP_IO_DEBUG) {
            m_traceLogger.log(Level.FINEST, "AJPBodyInputStream.setNewState(req, ajpIn, ajpOut)");
        }
        this.ajpIn = ajpIn;
        this.ajpOut = ajpOut;
        this.request = req;
        this.resetState();
    }

    public int read() throws IOException {
        if (AJPRequestHandler.AJP_IO_DEBUG) {
            m_traceLogger.log(Level.FINEST, "AJP: read() ... blen:" + this.blen + "  Pos: " + this.pos);
        }
        if (this.blen <= 0 || this.pos >= this.blen) {
            this.refillReadBuffer();
        }
        return this.bodyBuff[this.pos++];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] data, int off, int len) throws IOException {
        int refillLen;
        if (len == 0) {
            return 0;
        }
        if (AJPRequestHandler.AJP_IO_DEBUG) {
            m_traceLogger.log(Level.FINEST, "AJP: READ(data[]   blen:" + this.blen + "  Pos: " + this.pos);
        }
        if (this.blen <= 0 && (refillLen = this.refillReadBuffer()) <= 0) {
            if (AJPRequestHandler.AJP_IO_DEBUG) {
                m_traceLogger.log(Level.FINE, "AJP: refillReadBuffer return " + refillLen);
            }
            return -1;
        }
        int avail = this.blen - this.pos;
        int initialOff = off;
        while (avail < len) {
            if (AJPRequestHandler.AJP_IO_DEBUG) {
                m_traceLogger.log(Level.FINEST, "AJP: Has " + avail + " bytes in the buffer");
            }
            System.arraycopy(this.bodyBuff, this.pos, data, off, avail);
            refillLen = this.refillReadBuffer();
            if (refillLen <= 0) {
                this.pos += avail;
                len = off - initialOff + avail;
                if (AJPRequestHandler.AJP_IO_DEBUG) {
                    m_traceLogger.log(Level.FINE, "AJP: refillReadBuffer return " + refillLen + " and read return " + len);
                }
                return len != 0 ? len : -1;
            }
            off += avail;
            len -= avail;
            avail = this.blen - this.pos;
        }
        System.arraycopy(this.bodyBuff, this.pos, data, off, len);
        this.pos += len;
        return off - initialOff + len;
    }

    private int refillReadBuffer() throws IOException {
        if (AJPRequestHandler.AJP_IO_DEBUG) {
            m_traceLogger.log(Level.FINEST, "AJP: RefillReadBuffer ... blen:" + this.blen + "  Pos: " + this.pos);
        }
        if (!this.firstBuffer) {
            this.ajpOut.write(bytesGetBodyChunk);
            this.ajpOut.flush();
        } else {
            this.firstBuffer = false;
        }
        int rd = this.ajpIn.read(this.bodyBuff, 0, 4);
        if (rd <= 0) {
            return rd;
        }
        rd = this.ajpIn.read(this.bodyBuff, 0, 2);
        if (rd <= 0) {
            return rd;
        }
        int length = ((this.bodyBuff[0] & 0xFF) << 8) + (this.bodyBuff[1] & 0xFF);
        if (length > MAX_READ_SIZE) {
            m_traceLogger.log(Level.FINEST, "AJP: Assert failed. Buffer too small..");
            throw new IOException("AJP: Buffer too small ...");
        }
        IOUtils.readFully(this.ajpIn, this.bodyBuff, 0, length);
        if (AJPRequestHandler.AJP_IO_DEBUG) {
            m_traceLogger.log(Level.FINEST, "AJP: Body Length: " + length + " Body is :");
            m_traceLogger.log(Level.FINEST, new String(this.bodyBuff, 0, length));
        }
        this.blen = length;
        this.pos = 0;
        return length;
    }

    static {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(65);
            baos.write(66);
            baos.write(0);
            baos.write(3);
            baos.write(6);
            baos.write(MAX_READ_SIZE >> 8);
            baos.write(MAX_READ_SIZE & 0xFF);
            baos.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        bytesGetBodyChunk = baos.toByteArray();
    }
}

