/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.proxy;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.LocalStatelessSessionEJBObject;
import com.evermind.server.ejb.RemoteStatelessSessionEJBObject;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.proxy.ProxyGenerator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Type;

public class StatelessProxyGenerator
extends ProxyGenerator {
    private SessionBeanDescriptor sd;

    public StatelessProxyGenerator(SessionBeanDescriptor sd, boolean local) {
        Class clazz = local ? LocalStatelessSessionEJBObject.class : RemoteStatelessSessionEJBObject.class;
        super(clazz, local ? sd.getLocalInterface() : sd.getRemoteInterface());
        this.sd = sd;
        this.setRemote(!local);
        this.setCopyByValue(sd.isCopyByValue());
        if (this.isRemote() && sd.getGenerateIIOP()) {
            this.setCorba(true);
        }
        if (!local && sd.getServiceEndpoint() != null && sd.getServiceEndpoint() != sd.getRemoteInterface()) {
            this.getProxyInterfaces().add(sd.getServiceEndpoint());
        }
    }

    protected String generateProxyClassName() {
        return EJBUtils.getProxyName(this.sd, this.isRemote(), this.isHome());
    }

    protected void afterGenerateMethods(ClassVisitor cw) {
        this.generateStaticInitializer(cw);
        this.generateCreateBean(cw);
    }

    private void generateStaticInitializer(ClassVisitor cw) {
        cw.visitField(24, "serialVersionUID", "J", null, null);
        CodeVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitLdcInsn((Object)this.getProxyClassName());
        mv.visitMethodInsn(184, "com/evermind/server/ApplicationServer", "computeSerialVersionUID", "(Ljava/lang/String;)J");
        mv.visitFieldInsn(179, this.getProxyClassName(), "serialVersionUID", "J");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    protected void generateConstructor(ClassVisitor cw) {
        super.generateConstructor(cw);
        CodeVisitor mv = cw.visitMethod(1, "<init>", "(Lcom/evermind/server/ejb/StatelessSessionEJBHome;)V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName((Class)this.getParentClass()), "<init>", "(Lcom/evermind/server/ejb/StatelessSessionEJBHome;)V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
    }

    private void generateCreateBean(ClassVisitor cw) {
        String classDesc = Type.getInternalName((Class)this.sd.getEJBClass());
        CodeVisitor mv = cw.visitMethod(1, "OC4J_createBeanInstance", "()Ljava/lang/Object;", new String[]{"java/lang/Exception"}, null);
        mv.visitTypeInsn(187, classDesc);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, classDesc, "<init>", "()V");
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
    }
}

