/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.persistence;

import com.evermind.server.Application;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.logging.PersistenceMessages;
import com.evermind.server.ejb.persistence.EARPersistenceModule;
import com.evermind.server.ejb.persistence.EJBPersistenceModule;
import com.evermind.server.ejb.persistence.PersistenceModule;
import com.evermind.server.ejb.persistence.PersistenceUnitManager;
import com.evermind.server.ejb.persistence.WARPersistenceModule;
import com.evermind.server.http.HttpApplication;
import com.evermind.util.EJBProperties;
import java.lang.reflect.Constructor;

public class PersistenceUnitManagerFactory {
    private static final String PERSISTENCE_UNIT_MGR_CLASS = "com.evermind.server.ejb.persistence.PersistenceUnitManagerImpl";
    private static Constructor persistenceUnitMgrConstructor;
    private static boolean isTopLinkPreviewPersistence;

    public static PersistenceUnitManager createPersistenceUnitManager(EJBPackageDeployment deployment) {
        if (!PersistenceUnitManagerFactory.checkRequirements()) {
            return null;
        }
        if (deployment.getContainer() != null && deployment.getContainer().getApplication() != null) {
            return PersistenceUnitManagerFactory.createPersistenceUnitManager(new EJBPersistenceModule(deployment), deployment.getContainer().getApplication().getPersistenceUnitManager());
        }
        return PersistenceUnitManagerFactory.createPersistenceUnitManager(new EJBPersistenceModule(deployment), null);
    }

    public static PersistenceUnitManager createPersistenceUnitManager(HttpApplication deployment) {
        if (!PersistenceUnitManagerFactory.checkRequirements()) {
            return null;
        }
        if (deployment.getApplication() != null) {
            return PersistenceUnitManagerFactory.createPersistenceUnitManager(new WARPersistenceModule(deployment), deployment.getApplication().getPersistenceUnitManager());
        }
        return PersistenceUnitManagerFactory.createPersistenceUnitManager(new WARPersistenceModule(deployment), null);
    }

    public static PersistenceUnitManager createPersistenceUnitManager(Application deployment) {
        if (!PersistenceUnitManagerFactory.checkRequirements()) {
            return null;
        }
        return PersistenceUnitManagerFactory.createPersistenceUnitManager(new EARPersistenceModule(deployment), null);
    }

    private static PersistenceUnitManager createPersistenceUnitManager(PersistenceModule module, PersistenceUnitManager parent) {
        try {
            return (PersistenceUnitManager)PersistenceUnitManagerFactory.getPersistenceUnitManagerConstructor().newInstance(module, parent);
        }
        catch (Exception e) {
            throw (DeploymentException)new DeploymentException("An Exception occurred initializing  the PersistenceUnitManager").initCause(e);
        }
    }

    private static Constructor getPersistenceUnitManagerConstructor() throws ClassNotFoundException {
        if (persistenceUnitMgrConstructor == null) {
            persistenceUnitMgrConstructor = Class.forName(PERSISTENCE_UNIT_MGR_CLASS).getConstructors()[0];
        }
        return persistenceUnitMgrConstructor;
    }

    private static boolean checkRequirements() {
        return EJBUtils.isJdk50() && !isTopLinkPreviewPersistence;
    }

    static {
        isTopLinkPreviewPersistence = false;
        if ("toplink".equals(EJBProperties.getDefaultPersistenceProvider())) {
            PersistenceMessages.infoUsingTopLinkPreviewPersistenceProvider();
            isTopLinkPreviewPersistence = true;
        }
    }
}

