/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.persistence;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityManagerProxy
implements EntityManager {
    private Map properties;

    public AbstractEntityManagerProxy(Map properties) {
        this.properties = properties;
    }

    public Map getProperties() {
        return this.properties;
    }

    protected abstract EntityManager allocateEntityManager();

    protected abstract void releaseEntityManager(EntityManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object arg0) {
        EntityManager em = this.allocateEntityManager();
        try {
            em.persist(arg0);
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T arg0) {
        EntityManager em = this.allocateEntityManager();
        try {
            Object object = em.merge(arg0);
            return (T)object;
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object arg0) {
        EntityManager em = this.allocateEntityManager();
        try {
            em.remove(arg0);
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> arg0, Object arg1) {
        EntityManager em = this.allocateEntityManager();
        try {
            Object object = em.find(arg0, arg1);
            return (T)object;
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> arg0, Object arg1) {
        EntityManager em = this.allocateEntityManager();
        try {
            Object object = em.getReference(arg0, arg1);
            return (T)object;
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        EntityManager em = this.allocateEntityManager();
        try {
            em.flush();
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object arg0) {
        EntityManager em = this.allocateEntityManager();
        try {
            em.refresh(arg0);
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object arg0) {
        EntityManager em = this.allocateEntityManager();
        try {
            boolean bl = em.contains(arg0);
            return bl;
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String arg0) {
        EntityManager em = this.allocateEntityManager();
        try {
            Query query = em.createQuery(arg0);
            return query;
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String arg0) {
        EntityManager em = this.allocateEntityManager();
        try {
            Query query = em.createNamedQuery(arg0);
            return query;
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String arg0) {
        EntityManager em = this.allocateEntityManager();
        try {
            Query query = em.createNativeQuery(arg0);
            return query;
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String arg0, Class arg1) {
        EntityManager em = this.allocateEntityManager();
        try {
            Query query = em.createNativeQuery(arg0, arg1);
            return query;
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String arg0, String arg1) {
        EntityManager em = this.allocateEntityManager();
        try {
            Query query = em.createNativeQuery(arg0, arg1);
            return query;
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    public void close() {
        throw new IllegalStateException("Cannot close a container managed EntityManager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        EntityManager em = this.allocateEntityManager();
        try {
            boolean bl = em.isOpen();
            return bl;
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType mode) {
        EntityManager em = this.allocateEntityManager();
        try {
            em.setFlushMode(mode);
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        EntityManager em = this.allocateEntityManager();
        try {
            FlushModeType flushModeType = em.getFlushMode();
            return flushModeType;
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object o, LockModeType mode) {
        EntityManager em = this.allocateEntityManager();
        try {
            em.lock(o, mode);
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EntityManager em = this.allocateEntityManager();
        try {
            em.clear();
        }
        finally {
            this.releaseEntityManager(em);
        }
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException("Cannot use resource level transactions with a container managed EntityManager");
    }

    public void joinTransaction() {
    }
}

