/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.logging;

import com.evermind.server.ThreadState;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.logging.EJBMessages;
import com.evermind.server.ejb.logging.i18n.EJBTransactionMessageBundle;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.CustomerLogger;

public class EJBTransactionMessages
extends EJBMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.ejb.transaction", EJBTransactionMessageBundle.class.getName());

    public static void warningTxResumeError(String beanName, Throwable t) {
        if (EJBTransactionMessages.isLoggable(Level.WARNING)) {
            EJBTransactionMessages.logException(m_logger, Level.WARNING, "J2EE EJB-08003", new Object[]{beanName, Thread.currentThread().getName(), t}, t);
        }
    }

    public static void warningTransactionForRollback(Exception e) {
        if (EJBTransactionMessages.isLoggable(Level.WARNING)) {
            EJBTransactionMessages.logException(m_logger, Level.WARNING, "J2EE EJB-08001", new Object[]{e}, e);
        }
    }

    public static void warningTxEndError(String beanName, Throwable t) {
        if (EJBTransactionMessages.isLoggable(Level.WARNING)) {
            EJBTransactionMessages.logException(m_logger, Level.WARNING, "J2EE EJB-08002", new Object[]{beanName, Thread.currentThread().getName(), t}, t);
        }
    }

    public static void finestSynchronizationMessage(String msg) {
        if (EJBTransactionMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE EJB-08004", new Object[]{ThreadState.getCurrentState().toString(), msg});
        }
    }

    public static void fineMethodRetry(BeanDescriptor descriptor, Method method, int maxRetries, int retryCount) {
        if (EJBTransactionMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE EJB-08005", new Object[]{descriptor.getName(), method, new Integer(retryCount), new Integer(maxRetries)});
        }
    }

    public static void severeMethodException(BeanDescriptor descriptor, Method method, Throwable t) {
        EJBTransactionMessages.logException(m_logger, Level.SEVERE, "J2EE EJB-08006", new Object[]{EJBTransactionMessages.getBeanName(descriptor), method, t}, t);
    }

    public static void severeUncommittedBeanManagedTransaction(BeanDescriptor desc, String txId) {
        m_logger.log(Level.SEVERE, "J2EE EJB-08007", new Object[]{EJBTransactionMessages.getApplicationName(desc), EJBTransactionMessages.getModuleName(desc), EJBTransactionMessages.getBeanName(desc), txId});
    }

    private static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }
}

