/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.logging;

import com.evermind.server.Application;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.logging.EJBMessages;
import com.evermind.server.ejb.logging.i18n.EJBIiopMessageBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.LoggingUtils;
import oracle.oc4j.corba.transport.CorbaEJBHome;

public class EJBIiopMessages
extends EJBMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.ejb.iiop", EJBIiopMessageBundle.class.getName());

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void severeUnableToCreateHomeReference(CorbaEJBHome home, Exception exception) {
        m_logger.log(Level.SEVERE, "J2EE EJB-09003", home.getBeanName());
        LoggingUtils.logSevereStackTrace(m_logger, exception);
    }

    public static void severeUnableToCreateObjectReference(AbstractEJBHome home, Exception exception) {
        m_logger.log(Level.SEVERE, "J2EE EJB-09004", home.getBeanName());
        LoggingUtils.logSevereStackTrace(m_logger, exception);
    }

    public static void finestIiopBeansAvailableInApplication(Application application) {
        if (EJBIiopMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE EJB-09001", application.getName());
        }
    }

    public static void finestIiopBeansNotAvailableInApplication(Application application, boolean isGenerateIiop, boolean isEnabledIiop, boolean isIiopConfigured) {
        if (EJBIiopMessages.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "J2EE EJB-09002", new Object[]{application.getName(), isGenerateIiop, isEnabledIiop, isIiopConfigured});
        }
    }

    public static void severeUnableToRegisterHome(CorbaEJBHome home, Exception exception) {
        m_logger.log(Level.SEVERE, "J2EE EJB-09005", home.getBeanName());
        LoggingUtils.logSevereStackTrace(m_logger, exception);
    }

    public static void severeUnableToUnregisterHomes(String applicationName, Exception exception) {
        m_logger.log(Level.SEVERE, "J2EE EJB-09006", applicationName);
        LoggingUtils.logSevereStackTrace(m_logger, exception);
    }

    public static void warningErrorUndeployingApplication(String applicationName, Exception exception) {
        m_logger.log(Level.WARNING, "J2EE EJB-09007", applicationName);
        LoggingUtils.logWarningStackTrace(m_logger, exception);
    }

    public static void severeUnableToCreatePoa(Exception exception) {
        m_logger.log(Level.SEVERE, "J2EE EJB-09008");
        LoggingUtils.logSevereStackTrace(m_logger, exception);
    }

    public static void severeUnableToSetServantLocator(Exception exception) {
        m_logger.log(Level.SEVERE, "J2EE EJB-09009");
        LoggingUtils.logSevereStackTrace(m_logger, exception);
    }

    public static void severeUnableToCreateServant(Exception exception) {
        m_logger.log(Level.SEVERE, "J2EE EJB-09010");
        LoggingUtils.logSevereStackTrace(m_logger, exception);
    }

    public static void severeUnableToReadEJBObjectID(Throwable throwable) {
        m_logger.log(Level.SEVERE, "J2EE EJB-09011");
        LoggingUtils.logSevereStackTrace(m_logger, throwable);
    }

    public static void warningUnableToPerformIdentityCheck(Exception exception) {
        m_logger.log(Level.WARNING, "J2EE EJB-09012");
        LoggingUtils.logWarningStackTrace(m_logger, exception);
    }
}

