/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.logging;

import com.evermind.server.Application;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.logging.DiagnosticContext;
import com.evermind.server.ejb.logging.EJBMessages;
import com.evermind.server.ejb.logging.i18n.EJBDeploymentMessageBundle;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.CustomerLogger;

public class EJBDeploymentMessages
extends EJBMessages {
    private static Logger m_logger = CustomerLogger.getLogger("oracle.j2ee.ejb.deployment", EJBDeploymentMessageBundle.class.getName());

    public static void warningGetBeansFromEJBModule(DiagnosticContext pkg) {
        if (EJBDeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03001", new Object[]{pkg.getContextId()});
        }
    }

    public static void warningMultiplePMEntries(DiagnosticContext pkg, String deployedName) {
        if (EJBDeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03002", new Object[]{pkg.getContextId(), deployedName});
        }
    }

    public static void warningNotifyingPluggablePMs(DiagnosticContext pkg, String pMOpString, Exception e) {
        if (EJBDeploymentMessages.isLoggable(Level.WARNING)) {
            EJBDeploymentMessages.logException(m_logger, Level.WARNING, "J2EE EJB-03003", new Object[]{pkg.getContextId(), pMOpString, e}, e);
        }
    }

    public static void warningGettingDataSourceName(DiagnosticContext desc, Exception e) {
        if (EJBDeploymentMessages.isLoggable(Level.WARNING)) {
            EJBDeploymentMessages.logException(m_logger, Level.WARNING, "J2EE EJB-03004", new Object[]{desc.getContextId(), e}, e);
        }
    }

    public static void warningPMName(DiagnosticContext desc) {
        m_logger.log(Level.WARNING, "J2EE EJB-03005", new Object[]{desc.getContextId()});
    }

    public static void warningNativeCMPName() {
        m_logger.log(Level.WARNING, "J2EE EJB-03006");
    }

    public static void warningStatefulSessionBeanTags(DiagnosticContext desc, String name) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03007", new Object[]{desc.getContextId(), name});
        }
    }

    public static void infoEJBModuleDeployed(String appName, String moduleName, String path, String deployed) {
        if (m_logger.isLoggable(Level.INFO)) {
            m_logger.log(Level.FINE, "J2EE EJB-03008", new Object[]{appName, moduleName, path, deployed});
        }
    }

    public static void warningLoadingEJBModule(String appName, String moduleName, String codebase, String message) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE EJB-03009", new Object[]{appName, moduleName, codebase, message});
        }
    }

    public static void warningPMClassNotFound(String message) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03010", new Object[]{message});
        }
    }

    public static void warningIllegalAccessPMClass(String message) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03011", new Object[]{message});
        }
    }

    public static void warningPMInterfaceNotImplemented(String message) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03012", new Object[]{message});
        }
    }

    public static void finerCreateMDBHome(DiagnosticContext desc) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-03013", new Object[]{desc.getContextId()});
        }
    }

    public static void finerBindRemoteHome(DiagnosticContext desc, String location) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-03014", new Object[]{desc.getContextId(), location});
        }
    }

    public static void finerBindRemoteBeanFactory(DiagnosticContext desc, String location) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-03015", new Object[]{desc.getContextId(), location});
        }
    }

    public static void finerBindLocalHome(DiagnosticContext desc, String location) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-03016", new Object[]{desc.getContextId(), location});
        }
    }

    public static void finerBindLocalBeanFactory(DiagnosticContext desc, String location) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-03017", new Object[]{desc.getContextId(), location});
        }
    }

    public static void finerUnBindHome(DiagnosticContext desc, String path) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-03018", new Object[]{desc.getContextId(), path});
        }
    }

    public static void finerNotifyPMs(DiagnosticContext pkg, String pMOpString) {
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "J2EE EJB-03019", new Object[]{pkg.getContextId(), pMOpString});
        }
    }

    public static void warningUnableLoadClassFile(DiagnosticContext pkg, String fileName) {
        if (m_logger.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03020", new Object[]{pkg.getContextId(), fileName});
        }
    }

    public static void fineMethodParamsIgnored(DiagnosticContext ctx, String parentTag) {
        if (EJBDeploymentMessages.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "J2EE EJB-03021", new Object[]{ctx.getContextId(), parentTag});
        }
    }

    public static void warningInvalidTimeoutTransactionType(BeanDescriptor desc) {
        if (EJBDeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03022", new Object[]{EJBDeploymentMessages.getModuleName(desc), EJBDeploymentMessages.getBeanName(desc)});
        }
    }

    public static void warningInvalidSessionCreateTransactionType(BeanDescriptor desc) {
        if (EJBDeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03023", new Object[]{EJBDeploymentMessages.getModuleName(desc), EJBDeploymentMessages.getBeanName(desc)});
        }
    }

    public static void warningOldPessimisticLockingMode(DiagnosticContext desc) {
        if (EJBDeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03024", new Object[]{desc.getContextId()});
        }
    }

    public static void warningPersistenceManagerWithNoCMP(DiagnosticContext pkg) {
        if (EJBDeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03025", new Object[]{pkg.getContextId()});
        }
    }

    public static void warningBatchCompileSystemProperty(Application app) {
        if (EJBDeploymentMessages.isLoggable(Level.WARNING)) {
            m_logger.log(Level.WARNING, "J2EE EJB-03026", new Object[]{app.getName()});
        }
    }

    public static void severeDeploymentFailure(Application app, Exception e) {
        EJBDeploymentMessages.logException(m_logger, Level.SEVERE, "J2EE EJB-03027", new Object[]{app.getName(), e}, e);
    }

    public static void warningPmNameSelected(DiagnosticContext module, String pmName) {
        m_logger.log(Level.WARNING, "J2EE EJB-03028", new Object[]{module.getContextId(), pmName});
    }

    public static void warningIgnoringPm(DiagnosticContext module, String pmName) {
        m_logger.log(Level.WARNING, "J2EE EJB-03029", new Object[]{module.getContextId(), pmName});
    }

    public static void warningIgnoringEjbql(String query) {
        m_logger.log(Level.WARNING, "J2EE EJB-03030", new Object[]{query});
    }

    public static void warningDisableFinder(DiagnosticContext desc, Method method) {
        m_logger.log(Level.WARNING, "J2EE EJB-03031", new Object[]{desc.getContextId(), method});
    }

    public static void warningDisableSelect(DiagnosticContext desc, Method method) {
        m_logger.log(Level.WARNING, "J2EE EJB-03032", new Object[]{desc.getContextId(), method});
    }

    public static void warningUseJaas(DiagnosticContext module) {
        m_logger.log(Level.WARNING, "J2EE EJB-03033", new Object[]{module.getContextId()});
    }

    public static void fineInitializingPersistenceUnitManager(DiagnosticContext ctx) {
        m_logger.log(Level.FINE, "J2EE EJB-03034", new Object[]{ctx.getContextId()});
    }

    public static void fineParsingPersistenceXml(DiagnosticContext ctx, String root) {
        m_logger.log(Level.FINE, "J2EE EJB-03035", new Object[]{ctx.getContextId(), root});
    }

    public static void fineInitializingEntityManagerFactory(DiagnosticContext ctx, String emfName, String persistenceProvider) {
        m_logger.log(Level.FINE, "J2EE EJB-03036", new Object[]{ctx.getContextId(), emfName, persistenceProvider});
    }

    public static void fineDestroyingPersistenceUnitManager(DiagnosticContext ctx) {
        m_logger.log(Level.FINE, "J2EE EJB-03037", new Object[]{ctx.getContextId()});
    }

    public static void fineClosingEntityManagerFactory(DiagnosticContext ctx, String emfName) {
        m_logger.log(Level.FINE, "J2EE EJB-03038", new Object[]{ctx.getContextId(), emfName});
    }

    public static void infoUsingTopLinkPreviewPersistenceProvider() {
        if (EJBDeploymentMessages.isLoggable(Level.INFO)) {
            m_logger.log(Level.INFO, "J2EE EJB-03039");
        }
    }

    public static void finerBindingEntityManagerFactory(DiagnosticContext ctx, String unitName, String jndiName) {
        m_logger.log(Level.FINE, "J2EE EJB-03040", new Object[]{ctx.getContextId(), unitName, jndiName});
    }

    public static boolean isLoggable(Level level) {
        return m_logger.isLoggable(level);
    }

    public static void warningInterceptorAnnotationDeprecated(DiagnosticContext ctx) {
        m_logger.log(Level.WARNING, "J2EE EJB-03041", new Object[]{ctx.getContextId()});
    }

    public static void warningLifecycleCallbackClass(DiagnosticContext ctx, String parentTag, String subTag) {
        m_logger.log(Level.WARNING, "J2EE EJB-03042", new Object[]{ctx.getContextId(), parentTag, subTag});
    }

    public static void warningIgnoredTag(String parentTag, String subTag) {
        m_logger.log(Level.WARNING, "J2EE EJB-03043", new Object[]{parentTag});
    }

    public static void warningMissingSessionBeanType(DiagnosticContext ctx, String beanName) {
        m_logger.log(Level.WARNING, "J2EE EJB-03044", new Object[]{ctx.getContextId(), beanName});
    }

    public static void warningBeanTypeMismatch(DiagnosticContext ctx, String xmlFile, String beanType) {
        m_logger.log(Level.WARNING, "J2EE EJB-03045", new Object[]{ctx.getContextId(), xmlFile, beanType});
    }

    public static void warningSessionBizInterfaceNotDefined(DiagnosticContext ctx) {
        m_logger.log(Level.WARNING, "J2EE EJB-03046", new Object[]{ctx.getContextId()});
    }

    public static void warningTxTypeMismatch(DiagnosticContext ctx, String txType) {
        m_logger.log(Level.WARNING, "J2EE EJB-03047", new Object[]{ctx.getContextId(), txType});
    }

    public static void warningReplicationTriggerReset(String fromTrigger, String toTrigger) {
        m_logger.log(Level.WARNING, "J2EE EJB-03049", new Object[]{fromTrigger, toTrigger});
    }
}

