/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor.system;

import com.evermind.security.User;
import com.evermind.server.RuntimeSecurityRole;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.EJBPrivileged;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.interceptor.InvocationContext;
import com.evermind.server.ejb.interceptor.MethodState;
import java.util.Collections;
import java.util.List;
import javax.ejb.AccessLocalException;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.security.acc.JaccWrapper;

public class SecurityRoleInterceptor
implements Interceptor {
    private static Interceptor instance = new SecurityRoleInterceptor();
    private static String[] DEFAULT_ROLE_NAMES = new String[]{"<<default>>"};

    private SecurityRoleInterceptor() {
    }

    public static Interceptor getInstance(MethodState methodState) {
        if (JaccWrapper.isJaccEnabled()) {
            return null;
        }
        if (methodState.getSecurityRole() == null || methodState.getSecurityRole().impliesAll()) {
            return null;
        }
        return instance;
    }

    public Object invoke(InvocationContext ctx) throws Exception {
        ThreadState threadState = ctx.getCurrentThreadState();
        threadState.shieldedUser = false;
        SecurityRoleInterceptor.checkRuntimeSecurityRole(ctx.getMethodState(), threadState);
        return ctx.proceed();
    }

    public static void checkRuntimeSecurityRoleLocal(MethodState methodState, ThreadState threadState) {
        try {
            SecurityRoleInterceptor.checkRuntimeSecurityRole(methodState, threadState);
        }
        catch (OracleRemoteException e) {
            throw EJBUtils.createEJBException(e);
        }
    }

    public static void checkRuntimeSecurityRole(MethodState methodState, ThreadState threadState) throws OracleRemoteException {
        if (methodState.getSecurityRole() == null || methodState.getSecurityRole().impliesAll()) {
            return;
        }
        User user = EJBPrivileged.getUser(threadState);
        if (!EJBPrivileged.impliesUser(methodState.getSecurityRole(), user, null)) {
            String error = user.getName() + " is not allowed to call this EJB method, check your security settings (method-permission in ejb-jar.xml and security-role-mapping in orion-application.xml).";
            if (methodState.isLocal()) {
                throw new AccessLocalException(error);
            }
            throw new OracleRemoteException(error);
        }
    }

    public static RuntimeSecurityRole getSecurityRole(MethodState methodState) {
        String[] allowedRoleNames;
        List allowedRoleNamesList = methodState.getBeanDescriptor().getSecurityRoles(methodState.getInterfaceMethod(), methodState.isHome(), methodState.isLocal());
        if (allowedRoleNamesList == Collections.EMPTY_LIST) {
            return null;
        }
        if (allowedRoleNamesList == null) {
            allowedRoleNames = DEFAULT_ROLE_NAMES;
        } else {
            allowedRoleNames = new String[allowedRoleNamesList.size()];
            allowedRoleNamesList.toArray(allowedRoleNames);
        }
        try {
            return methodState.getBeanDescriptor().getPackage().getDeployment().getRuntimeRole(allowedRoleNames);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

