/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor.system;

import com.evermind.server.ThreadState;
import com.evermind.server.ejb.EJBPrivileged;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.interceptor.InvocationContext;
import com.evermind.server.ejb.interceptor.MethodState;
import javax.ejb.AccessLocalException;
import javax.ejb.EnterpriseBean;
import javax.naming.NamingException;
import javax.security.jacc.EJBMethodPermission;
import javax.xml.soap.SOAPMessage;
import oracle.oc4j.rmi.OracleRemoteException;
import oracle.oc4j.security.acc.JaccWrapper;

public class JACCInterceptor
implements Interceptor {
    private static Interceptor instance = new JACCInterceptor();

    private JACCInterceptor() {
    }

    public static Interceptor getInstance() {
        if (JaccWrapper.isJaccEnabled()) {
            return instance;
        }
        return null;
    }

    public Object invoke(InvocationContext ctx) throws Exception {
        ThreadState threadState = ctx.getCurrentThreadState();
        threadState.shieldedUser = false;
        EnterpriseBean target = null;
        if (ctx.getTarget() != null && ctx.getTarget() instanceof EnterpriseBean) {
            target = (EnterpriseBean)ctx.getTarget();
        }
        if (ctx.getMethodState().isLocal()) {
            JACCInterceptor.authorizeLocal(ctx.getMethodState().getMethodPermission(), target, ctx.getParametersOrNull(), null, threadState);
        } else {
            JACCInterceptor.authorizeRemote(ctx.getMethodState().getMethodPermission(), target, ctx.getParametersOrNull(), null, threadState);
        }
        return ctx.proceed();
    }

    public static void authorizeLocal(EJBMethodPermission permission, EnterpriseBean target, Object[] params, SOAPMessage soapMsg, ThreadState threadState) {
        String error = JACCInterceptor.authorize(permission, target, params, soapMsg, threadState);
        if (error != null) {
            throw new AccessLocalException(error);
        }
    }

    public static void authorizeRemote(EJBMethodPermission permission, EnterpriseBean target, Object[] params, SOAPMessage soapMsg, ThreadState threadState) throws OracleRemoteException {
        String error = JACCInterceptor.authorize(permission, target, params, soapMsg, threadState);
        if (error != null) {
            throw new OracleRemoteException(error);
        }
    }

    private static String authorize(EJBMethodPermission permission, EnterpriseBean target, Object[] params, SOAPMessage soapMsg, ThreadState threadState) {
        JaccWrapper jaccWrapper = null;
        try {
            jaccWrapper = threadState.getJaccWrapper(threadState.contextContainer.getApplication().getName());
        }
        catch (NamingException ne) {
            // empty catch block
        }
        if (jaccWrapper == null || !jaccWrapper.authorizeEJB(permission, EJBPrivileged.getUser(threadState), params, target, soapMsg)) {
            return EJBPrivileged.getUser(threadState).getName() + " is not allowed to call this EJB method, check your security settings (method-permission in ejb-jar.xml and security-role-mapping in orion-application.xml).";
        }
        return null;
    }

    public static EJBMethodPermission getMethodPermission(MethodState methodState) {
        String methodIntf = null;
        methodIntf = methodState.isLocal() ? (methodState.isHome() ? "LocalHome" : "Local") : (methodState.isHome() ? "Home" : null);
        return new EJBMethodPermission(methodState.getBeanDescriptor().getName(), methodIntf, methodState.getInterfaceMethod());
    }
}

