/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor.system;

import com.evermind.server.ApplicationServer;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.interceptor.InvocationContext;
import com.evermind.server.ejb.interceptor.MethodState;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.ClassUtils;
import java.lang.reflect.Method;
import java.util.logging.Level;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.StateIntf;

public class DMSInterceptor
implements Interceptor {
    PhaseEventIntf phaseEvent;

    private DMSInterceptor(MethodState methodState, boolean isClientPhaseEvent) {
        this.phaseEvent = isClientPhaseEvent ? methodState.getClientPhaseEvent() : methodState.getWrapperPhaseEvent();
    }

    public static Interceptor getInstance(MethodState methodState, boolean isClientPhaseEvent) {
        if (!ApplicationServer.DMS_GATE) {
            return null;
        }
        if (isClientPhaseEvent) {
            return new DMSInterceptor(methodState, true);
        }
        return new DMSInterceptor(methodState, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(InvocationContext ctx) throws Exception {
        long dmsToken = 0L;
        try {
            dmsToken = this.phaseEvent.start();
            Object object = ctx.proceed();
            return object;
        }
        finally {
            this.phaseEvent.stop2(dmsToken);
        }
    }

    public static PhaseEventIntf createDMSBeanMethodPE(NounIntf beanTypeNoun, String transType, String dmsMethodName, String nounCategory, String phaseCategory) {
        if (transType == null) {
            transType = "unspecified";
        }
        NounIntf methodNoun = ApplicationServer.nounFactory().create(beanTypeNoun, dmsMethodName, nounCategory);
        PhaseEventIntf pe = ApplicationServer.phaseEventFactory().create(methodNoun, phaseCategory, phaseCategory);
        ApplicationServer.stateFactory().create(methodNoun, "trans-attribute", "", "trans attribute", (Object)transType);
        pe.deriveMetric(511);
        return pe;
    }

    public static String getDMSMethodName(Method method) {
        StringBuffer sbDms = new StringBuffer();
        sbDms.append(method.getName() + "(");
        Class<?>[] args = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                sbDms.append(",");
            }
            sbDms.append(ClassUtils.getSourceNotation(args[i], 0));
        }
        sbDms.append(")");
        return sbDms.toString();
    }

    public static StateIntf createCountState(NounIntf beanNoun, String _name, String _desc) {
        StateIntf _ret = null;
        try {
            _ret = ApplicationServer.stateFactory().create(beanNoun, _name, (byte)3, "count", _desc);
            _ret.deriveMetric(511);
            if (!_ret.isInitialized()) {
                _ret.update(0);
            }
        }
        catch (Exception e) {
            EJBTraceLogger.getLogger(DMSInterceptor.class).log(Level.SEVERE, "Unable to create " + _name + "DMS noun");
        }
        return _ret;
    }
}

