/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.interceptor.InvocationContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.ejb.EJBContext;

public abstract class MethodBasedInterceptor
implements Interceptor {
    private Method method;

    public MethodBasedInterceptor(Method method) {
        this.setMethod(method);
    }

    public Object invoke(InvocationContext ctx) throws Exception {
        try {
            return this.getMethod().invoke(this.getInterceptorInstance(ctx), new EJBInvocationCallbackImpl(ctx));
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw EJBUtils.createEJBException(new Exception(cause));
        }
    }

    public abstract Object getInterceptorInstance(InvocationContext var1);

    private final Method getMethod() {
        return this.method;
    }

    private void setMethod(Method method) {
        this.method = method;
    }

    private class EJBInvocationCallbackImpl
    implements javax.interceptor.InvocationContext {
        private InvocationContext context;

        public EJBInvocationCallbackImpl(InvocationContext ctx) {
            this.context = ctx;
        }

        public Object getTarget() {
            return this.context.getTarget();
        }

        public Method getMethod() {
            return this.context.getMethod();
        }

        public Object[] getParameters() {
            return this.context.getParameters();
        }

        public void setParameters(Object[] params) {
            this.context.setParameters(params);
        }

        public EJBContext getEJBContext() {
            return this.context.getEJBContext();
        }

        public Map getContextData() {
            return this.context.getContextData();
        }

        public Object proceed() throws Exception {
            return this.context.proceed();
        }
    }
}

