/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor;

import com.evermind.server.ThreadState;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.AbstractEJBObject;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.interceptor.InvocationContext;
import com.evermind.server.ejb.interceptor.MethodState;
import com.evermind.server.ejb.interceptor.joinpoint.EJBJoinPoint;
import com.evermind.server.ejb.interceptor.system.TxLifecycleCallback;
import com.oracle.server.ejb.persistence.container.WrapperObject;
import com.oracle.server.ejb.persistence.pm.PersistenceManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBContext;

public class InvocationContextImpl
implements InvocationContext,
com.oracle.server.ejb.persistence.container.InvocationContext {
    private int interceptorIndex = 0;
    private Object bean;
    private EJBContext context;
    private MethodState methodState;
    private boolean newTxStarted = false;
    private AbstractEJBObject beanWrapper;
    private AbstractEJBHome homeWrapper;
    private TxLifecycleCallback txCallback;
    private Object[] parameters;
    private Map contextData;
    private Object primaryKey;
    private ThreadState currentState;
    private Interceptor[] callChain;
    public InvocationContextImpl next;

    public InvocationContextImpl(MethodState methodState, Object bean, EJBContext context, Object[] params, ThreadState thread, AbstractEJBObject beanWrapper, AbstractEJBHome homeWrapper) {
        this.methodState = methodState;
        this.bean = bean;
        this.context = context;
        this.parameters = params;
        this.beanWrapper = beanWrapper;
        this.homeWrapper = homeWrapper;
        this.currentState = thread;
        this.callChain = methodState.getJoinPoint().getCallChain();
    }

    public InvocationContextImpl(ThreadState state) {
        this.currentState = state;
    }

    public void init(MethodState methodState, Object bean, EJBContext context, Object[] params, AbstractEJBObject beanWrapper, AbstractEJBHome homeWrapper) {
        this.methodState = methodState;
        this.bean = bean;
        this.context = context;
        this.parameters = params;
        this.beanWrapper = beanWrapper;
        this.homeWrapper = homeWrapper;
        this.callChain = methodState.getJoinPoint().getCallChain();
    }

    public void clear() {
        this.methodState = null;
        this.bean = null;
        this.context = null;
        this.parameters = null;
        this.beanWrapper = null;
        this.homeWrapper = null;
        this.callChain = null;
        this.primaryKey = null;
        this.contextData = null;
        this.txCallback = null;
        this.newTxStarted = false;
        this.interceptorIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed() throws Exception {
        try {
            Object object = this.callChain[this.interceptorIndex++].invoke(this);
            return object;
        }
        finally {
            --this.interceptorIndex;
        }
    }

    public final Object getTarget() {
        return this.bean;
    }

    public final Method getMethod() {
        return this.getMethodState().getInvocationContextMethod();
    }

    public final Object[] getParameters() {
        if (this.parameters == null) {
            this.parameters = new Object[0];
        }
        return this.parameters;
    }

    public Object[] getParametersOrNull() {
        return this.parameters;
    }

    public void setParameters(Object[] params) {
        this.parameters = params;
    }

    public final EJBContext getEJBContext() {
        return this.context;
    }

    public Map getContextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap();
        }
        return this.contextData;
    }

    public final MethodState getMethodState() {
        return this.methodState;
    }

    private final EJBJoinPoint getJoinPoint() {
        return this.getMethodState().getJoinPoint();
    }

    public void setTarget(Object bean) {
        this.bean = bean;
    }

    public void setEJBContext(EJBContext context) {
        this.context = context;
    }

    public ThreadState getCurrentThreadState() {
        if (this.currentState == null) {
            this.currentState = ThreadState.getCurrentState();
        }
        return this.currentState;
    }

    public boolean wasNewTransactionStarted() {
        return this.newTxStarted;
    }

    public void setNewTransactionStarted(boolean wasNewTxStarted) {
        this.newTxStarted = wasNewTxStarted;
    }

    public void setBeanWrapper(AbstractEJBObject beanWrapper) {
        this.beanWrapper = beanWrapper;
    }

    public AbstractEJBObject getBeanWrapper() {
        return this.beanWrapper;
    }

    public AbstractEJBHome getHome() {
        return this.homeWrapper;
    }

    public void setTxLifecycleCallback(TxLifecycleCallback callback) {
        this.txCallback = callback;
    }

    public TxLifecycleCallback getTxLifecycleCallback() {
        return this.txCallback;
    }

    public void setPrimaryKey(Object pk) {
        this.primaryKey = pk;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public Map getProperties() {
        return this.getContextData();
    }

    public boolean isLocal() {
        return this.getMethodState().isLocal();
    }

    public WrapperObject getWrapperObject() {
        return (WrapperObject)((Object)this.getBeanWrapper());
    }

    public boolean isNewContainerTransaction() {
        return this.wasNewTransactionStarted();
    }

    public PersistenceManager getPm() {
        return this.getHome().getPM();
    }

    public void setBean(Object bean) {
        this.setTarget(bean);
    }

    public Object getBean() {
        return this.getTarget();
    }
}

