/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.exception;

import com.evermind.server.ejb.deployment.BeanDescriptor;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class EJBExceptionsHelper {
    private static final String VERSION = "2.1";
    public static final String SPEC_SECTION = "SPEC_SECTION";

    public static String buildMessage(ResourceBundle resourceBundle, Object[] args, String exceptionKey) {
        return EJBExceptionsHelper.internalBuildMessage(resourceBundle, args, exceptionKey);
    }

    public static String buildMessage(ResourceBundle resourceBundle, Object[] args, String exceptionKey, String specSection) {
        return EJBExceptionsHelper.buildMessage(resourceBundle, args, exceptionKey) + EJBExceptionsHelper.buildSpecReferenceString(resourceBundle, specSection);
    }

    private static String internalBuildMessage(ResourceBundle resourceBundle, Object[] args, String exceptionKey) {
        try {
            String message = resourceBundle.getString(exceptionKey);
            return MessageFormat.format(message, args);
        }
        catch (Exception e) {
            return "Unable to format translated message for exception: " + exceptionKey + " args: " + EJBExceptionsHelper.argsToString(args) + " exception: " + e;
        }
    }

    private static String buildSpecReferenceString(ResourceBundle resourceBundle, String specSection) {
        return EJBExceptionsHelper.internalBuildMessage(resourceBundle, new Object[]{specSection, VERSION}, SPEC_SECTION);
    }

    private static String argsToString(Object[] args) {
        StringBuffer argsAsString = new StringBuffer("[");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (i != 0) {
                    argsAsString.append(",");
                }
                try {
                    argsAsString.append(args[i].toString());
                    continue;
                }
                catch (Exception ex2) {
                    argsAsString.append(ex2);
                }
            }
        }
        return argsAsString.append("]").toString();
    }

    public static String buildMessagePrefix(BeanDescriptor desc) {
        StringBuffer prefix = new StringBuffer("[");
        prefix.append(desc.getEJBPackage().getApplication().getName()).append(":").append(desc.getEJBPackage().getName()).append(":");
        if (desc.getName() != null) {
            prefix.append(desc.getName());
        } else if (desc.getBeanTypeString() != null) {
            prefix.append(desc.getBeanTypeString());
        } else {
            prefix.append(desc.getEJBClassName());
        }
        return prefix.append("]").toString();
    }
}

