/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.BeanDescriptorXMLFactory;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public abstract class ExposableBeanDescriptorXMLFactory
extends BeanDescriptorXMLFactory {
    protected ExposableBeanDescriptorXMLFactory() {
    }

    protected boolean parseEJBJarXMLNode(BeanDescriptor desc, Node node) throws InstantiationException {
        String name = node.getNodeName();
        String value = XMLUtils.getStringValue(node);
        ExposableBeanDescriptor descriptor = (ExposableBeanDescriptor)desc;
        if (name.equals("home")) {
            descriptor.setRemoteHomeName(value);
        } else if (name.equals("remote")) {
            descriptor.addRemoteInterfaceName(value);
        } else if (name.equals("business-remote")) {
            descriptor.addRemoteInterfaceName(value);
        } else if (name.equals("local-home")) {
            descriptor.setLocalHomeName(value);
        } else if (name.equals("local")) {
            descriptor.addLocalInterfaceName(value);
        } else if (name.equals("business-local")) {
            descriptor.addLocalInterfaceName(value);
        } else {
            return super.parseEJBJarXMLNode(descriptor, node);
        }
        return true;
    }

    protected boolean parseOracleEJBJarXMLAttribute(BeanDescriptor desc, String name, String value) throws InstantiationException {
        ExposableBeanDescriptor descriptor = (ExposableBeanDescriptor)desc;
        if (name.equals("location")) {
            descriptor.setLocation(value);
        } else if (name.equals("local-location")) {
            descriptor.setLocalLocation(value);
        } else if (!(name.equals("wrapper") || name.equals("local-wrapper") || name.equals("remote-wrapper-name") || name.equals("local-wrapper-name") || name.equals("remote") || name.equals("local"))) {
            return super.parseOracleEJBJarXMLAttribute(descriptor, name, value);
        }
        return true;
    }

    protected String getOracleEJBJarXMLAttributes(BeanDescriptor desc) {
        ExposableBeanDescriptor descriptor = (ExposableBeanDescriptor)desc;
        StringBuffer attributes = new StringBuffer(super.getOracleEJBJarXMLAttributes(desc));
        this.appendAttribute("location", descriptor.getLocation(), attributes);
        this.appendAttribute("local-location", descriptor.getLocalLocation(), attributes);
        return attributes.toString();
    }

    protected void writeBeanSpecificEJBJarXMLTags(BeanDescriptor descriptor, PrintWriter out, String indentation) throws IOException {
        ExposableBeanDescriptor exposableDescriptor = (ExposableBeanDescriptor)descriptor;
        this.writeTag("home", exposableDescriptor.getRemoteHomeName(), out, indentation);
        this.writeTag("remote", exposableDescriptor.getRemoteInterfaceName(), out, indentation);
        this.writeTag("local-home", exposableDescriptor.getLocalHomeName(), out, indentation);
        this.writeTag("local", exposableDescriptor.getLocalInterfaceName(), out, indentation);
        this.writeTag("service-endpoint", exposableDescriptor.getServiceEndpointName(), out, indentation);
        this.writeTag("ejb-class", exposableDescriptor.getEJBClassName(), out, indentation);
    }
}

