/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.naming.ContextUtils;
import com.evermind.server.ApplicationServer;
import com.evermind.server.SystemProperties;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.BMPOrionEntityBeanPool;
import com.evermind.server.ejb.BeanPool;
import com.evermind.server.ejb.DBEntityEJBHome;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.EntityBeanPool;
import com.evermind.server.ejb.EntityEJBHome;
import com.evermind.server.ejb.ExtendedContainerManagedObject;
import com.evermind.server.ejb.cache.AlternateHashTable;
import com.evermind.server.ejb.cache.BMPCacheManager;
import com.evermind.server.ejb.cache.CMPCacheManager;
import com.evermind.server.ejb.cache.CachePolicy;
import com.evermind.server.ejb.cache.EntityCacheManager;
import com.evermind.server.ejb.cache.ObjectHashTableFactory;
import com.evermind.server.ejb.cache.PrivateAccessor;
import com.evermind.server.ejb.compilation.EntityBeanCompilation;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.database.TableNameContainer;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.BeanDescriptorXMLFactory;
import com.evermind.server.ejb.deployment.CommitOptionDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.DataSynchronizationOptionDescriptor;
import com.evermind.server.ejb.deployment.EJBDeploymentContext;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.EJBQuery;
import com.evermind.server.ejb.deployment.EntityBeanDescriptorXMLFactory;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.deployment.FinderMethod;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.deployment.ORNameMapper;
import com.evermind.server.ejb.deployment.PersistenceManagerDescriptor;
import com.evermind.server.ejb.deployment.PrimaryKeyContext;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.ArraySet;
import com.evermind.util.ClassUtils;
import com.evermind.util.EJBProperties;
import com.evermind.util.ExtendedComparator;
import com.oracle.server.ejb.container.deployment.ContainerEntityDescriptor;
import com.oracle.server.ejb.container.deployment.EntityDescriptorImpl;
import com.oracle.server.ejb.container.deployment.FinderDescriptorImpl;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EntityBean;

public class EntityBeanDescriptor
extends ExposableBeanDescriptor
implements PrimaryKeyContext,
TableNameContainer {
    private boolean isBMP;
    private String primaryKeyClassName;
    private boolean isReentrant;
    private String version;
    private String abstractSchemaName;
    private String primaryKeyFieldName;
    private Set containerManagedFields;
    private List queries;
    private ContainerManagedField primaryKeyField;
    public static final int LOCKING_MODE_PESSIMISTIC = 1;
    public static final int LOCKING_MODE_OPTIMISTIC = 2;
    public static final int LOCKING_MODE_READ_ONLY = 3;
    public static final int CLUSTERING_DEFAULT = 1;
    public static final int CLUSTERING_ASYNCHRONOUS_CACHE = 2;
    protected static final int DEFAULT_VALIDITY_TIMEOUT = 0;
    protected static final int DEFAULT_CLUSTERING_SCHEMA = 1;
    protected static final int DEFAULT_LOCKING_MODE = 2;
    protected static final int DEFAULT_ISOLATION_LEVEL = 2;
    protected static final boolean DEFAULT_FORCE_UPDATE = false;
    protected static final boolean DEFAULT_SELECT_BEFORE_INSERT = true;
    protected static final boolean DEFAULT_EXCLUSIVE_WRITE_ACCESS = false;
    protected static final boolean DEFAULT_UPDATE_CHANGED_FIELDS_ONLY = true;
    protected static final boolean DEFAULT_DELAY_UPDATEDS_UNTIL_COMMIT = true;
    private String tableName;
    private String dataSourceName;
    private boolean selectBeforeInsert;
    private boolean exclusiveWriteAccess;
    private long validityTimeout;
    private int clusteringSchema;
    private int isolationLevel;
    private int lockingMode;
    private int batchSize;
    private boolean updateChangedFieldsOnly;
    private boolean forceUpdate;
    private boolean delayUpdatesUntilCommit;
    private Boolean findByPrimaryKeyLazyLoading;
    private String concreteBeanClassName;
    private static int concreteCount = 0;
    private List finderMethods;
    private CommitOptionDescriptor commitOptionDescriptor;
    private DataSynchronizationOptionDescriptor dataSynchronizationOption;
    private Class primaryKeyClass;
    private PropertyDescriptor[] properties;
    private boolean fieldsInitialized;
    private boolean cmp20_compiled = false;
    private EntityBeanCompilation localEntityBeanCompilation = null;
    private EntityBeanCompilation remoteEntityBeanCompilation = null;
    private Hashtable fieldsMap = new Hashtable();
    private Object ejbqlDescriptor;
    private ContainerEntityDescriptor entityDescriptorImpl;
    private static Logger m_logger = EJBTraceLogger.getLogger(EntityBeanDescriptor.class);
    protected AlternateHashTable cache = null;
    static /* synthetic */ Class class$java$lang$Object;

    public EntityBeanDescriptor(EJBPackage ejbPackage, String ejbName) {
        this(ejbPackage);
        this.setName(ejbName);
    }

    private EntityBeanDescriptor(EJBPackage ejbPackage) {
        super(ejbPackage);
        this.setBeanType(0);
        if (ejbPackage.isEJB2_0()) {
            this.setVersion("2.x");
        } else {
            this.setVersion("1.x");
        }
        this.setBatchSize(EJBProperties.getDefaultBatchSize());
        this.setValidityTimeout(0L);
        this.setClusteringSchema(1);
        this.setLockingMode(2);
        this.setForceUpdate(false);
        this.setSelectBeforeInsert(true);
        this.setExclusiveWriteAccess(false);
        this.setDelayUpdatesUntilCommit(true);
        this.setUpdateChangedFieldsOnly(true);
        this.setIsolationLevel(0);
        this.setCommitOptionDescriptor(new CommitOptionDescriptor(3));
        this.setDataSynchronizationOption(new DataSynchronizationOptionDescriptor(2));
    }

    protected void initialize() throws InstantiationException {
        super.initialize();
        if (this.isContainerManaged()) {
            if (this.isCMP2_0() && this.getAbstractSchemaName() == null) {
                throw new InstantiationException("abstract-schema-name not specified for entity '" + this.getName() + "', it must be specified for EJB 2.0 style CMP beans");
            }
        } else {
            if (!this.getContainerManagedFields().isEmpty()) {
                throw new InstantiationException("Invalid entity bean definition, beans with bean-managed persistence cannot contain cmp-field tags");
            }
            if (this.getPrimaryKeyFieldName() != null) {
                throw new InstantiationException("Invalid entity bean definition, beans with bean-managed persistence cannot contain a primkey-field tags");
            }
        }
        if (this.findByPrimaryKeyLazyLoading == null) {
            this.findByPrimaryKeyLazyLoading = new Boolean(SystemProperties.FINDBYPK_LAZYLOADING);
        }
        if (this.getTableName() == null) {
            this.setTableName(this.getEJBPackage().appendNamespace(this.getName()));
        }
        if (this.getLockingMode() != 3) {
            this.setExclusiveWriteAccess(false);
        }
        if (this.getBatchSize() < 1) {
            throw new InstantiationException("Batch size needs to be greater or equal to 1 (1 means no batch)");
        }
        if (this.getForceUpdate()) {
            if (this.getLockingMode() == 3) {
                throw new InstantiationException("Cannot set force-update to true for read-only beans");
            }
            this.setUpdateChangedFieldsOnly(false);
        }
        if (this.getDataSynchronizationOption() == null) {
            this.setDataSynchronizationOption(new DataSynchronizationOptionDescriptor(2));
        }
        if (!this.isContainerManaged() && this.getLockingMode() != 2 && this.getLockingMode() != 3) {
            throw new InstantiationException("Only valid mode that can be specified for BMP is optimistic or read-only. This simply means that concurrent access is allowed, how the locking is done is left to the Bean provider");
        }
    }

    public void initialize(EJBDeploymentContext container) throws InstantiationException {
        super.initialize(container);
        if (!EntityBean.class.isAssignableFrom(this.getEJBClass())) {
            throw new InstantiationException(this.getEJBClass().getName() + " does not implement javax.ejb.EntityBean");
        }
        if (Modifier.isFinal(this.getEJBClass().getModifiers())) {
            throw new InstantiationException("Bean class " + this.getEJBClassName() + " must not be declared final");
        }
        if (!(!Modifier.isAbstract(this.getEJBClass().getModifiers()) || this.isContainerManaged() && this.isCMP2_0())) {
            throw new InstantiationException("Bean class " + this.getEJBClassName() + " must not be declared abstract (" + (this.isContainerManaged() ? "it is not an EJB 2.0 bean" : "it is not a CMP bean") + ")");
        }
        if (!Modifier.isPublic(this.getEJBClass().getModifiers())) {
            throw new InstantiationException("Bean class " + this.getEJBClassName() + " must be declared public");
        }
        try {
            if (this.getPrimaryKeyClassName() == null) {
                throw new InstantiationException("<prim-key-class> not specified in <entity> tag for bean " + this.getName());
            }
            this.primaryKeyClass = Class.forName(this.getPrimaryKeyClassName(), true, this.getEJBPackage().getEJBClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException("Class '" + this.getPrimaryKeyClassName() + "' not found");
        }
        catch (Throwable t) {
            throw new InstantiationException("Error loading class '" + this.getPrimaryKeyClassName() + "': " + t);
        }
    }

    protected void addDMSAttrs() {
        if (ApplicationServer.DMS_GATE) {
            ApplicationServer.stateFactory().create(this.getBeanNoun(), "persistence-type", "", "persistence type", (Object)(this.isContainerManaged() ? "Container" : "Bean"));
            ApplicationServer.stateFactory().create(this.getBeanNoun(), "isolation", "", "isolation", (Object)this.getIsolationLevelAsString());
            ApplicationServer.stateFactory().create(this.getBeanNoun(), "exclusive-write-access", "", "exclusive writeaccess", (Object)(this.hasExclusiveWriteAccess() ? "true" : "false"));
            super.addDMSAttrs();
        }
    }

    public boolean isEntity() {
        return true;
    }

    public boolean isTopLinkCMP() {
        return this.isContainerManaged() && this.getPersistenceManagerDescriptor().isTopLinkPM();
    }

    public boolean isOrionCMP() {
        return this.isContainerManaged() && this.getPersistenceManagerDescriptor().isOrionPM();
    }

    public boolean isContainerManaged() {
        return !this.isBMP();
    }

    public boolean isBMP() {
        return this.isBMP;
    }

    public boolean isReadOnlyBMP() {
        return this.isBMP() && this.getLockingMode() == 3;
    }

    public boolean isAutomaticIdentity() {
        return this.getPrimaryKeyClassName().equals("java.lang.Object");
    }

    public boolean isCMP2_0() {
        return this.isContainerManaged() && this.version == "2.x";
    }

    public boolean isReentrant() {
        return this.isReentrant;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public String getPrimaryKeyClassName() {
        return this.primaryKeyClassName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getValidityTimeout() {
        return this.validityTimeout;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public String getIsolationLevelAsString() {
        switch (this.getIsolationLevel()) {
            case 2: {
                return "committed";
            }
            case 8: {
                return "serializable";
            }
            case 1: {
                return "uncommitted";
            }
            case 4: {
                return "repeatable_read";
            }
        }
        return "DB-determined";
    }

    public int getClusteringSchema() {
        return this.clusteringSchema;
    }

    public boolean hasExclusiveWriteAccess() {
        return this.exclusiveWriteAccess;
    }

    public boolean getSelectBeforeInsert() {
        return this.selectBeforeInsert;
    }

    public int getLockingMode() {
        return this.lockingMode;
    }

    public boolean getFindByPrimaryKeyLazyLoading() {
        return this.findByPrimaryKeyLazyLoading;
    }

    public boolean getDelayUpdatesUntilCommit() {
        return this.delayUpdatesUntilCommit;
    }

    public boolean getForceUpdate() {
        return this.forceUpdate;
    }

    public boolean getUpdateChangedFieldsOnly() {
        return this.updateChangedFieldsOnly;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getConcreteBeanClassName() {
        if (this.concreteBeanClassName == null) {
            this.concreteBeanClassName = EJBUtils.buildSafeClassName(this.getName()) + "_ConcreteSubClass" + concreteCount++;
        }
        return this.concreteBeanClassName;
    }

    public DataSynchronizationOptionDescriptor getDataSynchronizationOption() {
        return this.dataSynchronizationOption;
    }

    public CommitOptionDescriptor getCommitOption() {
        return this.commitOptionDescriptor;
    }

    public String getTableName(boolean create) {
        return this.getTableName();
    }

    public PersistenceManagerDescriptor getPersistenceManagerDescriptor() {
        return this.getPackage().getPersistenceManagerDescriptor();
    }

    public ContainerManagedField getPrimaryKey() {
        return this.primaryKeyField;
    }

    public String getPrimaryKeyFieldName() {
        return this.primaryKeyFieldName;
    }

    public Class getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public void setPrimaryKeyClass(Class primaryKeyClass) {
        this.primaryKeyClass = primaryKeyClass;
    }

    public String getRuntimePrimaryKeyClassName() {
        if (this.isAutomaticIdentity()) {
            return ClassUtils.getSourceNotation(this.getPrimaryKey().getType(), 0);
        }
        return this.getPrimaryKeyClassName();
    }

    public Class getRuntimePrimaryKeyClass() {
        return this.isAutomaticIdentity() ? this.getPrimaryKey().getType() : this.getPrimaryKeyClass();
    }

    public ContainerManagedField getPrimaryKey(EJBDeploymentContext container, DatabaseSchema schema) throws InstantiationException {
        this.initPropertyDescriptorsAndConvertNameToLowercase();
        ContainerManagedField primaryKey = this.getPrimaryKey();
        if (primaryKey == null || primaryKey.getType() == null) {
            Object field;
            if (this.getPrimaryKeyFieldName() != null) {
                Iterator fields = this.getContainerManagedFields().iterator();
                while (fields.hasNext()) {
                    field = (ContainerManagedField)fields.next();
                    if (!((ContainerManagedField)field).getName().equals(this.getPrimaryKeyFieldName())) continue;
                    primaryKey = field;
                    this.setPrimaryKeyField(primaryKey);
                }
                if (primaryKey == null) {
                    throw new InstantiationException("The specified primkey-field '" + this.getPrimaryKeyFieldName() + "' was not found among the cmp-fields for the bean " + this.getName());
                }
            } else {
                if (primaryKey == null) {
                    primaryKey = new ContainerManagedField(null, (PrimaryKeyContext)this, "");
                    this.setPrimaryKeyField(primaryKey);
                }
                primaryKey.setPersistenceType(3);
            }
            try {
                if (this.getPrimaryKeyFieldName() != null) {
                    if (primaryKey == null) {
                        throw new NullPointerException("primaryKey was null");
                    }
                    if (this.getEJBClass() == null) {
                        throw new NullPointerException("Missing ejb-class for entity " + this.getName());
                    }
                    Class<?> type = null;
                    if (this.isCMP2_0()) {
                        type = this.getPropertyType(this.getPrimaryKeyFieldName(), primaryKey);
                    } else {
                        field = this.getEJBClass().getField(this.getPrimaryKeyFieldName());
                        if (field == null) {
                            throw new InstantiationException("Class '" + this.getEJBClass().getName() + "' does not contain a field named '" + this.getPrimaryKeyFieldName() + "'");
                        }
                        type = ((Field)field).getType();
                    }
                    primaryKey.init(container, schema, null, type);
                    this.getContainerManagedFields().remove(primaryKey);
                } else if (this.isAutomaticIdentity()) {
                    primaryKey.setName("<<auto id>>");
                    primaryKey.setPersistenceType(1);
                    primaryKey.init(container, schema, null, Long.class);
                    this.primaryKeyClass = Long.class;
                } else {
                    primaryKey.init(container, schema, null, this.getPrimaryKeyClass());
                    this.getContainerManagedFields().removeAll(primaryKey.getPropertyFields());
                    if (this.isCMP2_0()) {
                        Iterator keyIter = primaryKey.getPropertyFields().iterator();
                        while (keyIter.hasNext()) {
                            field = (ContainerManagedField)keyIter.next();
                            Class type = null;
                            type = this.getPropertyType(((ContainerManagedField)field).getName(), (ContainerManagedField)field);
                            ((ContainerManagedField)field).setType(type);
                            ((ContainerManagedField)field).setPersistenceType(1);
                        }
                    }
                }
            }
            catch (NoSuchFieldException e) {
                throw new InstantiationException("cmp-field '" + this.getPrimaryKeyFieldName() + "' not found in class " + this.getEJBClassName());
            }
        }
        if (primaryKey.getType() == null) {
            throw new InternalError("Primary key type was null");
        }
        return primaryKey;
    }

    private boolean containsCMPField(String name) {
        return !this.getContainerManagedFields().isEmpty() && this.getContainerManagedField(name, this) != null;
    }

    public void initializeCMPFields(EJBDeploymentContext container) throws InstantiationException {
        this.initializeCMPFields(container, null);
    }

    public void initializeCMPFields(EJBDeploymentContext container, ORNameMapper nameMapper) throws InstantiationException {
        if (!this.isContainerManaged() || this.fieldsInitialized) {
            return;
        }
        this.fieldsInitialized = true;
        this.setDataSourceName(container.getProperCMTSourceName(this.getDataSourceName()));
        DatabaseSchema schema = container.getDatabaseSchema(this.getDataSourceName());
        this.getPrimaryKey(container, schema);
        Iterator iterator = this.getContainerManagedFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            try {
                Class<?> fieldType = this.isCMP2_0() ? this.getPropertyType(field.getName(), field) : this.getEJBClass().getField(field.getName()).getType();
                field.init(container, nameMapper, schema, this.getEJBClass(), fieldType);
            }
            catch (NoSuchFieldException e) {
                throw new InstantiationException("cmp-field '" + field.getName() + "' not found in class " + this.getEJBClassName());
            }
        }
    }

    public void initializeOCAField(EJBDeploymentContext container, ORNameMapper nameMapper) throws InstantiationException {
        if (this.fieldsInitialized) {
            return;
        }
        this.fieldsInitialized = true;
        Iterator iterator = this.getContainerManagedFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            try {
                Class<?> fieldType = this.isCMP2_0() ? this.getPropertyType(field.getName(), field) : this.getEJBClass().getField(field.getName()).getType();
                field.setType(fieldType);
            }
            catch (NoSuchFieldException e) {
                throw new InstantiationException("cmp-field '" + field.getName() + "' not found in class " + this.getEJBClassName());
            }
        }
    }

    public Set getContainerManagedFields() {
        if (this.containerManagedFields == null) {
            this.containerManagedFields = new ArraySet();
        }
        return this.containerManagedFields;
    }

    public void addContainerManagedField(ContainerManagedField field) {
        this.getContainerManagedFields().add(field);
        this.firePropertyChangeEvent("containerManagedFields", null, field);
    }

    public ContainerManagedField getContainerManagedField(String name, boolean caseSensitive) {
        ContainerManagedField field;
        ContainerManagedField primaryKey = this.getPrimaryKey();
        if (primaryKey != null) {
            if (primaryKey.getPersistenceType() == 3 || primaryKey.getPersistenceType() == 2) {
                Iterator keyIter = primaryKey.getPropertyFields().iterator();
                while (keyIter.hasNext()) {
                    field = (ContainerManagedField)keyIter.next();
                    if (!(caseSensitive ? field.getDatabaseName().equals(name) : field.getDatabaseName().equalsIgnoreCase(name))) continue;
                    return field;
                }
            }
            if (caseSensitive ? primaryKey.getDatabaseName().equals(name) : primaryKey.getDatabaseName().equalsIgnoreCase(name)) {
                return primaryKey;
            }
        }
        if (this.getContainerManagedFields().isEmpty()) {
            return null;
        }
        Iterator fieldIter = this.getContainerManagedFields().iterator();
        while (fieldIter.hasNext()) {
            field = (ContainerManagedField)fieldIter.next();
            if (!(caseSensitive ? field.getDatabaseName().equals(name) : field.getDatabaseName().equalsIgnoreCase(name))) continue;
            return field;
        }
        return null;
    }

    public ContainerManagedField getContainerManagedField(String name, PrimaryKeyContext context) {
        ContainerManagedField field;
        Iterator iterator;
        ContainerManagedField primaryKey = this.getPrimaryKey();
        if (primaryKey != null && primaryKey.getPersistenceType() != 0) {
            if (primaryKey.getPersistenceType() == 3 || primaryKey.getPersistenceType() == 2) {
                iterator = primaryKey.getPropertyFields().iterator();
                while (iterator.hasNext()) {
                    field = (ContainerManagedField)iterator.next();
                    if (!field.getName().equals(name)) continue;
                    return field;
                }
            } else if (primaryKey.getName().equals(name)) {
                return primaryKey;
            }
        }
        if (this.getContainerManagedFields().isEmpty()) {
            return null;
        }
        iterator = this.getContainerManagedFields().iterator();
        while (iterator.hasNext()) {
            field = (ContainerManagedField)iterator.next();
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public void addFinderMethod(FinderMethod method) {
        if (this.finderMethods == null) {
            this.finderMethods = new ArrayList();
        }
        if (method.getMethod() != null) {
            method.setEJBQuery(this.getEJBQuery(method.getMethod()));
        }
        this.finderMethods.add(method);
    }

    public List getFinderMethods() {
        if (this.finderMethods == null) {
            return Collections.EMPTY_LIST;
        }
        return this.finderMethods;
    }

    public FinderMethod getFinderMethod(Method method) {
        int level = 0;
        FinderMethod finder = null;
        if (this.finderMethods != null) {
            Iterator finders = this.finderMethods.iterator();
            while (finders.hasNext()) {
                int newLevel;
                FinderMethod newFinder = (FinderMethod)finders.next();
                if (newFinder == null || newFinder.getMethod() == null || (newLevel = newFinder.getMethod().implies(this.getName(), method, 0)) <= level) continue;
                level = newLevel;
                finder = newFinder;
            }
        }
        return finder;
    }

    public List getQueries() {
        return this.queries;
    }

    public void addQuery(EJBQuery query) {
        if (this.queries == null) {
            this.queries = new ArrayList();
        }
        this.queries.add(query);
    }

    public EJBQuery getEJBQuery(Method method) {
        int level = 0;
        EJBQuery query = null;
        if (this.getQueries() != null) {
            Iterator queries = this.getQueries().iterator();
            while (queries.hasNext()) {
                int newLevel;
                EJBQuery newQuery = (EJBQuery)queries.next();
                if (newQuery.getMethod() == null || (newLevel = newQuery.getMethod().implies(this.getName(), method, 0)) <= level) continue;
                level = newLevel;
                query = newQuery;
            }
        }
        return query;
    }

    private EJBQuery getEJBQuery(MethodDescriptor method) {
        int level = 0;
        EJBQuery query = null;
        if (this.getQueries() != null) {
            Iterator queries = this.getQueries().iterator();
            while (queries.hasNext()) {
                int newLevel;
                EJBQuery newQuery = (EJBQuery)queries.next();
                if (newQuery == null || newQuery.getMethod() == null || (newLevel = newQuery.getMethod().implies(method)) <= level) continue;
                level = newLevel;
                query = newQuery;
            }
        }
        return query;
    }

    public DataSourceConnectionContainer getDataSourceContainer(EJBContainer container) throws InstantiationException {
        DataSourceConnectionContainer dsContainer;
        this.setDataSourceName(container.getApplication().getProperCMTSourceName(this.getDataSourceName()));
        if (this.getIsolationLevel() == 0) {
            dsContainer = container.getApplication().getDataSourceContainer(this.getDataSourceName(), 2);
            dsContainer.setIsolationSet(false);
        } else {
            dsContainer = container.getApplication().getDataSourceContainer(this.getDataSourceName(), this.getIsolationLevel());
            dsContainer.setIsolationSet(true);
        }
        return dsContainer;
    }

    public Method getFindByPrimaryKeyMethod(boolean local) throws InstantiationException {
        Class homeClass;
        Method findByPrimaryKeyMethod = null;
        Class clazz = homeClass = local ? this.getLocalHome() : this.getRemoteHome();
        if (homeClass == null) {
            throw new NullPointerException((local ? "local " : "") + "homeclass was null");
        }
        Method[] methods = homeClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("findByPrimaryKey") || methods[i].getParameterTypes().length != 1 || !ClassUtils.equalsIgnorePrimitive(methods[i].getParameterTypes()[0], this.getPrimaryKeyClass()) && methods[i].getParameterTypes()[0] != (class$java$lang$Object == null ? EntityBeanDescriptor.class$("java.lang.Object") : class$java$lang$Object)) continue;
            findByPrimaryKeyMethod = methods[i];
            break;
        }
        if (findByPrimaryKeyMethod == null) {
            throw new InstantiationException("No method matching 'public " + this.getRemoteHomeName() + " findByPrimaryKey(" + this.getPrimaryKeyClassName() + ")' found in " + this.getRemoteHomeName());
        }
        if (!findByPrimaryKeyMethod.getReturnType().equals(local ? this.getLocalInterface() : this.getRemoteInterface())) {
            throw new InstantiationException("Invalid return-type for " + findByPrimaryKeyMethod + ", " + this.getRemoteInterfaceName() + " expected");
        }
        return findByPrimaryKeyMethod;
    }

    public ClassLoader getClassLoader() {
        return this.getEJBPackage().getEJBClassLoader();
    }

    public PropertyDescriptor[] getProperties() {
        return this.properties;
    }

    private void initPropertyDescriptorsAndConvertNameToLowercase() throws InstantiationException {
        if (this.properties == null) {
            try {
                BeanInfo info = Introspector.getBeanInfo(this.getEJBClass());
                this.properties = info.getPropertyDescriptors();
                for (int i = 0; i < this.properties.length; ++i) {
                    this.properties[i].setName(this.lowerFirstCharacter(this.properties[i].getName()));
                }
            }
            catch (IntrospectionException e) {
                throw (InstantiationException)new InstantiationException(e.getMessage()).initCause(e);
            }
            finally {
                Introspector.flushFromCaches(this.getEJBClass());
            }
        }
    }

    private String lowerFirstCharacter(String original) {
        if (Character.isUpperCase(original.charAt(0))) {
            char[] old = original.toCharArray();
            old[0] = original.substring(0, 1).toLowerCase().charAt(0);
            return new String(old);
        }
        return original;
    }

    public Class getPropertyType(String name, ContainerManagedField field) throws InstantiationException {
        try {
            PropertyDescriptor[] descriptors = this.getProperties();
            Object fieldType = null;
            if (this.isCMP2_0()) {
                for (int i = 0; i < descriptors.length; ++i) {
                    if (!descriptors[i].getName().equals(name)) continue;
                    field.setPropertyDescriptor(descriptors[i]);
                    if (descriptors[i].getWriteMethod() != null) {
                        return descriptors[i].getWriteMethod().getParameterTypes()[0];
                    }
                    if (descriptors[i].getReadMethod() == null) continue;
                    return this.replaceIsMethods(descriptors[i]);
                }
            }
            if (field.getEJBRelationshipRole() != null && field.getEJBRelationshipRole().getRelation().unspecifiedCMRField()) {
                if (field.getPeer().isMany()) {
                    if (field.getPeer().isMany()) {
                        if ("java.util.Set".equals(field.getPeer().getRelation().getType())) {
                            return Set.class;
                        }
                        return Collection.class;
                    }
                    return Set.class;
                }
                EntityBeanDescriptor peer = (EntityBeanDescriptor)field.getPeer().getRelation().getResolved().getOwner();
                Class type = peer.getLocalInterface() != null ? peer.getLocalInterface() : peer.getRemoteInterface();
                if (type == null) {
                    throw new NullPointerException("type was null");
                }
                return type;
            }
            if (field.isOCA()) {
                if (this.getCommitOption().getType().equals("int")) {
                    return Integer.TYPE;
                }
                if (this.getCommitOption().getType().equals("long")) {
                    return Long.TYPE;
                }
                throw new InstantiationException("No valid type found for Optimistic Control Attribute in bean " + this.getName());
            }
            StringBuffer propertiesBuffer = new StringBuffer();
            for (int i = 0; i < descriptors.length; ++i) {
                if (i > 0) {
                    propertiesBuffer.append(", ");
                }
                propertiesBuffer.append(descriptors[i].getName());
            }
            throw new InvalidEJBAssemblyException("No abstract getter/setter found for cm" + (field.getPeer() != null ? "r" : "p") + "-field " + name + " in entity " + this.getName() + ", found properties were: " + propertiesBuffer.toString(), "10.3.1");
        }
        catch (IntrospectionException e) {
            throw new InvalidEJBAssemblyException("Error introspecting bean-class " + this.getEJBClassName() + ": " + e.getMessage(), "10.3.1");
        }
    }

    private Class replaceIsMethods(PropertyDescriptor descriptor) throws IntrospectionException {
        Method readMethod;
        if (!Modifier.isAbstract(descriptor.getReadMethod().getModifiers()) && descriptor.getReadMethod().getName().startsWith("is")) {
            Method writeMethod;
            block9: {
                readMethod = null;
                writeMethod = null;
                String upperCaseName = Character.toUpperCase(descriptor.getName().charAt(0)) + descriptor.getName().substring(1);
                try {
                    readMethod = this.getEJBClass().getMethod("get" + upperCaseName, new Class[0]);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    String matchName = "set" + upperCaseName;
                    if (readMethod != null) {
                        writeMethod = this.getEJBClass().getMethod(matchName, readMethod.getReturnType());
                        break block9;
                    }
                    Method[] methods = this.getEJBClass().getMethods();
                    for (int y = 0; y < methods.length; ++y) {
                        if (!methods[y].getName().equals(matchName) || methods[y].getParameterTypes().length != 1) continue;
                        writeMethod = methods[y];
                        break;
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (readMethod != null || writeMethod != null) {
                descriptor = new PropertyDescriptor(descriptor.getName(), readMethod, writeMethod);
            }
        }
        if ((readMethod = descriptor.getReadMethod()) != null) {
            return readMethod.getReturnType();
        }
        return descriptor.getWriteMethod().getReturnType();
    }

    public boolean isPropertyMethod(Method method) throws IntrospectionException {
        PropertyDescriptor property;
        int i;
        boolean isValid = false;
        PropertyDescriptor[] properties = this.getProperties();
        for (i = 0; i < properties.length; ++i) {
            property = properties[i];
            if (property.getReadMethod() != null && property.getReadMethod().equals(method)) {
                if (this.checkPKPropertyMethod(property)) {
                    isValid = true;
                    break;
                }
                if (this.containsCMPField(property.getName())) {
                    isValid = true;
                    break;
                }
            }
            if (property.getWriteMethod() == null || !property.getWriteMethod().equals(method)) continue;
            if (this.checkPKPropertyMethod(property)) {
                isValid = true;
                break;
            }
            if (!this.containsCMPField(property.getName())) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            for (i = 0; i < properties.length; ++i) {
                property = properties[i];
                if (property.getReadMethod() != null && ClassUtils.signatureEquals(property.getReadMethod(), method) && this.containsCMPField(property.getName())) {
                    isValid = true;
                    break;
                }
                if (property.getWriteMethod() == null || !ClassUtils.signatureEquals(property.getWriteMethod(), method) || !this.containsCMPField(property.getName())) continue;
                isValid = true;
                break;
            }
        }
        if (!isValid && (method.getName().startsWith("get") || method.getName().startsWith("set"))) {
            for (i = 0; i < properties.length; ++i) {
                PropertyDescriptor newProperty;
                property = properties[i];
                String supposedName = "get" + Character.toUpperCase(property.getName().charAt(0)) + property.getName().substring(1);
                if (supposedName.equals(method.getName()) && property.getReadMethod() != null && !Modifier.isAbstract(property.getReadMethod().getModifiers())) {
                    PropertyDescriptor newProperty2;
                    Method writeMethod = null;
                    try {
                        writeMethod = method.getDeclaringClass().getMethod("set" + Character.toUpperCase(property.getName().charAt(0)) + property.getName().substring(1), method.getReturnType());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    properties[i] = newProperty2 = new PropertyDescriptor(property.getName(), method, writeMethod);
                    isValid = true;
                    break;
                }
                supposedName = "set" + Character.toUpperCase(property.getName().charAt(0)) + property.getName().substring(1);
                if (!supposedName.equals(method.getName()) || property.getReadMethod() == null || Modifier.isAbstract(property.getReadMethod().getModifiers())) continue;
                Method readMethod = null;
                try {
                    readMethod = method.getDeclaringClass().getMethod("get" + Character.toUpperCase(property.getName().charAt(0)) + property.getName().substring(1), method.getReturnType());
                }
                catch (Throwable t) {
                    // empty catch block
                }
                properties[i] = newProperty = new PropertyDescriptor(property.getName(), readMethod, method);
                isValid = true;
                break;
            }
        }
        return isValid;
    }

    public String isDeployed() {
        if (this.isTopLinkCMP()) {
            String reason = this.checkBeanUpdate();
            if (reason != null) {
                return reason;
            }
        } else {
            String deployed = super.isDeployed();
            if (deployed != null) {
                return deployed;
            }
        }
        String pkName = this.getPrimaryKeyClassName();
        try {
            if (ContextUtils.isInContext(this.getEJBPackage().getContext(), pkName)) {
                return this.checkClassForUpdate(this.getPrimaryKeyClassName());
            }
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        return null;
    }

    public AbstractEJBHome createHomeInstance(EJBContainer container, ClassLoader loader, boolean local) throws InstantiationException {
        try {
            Class<Object> homeClass = null;
            if (this.isTopLinkCMP()) {
                homeClass = local ? this.getLocalHomeWrapper() : this.getRemoteHomeWrapper();
            } else {
                String className;
                String string = className = local ? this.getLocalHomeWrapperName() : this.getRemoteHomeWrapperName();
                if (className == null) {
                    throw new InstantiationException("wrapper class name not specified in orion-ejb-jar.xml; redeploy");
                }
                homeClass = Class.forName(className, true, loader);
            }
            DBEntityEJBHome retHome = this.createNewHomeInstance(homeClass, container);
            if (this.getCommitOption().isCacheable() || this.isReadOnlyBMP()) {
                this.initCache(retHome);
            }
            return retHome;
        }
        catch (NoClassDefFoundError e) {
            this.getEJBPackage().getContainer().getApplication().log("Error creating home instance for " + this.getName(), e);
            throw new InstantiationException("Error creating home instance, unable to load stub classes (" + e.getMessage() + ")");
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (Throwable t) {
            container.getApplication().log("Internal server error", t);
            throw new InstantiationException("Internal server error: " + t.getClass().getName() + " (" + t.getMessage() + ")");
        }
    }

    private DBEntityEJBHome createNewHomeInstance(Class homeClass, EJBContainer container) throws InstantiationException, IllegalAccessException {
        DBEntityEJBHome homeInstance = (DBEntityEJBHome)homeClass.newInstance();
        homeInstance.setBeanDescriptor(this);
        homeInstance.setHasExclusiveWriteAccess(this.hasExclusiveWriteAccess());
        if (this.isContainerManaged()) {
            homeInstance.dataSourceContainer = this.getDataSourceContainer(container);
        }
        homeInstance.setContainer(container, this.getPackage().getDeployment(), this.getRoleReferences());
        homeInstance.setClusteringSchema(this.getClusteringSchema());
        homeInstance.OC4J_setBindingPath(this.getLocation());
        homeInstance.setLockingMode(this.getLockingMode());
        return homeInstance;
    }

    public void setEjbqlDescriptor(Object value) {
        this.ejbqlDescriptor = value;
        ((EjbCMPEntityDescriptor)value).getPersistenceDescriptor().setOc4jEntity(this);
    }

    public Hashtable getFieldsMap() {
        return this.fieldsMap;
    }

    public void addFieldToMap(String aFieldName, String aColumnName) {
        this.fieldsMap.put(aFieldName, aColumnName);
    }

    public void setCmp20_compiled(boolean _compiled) {
        this.cmp20_compiled = _compiled;
    }

    public boolean getCmp20_compiled() {
        return this.cmp20_compiled;
    }

    public void setEntityBeanCompilation(EntityBeanCompilation _ebCompilation, boolean local) {
        if (local) {
            this.localEntityBeanCompilation = _ebCompilation;
        } else {
            this.remoteEntityBeanCompilation = _ebCompilation;
        }
    }

    public EntityBeanCompilation getEntityBeanCompilation(boolean local) {
        return local ? this.localEntityBeanCompilation : this.remoteEntityBeanCompilation;
    }

    public ContainerEntityDescriptor getEntityDescriptor() {
        if (this.entityDescriptorImpl == null) {
            this.entityDescriptorImpl = this.buildEntityDescriptor();
        }
        return this.entityDescriptorImpl;
    }

    private ContainerEntityDescriptor buildEntityDescriptor() {
        EntityDescriptorImpl ed = new EntityDescriptorImpl();
        ed.setEntityBeanDescriptor(this);
        ed.setConcreteBeanClassName(this.getConcreteBeanClassName());
        ed.setLocalImplClassName(this.getLocalWrapperName());
        ed.setRemoteImplClassName(this.getRemoteWrapperName());
        ed.setHomeImplClassName(this.getRemoteHomeWrapperName());
        ed.setLocalHomeImplClassName(this.getLocalHomeWrapperName());
        ed.setEJB20(this.isCMP2_0());
        ed.setCMP(this.isContainerManaged());
        ed.setWrapperClassLoader((ClassLoader)this.getEJBPackage().getDeployment().getEJBClassLoader());
        ed.setBeanName(this.getName());
        ed.setJarName(this.getEJBPackage().getName());
        ed.setApplicationName(this.getEJBPackage().getContainer().getApplication().getName());
        ed.setEntityAbstractEJBSchemaName(this.getAbstractSchemaName());
        ed.setPMDescriptor(this.getPersistenceManagerDescriptor().getDescriptorName());
        ed.setPMProperties(this.getPersistenceManagerDescriptor().getProperties());
        ed.setEJBClass(this.getEJBClass());
        ed.setRemoteIntfClass(this.getRemoteInterface());
        ed.setRemoteIntfName(this.getRemoteInterfaceName());
        ed.setLocalIntfClass(this.getLocalInterface());
        ed.setLocalIntfName(this.getLocalInterfaceName());
        ed.setHomeIntfName(this.getRemoteHomeName());
        ed.setHomeIntfClass(this.getRemoteHome());
        ed.setLocalHomeIntfName(this.getLocalHomeName());
        ed.setLocalHomeIntfClass(this.getLocalHome());
        ed.setPrimaryKeyClassName(this.getPrimaryKeyClassName());
        ed.setPrimaryKeyFieldName(this.getPrimaryKeyFieldName());
        ed.setIsAutoCreateTables(this.getEJBPackage().getContainer().getConfig().getAutoCreateTables());
        ed.setIsAutoDeleteTables(this.getEJBPackage().getContainer().getConfig().getAutoDeleteTables());
        if (this.getDataSourceName() == null) {
            this.fillDataSourceName();
        }
        ed.setDSName(this.getDataSourceName());
        ed.setPMDescriptor(this.getPersistenceManagerDescriptor());
        ed.setFinderDescriptors(this.buildFinderDescriptors());
        ed.setRelationshipDescriptors(this.getEJBPackage().getRelationshipDescriptorsForBean(this.getName()));
        return ed;
    }

    public Object getEjbqlDescriptor() {
        return this.ejbqlDescriptor;
    }

    public boolean hasNonNativeOC4JPM() {
        return this.isContainerManaged() && !this.getPersistenceManagerDescriptor().isOrionPM();
    }

    private void fillDataSourceName() {
        if (this.isContainerManaged()) {
            try {
                if (this.getEJBPackage().getApplication().getDefaultDataSource() != null) {
                    this.setDataSourceName(this.getEJBPackage().getApplication().getDefaultDataSource());
                } else {
                    this.setDataSourceName(this.getEJBPackage().getContainer().getApplication().getDefaultDataSourceJNDILocation());
                }
            }
            catch (Exception e) {
                EJBDeploymentMessages.warningGettingDataSourceName(this, e);
            }
        }
    }

    private Collection buildFinderDescriptors() {
        if (this.getQueries() == null) {
            return null;
        }
        ArrayList<FinderDescriptorImpl> finderDescriptors = new ArrayList<FinderDescriptorImpl>(this.getQueries().size());
        Iterator i = this.getQueries().iterator();
        while (i.hasNext()) {
            EJBQuery query = (EJBQuery)i.next();
            FinderDescriptorImpl fd = new FinderDescriptorImpl();
            fd.setEjbqlString(query.getQuery());
            fd.setIsRemoteQuery(query.getResultTypeRemotes());
            fd.setMethodName(query.getMethod().getName());
            fd.setMethodParams(Arrays.asList(query.getMethod().getParameterNames()));
            finderDescriptors.add(fd);
        }
        return finderDescriptors;
    }

    public InputStream getDeployedPMDescriptor() {
        return this.getEJBPackage().getDeployedPMDescriptor(this.getPersistenceManagerDescriptor().getDescriptorName());
    }

    protected BeanPool createBeanPool(Object home) {
        if (this.isBMP()) {
            return new BMPOrionEntityBeanPool(this, (EntityEJBHome)home);
        }
        if (this.isTopLinkCMP()) {
            return new EntityBeanPool(this, (EntityEJBHome)home);
        }
        return new BMPOrionEntityBeanPool(this, (EntityEJBHome)home);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setIsBMP(boolean isBmp) {
        this.isBMP = isBmp;
        if (isBmp) {
            this.setPrimaryKeyFieldName(null);
            this.containerManagedFields = null;
        }
        this.firePropertyChangeEvent("containerManagedPersistence", null, isBmp ? Boolean.FALSE : Boolean.TRUE);
    }

    public void setIsReentrant(boolean isReentrant) {
        this.isReentrant = isReentrant;
    }

    public void setPrimaryKeyClassName(String primaryKeyClassName) {
        this.primaryKeyClassName = primaryKeyClassName;
        this.firePropertyChangeEvent("primaryKeyClass", null, this.primaryKeyClassName);
    }

    public void setAbstractSchemaName(String abstractSchemaName) {
        this.abstractSchemaName = abstractSchemaName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKeyFieldName(String primaryKeyFieldName) {
        this.primaryKeyFieldName = primaryKeyFieldName;
        this.firePropertyChangeEvent("primaryKeyField", null, this.primaryKeyField);
    }

    public void setValidityTimeout(long timeout) {
        this.validityTimeout = timeout;
    }

    public void setClusteringSchema(int type) {
        this.clusteringSchema = type;
    }

    public void setIsolationLevel(int level) {
        this.isolationLevel = level;
    }

    public void setFindByPrimaryKeyLazyLoading(boolean lazyLoad) {
        this.findByPrimaryKeyLazyLoading = new Boolean(lazyLoad);
    }

    public void setExclusiveWriteAccess(boolean exclusiveWriteAccess) {
        this.exclusiveWriteAccess = exclusiveWriteAccess;
    }

    public void setSelectBeforeInsert(boolean selectBeforeInsert) {
        this.selectBeforeInsert = selectBeforeInsert;
    }

    public void setDataSynchronizationOption(DataSynchronizationOptionDescriptor newSynchronizationOption) {
        this.dataSynchronizationOption = newSynchronizationOption;
    }

    public void setLockingMode(int lockingMode) {
        this.lockingMode = lockingMode;
    }

    public void setDelayUpdatesUntilCommit(boolean delayUpdatesUntilCommit) {
        this.delayUpdatesUntilCommit = delayUpdatesUntilCommit;
    }

    public void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    public void setUpdateChangedFieldsOnly(boolean updateChangedFieldsOnly) {
        this.updateChangedFieldsOnly = updateChangedFieldsOnly;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setConcreteBeanClassName(String concreteBeanClassName) {
        this.concreteBeanClassName = concreteBeanClassName;
    }

    public void setPrimaryKeyField(ContainerManagedField primaryKeyField) {
        this.primaryKeyField = primaryKeyField;
    }

    public void setCommitOptionDescriptor(CommitOptionDescriptor commitOptionDescriptor) {
        this.commitOptionDescriptor = commitOptionDescriptor;
    }

    public int getTTL() {
        return this.getCommitOption().getTTL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initCache(ExtendedComparator comp) {
        if (this.getCache() == null) {
            EntityBeanDescriptor entityBeanDescriptor = this;
            synchronized (entityBeanDescriptor) {
                if (this.isBMP()) {
                    this.init(this, comp, BMPCacheManager.instance(), this.getCommitOption().getNumberOfBuckets());
                } else {
                    this.init(this, comp, CMPCacheManager.instance(), this.getCommitOption().getNumberOfBuckets());
                }
                if (m_logger.isLoggable(Level.FINE)) {
                    m_logger.log(Level.FINE, "Bean TTL= " + this.getCommitOption().getTTL());
                }
            }
        }
        return true;
    }

    private void init(BeanDescriptor desc, ExtendedComparator comp, CachePolicy pol, int buckets) {
        if (this.cache == null) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "initCache with " + buckets + " buckets.");
            }
            if (desc instanceof EntityBeanDescriptor) {
                EntityBeanDescriptor desc2 = (EntityBeanDescriptor)desc;
                this.cache = ObjectHashTableFactory.getInstance().getObjectHashTable(desc2, comp, pol, buckets);
                EntityCacheManager.instance().registerDescriptor(this.getName(), this);
            }
        }
    }

    public Object updateCache(Object key, Object pm) {
        Object obj = this.getCache().putClone(key, null, pm);
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "updateCache key:" + key + " value:" + pm + " old:" + obj);
        }
        return obj;
    }

    public Object cloneFromCache(Object key, Object dest) {
        Object obj = this.getCache().getClone(key, dest, false);
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINER, "cloneFromCache key:" + key + " clone:" + obj + " dest:" + dest);
        }
        return obj;
    }

    public ExtendedContainerManagedObject removeFromCache(Object key) {
        Object obj = this.getCache().remove(key, false);
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "removeFromCache key:" + key + " old:" + obj);
        }
        return (ExtendedContainerManagedObject)obj;
    }

    public Object getOCAValue(Object key, String controlFieldName) throws IllegalAccessException {
        Object obj = this.getCache().get(key, false);
        Object anOCAValue = null;
        if (obj != null) {
            anOCAValue = PrivateAccessor.getPrivateFieldValue(obj, controlFieldName);
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "oca value for key:" + key + " oca:" + anOCAValue);
        }
        return anOCAValue;
    }

    public AlternateHashTable getCache() {
        return this.cache;
    }

    public BeanDescriptorXMLFactory getBeanDescriptorXMLFactory() {
        return EntityBeanDescriptorXMLFactory.getInstance();
    }

    private boolean checkPKPropertyMethod(PropertyDescriptor property) {
        if (this.getPrimaryKeyFieldName() != null) {
            if (this.getPrimaryKeyFieldName().endsWith(property.getName())) {
                return true;
            }
        } else if (this.primaryKeyField != null && this.primaryKeyField.getPropertyFields() != null) {
            Iterator itrpkfield = this.primaryKeyField.getPropertyFields().iterator();
            while (itrpkfield.hasNext()) {
                ContainerManagedField pkField = (ContainerManagedField)itrpkfield.next();
                if (!pkField.getName().equals(property.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

