/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.deployment.EJBRelationshipRole;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EJBRelationship
extends AbstractDescribable
implements XMLizable {
    EJBRelationshipRole firstRole;
    EJBRelationshipRole secondRole;
    private boolean cascadeDeleteForRole = false;

    public boolean isCascadeDeleteForRole() {
        return this.cascadeDeleteForRole;
    }

    public void setCascadeDeleteForRole(boolean deleteForRole) {
        this.cascadeDeleteForRole = deleteForRole;
    }

    public EJBRelationship(String name) {
        this.setName(name);
        this.firstRole = new EJBRelationshipRole(this, "First role");
        this.secondRole = new EJBRelationshipRole(this, "Second role");
    }

    public EJBRelationship(Node parent) throws InstantiationException {
        NodeList list = parent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.startsWith("#")) continue;
                if (name.equals("description")) {
                    this.setDescription(XMLUtils.getStringValue(node));
                    continue;
                }
                if (name.equals("ejb-relation-name")) {
                    this.setName(XMLUtils.getStringValue(node));
                    continue;
                }
                if (name.equals("ejb-relationship-role")) {
                    if (this.firstRole == null) {
                        this.firstRole = new EJBRelationshipRole(this, node);
                        continue;
                    }
                    this.secondRole = new EJBRelationshipRole(this, node);
                    continue;
                }
                throw new InstantiationException("Unknown ejb-relation subtag: " + name);
            }
        }
        if (this.secondRole == null) {
            throw new InstantiationException("ejb-relation must contain two (no more, no less) ejb-relationship-role tags");
        }
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<ejb-relation>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<ejb-relation-name>" + XMLUtils.encode(this.getName()) + "</ejb-relation-name>");
        }
        if (this.firstRole != null) {
            this.firstRole.writeXML(out, indention + "\t");
        }
        if (this.secondRole != null) {
            this.secondRole.writeXML(out, indention + "\t");
        }
        out.println(indention + "</ejb-relation>");
    }

    public void setFirstRole(EJBRelationshipRole role) {
        this.firstRole = role;
    }

    public void setSecondRole(EJBRelationshipRole role) {
        this.secondRole = role;
    }

    public EJBRelationshipRole getFirstRole() {
        return this.firstRole;
    }

    public EJBRelationshipRole getSecondRole() {
        return this.secondRole;
    }

    public String toString() {
        return "[Relationship: " + this.firstRole + " : " + this.secondRole + "]";
    }
}

