/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

public final class DataSynchronizationOptionDescriptor {
    public static final int UNKNOWN = 0;
    public static final int EJBCREATE = 1;
    public static final int EJBPOSTCREATE = 2;
    private int option = 0;

    public DataSynchronizationOptionDescriptor(int anOption) {
        this.option = anOption;
    }

    public DataSynchronizationOptionDescriptor(String anOption) {
        this.setOption(anOption);
    }

    public void setOption(int anOption) {
        this.option = anOption;
    }

    public void setOption(String anOption) {
        if (anOption.equalsIgnoreCase("ejbCreate")) {
            this.setOption(1);
        } else if (anOption.equalsIgnoreCase("ejbPostCreate")) {
            this.setOption(2);
        } else {
            System.err.println("unknown data-syncrhonization-option " + anOption);
        }
    }

    public int getOption() {
        return this.option;
    }

    public boolean isSynchronizedAtEjbPostCreate() {
        return this.getOption() == 2;
    }

    public boolean isSynchronizedAtEjbCreate() {
        return this.getOption() == 1;
    }

    public boolean isUnknown() {
        return this.getOption() == 0;
    }

    public String toString() {
        switch (this.getOption()) {
            case 1: {
                return "ejbCreate";
            }
            case 2: {
                return "ejbPostCreate";
            }
            case 0: {
                return "unknown";
            }
        }
        return "unknown";
    }
}

