/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.deployment.AnnotationManager;
import com.evermind.server.deployment.J2EEContextAnnotationParser;
import com.evermind.server.deployment.SecurityIdentity;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.deployment.SecurityRoleReference;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.ApplicationException;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ContainerTransaction;
import com.evermind.server.ejb.deployment.EJBJarAnnotations;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.ExcludeList;
import com.evermind.server.ejb.deployment.InterceptorBinding;
import com.evermind.server.ejb.deployment.InterceptorDescriptor;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptorAnnotationParser;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.deployment.MethodPermission;
import com.evermind.server.ejb.deployment.SessionBeanDescriptorAnnotationParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;
import javax.ejb.Timer;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.interceptor.Interceptors;
import oracle.j2ee.deployment.AnnotationParsingMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanDescriptorAnnotationParser
extends J2EEContextAnnotationParser {
    public static void parseAnnotations(EJBPackage ejbPackage, Class cls, Object annotationManager) throws InstantiationException {
        BeanDescriptorAnnotationParser parser = BeanDescriptorAnnotationParser.getAnnotationParserForClass(cls);
        if (parser == null) {
            BeanDescriptorAnnotationParser.parseModuleAnnotations(ejbPackage, cls);
            return;
        }
        BeanDescriptor descriptor = parser.getDescriptor(ejbPackage, cls);
        BeanDescriptorAnnotationParser.parseAnnotations(parser, descriptor, cls, annotationManager);
    }

    public static void parseAnnotations(Object beanParser, BeanDescriptor descriptor, Class cls, Object annotationManager) throws InstantiationException {
        BeanDescriptorAnnotationParser parser = (BeanDescriptorAnnotationParser)beanParser;
        if (parser == null) {
            parser = BeanDescriptorAnnotationParser.buildParserForBeanDescriptor(descriptor);
        }
        AnnotationManager annotMgr = (AnnotationManager)annotationManager;
        parser.parseBeanAnnotations(descriptor, cls, annotMgr);
        Set<String> businessMethods = parser.getBusinessMethods(descriptor, cls);
        for (Method method : cls.getMethods()) {
            if (!parser.isBusinessMethod(descriptor, cls, method, businessMethods)) continue;
            parser.parseBusinessMethodAnnotations(descriptor, method, annotMgr);
        }
        for (Method method : annotMgr.getMethods(cls)) {
            parser.parseInjectedMethodAndCallbacks(descriptor, method);
        }
        for (Field field : annotMgr.getFields(cls)) {
            parser.parseInjectedField(descriptor.getConfigDelegate(), field);
        }
    }

    private static BeanDescriptorAnnotationParser getAnnotationParserForClass(Class cls) throws InstantiationException {
        BeanDescriptorAnnotationParser parser = null;
        int parserCount = 0;
        if (cls.isAnnotationPresent(EJBJarAnnotations.STATEFUL_ANNOTATION)) {
            parser = SessionBeanDescriptorAnnotationParser.getInstance();
            AnnotationParsingMessages.fineParsingAnnotatedClass(cls.getName(), EJBJarAnnotations.STATEFUL_ANNOTATION.getName());
            ++parserCount;
        }
        if (cls.isAnnotationPresent(EJBJarAnnotations.STATELESS_ANNOTATION)) {
            parser = SessionBeanDescriptorAnnotationParser.getInstance();
            AnnotationParsingMessages.fineParsingAnnotatedClass(cls.getName(), EJBJarAnnotations.STATELESS_ANNOTATION.getName());
            ++parserCount;
        }
        if (cls.isAnnotationPresent(EJBJarAnnotations.MESSAGE_DRIVEN_ANNOTATION)) {
            parser = MessageDrivenBeanDescriptorAnnotationParser.getInstance();
            AnnotationParsingMessages.fineParsingAnnotatedClass(cls.getName(), EJBJarAnnotations.MESSAGE_DRIVEN_ANNOTATION.getName());
            ++parserCount;
        }
        if (parserCount > 1 && parser != null) {
            throw new InstantiationException("Bean class may only have one of @Stateless, @Stateful or @MessageDriven");
        }
        return parser;
    }

    private static BeanDescriptorAnnotationParser buildParserForBeanDescriptor(BeanDescriptor descriptor) throws InstantiationException {
        BeanDescriptorAnnotationParser parser = null;
        if (descriptor.isSession()) {
            parser = SessionBeanDescriptorAnnotationParser.getInstance();
            AnnotationParsingMessages.fineParsingAnnotatedClass(descriptor.getName(), EJBJarAnnotations.STATEFUL_ANNOTATION.getName());
        }
        if (descriptor.isMessageDriven()) {
            parser = MessageDrivenBeanDescriptorAnnotationParser.getInstance();
            AnnotationParsingMessages.fineParsingAnnotatedClass(descriptor.getName(), EJBJarAnnotations.MESSAGE_DRIVEN_ANNOTATION.getName());
        }
        return parser;
    }

    public static void parseModuleAnnotations(EJBPackage ejbPackage, Class cls) {
        BeanDescriptorAnnotationParser.parseApplicationExceptionAnnotation(ejbPackage, cls);
    }

    public static ApplicationException parseApplicationExceptionAnnotation(EJBPackage ejbPackage, Class cls) {
        Object annot = cls.getAnnotation(EJBJarAnnotations.APPLICATION_EXCEPTION_ANNOTATION);
        if (annot != null) {
            AnnotationParsingMessages.fineParsingAnnotatedClass(cls.getName(), EJBJarAnnotations.APPLICATION_EXCEPTION_ANNOTATION.getName());
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.APPLICATION_EXCEPTION_ANNOTATION.getName());
            ApplicationException descriptor = new ApplicationException();
            descriptor.setClassName(cls.getName());
            descriptor.setRollback(((javax.ejb.ApplicationException)annot).rollback());
            ejbPackage.addApplicationException(descriptor);
            return descriptor;
        }
        return null;
    }

    protected abstract BeanDescriptor getDescriptor(EJBPackage var1, Class var2);

    protected void parseBeanAnnotations(BeanDescriptor descriptor, Class cls, AnnotationManager annotationManager) throws InstantiationException {
        descriptor.setEJBClassName(cls.getName());
        this.parseClassLevelAnnotations(descriptor.getConfigDelegate(), cls);
        Object annot = cls.getAnnotation(EJBJarAnnotations.TX_ATTRIBUTE_ANNOTATION);
        if (annot != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.TX_ATTRIBUTE_ANNOTATION.getName());
            this.parseTxAttributeAnnotation(descriptor, null, ((TransactionAttribute)annot).value());
        }
        if ((annot = cls.getAnnotation(EJBJarAnnotations.TRANSACTION_MGMT_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.TRANSACTION_MGMT_ANNOTATION.getName());
            this.parseTxManagementAnnotation(descriptor, ((TransactionManagement)annot).value());
        }
        this.parseInterceptors(cls, descriptor, annotationManager);
        annot = cls.getAnnotation(EJBJarAnnotations.ROLES_ALLOWED_ANNOTATION);
        if (annot != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.ROLES_ALLOWED_ANNOTATION.getName());
            if (cls.isAnnotationPresent(EJBJarAnnotations.PERMIT_ALL_ANNOTATION)) {
                throw new InstantiationException("Cannot have both @RolesAllowed and @PermitAll as class level annotations.");
            }
            this.parseRolesAllowedAnnotation(descriptor, null, ((RolesAllowed)annot).value());
        }
        if ((annot = cls.getAnnotation(EJBJarAnnotations.PERMIT_ALL_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.PERMIT_ALL_ANNOTATION.getName());
            if (cls.isAnnotationPresent(EJBJarAnnotations.ROLES_ALLOWED_ANNOTATION)) {
                throw new InstantiationException("Cannot have both @RolesAllowed and @PermitAll as class level annotations.");
            }
            this.parsePermitAllAnnotation(descriptor, null);
        }
        if ((annot = cls.getAnnotation(EJBJarAnnotations.RUN_AS_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.RUN_AS_ANNOTATION.getName());
            this.parseRunAsAnnotation(descriptor, ((RunAs)annot).value());
        }
        if ((annot = cls.getAnnotation(EJBJarAnnotations.DECLARE_ROLES_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.DECLARE_ROLES_ANNOTATION.getName());
            this.parseDeclareRolesAnnotation(descriptor, ((DeclareRoles)annot).value());
        }
    }

    private boolean isBusinessMethod(BeanDescriptor descriptor, Class cls, Method method, Set businessMethods) throws InstantiationException {
        return businessMethods.contains(EJBUtils.getUniqueMethodSignature(method));
    }

    protected abstract Set<String> getBusinessMethods(BeanDescriptor var1, Class var2) throws InstantiationException;

    protected void parseBusinessMethodAnnotations(BeanDescriptor descriptor, Method method, AnnotationManager annotMgr) throws InstantiationException {
        this.parseTxAttributeMethodAnnotations(descriptor, method);
        this.parseSecurityMethodAnnotations(descriptor, method);
        InterceptorBinding binding = this.parseInterceptors(method, descriptor, annotMgr);
        if (binding != null) {
            binding.setMethodDescriptor(new MethodDescriptor(null, method, 0));
        }
    }

    protected void parseTxAttributeMethodAnnotations(BeanDescriptor descriptor, Method method) throws InstantiationException {
        Object annot = method.getAnnotation(EJBJarAnnotations.TX_ATTRIBUTE_ANNOTATION);
        if (annot != null) {
            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.TX_ATTRIBUTE_ANNOTATION.getName(), method.getName());
            this.parseTxAttributeAnnotation(descriptor, method, ((TransactionAttribute)annot).value());
        } else if (!descriptor.getEJBClassName().equals(method.getDeclaringClass().getName()) && (annot = method.getDeclaringClass().getAnnotation(EJBJarAnnotations.TX_ATTRIBUTE_ANNOTATION)) != null) {
            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.TX_ATTRIBUTE_ANNOTATION.getName(), method.getName());
            this.parseTxAttributeAnnotation(descriptor, method, ((TransactionAttribute)annot).value());
        }
    }

    protected void parseSecurityMethodAnnotations(BeanDescriptor descriptor, Method method) throws InstantiationException {
        if (this.isMethodAnnotatedWithSecurity(method)) {
            if (method.isAnnotationPresent(EJBJarAnnotations.ROLES_ALLOWED_ANNOTATION) && method.isAnnotationPresent(EJBJarAnnotations.PERMIT_ALL_ANNOTATION)) {
                throw new InstantiationException("Cannot have both @RolesAllowed and @PermitAll as method level annotations.");
            }
            Object annot = method.getAnnotation(EJBJarAnnotations.ROLES_ALLOWED_ANNOTATION);
            if (annot != null) {
                AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.ROLES_ALLOWED_ANNOTATION.getName(), method.getName());
                this.parseRolesAllowedAnnotation(descriptor, method, ((RolesAllowed)annot).value());
            } else if (method.isAnnotationPresent(EJBJarAnnotations.PERMIT_ALL_ANNOTATION)) {
                AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.PERMIT_ALL_ANNOTATION.getName(), method.getName());
                this.parsePermitAllAnnotation(descriptor, method);
            } else if (method.isAnnotationPresent(EJBJarAnnotations.DENY_ALL_ANNOTATION)) {
                AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.DENY_ALL_ANNOTATION.getName(), method.getName());
                this.parseDenyAllAnnotation(descriptor, method);
            }
        } else if (!descriptor.getEJBClassName().equals(method.getDeclaringClass().getName())) {
            Object annot = method.getDeclaringClass().getAnnotation(EJBJarAnnotations.ROLES_ALLOWED_ANNOTATION);
            if (annot != null) {
                AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.ROLES_ALLOWED_ANNOTATION.getName(), method.getName());
                this.parseRolesAllowedAnnotation(descriptor, method, ((RolesAllowed)annot).value());
            } else if (method.getDeclaringClass().isAnnotationPresent(EJBJarAnnotations.PERMIT_ALL_ANNOTATION)) {
                AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.PERMIT_ALL_ANNOTATION.getName(), method.getName());
                this.parsePermitAllAnnotation(descriptor, method);
            } else if (method.getDeclaringClass().isAnnotationPresent(EJBJarAnnotations.DENY_ALL_ANNOTATION)) {
                AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.DENY_ALL_ANNOTATION.getName(), method.getName());
                this.parseDenyAllAnnotation(descriptor, method);
            }
        }
    }

    private boolean isMethodAnnotatedWithSecurity(Method method) {
        return method.isAnnotationPresent(EJBJarAnnotations.ROLES_ALLOWED_ANNOTATION) || method.isAnnotationPresent(EJBJarAnnotations.PERMIT_ALL_ANNOTATION) || method.isAnnotationPresent(EJBJarAnnotations.DENY_ALL_ANNOTATION);
    }

    public void parseInjectedMethodAndCallbacks(BeanDescriptor descriptor, Method method) throws InstantiationException {
        this.parseInjectedMethod(descriptor.getConfigDelegate(), method);
        BeanDescriptorAnnotationParser.parseInterceptorCallbacks(descriptor.getBeanInterceptor(), method);
    }

    private void parseTxManagementAnnotation(BeanDescriptor descriptor, TransactionManagementType mode) {
        if (mode == TransactionManagementType.BEAN) {
            descriptor.setTransactionType(1);
        } else {
            descriptor.setTransactionType(0);
        }
    }

    private void parseTxAttributeAnnotation(BeanDescriptor descriptor, Method method, TransactionAttributeType txType) throws InstantiationException {
        MethodDescriptor methodDesc = method == null ? new MethodDescriptor(descriptor.getName()) : new MethodDescriptor(descriptor.getName(), method, 0);
        ContainerTransaction tx = new ContainerTransaction(descriptor.getEJBPackage(), methodDesc);
        if (txType == TransactionAttributeType.REQUIRED) {
            tx.setTransactionType("Required");
        } else if (txType == TransactionAttributeType.REQUIRES_NEW) {
            tx.setTransactionType("RequiresNew");
        } else if (txType == TransactionAttributeType.MANDATORY) {
            tx.setTransactionType("Mandatory");
        } else if (txType == TransactionAttributeType.SUPPORTS) {
            tx.setTransactionType("Supports");
        } else if (txType == TransactionAttributeType.NOT_SUPPORTED) {
            tx.setTransactionType("NotSupported");
        } else if (txType == TransactionAttributeType.NEVER) {
            tx.setTransactionType("Never");
        }
        descriptor.getEJBPackage().addContainerTransaction(tx);
    }

    private InterceptorBinding parseInterceptors(AnnotatedElement annotElement, BeanDescriptor descriptor, AnnotationManager annotationManager) throws InstantiationException {
        Object interceptors = annotElement.getAnnotation(EJBJarAnnotations.INTERCEPTORS_ANNOTATION);
        boolean excludeDefault = annotElement.isAnnotationPresent(EJBJarAnnotations.EXCLUDE_DEFAULT_INTERCEPTORS_ANNOTATION);
        boolean excludeClass = annotElement.isAnnotationPresent(EJBJarAnnotations.EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION);
        if (interceptors != null || excludeDefault || excludeClass) {
            if (AnnotationParsingMessages.isLoggable(Level.FINEST)) {
                if (annotElement instanceof Class) {
                    if (interceptors != null) {
                        AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.INTERCEPTORS_ANNOTATION.getName());
                    }
                    if (excludeDefault) {
                        AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.EXCLUDE_DEFAULT_INTERCEPTORS_ANNOTATION.getName());
                    }
                    if (excludeClass) {
                        AnnotationParsingMessages.finestParsingClassLevelAnnotation(EJBJarAnnotations.EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION.getName());
                    }
                } else {
                    if (interceptors != null) {
                        AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.INTERCEPTORS_ANNOTATION.getName(), ((Method)annotElement).getName());
                    }
                    if (excludeDefault) {
                        AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.EXCLUDE_DEFAULT_INTERCEPTORS_ANNOTATION.getName(), ((Method)annotElement).getName());
                    }
                    if (excludeClass) {
                        AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION.getName(), ((Method)annotElement).getName());
                    }
                }
            }
            InterceptorBinding binding = new InterceptorBinding(descriptor.getName());
            binding.setExcludeDefaultInterceptors(excludeDefault);
            binding.setExcludeClassInterceptors(excludeClass);
            Class[] interceptorClasses = null;
            if (interceptors != null) {
                interceptorClasses = ((Interceptors)interceptors).value();
            }
            if (interceptorClasses != null) {
                J2EEContextAnnotationParser utilParser = new J2EEContextAnnotationParser(annotationManager);
                for (Class interceptorClass : interceptorClasses) {
                    String className = interceptorClass.getName();
                    if (!descriptor.getEJBPackage().getInterceptorDescriptors().containsKey(className)) {
                        descriptor.getEJBPackage().addInterceptorDescriptor(BeanDescriptorAnnotationParser.buildInterceptorClassDescriptor(interceptorClass, utilParser));
                    }
                    binding.getInterceptorClassNames().add(className);
                }
            }
            descriptor.getEJBPackage().addInterceptorBinding(binding);
            return binding;
        }
        return null;
    }

    public static InterceptorDescriptor buildInterceptorClassDescriptor(Class interceptorClass, Object parser) throws InstantiationException {
        J2EEContextAnnotationParser utilParser = (J2EEContextAnnotationParser)parser;
        InterceptorDescriptor intDesc = BeanDescriptorAnnotationParser.parseInterceptorAnnotation(interceptorClass, utilParser.getAnnotationManager());
        utilParser.parse(intDesc.getConfigDelegate(), interceptorClass);
        return intDesc;
    }

    public static InterceptorDescriptor buildInterceptorClassDescriptor(Class interceptorClass) throws InstantiationException {
        return BeanDescriptorAnnotationParser.buildInterceptorClassDescriptor(interceptorClass, new J2EEContextAnnotationParser(new AnnotationManager()));
    }

    private static InterceptorDescriptor parseInterceptorAnnotation(Class interceptorClass, AnnotationManager annotationManager) {
        AnnotationParsingMessages.fineParsingAnnotatedClass(interceptorClass.getName());
        InterceptorDescriptor interceptorDescriptor = new InterceptorDescriptor();
        interceptorDescriptor.setInterceptorClassName(interceptorClass.getName());
        for (Method interceptorMethod : annotationManager.getMethods(interceptorClass)) {
            BeanDescriptorAnnotationParser.parseInterceptorCallbacks(interceptorDescriptor, interceptorMethod);
        }
        return interceptorDescriptor;
    }

    private static void parseInterceptorCallbacks(InterceptorDescriptor interceptorDescriptor, Method interceptorMethod) {
        if (interceptorMethod.isAnnotationPresent(EJBJarAnnotations.AROUND_INVOKE_ANNOTATION)) {
            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.AROUND_INVOKE_ANNOTATION.getName(), interceptorMethod.getName());
            interceptorDescriptor.addAroundInvokeMethod(interceptorMethod.getName(), interceptorMethod.getDeclaringClass().getName());
        }
        if (interceptorMethod.isAnnotationPresent(EJBJarAnnotations.POST_CONSTRUCT_ANNOTATION)) {
            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.POST_CONSTRUCT_ANNOTATION.getName(), interceptorMethod.getName());
            interceptorDescriptor.addPostConstructMethod(interceptorMethod.getName(), interceptorMethod.getDeclaringClass().getName());
        }
        if (interceptorMethod.isAnnotationPresent(EJBJarAnnotations.PRE_DESTROY_ANNOTATION)) {
            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.PRE_DESTROY_ANNOTATION.getName(), interceptorMethod.getName());
            interceptorDescriptor.addPreDestroyMethod(interceptorMethod.getName(), interceptorMethod.getDeclaringClass().getName());
        }
        if (interceptorMethod.isAnnotationPresent(EJBJarAnnotations.POST_ACTIVATE_ANNOTATION)) {
            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.POST_ACTIVATE_ANNOTATION.getName(), interceptorMethod.getName());
            interceptorDescriptor.addPostActivateMethod(interceptorMethod.getName(), interceptorMethod.getDeclaringClass().getName());
        }
        if (interceptorMethod.isAnnotationPresent(EJBJarAnnotations.PRE_PASSIVATE_ANNOTATION)) {
            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.PRE_PASSIVATE_ANNOTATION.getName(), interceptorMethod.getName());
            interceptorDescriptor.addPrePassivateMethod(interceptorMethod.getName(), interceptorMethod.getDeclaringClass().getName());
        }
    }

    protected void parseTimeoutMethod(BeanDescriptor descriptor, Method method) throws InstantiationException {
        if (Modifier.isPublic(method.getModifiers()) && method.isAnnotationPresent(EJBJarAnnotations.TIMEOUT_ANNOTATION)) {
            AnnotationParsingMessages.finestParsingMethodLevelAnnotation(EJBJarAnnotations.TIMEOUT_ANNOTATION.getName(), method.getName());
            if (descriptor.getTimeoutMethodName() != null && !descriptor.getTimeoutMethodName().equals(method.getName())) {
                throw new InstantiationException("A bean class may only have one @Timeout method defined, including one maybe defined in it's superclass");
            }
            if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].isAssignableFrom(Timer.class)) {
                throw new InstantiationException("The method (" + method + ") does not satisfy the @Timeout definition as: public void <METHOD> (javax.ejb.Timer). Check spec 17.2.2");
            }
            descriptor.setTimeoutMethodName(method.getName());
        }
    }

    private MethodPermission parseRolesAllowedAnnotation(BeanDescriptor descriptor, Method method, String[] rolesAllowed) throws InstantiationException {
        MethodDescriptor methodDesc;
        MethodPermission permission = new MethodPermission(descriptor.getEJBPackage());
        if (method == null) {
            methodDesc = new MethodDescriptor(descriptor.getName());
            methodDesc.setType(3);
            permission.addMethod(methodDesc);
            methodDesc = new MethodDescriptor(descriptor.getName());
            methodDesc.setType(1);
            permission.addMethod(methodDesc);
            methodDesc = new MethodDescriptor(descriptor.getName());
            methodDesc.setType(5);
            permission.addMethod(methodDesc);
        } else {
            permission.setIsOverride(true);
            methodDesc = new MethodDescriptor(descriptor.getName(), method, 3);
            permission.addMethod(methodDesc);
            methodDesc = new MethodDescriptor(descriptor.getName(), method, 1);
            permission.addMethod(methodDesc);
            methodDesc = new MethodDescriptor(descriptor.getName(), method, 5);
            permission.addMethod(methodDesc);
        }
        if (rolesAllowed != null) {
            for (String roleName : rolesAllowed) {
                permission.addRoleName(roleName);
                descriptor.getEJBPackage().addSecurityRole(new SecurityRole(roleName));
            }
        }
        descriptor.getEJBPackage().addMethodPermission(permission);
        return permission;
    }

    private void parsePermitAllAnnotation(BeanDescriptor descriptor, Method method) throws InstantiationException {
        this.parseRolesAllowedAnnotation(descriptor, method, null).setUnchecked(true);
    }

    private void parseDenyAllAnnotation(BeanDescriptor descriptor, Method method) throws InstantiationException {
        if (descriptor.getPackage().getExcludeList() == null) {
            descriptor.getPackage().setExcludeList(new ExcludeList());
        }
        descriptor.getPackage().getExcludeList().addMethod(new MethodDescriptor(descriptor.getName(), method, 0));
    }

    private void parseRunAsAnnotation(BeanDescriptor descriptor, String runAs) {
        descriptor.setSecurityIdentity(new SecurityIdentity(runAs));
    }

    private void parseDeclareRolesAnnotation(BeanDescriptor descriptor, String[] roleNames) {
        for (String role : roleNames) {
            descriptor.getEJBPackage().addSecurityRole(new SecurityRole(role));
            SecurityRoleReference ref = new SecurityRoleReference();
            ref.setName(role);
            descriptor.addSecurityRoleReference(ref);
        }
    }

    protected static <T extends Annotation> T getAnnotation(AnnotatedElement element, Class annotationCls) {
        return element.getAnnotation(annotationCls);
    }

    protected String getDefaultBeanName(Class cls) {
        return cls.getName().substring(cls.getName().lastIndexOf(46) + 1);
    }
}

