/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.logging.DiagnosticContext;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationException
implements XMLizable {
    private String className;
    private boolean rollback;

    public ApplicationException() {
    }

    public ApplicationException(String className, boolean rollback) {
        this.className = className;
        this.rollback = rollback;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setRollback(boolean rollback) {
        this.rollback = rollback;
    }

    public boolean getRollback() {
        return this.rollback;
    }

    public ApplicationException parseEJBJarXML(DiagnosticContext ctx, Node exceptionNode) throws InstantiationException {
        NodeList nodes = exceptionNode.getChildNodes();
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("exception-class")) {
                ApplicationException.checkForDuplicateTag(ctx, this.getClassName(), "exception-class");
                this.setClassName(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("rollback")) {
                this.setRollback(XMLUtils.getStringValue(node).equals("true"));
                continue;
            }
            throw DeploymentException.unknownXmlSubtag(ctx, "application-exception", name);
        }
        if (this.getClassName() == null) {
            throw DeploymentException.missingOrNullTag(ctx, "application-exception", "exception-class");
        }
        return this;
    }

    private static void checkForDuplicateTag(DiagnosticContext ctx, Object currentValue, String tagName) {
        if (currentValue != null) {
            throw DeploymentException.duplicateTag(ctx, "application-exception", tagName);
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws IOException {
        out.println(indentation + "<" + "application-exception" + ">");
        ApplicationException.writeTag("exception-class", this.getClassName(), out, indentation);
        ApplicationException.writeTag("rollback", String.valueOf(this.getRollback()), out, indentation);
        out.println(indentation + "</" + "application-exception" + ">");
    }

    private static void writeTag(String tagName, String tagValue, PrintWriter out, String indentation) {
        if (tagValue != null) {
            out.println(indentation + "\t<" + tagName + ">" + XMLUtils.encode(tagValue) + "</" + tagName + ">");
        }
    }
}

