/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.server.ejb.database.TableIteration;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import com.sun.ejb.ejbql.RuntimeInfoVisitor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.mail.internet.InternetAddress;

public class SelectMethodCompilation
extends MethodCompilation {
    private static final String LOCAL_EJB_OBJECT = "javax.ejb.EJBLocalObject";
    private static final String EJB_OBJECT = "javax.ejb.EJBObject";
    private EntityBeanDescriptor entityBeanDescriptor;
    private EntityBeanDescriptor resultEntityBeanDescriptor;
    private Class resultType = null;
    private boolean resultTypeRemote = false;
    String sqlStatement;
    private int statementArgumentIndex;

    public SelectMethodCompilation(ClassCompilation declaringClass, EntityBeanDescriptor ebd, Method method) throws CompilationException {
        super(declaringClass, method);
        this.entityBeanDescriptor = ebd;
    }

    public void compile() throws CompilationException {
        QueryDescriptor qd;
        this.checkThrows(FinderException.class);
        this.appendMethodWrapperStart(false);
        this.source.append("\n{\ntraceLog(\"Starting ejbSelect method " + this.method.getName() + "\");\n");
        Class<?> returnClass = this.method.getReturnType();
        boolean singleReturn = true;
        if (returnClass == Collection.class || returnClass == Set.class) {
            singleReturn = false;
        }
        if ((qd = ((EjbCMPEntityDescriptor)this.entityBeanDescriptor.getEjbqlDescriptor()).getPersistenceDescriptor().getQueryFor(this.method)) == null) {
            throw new CompilationException("query for " + this.method.getName() + " not declared in ejb-jar.xml");
        }
        this.sqlStatement = qd.getSQLAsPrintableString();
        if (this.sqlStatement == null && EJBUtils.isOrionCmpForced()) {
            EJBDeploymentMessages.warningDisableSelect(this.entityBeanDescriptor, this.method);
            this.source.append("\nthrow new javax.ejb.FinderException(\"The ejb-ql defined for this finder is not supported by Orion CMP\");\n");
            this.source.append("\n}");
            return;
        }
        boolean selectObject = false;
        try {
            RuntimeInfoVisitor info = qd.getEjbQlRuntimeInfo();
            if (info.getReturnsCmpField()) {
                this.resultType = info.getReturnObjectType();
            } else {
                PersistenceDescriptor rpd = info.getEjbDescriptor();
                this.resultEntityBeanDescriptor = rpd.getOc4jEntity();
                selectObject = true;
                this.resultTypeRemote = this.entityBeanDescriptor.getEJBQuery(this.method).getResultTypeRemotes();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CompilationException(e.getMessage());
        }
        if (selectObject) {
            this.source.append(this.resultEntityBeanDescriptor.getPrimaryKeyClassName() + " key = null;\n");
        }
        this.source.append(returnClass.getName() + " response;\n");
        if (!singleReturn) {
            this.source.append("response = ");
            if (returnClass == Collection.class) {
                this.source.append("new java.util.ArrayList();\n");
            } else if (returnClass == Set.class) {
                this.source.append("new java.util.HashSet();\n");
            }
        } else {
            this.source.append("response = null;\n");
        }
        this.source.append("com.evermind.server.ApplicationServerTransaction transaction = (com.evermind.server.ApplicationServerTransaction)" + EJBCompilationUtils.getTransactionManagerString() + ".getTransaction();\n" + "DataSourceConnection connection = null;\n" + "java.sql.PreparedStatement statement = null;\n" + "try {\n" + "if (__context.localHome != null) {\n" + "if (transaction == null) {\n" + "connection = ((EntityEJBHome)__context.localHome).dataSourceContainer.getLocalConnection();\n" + "} else {\n" + "connection = transaction.getLocalConnection(((EntityEJBHome)__context.localHome).dataSourceContainer);\n" + "}\n" + "} else {\n" + "if (transaction == null) {\n" + "connection = ((EntityEJBHome)__context.remoteHome).dataSourceContainer.getConnection();\n" + "} else {\n" + "connection = transaction.getConnection(((EntityEJBHome)__context.remoteHome).dataSourceContainer);\n" + "}\n" + "}\n\n");
        this.source.append("statement = EJBPrivileged.getCustomStatement(connection, \"");
        this.source.append(this.sqlStatement, true);
        this.source.append("\");\n\n");
        Class<?>[] types = this.method.getParameterTypes();
        this.statementArgumentIndex = 1;
        for (int argumentIndex = 0; argumentIndex < types.length; ++argumentIndex) {
            this.appendPreparedSet(this.source, "statement", types[argumentIndex], "argument" + argumentIndex, false);
        }
        this.source.append("\njava.sql.ResultSet set = statement.executeQuery();\n\n");
        this.source.append("traceLog(\"Got result set\");\n");
        if (singleReturn) {
            this.source.append("boolean gotOne = false;\n");
            this.source.append("while(set.next())\n{\n");
            this.source.append("if (gotOne)\nthrow com.evermind.server.ejb.EJBUtils.createEJBException(\"Single ejbSelect method cannot return multiple values.\");\n");
        } else {
            this.source.append("while(set.next())\n{\n");
        }
        if (selectObject) {
            this.getResultObject(returnClass, singleReturn);
        } else {
            this.getResultColumn(returnClass, singleReturn);
        }
        this.source.append("}\n");
        this.source.append("catch(java.sql.SQLException e)\n");
        this.source.append("{\ne.printStackTrace();\nthrow new javax.ejb.FinderException(\"Database error: \" + e.getMessage());\n}\n");
        this.source.append("catch(java.lang.Throwable t)\n");
        this.source.append("{\nt.printStackTrace();\nthrow new javax.ejb.FinderException(\"Internal error: \" + t.getMessage());\n}\n");
        this.source.append("finally\n");
        this.source.append("{\nif(statement != null) {\n try {\n statement.close();\n } catch(java.sql.SQLException e) {}\n }\nif(transaction == null && connection != null) {connection.close(true);\nconnection = null;\n}\n}\n");
        this.source.append("if (response == null) throw new ObjectNotFoundException(\"Select method could not find anything\");\ntraceLog(\"Leaving ejbSelect method " + this.method.getName() + "\");\n" + "return response;\n" + "}\n");
    }

    private void getResultColumn(Class returnClass, boolean singleReturn) throws CompilationException {
        this.source.append("traceLog(\"Found one value\");\n");
        String columnName = this.findColumnName(this.sqlStatement);
        ContainerManagedField field = this.entityBeanDescriptor.getContainerManagedField(columnName, false);
        String columnType = null;
        if (field != null) {
            columnType = field.getColumnType();
        }
        if (columnType != null && columnType.indexOf("WITH LOCAL TIME ZONE") != -1) {
            this.source.append("try  {\n");
            this.source.append("oracle.jdbc.OracleConnection tempConn = (oracle.jdbc.OracleConnection) connection.getConnection() ;\n ");
            this.source.append("TimeZone tmz = TimeZone.getDefault();\n");
            this.source.append("String tmz_str = tmz.getID();\n");
            this.source.append("tempConn.setSessionTimeZone(tmz_str);\n");
            this.source.append("} catch(ClassCastException ex) {\n // do nothing if not Oracle specific\n}");
        }
        if (singleReturn) {
            this.source.append("response = ");
            this.appendJDBCGetterMethod(this.source, "set", 1, this.resultType, field);
            this.source.append(";\n");
            this.source.append("gotOne = true;\n");
        } else {
            this.source.append("response.add(");
            this.appendJDBCGetterMethod(this.source, "set", 1, this.resultType, field, false, true);
            this.source.append(");\n");
        }
        this.source.append("}\n");
    }

    private void getResultObject(Class returnClass, boolean singleReturn) throws CompilationException {
        TableIteration getterTableIteration = new TableIteration();
        if (this.resultEntityBeanDescriptor.getPrimaryKeyFieldName() == null && !this.resultEntityBeanDescriptor.isAutomaticIdentity()) {
            this.source.append("key = new " + this.resultEntityBeanDescriptor.getPrimaryKeyClassName() + "();\n");
            Set fields = this.resultEntityBeanDescriptor.getPrimaryKey().getPropertyFields();
            Iterator iterator = fields.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                if (field != null) {
                    String columnType = field.getColumnType();
                    if (columnType != null && columnType.indexOf("WITH LOCAL TIME ZONE") != -1) {
                        this.source.append("try  {\n");
                        this.source.append("oracle.jdbc.OracleConnection tempConn = (oracle.jdbc.OracleConnection) connection.getConnection() ;\n ");
                        this.source.append("TimeZone tmz = TimeZone.getDefault();\n");
                        this.source.append("String tmz_str = tmz.getID();\n");
                        this.source.append("tempConn.setSessionTimeZone(tmz_str);\n");
                        this.source.append("} catch(ClassCastException ex) {\n // do nothing if not Oracle specific\n}");
                    }
                    this.source.append("key." + field.getName() + " = ");
                    this.appendJDBCGetterMethod(this.source, "set", i, field.getType(), field);
                    this.source.append(";\ntraceLog(\"key." + field.getName() + " = \" + key." + field.getName() + ");\n");
                }
                ++i;
            }
        } else {
            ContainerManagedField field = this.resultEntityBeanDescriptor.getPrimaryKey();
            String columnType = field.getColumnType();
            if (columnType != null && columnType.indexOf("WITH LOCAL TIME ZONE") != -1) {
                this.source.append("try  {\n");
                this.source.append("oracle.jdbc.OracleConnection tempConn = (oracle.jdbc.OracleConnection) connection.getConnection() ;\n ");
                this.source.append("TimeZone tmz = TimeZone.getDefault();\n");
                this.source.append("String tmz_str = tmz.getID();\n");
                this.source.append("tempConn.setSessionTimeZone(tmz_str);\n");
                this.source.append("} catch(ClassCastException ex) {\n // do nothing if not Oracle specific\n}");
            }
            this.source.append("key = ");
            this.appendJDBCGetterMethod(this.source, "set", 1, this.resultEntityBeanDescriptor.getPrimaryKey().getType(), field, true, false);
            this.source.append(";\ntraceLog(\"Found key \" + key);\n");
        }
        this.source.append("EJBPackageDeployment epd;\nif (__context.localHome != null) epd = __context.localHome.getEJBPackage();\nelse  epd = __context.remoteHome.getEJBPackage();\nEntityEJBHome resultEJBHome = (EntityEJBHome) epd.getHomeInstance(epd.getContainer(), \"" + this.resultEntityBeanDescriptor.getName() + "\", " + (this.resultTypeRemote ? "false" : "true") + ");\n" + "traceLog(\"Calling getWrapperByPK\");\n" + "AbstractEJBObject wrapper = resultEJBHome.getWrapperByPK(transaction, key);\n");
        this.source.append("wrapper.transaction = transaction;\nif (transaction != null)\n" + EJBCompilationUtils.getRegisterBeanString("wrapper") + ";\n");
        String resultName = !this.resultTypeRemote ? this.resultEntityBeanDescriptor.getLocalInterfaceName() : this.resultEntityBeanDescriptor.getRemoteInterfaceName();
        this.source.append("traceLog(\"Found one wrapper\");\n");
        if (singleReturn) {
            this.source.append("response = (" + resultName + ")wrapper;\n");
            this.source.append("gotOne = true;\n");
        } else {
            this.source.append("response.add((" + resultName + ")wrapper);\n");
        }
        this.source.append("}\n");
    }

    private void appendPreparedSet(ByteString buffer, String statementName, Class propertyType, String variableName, boolean variableContainsPrimaryKey) throws CompilationException {
        if (propertyType == EntityContext.class) {
            return;
        }
        String variableNameWithCast = null;
        variableNameWithCast = variableContainsPrimaryKey ? "((" + propertyType.getName() + ")" + variableName + ".getPrimaryKey())" : "((" + propertyType.getName() + ")" + variableName + ")";
        if (propertyType.isPrimitive()) {
            String primitiveName = null;
            primitiveName = variableContainsPrimaryKey ? "((" + ClassUtils.getNonPrimitiveType(propertyType).getName() + ")" + variableName + ".getPrimaryKey())." + ClassUtils.getSourceNotation(propertyType, 0) + "Value()" : variableName;
            if (propertyType == Integer.TYPE) {
                buffer.append(statementName + ".setInt(" + this.statementArgumentIndex + ", " + primitiveName + ");\n");
            } else if (propertyType == Character.TYPE) {
                buffer.append("com.evermind.server.ejb.EJBUtils.setChar(" + statementName + ", " + this.statementArgumentIndex + ", " + primitiveName + ");\n");
            } else if (propertyType == Short.TYPE) {
                buffer.append(statementName + ".setShort(" + this.statementArgumentIndex + ", " + primitiveName + ");\n");
            } else if (propertyType == Long.TYPE) {
                buffer.append(statementName + ".setLong(" + this.statementArgumentIndex + ", " + primitiveName + ");\n");
            } else if (propertyType == Float.TYPE) {
                buffer.append(statementName + ".setFloat(" + this.statementArgumentIndex + ", " + primitiveName + ");\n");
            } else if (propertyType == Double.TYPE) {
                buffer.append(statementName + ".setDouble(" + this.statementArgumentIndex + ", " + primitiveName + ");\n");
            } else if (propertyType == Byte.TYPE) {
                buffer.append(statementName + ".setByte(" + this.statementArgumentIndex + ", " + primitiveName + ");\n");
            } else if (propertyType == Boolean.TYPE) {
                buffer.append(statementName + ".setBoolean(" + this.statementArgumentIndex + ", " + primitiveName + ");\n");
            }
        } else if (propertyType == String.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.VARCHAR);\n");
            buffer.append("else " + statementName + ".setString(" + this.statementArgumentIndex + ", " + variableNameWithCast + ");\n");
        } else if (propertyType == java.util.Date.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.TIMESTAMP);\n");
            buffer.append("else " + statementName + ".setTimestamp(" + this.statementArgumentIndex + ", new java.sql.Timestamp(" + variableName + ".getTime()));\n");
        } else if (propertyType == InternetAddress.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.VARCHAR);\n");
            buffer.append("else " + statementName + ".setString(" + this.statementArgumentIndex + ", " + variableName + ".getAddress());\n");
        } else if (propertyType == Timestamp.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.TIMESTAMP);\n");
            buffer.append("else " + statementName + ".setTimestamp(" + this.statementArgumentIndex + ", " + variableNameWithCast + ");\n");
        } else if (propertyType == Time.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.TIME);\n");
            buffer.append("else " + statementName + ".setTime(" + this.statementArgumentIndex + ", " + variableName + ");\n");
        } else if (propertyType == Date.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.DATE);\n");
            buffer.append("else " + statementName + ".setDate(" + this.statementArgumentIndex + ", " + variableName + ");\n");
        } else if (propertyType == Locale.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.VARCHAR);\n");
            buffer.append("else " + statementName + ".setString(" + this.statementArgumentIndex + ", com.evermind.util.ObjectUtils.toString(" + variableName + "));\n");
        } else if (propertyType == BigDecimal.class) {
            buffer.append(statementName + ".setBigDecimal(" + this.statementArgumentIndex + ", " + variableNameWithCast + ");\n");
        } else if (propertyType == Blob.class) {
            buffer.append(statementName + ".setBlob(" + this.statementArgumentIndex + ", " + variableNameWithCast + ");\n");
        } else if (propertyType == Clob.class) {
            buffer.append(statementName + ".setClob(" + this.statementArgumentIndex + ", " + variableNameWithCast + ");\n");
        } else if (propertyType == BigInteger.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.VARCHAR);\n");
            buffer.append("else " + statementName + ".setString(" + this.statementArgumentIndex + ", " + variableNameWithCast + ".toString());\n");
        } else if (propertyType == Integer.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.BIGINT);\n");
            buffer.append("else " + statementName + ".setInt(" + this.statementArgumentIndex + ", " + variableNameWithCast + ".intValue());\n");
        } else if (propertyType == Character.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.CHAR);\n");
            buffer.append("else com.evermind.server.ejb.EJBUtils.setChar(" + statementName + ", " + this.statementArgumentIndex + ", " + variableName + " == null ? (char)0 : " + variableName + ".charValue());\n");
        } else if (propertyType == Short.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.INTEGER);\n");
            buffer.append("else " + statementName + ".setShort(" + this.statementArgumentIndex + ", " + variableNameWithCast + ".shortValue());\n");
        } else if (propertyType == Long.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.BIGINT);\n");
            buffer.append("else " + statementName + ".setLong(" + this.statementArgumentIndex + ", " + variableNameWithCast + ".longValue());\n");
        } else if (propertyType == Float.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.FLOAT);\n");
            buffer.append("else " + statementName + ".setFloat(" + this.statementArgumentIndex + ", " + variableNameWithCast + ".floatValue());\n");
        } else if (propertyType == Double.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.DOUBLE);\n");
            buffer.append("else " + statementName + ".setDouble(" + this.statementArgumentIndex + ", " + variableNameWithCast + ".doubleValue());\n");
        } else if (propertyType == Byte.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.SMALLINT);\n");
            buffer.append("else " + statementName + ".setByte(" + this.statementArgumentIndex + ", " + variableNameWithCast + ".byteValue());\n");
        } else if (propertyType == Boolean.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.BIT);\n");
            buffer.append("else " + statementName + ".setBoolean(" + this.statementArgumentIndex + ", " + variableNameWithCast + ".booleanValue());\n");
        } else if (propertyType == [B.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.LONGVARBINARY);\n" + "else " + statementName + ".setBinaryStream(" + this.statementArgumentIndex + ", new java.io.ByteArrayInputStream(" + variableName + "), " + variableName + ".length);\n");
        } else if (propertyType == [C.class) {
            buffer.append("if(" + variableName + " == null) " + statementName + ".setNull(" + this.statementArgumentIndex + ", java.sql.Types.LONGVARCHAR);\n" + "else " + statementName + ".setCharacterStream(" + this.statementArgumentIndex + ", new java.io.CharArrayReader(" + variableName + "), " + variableName + ".length);\n");
        } else {
            try {
                Class<?>[] interfaces = propertyType.getInterfaces();
                if (interfaces.length > 0 && (interfaces[0].getName().equals(LOCAL_EJB_OBJECT) || interfaces[0].getName().equals(EJB_OBJECT))) {
                    EntityBeanDescriptor epd = this.findEntityBeanDescriptor(propertyType.getName());
                    if (epd == null) {
                        throw new CompilationException(propertyType + " not found!");
                    }
                    ContainerManagedField field = epd.getPrimaryKey();
                    if (field.getName().length() == 0) {
                        Field[] fields = this.reOrderFields(epd.getPrimaryKeyClass().getFields(), field);
                        for (int index = 0; index < fields.length; ++index) {
                            Field currentField = fields[index];
                            this.appendPreparedSet(buffer, statementName, currentField.getType(), "((" + epd.getPrimaryKeyClassName() + ")" + variableName + ".getPrimaryKey())." + currentField.getName(), false);
                        }
                        return;
                    }
                    String fieldName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                    this.appendPreparedSet(buffer, statementName, field.getType(), variableName, true);
                } else {
                    buffer.append("EntityEJBObject.storeObject(" + statementName + ", " + this.statementArgumentIndex + ", " + variableName + ");\n");
                }
            }
            catch (CompilationException ce) {
                throw ce;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CompilationException("Failed to set argument in PreparedStatement: " + e.getMessage());
            }
        }
        ++this.statementArgumentIndex;
    }

    private Field[] reOrderFields(Field[] fields, ContainerManagedField pkField) {
        Field[] newFields = new Field[fields.length];
        Iterator iterFields = pkField.getPropertyFields().iterator();
        int j = 0;
        while (iterFields.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterFields.next();
            for (int i = 0; i < fields.length; ++i) {
                if (!field.getName().equals(fields[i].getName())) continue;
                newFields[j] = fields[i];
                ++j;
            }
        }
        return newFields;
    }

    private EntityBeanDescriptor findEntityBeanDescriptor(String beanObjectName) {
        EJBPackage epk = null;
        epk = this.resultEntityBeanDescriptor != null ? this.resultEntityBeanDescriptor.getPackage() : this.entityBeanDescriptor.getPackage();
        Iterator iterator = epk.getBeans().iterator();
        while (iterator.hasNext()) {
            BeanDescriptor bd = (BeanDescriptor)iterator.next();
            if (!(bd instanceof EntityBeanDescriptor)) continue;
            EntityBeanDescriptor ebd = (EntityBeanDescriptor)bd;
            String remoteName = ebd.getRemoteInterfaceName();
            String localName = ebd.getLocalInterfaceName();
            if ((remoteName == null || !remoteName.equals(beanObjectName)) && (localName == null || !localName.equals(beanObjectName))) continue;
            return ebd;
        }
        return null;
    }

    private String findColumnName(String sqlStatement) {
        int dot;
        int end = sqlStatement.indexOf(" ", 7);
        String field = sqlStatement.substring(7, end);
        if (field.equalsIgnoreCase("DISTINCT")) {
            end = sqlStatement.indexOf(" ", end + 1);
            field = sqlStatement.substring(field.length() + 7, end);
        }
        if ((dot = field.indexOf(".")) == -1) {
            return field;
        }
        return field.substring(dot + 1, field.length());
    }

    private void appendJDBCGetterMethod(ByteString source, String setName, int columnIndex, Class propertyType, ContainerManagedField field) throws CompilationException {
        this.appendJDBCGetterMethod(source, setName, columnIndex, propertyType, field, false, false);
    }

    private void appendJDBCGetterMethod(ByteString source, String setName, int columnIndex, Class propertyType, ContainerManagedField field, boolean isObjectKey, boolean isAddToCollection) throws CompilationException {
        boolean wasObject = false;
        if (propertyType == Integer.TYPE || propertyType == Integer.class) {
            source.append("EJBUtils.getInteger(" + setName + ", ");
        } else if (propertyType == Character.TYPE || propertyType == Character.class) {
            source.append("EJBUtils.getCharacter(" + setName + ", ");
        } else if (propertyType == Short.TYPE || propertyType == Short.class) {
            source.append("EJBUtils.getShort(" + setName + ", ");
        } else if (propertyType == Long.TYPE || propertyType == Long.class) {
            source.append("EJBUtils.getLong(" + setName + ", ");
        } else if (propertyType == Float.TYPE || propertyType == Float.class) {
            source.append("EJBUtils.getFloat(" + setName + ", ");
        } else if (propertyType == Double.TYPE || propertyType == Double.class) {
            source.append("EJBUtils.getDouble(" + setName + ", ");
        } else if (propertyType == Byte.TYPE || propertyType == Byte.class) {
            source.append("EJBUtils.getByte(" + setName + ", ");
        } else if (propertyType == Boolean.TYPE || propertyType == Boolean.class) {
            source.append("EJBUtils.getBoolean(" + setName + ", ");
        } else if (propertyType == String.class) {
            source.append(setName + ".getString(");
        } else if (propertyType == java.util.Date.class) {
            source.append("com.evermind.util.ObjectUtils.toDate(" + setName + ".getTimestamp(" + columnIndex + "))");
            wasObject = true;
        } else if (propertyType == InternetAddress.class) {
            source.append("com.evermind.util.ObjectUtils.toInternetAddress(" + setName + ".getString(" + columnIndex + "))");
            wasObject = true;
        } else if (propertyType == Date.class) {
            source.append(setName + ".getDate(");
        } else if (propertyType == Timestamp.class) {
            source.append(setName + ".getTimestamp(");
        } else if (propertyType == Time.class) {
            source.append(setName + ".getTime(");
        } else if (propertyType == BigDecimal.class) {
            source.append(setName + ".getBigDecimal(");
        } else if (propertyType == Blob.class) {
            source.append(setName + ".getBlob(");
        } else if (propertyType == Clob.class) {
            source.append(setName + ".getClob(");
        } else if (propertyType == Locale.class) {
            source.append("com.evermind.util.ObjectUtils.toLocale(" + setName + ".getString(" + columnIndex + "))");
            wasObject = true;
        } else if (propertyType == BigInteger.class) {
            source.append("com.evermind.util.ObjectUtils.toBigInteger(" + setName + ".getString(" + columnIndex + "))");
            wasObject = true;
        } else if (propertyType == [B.class) {
            source.append("EJBUtils.getContent(" + setName + ".getBinaryStream(" + columnIndex + "))");
            wasObject = true;
        } else if (propertyType == [C.class) {
            source.append("EJBUtils.getContent(" + setName + ".getCharacterStream(" + columnIndex + "))");
            wasObject = true;
        } else {
            throw new CompilationException("Unrecognized data type " + this.resultType.getName());
        }
        if (!wasObject) {
            source.append(columnIndex + ")");
            if (!isObjectKey && field != null && field.getType().isPrimitive() && !isAddToCollection) {
                source.append("." + ClassUtils.getSourceNotation(field.getType(), 0) + "Value()");
            }
        }
    }
}

