/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.Flag;
import com.evermind.server.ejb.compilation.CMPObjectCompilation;
import com.evermind.server.ejb.compilation.EntityBeanCompilation;
import com.evermind.server.ejb.deployment.CommitOptionDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.ByteString;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EntityContext;

public class PersistenceManagerCompilation
extends CMPObjectCompilation {
    EntityBeanCompilation compilation;
    private static Logger m_logger = EJBTraceLogger.getLogger(PersistenceManagerCompilation.class);

    public PersistenceManagerCompilation(EntityBeanCompilation compilation) throws CompilationException {
        super("PersistenceManager", compilation.compilation, compilation.descriptor, compilation.descriptor.getEJBClass(), compilation.getSchema());
        this.compilation = compilation;
    }

    protected void appendClearDirtyPersist(ByteString source) {
        source.append("public void __clearDirty()\n{\n   int i; \n   while ((i= __dirtyBSet.length()) !=0)\n   { \n     __dirtyBSet.clear(i-1) ; \n   } \n}\n");
    }

    protected void appendTraceLog(ByteString source) {
        source.append("public void traceLog(String message)\n{\nLogger.getAnonymousLogger().fine(message); \n}\n");
    }

    public void compile() throws CompilationException {
        super.preCompile();
        this.addDmsImports();
        this.source.append("import java.sql.*;\nimport javax.ejb.*;\nimport javax.sql.*;\nimport java.util.*;\nimport java.util.logging.*;\nimport com.evermind.server.ejb.*;\nimport com.evermind.server.*;\nimport com.evermind.server.ejb.cache.*;\nimport com.evermind.server.ejb.interceptor.MethodState;\n\n");
        int fieldCount = this.table.getFieldCount(true);
        this.source.append("public class " + this.getName() + "  extends " + this.interfaceClass.getName());
        if (this.compilation.descriptor.getCommitOption().isCacheable()) {
            this.source.append("  implements ExtendedContainerManagedObject\n");
        } else {
            this.source.append("  implements ContainerManagedObject\n");
        }
        this.source.append("{\nint fieldCount = " + fieldCount + " ;\n" + "BitSet __dirtyBSet = new BitSet(fieldCount);\n" + "EvermindEntityContext __context;\n" + "private static boolean persistenceManagerDebug = Boolean.getBoolean(\"PersistenceManagerDebug\");\n\n");
        this.source.append("static final long serialVersionUID = ApplicationServer.computeSerialVersionUID(\"" + this.getName() + "\");\n");
        this.appendCacheRelatedMethods();
        this.source.append("HashSet outOfTransDirtyEjbs = null;\nvoid addOutOfTransDirtyEjb( EntityEJBObject dirtyEjb )\n{\n  if( outOfTransDirtyEjbs == null )\n    outOfTransDirtyEjbs = new HashSet();\n  outOfTransDirtyEjbs.add( dirtyEjb );\n}\nIterator getOutOfTransDirtyEjbs()\n{\n  return outOfTransDirtyEjbs == null\n    ? Collections.EMPTY_SET.iterator()\n    : outOfTransDirtyEjbs.iterator();\n}\nvoid clearOutOfTransDirtyEjbs()\n{\n  if( outOfTransDirtyEjbs != null )\n    outOfTransDirtyEjbs.clear();\n}\n");
        if (this.compilation.home.constructorHasRemoteException) {
            this.source.append("public " + this.getName() + "() throws java.rmi.RemoteException\n" + "{\n" + "}\n" + "\n");
        }
        this.source.append("{\n");
        if (this.compilation.descriptor.isContainerManaged()) {
            CommitOptionDescriptor co = this.compilation.descriptor.getCommitOption();
            if (co.useOCA()) {
                this.appendln(co.getName() + " = 0;");
                this.appendln(co.getName() + "Changed = false;");
            }
            this.source.append("}\n\n");
        }
        this.processFields();
        this.source.append(this.createSource);
        this.appendClearDirtyPersist(this.source);
        this.appendTraceLog(this.source);
        this.source.append("\npublic void __setDirty(String referer)\n{\n");
        if (this.compilation.descriptor.isContainerManaged()) {
            Iterator iterator = this.table.getFields().iterator();
            int currentIndex = -1;
            CommitOptionDescriptor co = this.compilation.descriptor.getCommitOption();
            while (iterator.hasNext()) {
                ++currentIndex;
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                if (field.isSynthetic() && field.getType() != (class$java$util$Collection == null ? PersistenceManagerCompilation.class$("java.util.Collection") : class$java$util$Collection) && field.getType() != (class$java$util$Set == null ? PersistenceManagerCompilation.class$("java.util.Set") : class$java$util$Set)) continue;
                this.source.append("if(referer == \"" + field.getName() + "\")\n" + "{\n" + "this.__dirtyBSet.set(" + currentIndex + ");\n");
                if (co.useOCA()) {
                    this.appendln("_setChanged();");
                }
                this.appendln("}\nelse\n");
            }
        }
        this.source.append("return;\n}\n\n");
        this.source.append("public void setEntityContext(EntityContext context)");
        try {
            Method method = this.interfaceClass.getMethod("setEntityContext", EntityContext.class);
            Class<?>[] types = method.getExceptionTypes();
            if (types.length > 0) {
                this.source.append(" throws ");
            }
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    this.source.append(", ");
                }
                this.source.append(types[i].getName());
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.source.append("\n{\nthis.__context = (EvermindEntityContext)context;\n");
        this.source.append("\n   super.setEntityContext(context);\n");
        this.source.append("}\n\t");
        this.source.append("\n public EvermindEntityContext __getContext()\n{\nreturn this.__context;\n}\n");
        this.appendMethods();
        this.source.append("}");
    }

    private void appendln(String str) {
        this.source.append(str + "\n");
    }

    private void appendCacheRelatedFields() {
        int fieldCount = this.table.getFieldCount(true);
        this.appendln("private byte _state = 0;");
        this.appendln("private byte _flag = 0;");
        if (this.compilation.descriptor.isContainerManaged()) {
            CommitOptionDescriptor co = this.compilation.descriptor.getCommitOption();
            if (co.useOCA()) {
                this.appendln("boolean " + co.getName() + "Changed = false;");
            }
            Iterator iterator = this.table.getFields().iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                Class type = field.getType();
                if (field.isSynthetic() && type != (class$java$util$Collection == null ? PersistenceManagerCompilation.class$("java.util.Collection") : class$java$util$Collection) && type != (class$java$util$Set == null ? PersistenceManagerCompilation.class$("java.util.Set") : class$java$util$Set) || !field.isCMR() || !field.isOneToOne() && !field.isOneToMany_Many()) continue;
                this.appendln("Object _" + field.getName() + "FKey = null;");
            }
        }
    }

    private void addOCALocking() {
        this.source.append("// OC:  ade SFU " + this.compilation.descriptor.getCommitOption().getOptionStr() + "\n");
        CommitOptionDescriptor co = this.compilation.descriptor.getCommitOption();
        this.appendln("public boolean _lock(DataSourceConnection connection)\n");
        this.appendln("{\n");
        if (co.getOption() == 4) {
            this.source.append("// Generate locking ...\n");
            this.source.append("try\n{\n");
            if (this.compilation.descriptor.getDelayUpdatesUntilCommit()) {
                this.source.append("connection.sendBatchStatements();\n");
            }
            this.source.append("    " + co.getType() + " ocn = -1;\n");
            try {
                this.compilation.generateOCASelectStatement(this.source, co, "ocn", true, "");
            }
            catch (CompilationException e) {
                e.printStackTrace();
            }
            this.source.append("}\n");
            this.source.append("catch(java.sql.SQLException e)\n");
            this.source.append("{\ne.printStackTrace();return false;\n}\n");
        } else {
            this.source.append("return true;\n");
        }
        this.source.append("}\n");
    }

    private void appendCacheRelatedMethods() {
        CommitOptionDescriptor co = this.compilation.descriptor.getCommitOption();
        this.appendln("public boolean _isExtObject()");
        this.appendln("{");
        this.appendln("    return " + co.isCacheable() + " ;");
        this.appendln("}");
        if (!co.isCacheable()) {
            return;
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "appendCacheRelatedMethods... for " + this.getName() + " co:" + co.getOptionStr() + " oca?" + co.useOCA());
        }
        this.appendCacheRelatedFields();
        this.addOCALocking();
        this.appendln("public byte _setState(byte newState, boolean and)");
        this.appendln("{");
        this.appendln("    if(and) _state |= newState;\n");
        this.appendln("    else _state = newState;\n");
        this.appendln("    return _state;");
        this.appendln("}");
        this.appendln("public byte _getState()");
        this.appendln("{");
        this.appendln("    return _state;");
        this.appendln("}");
        this.appendln("public byte _setFlag(byte newFlag, boolean and)");
        this.appendln("{");
        this.appendln("    if(and) _flag |= newFlag;\n");
        this.appendln("    else _flag = newFlag;\n");
        this.appendln("    return _flag;");
        this.appendln("}");
        this.appendln("public byte _getFlag()");
        this.appendln("{");
        this.appendln("    return _flag;");
        this.appendln("}");
        ContainerManagedField ocaField = co.getField();
        this.appendln("public int _getVersion()");
        this.appendln("{");
        if (ocaField != null) {
            this.appendln("  return this." + ocaField.getName() + ";");
        } else {
            this.appendln("return 0;");
        }
        this.appendln("}");
        this.appendln("public int _getBaseVersion()");
        this.appendln("{");
        if (ocaField != null) {
            this.appendln("if(" + ocaField.getName() + "Changed)");
            this.appendln("  return this." + ocaField.getName() + "-1;");
            this.appendln("else");
            this.appendln("  return this." + ocaField.getName() + ";");
        } else {
            this.appendln("return 0;");
        }
        this.appendln("}");
        this.appendln("public boolean _isChanged()");
        this.appendln("{");
        if (ocaField != null) {
            this.appendln("return " + ocaField.getName() + "Changed;");
        } else {
            this.appendln("return false;");
        }
        this.appendln("}");
        this.appendln("public boolean _setChanged()");
        this.appendln("{");
        if (ocaField != null) {
            this.appendln("if(!" + ocaField.getName() + "Changed)");
            this.appendln("{");
            this.appendln(ocaField.getName() + "Changed = true;");
            this.appendln(ocaField.getName() + "++;");
            this.appendln("return true;");
            this.appendln("}");
            this.appendln("else");
            this.appendln("{");
            this.appendln("return false;");
            this.appendln("}");
        } else {
            this.appendln("return true;");
        }
        this.appendln("}");
        this.appendln("public Object _copy(boolean merge)");
        this.appendln("{");
        this.appendln(this.getName() + " to = new " + this.getName() + "();");
        this.appendln(" return _copy(this,to,merge);");
        this.appendln("}");
        this.appendln("public Object _copy(Object afrom, Object ato, boolean merge)");
        this.appendln("{");
        Flag genCloneCatch = new Flag(false);
        Flag genRMICatch = new Flag(false);
        if (this.compilation.descriptor.isContainerManaged()) {
            ContainerManagedField field;
            Iterator iterator;
            this.appendln(this.getName() + " from = (" + this.getName() + ") afrom;");
            this.appendln(this.getName() + " to = (" + this.getName() + ") ato;");
            this.appendln("// We do not copy the context to.__context = from.__context;");
            this.appendln("try");
            this.appendln("{");
            EntityBeanDescriptor bean = this.compilation.descriptor;
            if (ocaField != null) {
                this.appendln("if(merge)");
                this.appendln("{");
                this.appendln("if(from._isChanged() && (to._getVersion() > from._getBaseVersion()))");
                this.appendln("{");
                this.appendln("// OC: this is for debug only");
                this.appendln("traceLog(\">>>> Trying to merge stale data for bean " + this.getName() + " key = \" + " + bean.getPrimaryKeyFieldName() + " );");
                this.appendln("traceLog( from._getBaseVersion() + \" --> \" + to._getVersion());");
                this.appendln("return to;");
                this.appendln("}");
                this.appendln("}");
                this.appendln("else");
                this.appendln("{");
                this.appendln("if(to._isChanged() && (to._getVersion() > from._getVersion()))");
                this.appendln("{");
                this.appendln("traceLog(\">>>> Trying to merge stale data  \" + from._getVersion() + \" --> \" + to._getVersion());");
                this.appendln("return to;");
                this.appendln("}");
                this.appendln("}");
            }
            if (!bean.isAutomaticIdentity()) {
                if (bean.getPrimaryKeyFieldName() != null) {
                    this.generateCloneField(bean.getPrimaryKey(), genCloneCatch, genRMICatch);
                } else {
                    iterator = bean.getPrimaryKey().getPropertyFields().iterator();
                    while (iterator.hasNext()) {
                        field = (ContainerManagedField)iterator.next();
                        this.generateCloneField(field, genCloneCatch, genRMICatch);
                    }
                }
            }
            iterator = this.table.getFields().iterator();
            while (iterator.hasNext()) {
                field = (ContainerManagedField)iterator.next();
                this.generateCloneField(field, genCloneCatch, genRMICatch);
            }
            this.appendln("to.__dirtyBSet.clear();");
            this.appendln("to._state = 0x01;");
            this.appendln("to._flag = 0x00;");
            if (ocaField != null) {
                this.appendln("to." + co.getName() + "Changed = false;");
            }
            if (co.hasNonCMRFields()) {
                CommitOptionDescriptor.NonCMRField[] fields = co.getNonCMRFields();
                for (int i = 0; i < fields.length; ++i) {
                    CommitOptionDescriptor.NonCMRField o = fields[i];
                    fields.clone();
                    if (o.getClone()) {
                        this.appendln("try {\n");
                        this.appendln("to." + o.getName() + " = from." + o.getName() + ".clone();");
                        this.appendln("catch(CloneNotSupportedException e) {\n");
                        this.appendln("traceLog(\"Cannot clone Non CMR field: " + o.getName() + " \" + e);\n");
                        this.appendln("}\n");
                        continue;
                    }
                    this.appendln("to." + o.getName() + " = from." + o.getName() + ";");
                }
            }
        } else {
            this.appendln(" Object to = null;");
            this.appendln("try");
            this.appendln("{");
            this.appendln(" to = super.clone();");
        }
        this.appendln(" }");
        if (genCloneCatch.get()) {
            this.appendln(" catch (CloneNotSupportedException e)");
            this.appendln(" {");
            this.appendln("  traceLog(\"this is not Cloneable\" + e);");
            this.appendln(" }");
        }
        if (genRMICatch.get()) {
            this.appendln(" catch (java.rmi.RemoteException e)");
            this.appendln(" {");
            this.appendln("  traceLog(\"this is not Cloneable\" + e);");
            this.appendln(" }");
        }
        this.appendln(" finally{}");
        this.appendln(" return to;");
        this.appendln("}");
    }

    private void generateCloneField(ContainerManagedField field, Flag genCloneCatch, Flag genRMICatch) {
        Class type = field.getType();
        if (field.isSynthetic() && type != Collection.class && type != Set.class) {
            return;
        }
        if (field.isCMR()) {
            this.appendln("// This is a CMR: " + field.getName() + " " + field.getType().getName());
            if (field.isOneToOne() || field.isOneToMany_Many()) {
                EntityBeanDescriptor eDesc = field.getEntity();
                this.appendln("if(from." + field.getName() + " != null)");
                this.appendln("to._" + field.getName() + "FKey =  from." + field.getName() + ".getPrimaryKey();");
                this.appendln("else");
                this.appendln("to._" + field.getName() + "FKey =  from._" + field.getName() + "FKey;");
            } else {
                this.appendln("if(from." + field.getName() + " == null)");
                this.appendln(" if(to." + field.getName() + " == null)");
                this.appendln("  if(to.__context != null)");
                this.source.append("   to." + field.getName() + " = ");
                this.appendln("new " + field.getORMapping().getWrapperName() + "(to.__context);\n");
            }
        } else if (type.isPrimitive()) {
            this.appendln("to." + field.getName() + " = from." + field.getName() + ";");
        } else if (java.util.Date.class == type || Date.class == type || Timestamp.class == type || String.class == type) {
            this.source.append("to." + field.getName() + " = ");
            this.compilation.compilation.appendCloneSource("", false, this.source, "from", "from", field, field.getName(), true);
        } else if (type.isAssignableFrom(Cloneable.class)) {
            this.appendln("to." + field.getName() + " = " + field.getName() + ".clone();");
            genCloneCatch.set(true);
        } else {
            this.appendln("to." + field.getName() + " = (" + field.getType().getName() + ") EJBUtils.cloneObject(from." + field.getName() + ",null);");
            genRMICatch.set(true);
        }
    }

    public String getDirtyFieldPath() {
        return "dirty";
    }

    public String getDisplayName() {
        return "entity bean " + this.compilation.descriptor.getEJBClassName();
    }
}

