/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.EntityBeanCompilation;
import com.evermind.server.ejb.compilation.ORCompilation;
import com.evermind.server.ejb.database.TableIteration;
import com.evermind.server.ejb.deployment.CollectionORMapping;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.util.ClassUtils;
import java.util.Iterator;
import java.util.Vector;

public class ORSetCompilation
extends ORCompilation {
    CollectionORMapping mapping;

    public ORSetCompilation(ORCompilation slave) {
        super(slave);
    }

    public ORSetCompilation(ORCompilation slave, boolean _local) {
        super(slave);
        this.local = _local;
    }

    public ORSetCompilation() {
    }

    public boolean init() throws CompilationException {
        this.mapping = (CollectionORMapping)this.orField.getORMapping();
        return super.init("ORSet");
    }

    protected void createTable() throws CompilationException {
        if (!this.mapping.isManyToManySlave()) {
            this.compilation.createTable(this.getPrimaryKeysTable());
        }
    }

    public void compile() throws CompilationException {
        try {
            this.appendImports();
            this.appendClassStart("ORSet");
            this.appendGetObjectsMethod();
            this.appendPersistMethod();
            this.addDeleteEntriesMethod();
            this.appendIsValueImmutable();
            this.appendInitializeObject();
            this.appendGetTransaction();
            this.source.append("}\n");
        }
        catch (IllegalArgumentException e) {
            throw new CompilationException("Error in set-mapping '" + this.orField.getName() + "': " + e.getMessage());
        }
    }

    public void appendGetObjectsMethod() throws CompilationException {
        this.appendGetObjectsStart();
        this.source.append("Flag statementCached = new Flag(false);\n statement =  EJBPrivileged.getCustomStatement(connection, statementCached,\"");
        this.source.append(this.nonPrimaryKeyTable.getPreparedSelectStatement(false, "statement"), true);
        String primaryKeyVar = ClassUtils.getConvertSource("((" + this.compilation.descriptor.getPrimaryKeyClassName() + ")this.primaryKey)", this.compilation.descriptor.getPrimaryKeyClass(), this.mapping.getPrimaryKey().getType());
        this.getPrimaryKeysTable().appendPreparedSet(this.source, false, "statement", this.mapping.getPrimaryKey().getType(), new TableIteration(), primaryKeyVar, this.mapping.getPrimaryKey(), "context", true);
        this.source.append("ResultSet set = statement.executeQuery();\n");
        this.source.append("while(set.next())\n{\n");
        this.source.append(this.valueTypeName + " value = null;\n");
        TableIteration tableIteration = new TableIteration();
        EntityBeanCompilation.appendJDBCGetterMethod(this.local, "value", this.source, false, "set", this.mapping.getValueField(), tableIteration, this.compilation, "context", this);
        this.source.append("found.add(value);\n");
        this.appendGetObjectsEnd();
    }

    public void appendPersistMethod() throws CompilationException {
        this.source.append("public void persist(DataSourceConnection connection) throws java.sql.SQLException\n{\nthis.checkScope();\n\n");
        if (this.mapping.isOneToManyBiSlave()) {
            this.source.append("if(this.objects != null)\n{\nint length = objects.length;\nfor(int i = 0; i < objects.length; i++)\n{\nif(!(objects[i] instanceof ChangedValue))\ncontinue;\n\nChangedValue change = (ChangedValue)objects[i];\n" + this.valueTypeName + " value = (" + this.valueTypeName + ")change.newValue;\n" + "\n" + "if(value != null)\n" + "{\n" + "objects[i] = value;\n" + "}\n" + "else if(change.oldValue != null)\n" + "{\n" + "((com.evermind.server.ejb.EntityEJBObject) change.oldValue).updateFieldsBeforeLoadState();\n" + "}\n" + "}\n" + "clearRemoved();\n" + "}\n" + "dirty = false;\n" + "return;\n" + "}\n\n");
            return;
        }
        this.source.append("PreparedStatement deleteStatement = null;\nPreparedStatement insertStatement = null;\n");
        this.source.append("try\n{\nif(this.objects != null)\n{\n");
        this.appendDefinePrimaryKey();
        this.source.append("deleteStatement = EJBPrivileged.getCustomStatement(connection, \"");
        this.source.append(this.primaryKeysTable.getPreparedDeleteStatement(false), true);
        this.source.append("\"");
        EntityBeanDescriptor bean = this.compilation.descriptor;
        if (bean.getBatchSize() > 1) {
            this.source.append("," + bean.getBatchSize() + ",false");
        }
        this.source.append(");\n");
        this.source.append("insertStatement = EJBPrivileged.getCustomStatement(connection, \"");
        this.source.append(this.nonPrimaryKeyTable.getPreparedInsertStatement(false), true);
        this.source.append("\"");
        if (bean.getBatchSize() > 1) {
            this.source.append("," + bean.getBatchSize() + ",false");
        }
        this.source.append(");\n");
        this.source.append("int length = objects.length;\nfor(int i = 0; i < objects.length; i++)\n{\nif(!(objects[i] instanceof ChangedValue))\ncontinue;\n\nChangedValue change = (ChangedValue)objects[i];\n" + this.valueTypeName + " value = (" + this.valueTypeName + ")change.newValue;\n" + "\n" + "if(value == null)\n" + "{\n" + "value = (" + this.valueTypeName + ")change.oldValue;\n");
        TableIteration deleteIteration = new TableIteration();
        Iterator fields = this.getPrimaryKeysTable().getPrimaryKey().getPropertyFields().iterator();
        while (fields.hasNext()) {
            if (fields.next() == this.mapping.getKeyField()) {
                this.getPrimaryKeysTable().appendPreparedSet(this.source, false, "deleteStatement", this.mapping.getPrimaryKey().getType(), deleteIteration, "__thePrimaryKey", this.mapping.getPrimaryKey(), "context", true);
                continue;
            }
            this.getPrimaryKeysTable().appendPreparedSet(this.source, false, "deleteStatement", this.mapping.getValueField().getType(), deleteIteration, "value", this.mapping.getValueField(), "context", true);
        }
        this.source.append("deleteStatement.executeUpdate();\n}\nelse if(change.oldValue == null)\n{\n");
        TableIteration insertIteration = new TableIteration();
        this.getNonPrimaryKeyTable().appendPreparedSet(this.source, false, "insertStatement", this.mapping.getValueField().getType(), insertIteration, "value", this.mapping.getValueField(), "context", true);
        this.getNonPrimaryKeyTable().appendPreparedSet(this.source, false, "insertStatement", this.mapping.getPrimaryKey().getType(), insertIteration, "__thePrimaryKey", this.mapping.getPrimaryKey(), "context", true);
        this.source.append("try\n{\ninsertStatement.executeUpdate();\n}\ncatch(SQLException e)\n{\nPreparedStatement checkForInstanceStatement = EJBPrivileged.getCustomStatement(connection, \"");
        this.source.append(this.primaryKeysTable.getPreparedSelectStatement(false, "checkForInstanceStatement"), true);
        TableIteration checkForInstanceIteration = new TableIteration();
        fields = this.getPrimaryKeysTable().getPrimaryKey().getPropertyFields().iterator();
        while (fields.hasNext()) {
            if (fields.next() == this.mapping.getKeyField()) {
                this.getPrimaryKeysTable().appendPreparedSet(this.source, false, "checkForInstanceStatement", this.mapping.getPrimaryKey().getType(), checkForInstanceIteration, "__thePrimaryKey", this.mapping.getPrimaryKey(), "context", true);
                continue;
            }
            this.getPrimaryKeysTable().appendPreparedSet(this.source, false, "checkForInstanceStatement", this.mapping.getValueField().getType(), checkForInstanceIteration, "value", this.mapping.getValueField(), "context", true);
        }
        this.source.append("boolean existed;\ntry {\n ResultSet checkSet = checkForInstanceStatement.executeQuery();\nexisted = checkSet.next();\n} finally { try {\n checkForInstanceStatement.close();\n } catch(java.sql.SQLException ex) {}\n }\nif(!existed) throw e;\n}\nobjects[i] = value;\n");
        this.source.append("}\n}\n}\n}\n" + this.getCatches() + "finally\n" + "{\n" + "clearRemoved();\n" + "dirty = false;\n" + "if(deleteStatement != null) {\n try { deleteStatement.close();\n } catch(java.sql.SQLException e) {}\n }\n" + "if(insertStatement != null) {\n try { insertStatement.close();\n } catch(java.sql.SQLException e) {}\n }\n" + "}\n" + "}\n" + "\n");
    }

    public Vector getDependentClasses() {
        return null;
    }
}

