/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.PrimitiveTypeCache;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import java.lang.reflect.Method;

public abstract class MethodCompilation {
    protected ClassCompilation declaringClass;
    protected Method method;
    protected ByteString source = new ByteString(256);
    public ByteString staticFuncSource = new ByteString(256);
    public ByteString staticDeclSource = new ByteString(256);
    protected Class[] args;
    protected Class[] exceptions;
    protected String methodStateVariableName;
    private static int currentID;

    public static synchronized int getNextID() {
        return currentID++;
    }

    public void reset() {
        this.source.reset();
        if (this.staticFuncSource != null) {
            this.staticFuncSource.reset();
        }
        if (this.staticDeclSource != null) {
            this.staticDeclSource.reset();
        }
    }

    public MethodCompilation(ClassCompilation declaringClass, Method method) {
        this.declaringClass = declaringClass;
        this.method = method;
        this.args = method.getParameterTypes();
        this.exceptions = method.getExceptionTypes();
    }

    public ByteString getSource() {
        return this.source;
    }

    public abstract void compile() throws CompilationException;

    public void appendMethodWrapperStart(boolean synced) {
        int i;
        this.source.append("\npublic " + (synced ? "synchronized " : ""));
        String str = this.method.getReturnType().getName();
        str = str.replace('$', '.');
        this.source.append(ClassUtils.getSourceNotation(str, 0));
        this.source.append(" ");
        this.source.append(this.getMethodName());
        this.source.append("(");
        for (i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                this.source.append(", ");
            }
            this.source.append(ClassUtils.getClassNameFromSourceNotation(this.args[i], 0));
            this.source.append(" argument");
            this.source.append(i);
        }
        if (this.exceptions.length > 0) {
            this.source.append(") throws ");
            for (i = 0; i < this.exceptions.length; ++i) {
                if (i > 0) {
                    this.source.append(", ");
                }
                this.source.append(this.exceptions[i].getName());
            }
        } else {
            this.source.append(")");
        }
    }

    public void addSupportingMethods() throws CompilationException {
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public void checkThrows(Class type) throws CompilationException {
        Class<?>[] exceptionTypes = this.method.getExceptionTypes();
        if (exceptionTypes != null) {
            for (int i = 0; i < exceptionTypes.length; ++i) {
                if (!exceptionTypes[i].isAssignableFrom(type)) continue;
                return;
            }
        }
        throw new CompilationException("Method " + this.method + " must throw " + ClassUtils.getSourceNotation(type, 0));
    }

    protected void appendParamsToObjectArray() {
        Class<?>[] beanArgs = this.method.getParameterTypes();
        if (beanArgs.length == 0) {
            this.source.append("Object[] params = null;\n");
            return;
        }
        this.source.append("Object[] params = new Object[]{");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                this.source.append(", ");
            }
            if (beanArgs[i].isPrimitive()) {
                this.source.append(PrimitiveTypeCache.convertFromPrimitive("argument" + i));
                continue;
            }
            this.source.append("argument" + i);
        }
        this.source.append("};\n");
    }

    public String getInvocationTarget() {
        return "bean";
    }

    public String getResponseTypeName() {
        return this.method.getReturnType().getName();
    }

    protected String getMethodStateVariableName() {
        if (this.methodStateVariableName == null) {
            this.methodStateVariableName = "methodState" + MethodCompilation.getNextID();
        }
        return this.methodStateVariableName;
    }
}

