/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.BeanMethodCompilation;
import com.evermind.server.ejb.compilation.BeanMethodNotFoundException;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.server.ejb.compilation.CreateEntityBeanMethodCompilation;
import com.evermind.server.ejb.compilation.CustomFinderMethodCompilation;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.compilation.EntityBeanCompilation;
import com.evermind.server.ejb.compilation.EntityHomeMethodCompilation;
import com.evermind.server.ejb.compilation.FindByPrimaryKeyMethodCompilation;
import com.evermind.server.ejb.compilation.FinderMethodCompilation;
import com.evermind.server.ejb.compilation.HomeCompilation;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.server.ejb.database.TableView;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.FinderMethod;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import com.evermind.util.ServerProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;

public class EntityHomeCompilation
extends HomeCompilation {
    public EntityBeanCompilation beanCompilation;
    public Method findByPrimaryKeyMethod;
    public Method remoteFindByPrimaryKeyMethod;
    public Method findByPrimaryKeyBeanMethod;
    public EntityBeanDescriptor descriptor;
    public FindByPrimaryKeyMethodCompilation findByPrimaryKeyMethodCompilation;
    public FindByPrimaryKeyMethodCompilation remoteFindByPrimaryKeyMethodCompilation;
    boolean constructorHasRemoteException = false;
    boolean constructorHasCreateException = false;
    private List finderCacheVariables;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$javax$ejb$CreateException;

    public EntityHomeCompilation(EntityBeanCompilation beanCompilation) throws CompilationException {
        super(beanCompilation, "EntityHomeWrapper", beanCompilation.local ? beanCompilation.descriptor.getLocalHome() : beanCompilation.descriptor.getRemoteHome());
        this.beanCompilation = beanCompilation;
        this.descriptor = beanCompilation.descriptor;
        if (beanCompilation.local) {
            this.descriptor.setLocalHomeWrapperName(this.getName());
        } else {
            this.descriptor.setRemoteHomeWrapperName(this.getName());
        }
        try {
            Constructor constructor = this.descriptor.getEJBClass().getConstructor(ClassUtils.CLASS_NOARGS);
            int modifiers = constructor.getModifiers();
            if (!Modifier.isPublic(modifiers)) {
                throw new CompilationException("EJB class '" + this.descriptor.getEJBClassName() + "' must have a public no-arg constructor");
            }
            if (Modifier.isFinal(modifiers) && this.descriptor.isContainerManaged()) {
                throw new CompilationException("EJB class '" + this.descriptor.getEJBClassName() + "' cannot mark it's no-arg constructor as final");
            }
            Class<?>[] exceptionTypes = constructor.getExceptionTypes();
            if (exceptionTypes != null) {
                for (int i = 0; i < exceptionTypes.length; ++i) {
                    if (exceptionTypes[i] == (class$java$rmi$RemoteException == null ? EntityHomeCompilation.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException)) {
                        this.constructorHasRemoteException = true;
                        continue;
                    }
                    if (exceptionTypes[i] == (class$javax$ejb$CreateException == null ? EntityHomeCompilation.class$("javax.ejb.CreateException") : class$javax$ejb$CreateException)) {
                        this.constructorHasCreateException = true;
                        continue;
                    }
                    throw new CompilationException("EJB class '" + this.descriptor.getEJBClassName() + "' cannot throw exception '" + exceptionTypes[i].getName() + "' in it's no-arg constructor");
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new CompilationException("EJB class '" + this.descriptor.getEJBClassName() + "' must contain a public no-arg constructor");
        }
        try {
            this.findByPrimaryKeyMethod = this.descriptor.getFindByPrimaryKeyMethod(this.beanCompilation.local);
        }
        catch (InstantiationException e) {
            throw new CompilationException(e.getMessage());
        }
        this.findByPrimaryKeyMethodCompilation = new FindByPrimaryKeyMethodCompilation(this, this.findByPrimaryKeyMethod, this.beanCompilation.local);
    }

    public void cleanSource() {
        this.resetSource();
        if (this.findByPrimaryKeyMethod != null) {
            this.findByPrimaryKeyMethod = null;
        }
        if (this.remoteFindByPrimaryKeyMethod != null) {
            this.remoteFindByPrimaryKeyMethod = null;
        }
        if (this.findByPrimaryKeyBeanMethod != null) {
            this.findByPrimaryKeyBeanMethod = null;
        }
        if (this.finderCacheVariables != null) {
            this.finderCacheVariables.clear();
        }
    }

    public void compile() throws CompilationException {
        Iterator<Object> iterator;
        this.findByPrimaryKeyMethodCompilation.compile();
        this.methods.add(this.findByPrimaryKeyMethodCompilation);
        if (this.remoteFindByPrimaryKeyMethodCompilation != null) {
            this.remoteFindByPrimaryKeyMethodCompilation.compile();
            this.methods.add(this.remoteFindByPrimaryKeyMethodCompilation);
        }
        this.compileMethods();
        this.addDmsImports();
        String dbClass = this.beanCompilation.local ? "LocalDBEntityEJBHome" : "RemoteDBEntityEJBHome";
        String baseClassName = "com.evermind.server.ejb." + dbClass;
        this.addSharedImports();
        this.source.append("import com.evermind.server.ejb.*;\nimport com.evermind.server.*;\nimport java.util.*;\nimport java.lang.reflect.*;\nimport java.sql.*;\nimport javax.ejb.*;\nimport java.rmi.*;\nimport javax.transaction.*;\n\npublic class " + this.className + " extends " + baseClassName + " implements " + this.interfaceClass.getName() + "\n" + "{\n");
        TableView table = this.beanCompilation.persistenceManagerCompilation == null ? null : this.beanCompilation.persistenceManagerCompilation.table;
        this.addRemoveByPrimaryKeyMethod();
        if (!this.beanCompilation.local) {
            this.addRemoveByHandleMethod();
        }
        this.addFindExistingEntityMethod();
        this.addCompareMethod();
        this.addCreateInstanceMethod();
        this.addCreateWrapperInstanceMethod();
        this.addResetStateMethod();
        this.addHashCodeMethod();
        this.addGetEJBObjectMethod();
        this.addGetWrapperByPKMethod();
        this.addIfEntityExistMethod();
        this.addGetLazyInstanceMethod();
        this.addOneToOneGetMasterInMasterBean();
        this.appendMethods();
        if (this.beanCompilation.fieldPersistenceManagers != null) {
            iterator = this.beanCompilation.fieldPersistenceManagers.values().iterator();
            while (iterator.hasNext()) {
                this.source.append("static FieldPersistenceManager " + iterator.next() + ";\n");
            }
        }
        if (this.finderCacheVariables != null) {
            for (int i = 0; i < this.finderCacheVariables.size(); ++i) {
                this.source.append("java.util.Map " + this.finderCacheVariables.get(i) + " = new HashMap();\n");
            }
            this.source.append("\n");
        }
        this.source.append("public " + this.getName() + "() throws java.rmi.RemoteException\n" + "{\n");
        if (this.beanCompilation.local) {
            this.source.append("isRemote = false;\n");
        } else {
            this.source.append("isRemote = true;\n");
        }
        this.source.append("}\n\n");
        if (this.beanCompilation.fieldPersistenceManagers != null) {
            this.source.append("\nprotected void init()\n{\n");
            iterator = this.beanCompilation.fieldPersistenceManagers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.source.append(entry.getValue() + " = getFieldPersistenceManager(\"" + entry.getKey() + "\");\n");
            }
            this.source.append("}\n");
        }
        this.appendStaticDeclaration();
        this.appendStaticFunction();
        this.source.append("}\n");
        this.beanCompilation.compilation.addGenerator(this);
    }

    private void addHashCodeMethod() throws CompilationException {
        this.source.append("public int keyHashCode(Object object)\n{\n");
        this.source.append(this.beanCompilation.descriptor.getPrimaryKeyClassName() + " key = (" + this.beanCompilation.descriptor.getPrimaryKeyClassName() + ")object;\n");
        if (!this.descriptor.isContainerManaged() || this.descriptor.getPrimaryKeyFieldName() != null) {
            this.source.append("return key.hashCode();\n");
        } else {
            this.source.append("return " + this.beanCompilation.descriptor.getPrimaryKey().getHashCodeExpression("key.") + ";\n");
        }
        this.source.append("}\n");
        this.source.append("public int hashCode(Object object)\n{\ntry\n{\nif(object instanceof " + (this.beanCompilation.descriptor.isAutomaticIdentity() ? this.beanCompilation.descriptor.getPrimaryKey().getType().getName() : this.beanCompilation.descriptor.getPrimaryKeyClassName()) + ")\n" + "{\n" + this.beanCompilation.descriptor.getPrimaryKeyClassName() + " key = (" + this.beanCompilation.descriptor.getPrimaryKeyClassName() + ")object;\n");
        if (!this.descriptor.isContainerManaged() || this.descriptor.getPrimaryKeyFieldName() != null) {
            this.source.append("return key.hashCode();\n");
        } else {
            this.source.append("return " + this.beanCompilation.descriptor.getPrimaryKey().getHashCodeExpression("key.") + ";\n");
        }
        this.source.append("}\n\n" + this.beanCompilation.getName() + " key = (" + this.beanCompilation.getName() + ")object;\n");
        if (this.descriptor.getPrimaryKeyFieldName() != null || !this.descriptor.isContainerManaged()) {
            this.source.append("return key.primaryKey.hashCode();\n");
        } else {
            String aValueName = this.beanCompilation.descriptor.getPrimaryKey().getPropertyFields() == null ? "key." : "key.__";
            this.source.append("return " + this.beanCompilation.descriptor.getPrimaryKey().getHashCodeExpression(aValueName) + ";\n");
        }
        this.source.append("}\ncatch(NullPointerException e)\n{\nif(object == null) throw new NullPointerException(\"Primary key was null, make sure you are not passing a null primary key or a composite primary key with null fields\");\nthrow new NullPointerException(\"Primary key was null\");\n}\n}\n\n");
    }

    private void addCompareMethod() throws CompilationException {
        this.source.append("public boolean equalKeys(Object object1, Object object2)\n{\n" + this.beanCompilation.descriptor.getPrimaryKeyClassName() + " key1 = (" + this.beanCompilation.descriptor.getPrimaryKeyClassName() + ")object1;\n" + this.beanCompilation.descriptor.getPrimaryKeyClassName() + " key2 = (" + this.beanCompilation.descriptor.getPrimaryKeyClassName() + ")object2;\n");
        if (this.beanCompilation.descriptor.getPrimaryKeyFieldName() != null || !this.descriptor.isContainerManaged()) {
            this.source.append("return key1.equals(key2);\n");
        } else if (this.beanCompilation.descriptor.isAutomaticIdentity()) {
            this.source.append("return key1.equals(key2);\n");
        } else {
            this.source.append("return " + this.beanCompilation.descriptor.getPrimaryKey().getComparationExpression("key1.", "key2.") + ";\n");
        }
        this.source.append("}\n\n");
        this.source.append("public boolean equals(Object object1, Object object2)\n{\nif(object1 instanceof " + (this.beanCompilation.descriptor.isAutomaticIdentity() ? this.beanCompilation.descriptor.getPrimaryKey().getType().getName() : this.beanCompilation.descriptor.getPrimaryKeyClassName()) + ")\n" + "{\n" + this.beanCompilation.descriptor.getPrimaryKeyClassName() + " key1 = (" + this.beanCompilation.descriptor.getPrimaryKeyClassName() + ")object1;\n" + this.beanCompilation.getName() + " key2 = (" + this.beanCompilation.getName() + ")object2;\n");
        if (this.beanCompilation.descriptor.getPrimaryKeyFieldName() != null || !this.descriptor.isContainerManaged()) {
            this.source.append("return key1.equals(key2.primaryKey);\n");
        } else if (this.beanCompilation.descriptor.isAutomaticIdentity()) {
            this.source.append("return key1.equals(key2.primaryKey);\n");
        } else {
            this.source.append("return " + this.beanCompilation.descriptor.getPrimaryKey().getComparationExpression("key1.", "key2.__") + ";\n");
        }
        this.source.append("}\n\n" + this.beanCompilation.getName() + " key1 = (" + this.beanCompilation.getName() + ")object1;\n" + this.beanCompilation.getName() + " key2 = (" + this.beanCompilation.getName() + ")object2;\n");
        if (this.descriptor.getPrimaryKeyFieldName() != null || !this.descriptor.isContainerManaged()) {
            this.source.append("return key1.primaryKey.equals(key2.primaryKey);\n");
        } else if (this.descriptor.isAutomaticIdentity()) {
            this.source.append("return key1.primaryKey.equals(key2.primaryKey);\n");
        } else {
            this.source.append("return " + this.beanCompilation.descriptor.getPrimaryKey().getComparationExpression("key1.__", "key2.__") + ";\n");
        }
        this.source.append("}\n\n");
    }

    private void addRemoveByPrimaryKeyMethod() throws CompilationException {
        this.source.append("\nprivate Boolean excludeRemove = null;\n");
        this.source.append("\npublic void remove(Object primaryKey) throws " + (this.beanCompilation.local ? "" : "java.rmi.RemoteException, ") + "javax.ejb.RemoveException\n" + "{\n");
        this.source.append("if (excludeRemove == null) {\n");
        this.source.append("try {\n");
        this.source.append("Method method = getClass().getMethod(\"remove\", new Class[]{java.lang.Object.class});\n");
        this.source.append("MethodState state = new MethodState(getBeanDescriptor(), MethodState.WRAPPER_REMOVE, method, null, false, true);\n");
        this.source.append("excludeRemove = Boolean.valueOf(ExcludeInterceptor.isInExcludeList(state));\n");
        this.source.append("} catch(Exception e) {\n");
        this.source.append("// should never happen, but just in case...\n");
        if (this.beanCompilation.local) {
            this.source.append("throw new EJBException(e.getMessage(), e);\n");
        } else {
            this.source.append("throw new RemoteException(e.getMessage(), e);\n");
        }
        this.source.append("}\n");
        this.source.append("}\n");
        this.source.append("if (excludeRemove.booleanValue()) {\n");
        if (this.beanCompilation.local) {
            this.source.append("throw (EJBException)ExcludeInterceptor.localExclude();\n");
        } else {
            this.source.append("throw (RemoteException)ExcludeInterceptor.remoteExclude();\n");
        }
        this.source.append("}\n");
        this.source.append("try\n{\n");
        this.source.append(this.findByPrimaryKeyMethod.getReturnType().getName() + " instance = (" + this.findByPrimaryKeyMethod.getReturnType().getName() + ")this.findByPrimaryKey(" + ClassUtils.getConvertSource("((" + this.descriptor.getPrimaryKeyClassName() + ")primaryKey)", this.descriptor.getPrimaryKeyClass(), this.findByPrimaryKeyMethod.getParameterTypes()[0]) + ");\n" + "instance.remove();\n" + "}\n" + "catch(javax.ejb.FinderException e)\n" + "{\n" + "throw new " + (this.beanCompilation.local ? "javax.ejb.NoSuchObjectLocalException" : "java.rmi.NoSuchObjectException") + "(\"Object not found\");\n" + "}\n" + "catch(NoSuchEntityException e)\n" + "{\n" + "throw new " + (this.beanCompilation.local ? "javax.ejb.NoSuchObjectLocalException" : "java.rmi.NoSuchObjectException") + "(\"No such entity: \" + primaryKey);\n" + "}\n" + "catch(Exception e)\n" + "{\n" + "throw new javax.ejb.RemoveException" + "(\"Exception due to: \"  + e + \":\" + e.getMessage());\n" + "}\n" + "}\n");
    }

    private void addRemoveByHandleMethod() throws CompilationException {
        this.source.append("\npublic void remove(javax.ejb.Handle handle) throws java.rmi.RemoteException, javax.ejb.RemoveException\n{\nsuper.remove(handle);\n}\n");
    }

    public static String addEJBPrefix(String string) {
        return "ejb" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public MethodCompilation compileMethod(Method method) throws CompilationException {
        return this.compileMethod(method, this.beanCompilation.local);
    }

    public MethodCompilation compileMethod(Method method, boolean local) throws CompilationException {
        BeanMethodCompilation methodWrapper;
        block31: {
            methodWrapper = null;
            Class clazz = this.beanCompilation.local ? EJBLocalHome.class : EJBHome.class;
            if (method.getDeclaringClass() == clazz) {
                return null;
            }
            if (method.getName().startsWith("create")) {
                Method beanMethod;
                try {
                    beanMethod = this.beanCompilation.descriptor.getEJBClass().getMethod(EntityHomeCompilation.addEJBPrefix(method.getName()), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    ByteString buffer = new ByteString(100);
                    buffer.append(EntityHomeCompilation.addEJBPrefix(method.getName()) + "(");
                    Class<?>[] arguments = method.getParameterTypes();
                    for (int i = 0; i < arguments.length; ++i) {
                        if (i > 0) {
                            buffer.append(", ");
                        }
                        buffer.append(ClassUtils.getSourceNotation(arguments[i], 0));
                    }
                    buffer.append(")");
                    throw new CompilationException(buffer + " method not found in bean-class " + this.beanCompilation.descriptor.getEJBClassName());
                }
                methodWrapper = new CreateEntityBeanMethodCompilation(this.beanCompilation.persistenceManagerCompilation, this, method, beanMethod, local);
            } else {
                if (method.getName().equals("findByPrimaryKey")) {
                    if (!(method.equals(this.findByPrimaryKeyMethod) || this.beanCompilation.descriptor.getRemoteInterface() != null && this.beanCompilation.descriptor.getLocalInterface() != null && method.getDeclaringClass().isAssignableFrom(this.beanCompilation.descriptor.getRemoteHome()))) {
                        throw new CompilationException("Invalid additional findByPrimaryKey method in " + this.descriptor.getRemoteHomeName() + ": " + method);
                    }
                    return null;
                }
                if (method.getName().startsWith("find")) {
                    Class<?> returnType = method.getReturnType();
                    if (returnType != Collection.class && returnType != Enumeration.class && returnType != (local ? this.beanCompilation.descriptor.getLocalInterface() : this.beanCompilation.descriptor.getRemoteInterface())) {
                        throw new CompilationException(method.getName() + "() in " + (local ? this.beanCompilation.descriptor.getLocalHomeName() : this.beanCompilation.descriptor.getRemoteHomeName()) + " must return either a Collection, Enumeration or " + this.beanCompilation.descriptor.getPrimaryKeyClass());
                    }
                    try {
                        FinderMethod finder = this.beanCompilation.descriptor.getFinderMethod(method);
                        if (finder != null && this.beanCompilation.descriptor.isContainerManaged()) {
                            finder.setUsed(true);
                            methodWrapper = new CustomFinderMethodCompilation(this.beanCompilation.persistenceManagerCompilation, this, (EntityBeanDescriptor)this.beanCompilation.getDescriptor(), method, finder, local);
                            break block31;
                        }
                        methodWrapper = new FinderMethodCompilation(this, method, EntityHomeCompilation.addEJBPrefix(method.getName()), local);
                    }
                    catch (BeanMethodNotFoundException e) {
                        if (!this.beanCompilation.descriptor.isContainerManaged()) {
                            throw new CompilationException("Bean implementation of " + method + " in bean " + this.beanCompilation.descriptor.getName() + " (" + EntityHomeCompilation.addEJBPrefix(method.getName()) + "(...) is the expected bean-method name) not found");
                        }
                        String query = "";
                        boolean partial = true;
                        boolean _lazyLoading = ServerProperties.getCustomFinderMethodNoLazyLoading();
                        boolean _lazyLoading_specified = false;
                        try {
                            Class homeClass = this.areYouRemote() ? this.beanCompilation.getDescriptor().getRemoteHome() : this.beanCompilation.getDescriptor().getLocalHome();
                            Field queryField = homeClass.getField(method.getName() + "_query");
                            if (queryField != null && Modifier.isPublic(queryField.getModifiers()) && Modifier.isStatic(queryField.getModifiers()) && queryField.getType() == String.class) {
                                query = (String)queryField.get(null);
                                if (query == null) {
                                    query = "";
                                }
                                String NON_LAZY_LOADING = "nonLazyLoading:";
                                String LAZY_LOADING = "lazyLoading:";
                                if (query.startsWith(NON_LAZY_LOADING)) {
                                    _lazyLoading = false;
                                    query = query.substring(NON_LAZY_LOADING.length());
                                    _lazyLoading_specified = true;
                                } else if (query.startsWith(LAZY_LOADING)) {
                                    _lazyLoading = true;
                                    query = query.substring(LAZY_LOADING.length());
                                    _lazyLoading_specified = true;
                                }
                                if (query.startsWith("full:")) {
                                    partial = false;
                                    query = query.substring("full:".length());
                                }
                            }
                        }
                        catch (NoSuchFieldException nsfe) {
                        }
                        catch (IllegalAccessException iae) {
                            // empty catch block
                        }
                        if (query.equals("") && partial && this.beanCompilation.descriptor.getEJBQuery(method) == null && method.getParameterTypes().length == 1 && method.getName().startsWith("findBy")) {
                            ContainerManagedField field;
                            Iterator iterator;
                            String property = method.getName().substring(6);
                            if (this.beanCompilation.descriptor.isContainerManaged()) {
                                iterator = this.beanCompilation.descriptor.getContainerManagedFields().iterator();
                                while (iterator.hasNext()) {
                                    field = (ContainerManagedField)iterator.next();
                                    if (!field.getName().equalsIgnoreCase(property) || field.getType() != method.getParameterTypes()[0]) continue;
                                    query = "$" + field.getName() + " = $1";
                                    break;
                                }
                            }
                            if (query.equals("") && this.beanCompilation.descriptor.getPrimaryKey() != null && this.beanCompilation.descriptor.getPrimaryKey().getPropertyFields() != null) {
                                iterator = this.beanCompilation.descriptor.getPrimaryKey().getPropertyFields().iterator();
                                while (iterator.hasNext()) {
                                    field = (ContainerManagedField)iterator.next();
                                    if (!field.getName().equalsIgnoreCase(property) || field.getType() != method.getParameterTypes()[0]) continue;
                                    query = "$" + field.getName() + " = $1";
                                    break;
                                }
                            }
                        }
                        FinderMethod finder = FinderMethod.lookupEjbqlFinderMethod(this.descriptor, method, query, partial, _lazyLoading, _lazyLoading_specified);
                        finder.setUsed(true);
                        this.beanCompilation.descriptor.addFinderMethod(finder);
                        methodWrapper = new CustomFinderMethodCompilation(this.beanCompilation.persistenceManagerCompilation, this, (EntityBeanDescriptor)this.beanCompilation.getDescriptor(), method, finder, local);
                    }
                } else {
                    methodWrapper = new EntityHomeMethodCompilation(this, method, method.getName(), local);
                }
            }
        }
        if (methodWrapper != null) {
            ((MethodCompilation)methodWrapper).compile();
        }
        return methodWrapper;
    }

    public void addFindExistingEntityMethod() {
        this.source.append("\nprotected void findExistingEntity(" + this.beanCompilation.getName() + " wrapper, ApplicationServerTransaction transaction) throws javax.ejb.FinderException" + (this.beanCompilation.local ? ", javax.ejb.NoSuchObjectLocalException" : ", java.rmi.RemoteException") + "\n" + "{\n");
        this.source.append("try\n{\n");
        this.beanCompilation.appendCopyObjectPkFieldFromWrapper(this.source, "wrapper");
        this.source.append("wrapper.loadState(transaction);\n\n");
        this.source.append("}\n");
        if (this.beanCompilation.descriptor.isContainerManaged()) {
            this.source.append("catch(javax.ejb.NoSuchEntityException e)\n{\ntraceLog(\"loadState returned NoSuchEntityException: \" + e);\nwrapper.releaseContext(false);\n");
            this.source.append(ClassCompilation.convertRemoteException("removeWrapperInstance(wrapper)"));
            this.source.append((this.beanCompilation.local ? "throw new javax.ejb.NoSuchObjectLocalException(e.getMessage());\n" : "throw new java.rmi.NoSuchObjectException(e.getMessage());\n") + "}\n");
            this.source.append("catch(java.rmi.NoSuchObjectException e)\n{\ntraceLog(\"loadState returned NoSuchObejctException: \" + e);\nwrapper.releaseContext(false);\n");
            this.source.append(ClassCompilation.convertRemoteException("removeWrapperInstance(wrapper)"));
            this.source.append((this.beanCompilation.local ? "throw new javax.ejb.NoSuchObjectLocalException(e.getMessage());\n" : "throw new java.rmi.NoSuchObjectException(e.getMessage());\n") + "}\n" + "catch(java.sql.SQLException e)\n" + "{\n" + "traceLog(\"loadState returned a SQLException : \" + e);\n" + "wrapper.releaseContext(false);\n");
            this.source.append(ClassCompilation.convertRemoteException("removeWrapperInstance(wrapper)"));
            this.source.append("OC4J_log(e);\nthrow new " + (this.beanCompilation.local ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Database error: \" + e.getMessage(), e);\n" + "}\n" + "catch(java.io.IOException e)\n" + "{\n" + "traceLog(\"loadState returned an IOException: \" + e);\n" + "wrapper.releaseContext(false);\n");
            this.source.append(ClassCompilation.convertRemoteException("removeWrapperInstance(wrapper)"));
            this.source.append("OC4J_log(e);\nthrow new " + (this.beanCompilation.local ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Database error, IO failure: \" + e, e);\n" + "}\n" + "catch(ClassNotFoundException e)\n" + "{\n" + "wrapper.releaseContext(false);\n");
            this.source.append(ClassCompilation.convertRemoteException("removeWrapperInstance(wrapper)"));
            this.source.append("OC4J_log(e);\nthrow new " + (this.beanCompilation.local ? "javax.ejb.EJBException" : "oracle.oc4j.rmi.OracleRemoteException") + "(\"Database error, class not found: \" + e.getMessage(), e);\n" + "}\n");
        }
        this.source.append("catch(Throwable t)\n{\n");
        this.source.append(ClassCompilation.convertRemoteException("removeWrapperInstance(wrapper)"));
        this.source.append("OC4J_log(\"Error in ejbLoad()\", t);\n" + BeanMethodCompilation.getRollbackTransaction("\"Error in ejbLoad: \" + t", "t", EJBCompilationUtils.getTransactionString()));
        if (this.beanCompilation.local) {
            this.source.append("if(t instanceof Exception) throw com.evermind.server.ejb.EJBUtils.createEJBException(\"Error in ejbLoad: \" + t, (Exception)t);\nelse throw com.evermind.server.ejb.EJBUtils.createEJBException(\"Error in ejbLoad: \" + t, new oracle.oc4j.rmi.OracleRemoteException(\"Error in ejbLoad: \" + t, t));\n");
        } else {
            this.source.append("throw new oracle.oc4j.rmi.OracleRemoteException(\"Error in ejbLoad: \" + t, t);\n");
        }
        this.source.append("}\n");
        this.source.append("}\n\n");
    }

    public void addCreateWrapperInstanceMethod() {
        this.source.append("public EntityEJBObject createBeanWrapperInstance(EvermindEntityContext ctx, boolean init)\n{\nreturn new " + this.beanCompilation.getName() + "(ctx, init, this);\n" + "}\n");
    }

    public void addGetWrapperByPKMethod() {
        this.source.append("public AbstractEJBObject getWrapperByPK (ApplicationServerTransaction _tx, Object _pk) throws RemoteException {\n");
        this.source.append("if (_pk == null) {\nthis.OC4J_log(new Exception(\"passing a null as primary key to getWrapperByPK\"));\nreturn null;\n}\n");
        long callTimeout = this.descriptor.getCallTimeout();
        boolean containerManaged = this.descriptor.isContainerManaged();
        this.source.append(this.beanCompilation.getName() + " wrapper = null;\n");
        this.source.append("boolean addedNow = false;\n");
        this.source.append("boolean reentrantCall = false;\nEntityEJBObject wrapperToCallEndCallOn = null;\nboolean hasBeenCached = false; \nThreadState thread = ThreadState.getCurrentState();\ncom.evermind.server.ContextContainer previousContainer = thread.contextContainer;\nthread.contextContainer = this;\ntry\n{\n");
        this.source.append("if (_tx != null) {\nwrapper = (" + this.beanCompilation.getName() + ")_tx.getCachedEntityObject(\"" + this.beanCompilation.getName() + "\", _pk);\n" + "hasBeenCached = (wrapper != null);\n" + "}\n" + "if (wrapper == null)\n {\n");
        if (!this.descriptor.hasExclusiveWriteAccess()) {
            this.source.append(ClassCompilation.convertRemoteException("wrapper = (" + this.beanCompilation.getName() + ")getWrapperInstance(_pk, " + callTimeout + "l, true, (_tx != null))", this.beanCompilation.local));
        } else {
            this.source.append(ClassCompilation.convertRemoteException("wrapper = (" + this.beanCompilation.getName() + ")getWrapperInstance(_pk, " + callTimeout + "l, true, true)", this.beanCompilation.local));
        }
        this.source.append("wrapper.transaction = _tx;\n");
        if (containerManaged) {
            if (this.descriptor.getPrimaryKeyFieldName() != null) {
                this.source.append("wrapper.primaryKey = (" + this.descriptor.getPrimaryKeyClassName() + ") _pk;\n");
            } else if (this.descriptor.isAutomaticIdentity()) {
                this.source.append("wrapper.primaryKey = " + ClassUtils.getConvertSource("_pk", Object.class, Long.class) + ";\n");
            } else {
                Iterator iterator = this.descriptor.getPrimaryKey().getPropertyFields().iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    this.source.append("wrapper.__" + field.getName() + " = ((" + this.descriptor.getPrimaryKeyClassName() + ")_pk)." + field.getName() + ";\n");
                }
            }
        } else {
            this.source.append("wrapper.primaryKey = (" + this.descriptor.getPrimaryKeyClassName() + ") _pk;\n");
        }
        if (!this.descriptor.getCommitOption().isCacheable() && !this.descriptor.isReadOnlyBMP()) {
            this.source.append("if (_tx != null)\n");
            this.source.append("getBeanDescriptor().getLifecycleManager().postActivate(wrapper.context.getObject(), wrapper.context);\n");
        }
        if (this.descriptor.hasExclusiveWriteAccess()) {
            this.source.append("wrapper.loadState(_tx);\n");
        }
        this.source.append("}\n");
        this.source.append("else\n{\n");
        this.source.append("if (wrapper.context == null)\nwrapper.reActivateNew(false);\n");
        this.source.append("}\n");
        this.source.append("if (_tx != null) {\n");
        this.source.append("if (!hasBeenCached)\n");
        this.source.append("_tx.registerBean(wrapper, false);\n");
        this.source.append("} \n");
        this.source.append("return wrapper;\n");
        this.source.append("} catch (Exception e) {\n");
        this.source.append("throw new RemoteException(e.getMessage());\n");
        this.source.append("}\n");
        this.source.append("finally\n");
        this.source.append("{\n");
        this.source.append("thread.contextContainer = previousContainer;\n");
        this.source.append("}\n");
        this.source.append("}\n\n");
    }

    public void addIfEntityExistMethod() throws CompilationException {
        if (!this.descriptor.isContainerManaged()) {
            return;
        }
        boolean pessi = this.descriptor.getLockingMode() == 1;
        this.source.append("public boolean ifEntityExist (" + this.descriptor.getPrimaryKeyClassName() + " _pk) throws RemoteException {\n");
        this.source.append("// according to Anil, this is the right way to get connection\n");
        this.source.append("DataSourceConnection connection = dataSourceContainer.get" + (!this.areYouRemote() ? "Local" : "") + "Connection();\n");
        this.source.append("java.sql.ResultSet set = null; \n");
        this.source.append("String sqlStatement =\"\"; \n");
        this.source.append("try {\n");
        this.source.append("Flag findStatementCached = new Flag(false);\n PreparedStatement findStatement = null;\nif(" + EJBCompilationUtils.getTransactionEqualsNullString() + ")\n" + "{\n" + "findStatement = EJBPrivileged.getCustomStatement(connection, findStatementCached,\"");
        this.source.append(this.beanCompilation.persistenceManagerCompilation.table.getPreparedSelectStatementOld(true), true);
        this.source.append("\");\nsqlStatement = \"" + this.beanCompilation.persistenceManagerCompilation.table.getPreparedSelectStatementOld(true) + "\";\n" + "}\n" + "else\n" + "{\n" + "findStatement = EJBPrivileged.getCustomStatement(connection, findStatementCached,\"");
        this.source.append(this.beanCompilation.persistenceManagerCompilation.table.getPreparedSelectStatement(true, "findStatement"), true);
        this.source.append("\nsqlStatement = \"" + this.beanCompilation.persistenceManagerCompilation.table.getPreparedSelectStatement(true, null) + "\";\n" + "}\n");
        if (pessi) {
            this.source.append(" findStatement.setQueryTimeout(" + this.descriptor.getCallTimeout() / 1000L + ");\n");
        }
        this.beanCompilation.setPKVariablesInJDBCStatement(this.source, "findStatement", "_pk2", "_pk", "context");
        this.source.append("traceLog(\"about to select ... \" + _pk);\n");
        this.source.append("traceLog(\"executing select\\n\");\nboolean hasNext = false;\ntry {\nset = findStatement.executeQuery();\nhasNext = set.next();\n} finally { try {  findStatement.close();\n} catch(java.sql.SQLException e) {}\n }\ntraceLog(\"Done ...\\n\");\nreturn hasNext;\n");
        this.source.append("} catch (SQLException e) {\nString aMessage = null;\nif (connection != null) {\n// Anil said that we should close with true when SQLException occurs\nconnection.close(true);\nconnection = null;\n}\nif (SystemProperties.SQLLOG) \n{\naMessage = e.getMessage() +  sqlStatement;\n}\nelse \n{\naMessage = e.getMessage();\n}\nthrow new RemoteException(aMessage);\n");
        this.source.append("} finally { \n// Anil said that we should always close with *false* unless SQLException occurs\nif (connection != null) connection.close(false);\n}\n");
        this.source.append("}\n\n");
    }

    public void addGetLazyInstanceMethod() {
        this.source.append("public AbstractEJBObject getLazyInstance(Object keyObject) throws java.rmi.RemoteException\n{\n");
        this.source.append("traceLog(\"getLazyInstanceMethod() is called\\n\");\n");
        this.appendNewFindLazyMethod();
    }

    public void addOneToOneGetMasterInMasterBean(ContainerManagedField field) throws CompilationException {
        EntityBeanCompilation peerBeanComp = (EntityBeanCompilation)this.beanCompilation.compilation.getBeanCompilation(field.getEJBReferenceHome());
        if (peerBeanComp == null) {
            throw new CompilationException("Can not find the descriptor for Reference Home:" + field.getEJBReferenceHome());
        }
        this.source.append("\n// statement caching maybe not properly supported; defined column types not supported yet\n");
        this.source.append("private AbstractEJBObject getOneToOneOwnerFor" + field.getPeerName() + "_" + field.getPureName() + " (" + "Object _pkx, ApplicationServerTransaction _tx) {\n");
        this.source.append("DataSourceConnection connection = null;\n");
        this.source.append("try {\n");
        this.source.append(peerBeanComp.descriptor.getPrimaryKeyClassName() + " _pk = (" + peerBeanComp.descriptor.getPrimaryKeyClassName() + ") _pkx;\n");
        this.source.append("connection = dataSourceContainer.get" + (!this.areYouRemote() ? "Local" : "") + "Connection();\n");
        this.source.append(this.descriptor.getPrimaryKeyClassName() + " key = null;\n");
        this.source.append("java.sql.ResultSet set = null; \n");
        this.source.append("Flag findStatementCached = new Flag(false);\n java.sql.PreparedStatement findStatement;\n // we should not do any \"for update\" in the this statement\nfindStatement = EJBPrivileged.getCustomStatement(connection, findStatementCached,\"");
        this.source.append(this.beanCompilation.persistenceManagerCompilation.table.getPreparedOneToOneSelectStatement(false, "findStatement", field.getEJBReferenceHome() + "_" + field.getName()), true);
        this.source.append("\");\n\n");
        peerBeanComp.setPKVariablesInJDBCStatement(this.source, "findStatement", "_pk2", "_pk", "context");
        this.source.append("traceLog(\"executing select\\n\");\ntry {\nset = findStatement.executeQuery();\n");
        this.source.append("\n if (set.next()) {\n");
        this.beanCompilation.getPKFromJDBCResultSet(this.source, "key", false);
        this.source.append("\n// tchou_todo: multiple results not OK but we have not checked for it yet.\n");
        this.source.append("return getWrapperByPK(_tx, key);\n");
        this.source.append("}\n");
        this.source.append("} finally { try {  findStatement.close();\n} catch(java.sql.SQLException e) {}\n }\n");
        this.source.append("} catch (SQLException e) {\n");
        this.source.append("OC4J_log(e);\n");
        this.source.append("// Anil said that we should close with true when SQLException occurs\n");
        this.source.append("if (connection != null) {connection.close(true); connection = null; }\n");
        this.source.append("} catch (Exception e) {\n");
        this.source.append("OC4J_log(e);\n");
        this.source.append("} finally {\n// Anil said that we should always close with *false* unless SQLException occurs\n");
        this.source.append("if (connection != null) connection.close(false);\n");
        this.source.append("} \n");
        this.source.append("return null;\n");
        this.source.append("}\n\n");
    }

    public void addOneToOneGetMasterInMasterBean() throws CompilationException {
        if (!this.beanCompilation.descriptor.isContainerManaged()) {
            return;
        }
        Iterator iterator = this.beanCompilation.descriptor.getContainerManagedFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (!field.isCMR() || !field.isOneToOne() || !field.isUniDirectional() || !field.isMasterInUniDirectional()) continue;
            this.addOneToOneGetMasterInMasterBean(field);
        }
        boolean first = true;
        iterator = this.beanCompilation.descriptor.getContainerManagedFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (!field.isCMR() || !field.isOneToOne() || !field.isUniDirectional() || !field.isMasterInUniDirectional()) continue;
            if (first) {
                this.source.append("\npublic AbstractEJBObject getOneToOneOwnerFor (String _beanName, Object _pk, ApplicationServerTransaction _tx) {\n");
                this.source.append("if (_beanName.equals(\"" + field.getPeerName() + "_" + field.getName() + "\")) {\n");
                this.source.append("return getOneToOneOwnerFor" + field.getPeerName() + "_" + field.getPureName() + "(_pk, _tx);\n");
                first = false;
                continue;
            }
            this.source.append("} else if (_beanName.equals(\"" + field.getPeerName() + "_" + field.getName() + "\")) {\n");
            this.source.append("return getOneToOneOwnerFor" + field.getPeerName() + "_" + field.getPureName() + "(_pk, _tx);\n");
        }
        if (!first) {
            this.source.append("}\n");
            this.source.append("return null;\n");
            this.source.append("}\n\n");
        }
    }

    private void appendNewFindLazyMethod() {
        this.source.append("return  getWrapperByPK(" + EJBCompilationUtils.getTransactionString() + ",keyObject);\n}\n");
    }

    public void addGetEJBObjectMethod() {
        this.source.append("public EJBObject getEJBObject(Object key) throws EJBException, FinderException" + (this.beanCompilation.local ? "\n" : ", RemoteException\n") + "{\n" + "try\n" + "{\n" + "return (EJBObject)findByPrimaryKey(" + ClassUtils.getConvertSource("((" + this.descriptor.getPrimaryKeyClassName() + ")key)", this.descriptor.getPrimaryKeyClass(), this.findByPrimaryKeyMethod.getParameterTypes()[0]) + ");\n" + "}\n" + "catch(EJBException e)\n" + "{\n" + "throw e;\n" + "}\n" + "catch(FinderException e)\n" + "{\n" + "throw e;\n" + "}\n" + (this.beanCompilation.local ? "" : "catch(RemoteException e)\n{\nthrow e;\n}\n") + "catch(Exception e)\n" + "{\n" + "throw new EJBException" + "(\"Exception due to: \"  + e + \":\" + e.getMessage());\n" + "}\n" + "}\n" + "\n");
    }

    public BeanDescriptor getDescriptor() {
        return this.beanCompilation.getDescriptor();
    }

    public void addCreateInstanceMethod() throws CompilationException {
        if (this.constructorHasRemoteException || this.constructorHasCreateException) {
            this.source.append("public EntityBean createInstance()\n{\ntry\n{\nreturn new " + this.beanCompilation.getCMPClassName() + "();\n" + "}\n");
            if (this.constructorHasRemoteException) {
                this.source.append("catch(java.rmi.RemoteException e)\n{\nthrow com.evermind.server.ejb.EJBUtils.createEJBException(e);\n}\n");
            }
            if (this.constructorHasCreateException) {
                this.source.append("catch(javax.ejb.CreateException e)\n{\nthrow com.evermind.server.ejb.EJBUtils.createEJBException(e);\n}\n");
            }
            this.source.append("}\n\n");
        } else {
            this.source.append("public EntityBean createInstance()\n{\nreturn new " + this.beanCompilation.getCMPClassName() + "();\n" + "}\n" + "\n");
        }
    }

    public void addResetStateMethod() {
        this.source.append("public void resetState(EntityBean bean)\n{\n" + this.beanCompilation.getCMPClassName() + " object = (" + this.beanCompilation.getCMPClassName() + ")bean;\n");
        if (this.descriptor.isContainerManaged()) {
            this.beanCompilation.appendFieldReset(this.source, "object");
        }
        this.source.append("}\n\n");
    }

    public String getFinderCacheVariable() {
        if (this.finderCacheVariables == null) {
            this.finderCacheVariables = new ArrayList();
        }
        String name = "__finderCache" + ClassCompilation.getNextID();
        this.finderCacheVariables.add(name);
        return name;
    }
}

