/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.bytecode.ClassData;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.MethodData;
import com.evermind.bytecode.RawCodeAttribute;
import com.evermind.compiler.CompilationException;
import com.evermind.io.IOUtils;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.compilation.BeanCompilation;
import com.evermind.server.ejb.compilation.BeanMethodCompilation;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.server.ejb.compilation.Compilation;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.compilation.EntityBeanMethodCompilation;
import com.evermind.server.ejb.compilation.EntityHomeCompilation;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.server.ejb.compilation.ORCollectionCompilation;
import com.evermind.server.ejb.compilation.ORCompilation;
import com.evermind.server.ejb.compilation.ORSetCompilation;
import com.evermind.server.ejb.compilation.PersistenceManagerCompilation;
import com.evermind.server.ejb.compilation.RemoveEntityBeanMethodCompilation;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.database.Table;
import com.evermind.server.ejb.database.TableIteration;
import com.evermind.server.ejb.database.TableView;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.CollectionORMapping;
import com.evermind.server.ejb.deployment.CommitOptionDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.deployment.FinderMethod;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.deployment.ORMapping;
import com.evermind.server.ejb.deployment.PrimaryKeyContext;
import com.evermind.util.ArraySet;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import com.evermind.util.ServerProperties;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityContext;
import javax.mail.internet.InternetAddress;

public class EntityBeanCompilation
extends BeanCompilation {
    static final ByteString EJBPOSTCREATE = new ByteString("ejbPostCreate");
    public DatabaseSchema schema;
    public EntityHomeCompilation home;
    public PersistenceManagerCompilation persistenceManagerCompilation;
    public EntityBeanDescriptor descriptor;
    public boolean hasIsModifiedMethod;
    protected Map fieldPersistenceManagers;
    public boolean containsORMapping;
    public boolean exclusiveAccess;
    public List oneToOneFields;
    public ClassSerialization beanClassSerialization;
    public ClassData beanClassData;
    public ContainerManagedField[] primaryKeyFields;
    public ContainerManagedField[] containerManagedFields;
    public boolean cmp2_0;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Vector;

    public EntityBeanCompilation(Compilation compilation, EntityBeanDescriptor descriptor, boolean local) throws CompilationException {
        super(compilation, "EntityBeanWrapper", local ? descriptor.getLocalInterface() : descriptor.getRemoteInterface(), local);
        if (descriptor == null) {
            throw new NullPointerException("descriptor was null");
        }
        this.descriptor = descriptor;
        this.cmp2_0 = descriptor.isContainerManaged() && descriptor.isCMP2_0();
        this.exclusiveAccess = descriptor.hasExclusiveWriteAccess();
        try {
            descriptor.initializeCMPFields(compilation.container);
            if (descriptor.isContainerManaged()) {
                this.containerManagedFields = descriptor.getContainerManagedFields().toArray(new ContainerManagedField[descriptor.getContainerManagedFields().size()]);
            }
        }
        catch (InstantiationException e) {
            throw new CompilationException(e.getMessage());
        }
        URL classURL = this.descriptor.getPackage().getEJBClassLoader().getResource(this.descriptor.getEJBClassName().replace('.', '/') + ".class");
        if (classURL != null) {
            try {
                byte[] data = IOUtils.getContent(classURL);
                DataInputStream classIn = new DataInputStream(new ByteArrayInputStream(data));
                this.beanClassSerialization = new ClassSerialization();
                this.beanClassData = this.beanClassSerialization.read(descriptor.getEJBClassName(), classIn, null, 3, false);
            }
            catch (IOException e) {
            }
            catch (ClassFormatError e) {
                // empty catch block
            }
        }
        this.container = compilation.container;
        try {
            this.descriptor.setDataSourceName(compilation.container.getApplication().getProperCMTSourceName(this.descriptor.getDataSourceName()));
            if (this.descriptor.isContainerManaged()) {
                this.schema = compilation.container.getApplication().getDatabaseSchema(this.descriptor.getDataSourceName());
            }
        }
        catch (InstantiationException e) {
            throw new CompilationException(e.getMessage());
        }
        if (this.descriptor.isContainerManaged()) {
            if (this.descriptor.getEntityBeanCompilation(!local) == null) {
                this.persistenceManagerCompilation = new PersistenceManagerCompilation(this);
                this.compilation.addGenerator(this.persistenceManagerCompilation);
                this.descriptor.setEntityBeanCompilation(this, local);
            } else {
                this.persistenceManagerCompilation = this.descriptor.getEntityBeanCompilation((boolean)(!local ? true : false)).persistenceManagerCompilation;
            }
        }
        if (local) {
            descriptor.setLocalWrapperName(this.getName());
        } else {
            descriptor.setRemoteWrapperName(this.getName());
        }
    }

    public boolean isMethodEmpty(ByteString name, ByteString signature) {
        ByteString code = this.getMethodCode(name, signature);
        return code != null && code.length <= 1;
    }

    public TableIteration getPKFromJDBCResultSet(ByteString _source, String _key, boolean _partial) throws CompilationException {
        TableIteration _tableIter = new TableIteration();
        _source.append("\n");
        if (this.descriptor.getPrimaryKeyFieldName() == null && !this.descriptor.isAutomaticIdentity()) {
            _source.append(_key + " = new " + this.descriptor.getPrimaryKeyClassName() + "();\n");
            Set fields = this.descriptor.getPrimaryKey().getPropertyFields();
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                EntityBeanCompilation.appendJDBCGetterMethod(this.local, _key + "." + field.getName(), _source, true, "set", field, _tableIter, this, this.local ? "localWrapper.context" : "remoteWrapper.context", !_partial, false, null);
            }
        } else {
            _source.append(ClassUtils.getSourceNotation(this.descriptor.getPrimaryKey().getType(), 0) + " tempKey;\n");
            EntityBeanCompilation.appendJDBCGetterMethod(this.local, "tempKey", _source, true, "set", this.descriptor.getPrimaryKey(), _tableIter, this, this.local ? "localWrapper.context" : "remoteWrapper.context", !_partial, false, null);
            _source.append(_key + " = " + ClassUtils.getConvertSource("tempKey", this.descriptor.getPrimaryKey().getType(), this.descriptor.getPrimaryKeyClass()));
            _source.append(";\n");
        }
        return _tableIter;
    }

    public void setPKVariablesInJDBCStatement(ByteString _source, String _stmt, String _lhs, String _rhs, String _ctxString) throws CompilationException {
        EntityBeanDescriptor _desc = this.descriptor;
        PersistenceManagerCompilation _cmpComp = this.persistenceManagerCompilation;
        TableIteration tableIteration = new TableIteration();
        if (_desc.getPrimaryKeyFieldName() != null || _desc.isAutomaticIdentity()) {
            if (_desc.isAutomaticIdentity()) {
                _source.append(_desc.getPrimaryKey().getType().getName() + " " + _lhs + " = (" + _desc.getPrimaryKey().getType().getName() + ") " + _rhs + ";\n");
            }
            ContainerManagedField field = _desc.getPrimaryKey();
            _cmpComp.table.appendPreparedSet(_source, true, _stmt, field.getType(), tableIteration, ClassUtils.getConvertSource(_desc.isAutomaticIdentity() ? _lhs : _rhs, _desc.getPrimaryKeyClass(), field.getType()), field, _ctxString, true);
        } else {
            Iterator iterator = _desc.getPrimaryKey().getPropertyFields().iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                _cmpComp.table.appendPreparedSet(_source, true, _stmt, field.getType(), tableIteration, _rhs + "." + field.getName(), field, _ctxString, true);
            }
        }
    }

    public static boolean isReturn(int code) {
        switch (code) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    public boolean isGetterOnly(ByteString name, ByteString signature) {
        ByteString code = this.getMethodCode(name, signature);
        return code != null && (code.length <= 1 || code.data[code.offset] == 180 && EntityBeanCompilation.isReturn(code.data[code.offset + 3]));
    }

    public ByteString getMethodCode(ByteString name, ByteString signature) {
        if (this.beanClassData != null) {
            for (int i = 0; i < this.beanClassData.methodCount; ++i) {
                MethodData method = this.beanClassData.methods[i];
                if (!method.name.equals(name) || !method.descriptor.equals(signature)) continue;
                RawCodeAttribute code = method.getCodeAttribute();
                return code == null ? null : code.getCode();
            }
        }
        return null;
    }

    public void createTable(TableView table) throws CompilationException {
        try {
            DataSourceConnectionContainer container = this.descriptor.getDataSourceContainer(this.compilation.container);
            this.compilation.createTable(table, container);
        }
        catch (InstantiationException e) {
            throw new CompilationException("Error finding a suitable DataSource: " + e.getMessage());
        }
    }

    public void describeTable(TableView table, EntityBeanDescriptor desc) throws CompilationException {
        try {
            DataSourceConnectionContainer container = this.descriptor.getDataSourceContainer(this.compilation.container);
            this.compilation.describeTable(table, desc, container);
        }
        catch (InstantiationException e) {
            throw new CompilationException("Error finding a suitable DataSource: " + e.getMessage());
        }
    }

    public ExposableBeanDescriptor getDescriptor() {
        return this.descriptor;
    }

    public EntityBeanDescriptor getEntityBeanDescriptor() {
        return this.descriptor;
    }

    public void preCompile() throws CompilationException {
        if (this.descriptor.isContainerManaged()) {
            if (!this.descriptor.getCmp20_compiled()) {
                Iterator iterator = this.descriptor.getContainerManagedFields().iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    field.checkName(this.schema);
                    if (field.getORMapping() != null) {
                        this.containsORMapping = true;
                    }
                    if (field.getPeer() == null || field.getPeer().isMany() || field.getPeer().getPeer().isMany() || field.getPeer().getRelation() == null) continue;
                    if (this.oneToOneFields == null) {
                        this.oneToOneFields = new ArrayList();
                    }
                    this.oneToOneFields.add(field);
                }
                if (this.schema == null) {
                    throw new NullPointerException("Schema was null");
                }
                try {
                    this.persistenceManagerCompilation.table = new TableView(this.compilation.getTable(this.descriptor), this.descriptor.getPrimaryKey(this.compilation.container, this.schema), this.descriptor.getContainerManagedFields(), true, this);
                    this.persistenceManagerCompilation.table.setEnvironment(this.compilation.container, this.schema);
                }
                catch (InstantiationException e) {
                    throw new CompilationException(e.getMessage());
                }
                this.createTable(this.persistenceManagerCompilation.table);
            } else {
                this.oneToOneFields = this.descriptor.getEntityBeanCompilation((boolean)(!this.local ? true : false)).oneToOneFields;
            }
        }
    }

    public void compile() throws CompilationException {
        String pKClassNm__;
        try {
            Method method = this.descriptor.getEJBClass().getMethod("isModified", ClassUtils.CLASS_NOARGS);
            if (Modifier.isPublic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && method.getReturnType() == Boolean.TYPE) {
                this.hasIsModifiedMethod = true;
                if (method.getExceptionTypes().length != 0) {
                    throw new CompilationException("The isModified() method may not declare a throws clause");
                }
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        this.home = new EntityHomeCompilation(this);
        if (!this.descriptor.getCmp20_compiled()) {
            if (this.descriptor.isContainerManaged()) {
                Iterator iterator = this.descriptor.getContainerManagedFields().iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    if (field.getORMapping() == null) continue;
                    if (field.getORMapping().compilation == null) {
                        field.getORMapping().compilation = this.createORCompilation(field, null);
                    }
                    field.getORMapping().compilation.setEnvironment(field, this);
                    if (!field.getORMapping().compilation.init()) continue;
                    field.getORMapping().compilation.compile();
                }
            }
            this.descriptor.setCmp20_compiled(true);
            if (this.persistenceManagerCompilation != null) {
                this.persistenceManagerCompilation.setFields(this.descriptor.getContainerManagedFields());
                this.persistenceManagerCompilation.compile();
            }
        }
        this.checkPrimaryKeyIntegrity();
        if (TableView.DEFINE_COLUMN_TYPE && this.descriptor.isContainerManaged()) {
            this.describeTable(this.persistenceManagerCompilation.table, this.descriptor);
        }
        this.compileMethods();
        this.addDmsImports();
        String dbClass = this.local ? "LocalDBEntityEJBObject" : "RemoteDBEntityEJBObject";
        String baseClassName = "com.evermind.server.ejb." + dbClass;
        this.source.append("import java.sql.*;\nimport javax.transaction.*;\nimport com.evermind.server.*;\nimport java.util.*;\nimport javax.ejb.*;\nimport com.evermind.server.ejb.*;import com.evermind.server.ejb.cache.EntityCacheManager;\nimport com.evermind.server.ejb.cache.CMPCacheManager;\nimport com.evermind.server.ejb.cache.AbstractCacheManager;\nimport com.evermind.server.ejb.cache.BMPCacheManager;\n\n");
        this.addSharedImports();
        this.source.append("public class " + this.className + " extends " + baseClassName + "  implements " + this.interfaceClass.getName() + "\n{\n");
        this.source.append("public boolean finderSFUPessimisticFlag=false;\n");
        if (this.descriptor.getValidityTimeout() > 0L) {
            this.source.append("long validityCheck;\n");
        }
        if ((this.descriptor.isContainerManaged() && !this.cmp2_0 || this.hasIsModifiedMethod) && this.descriptor.isContainerManaged()) {
            int fieldCount = this.persistenceManagerCompilation.table.getFieldCount(true);
            this.source.append("int fieldCount = " + fieldCount + " ;\n" + "BitSet dirtyBSet = new BitSet(fieldCount);\n");
        }
        if (this.descriptor.isContainerManaged() && !this.exclusiveAccess) {
            this.source.append("transient DataSourceConnection connection;\n");
        }
        if (!this.descriptor.isContainerManaged() || this.descriptor.getPrimaryKeyFieldName() != null || this.descriptor.isAutomaticIdentity()) {
            this.source.append((this.descriptor.isAutomaticIdentity() ? this.descriptor.getPrimaryKey().getType().getName() : this.descriptor.getPrimaryKeyClassName()) + " primaryKey;\n");
        } else {
            this.source.append("private " + this.descriptor.getPrimaryKeyClassName() + " __key = null;\n");
            Iterator iterator = this.descriptor.getPrimaryKey().getPropertyFields().iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                if (this.descriptor.isAutomaticIdentity() && field.getName().startsWith("<")) continue;
                this.source.append(ClassUtils.getSourceNotation(field.getType(), 0) + " __" + field.getName() + ";\n");
            }
        }
        this.source.append("transient " + this.getName() + " trail;\n");
        this.appendSerialization();
        this.source.append("\npublic " + this.className + "(EvermindEntityContext context, boolean init, AbstractEJBHome _myHome)\n" + "{\n" + "super(context, init);\n" + "this.context = context;\n" + "setMyHome(_myHome);\n" + "if(init)\n" + "{\n");
        if (this.local) {
            this.source.append("context.localWrapper = this;\n");
        } else {
            this.source.append("context.remoteWrapper = this;\n");
        }
        this.source.append("}\n");
        this.source.append("classNmX = \"" + this.className + "\";\n");
        if (this.descriptor.isReadOnlyBMP()) {
            this.source.append("beanType = AbstractEJBObject.BEANTYPE_BMP_READ_ONLY;\n");
        } else {
            this.source.append("beanType = AbstractEJBObject.BEANTYPE_ENTITY;\n");
        }
        this.source.append("}\n");
        this.source.append("public void setPK_X (Object __pk) {\n try {\n");
        String string = pKClassNm__ = this.descriptor.isAutomaticIdentity() ? this.descriptor.getPrimaryKey().getType().getName() : this.descriptor.getPrimaryKeyClassName();
        if (!this.descriptor.isContainerManaged() || this.descriptor.getPrimaryKeyFieldName() != null || this.descriptor.isAutomaticIdentity()) {
            this.source.append("primaryKey = (" + pKClassNm__ + ") __pk;\n");
            if (this.descriptor.isCMP2_0()) {
                String aFieldName;
                String string2 = aFieldName = this.descriptor.isAutomaticIdentity() ? this.descriptor.getPrimaryKey().getDatabaseName() : this.descriptor.getPrimaryKey().getName();
                if (this.descriptor.getPrimaryKey().getType().isPrimitive()) {
                    this.source.append("if(context !=null && _getObject() != null) _getObject()." + aFieldName + " = ((" + pKClassNm__ + ") __pk)." + this.descriptor.getPrimaryKey().getType().getName() + "Value();\n");
                } else {
                    this.source.append("if(context !=null && _getObject() != null) _getObject()." + aFieldName + " = (" + pKClassNm__ + ") __pk;\n");
                }
            }
        } else {
            ContainerManagedField field;
            this.source.append("if(__key == null) __key = new " + this.descriptor.getPrimaryKeyClassName() + "();\n");
            Iterator iterator = this.descriptor.getPrimaryKey().getPropertyFields().iterator();
            while (iterator.hasNext()) {
                field = (ContainerManagedField)iterator.next();
                this.source.append("__" + field.getName() + " = ((" + pKClassNm__ + ") __pk)." + field.getName() + ";\n");
                if (!this.descriptor.isContainerManaged() || this.descriptor.getPrimaryKeyFieldName() != null || this.descriptor.isAutomaticIdentity()) continue;
                this.source.append("__key." + field.getName() + " = ((" + pKClassNm__ + ") __pk)." + field.getName() + ";\n");
            }
            if (this.descriptor.isCMP2_0()) {
                this.source.append("if(context !=null && _getObject() != null) \n{\n");
                while (iterator.hasNext()) {
                    field = (ContainerManagedField)iterator.next();
                    if (this.descriptor.isAutomaticIdentity() && field.getName().startsWith("<")) continue;
                    this.source.append("_getObject()." + field.getName() + " = ((" + pKClassNm__ + ") __pk)." + field.getName() + ";\n");
                }
                this.source.append("}\n");
            }
        }
        this.source.append("}\ncatch(Exception e) {\n}\n}");
        this.appendMethods();
        if (this.descriptor.isContainerManaged()) {
            this.appendLoadStateCoreNoPKMethod();
            this.appendLoadStateCoreNoPKWithColumnAliasMethod();
            this.appendLoadStateCorePKMethod();
            this.appendSetStateMethod();
        }
        this.appendLoadStateMethod();
        this.appendSaveStateMethod();
        this.addGetTrailMethod();
        this.addReActivateNewMethod();
        this.appendGetPrimaryKeyMethod();
        this.addIsIdenticalMethod();
        this.addIsRecursiveMethod();
        this.appendGetObjectMethod();
        this.appendFinalizer(this.source);
        this.appendGetDelayUpdateUntilCommit();
        if (this.oneToOneFields != null) {
            this.appendUpdateOneToOneMethod();
            this.appendOneToOneGetMasterInSlaveBean();
        }
        this.compilation.addGenerator(this);
        this.appendStaticDeclaration();
        this.appendStaticFunction();
        this.source.append("}\n");
        this.home.compile();
        List finderMethods = this.descriptor.getFinderMethods();
        for (int i = 0; i < finderMethods.size(); ++i) {
            FinderMethod finder = (FinderMethod)finderMethods.get(i);
            if (finder.isUsed()) continue;
            MethodDescriptor method = finder.getMethod();
            StringBuffer message = new StringBuffer("WARNING: Unused <finder-method> tag found in <entity-deployment> '" + this.descriptor.getName() + "', method name '" + (method == null ? "*" : (method.getName() == null ? "*" : method.getName())));
            if (method == null || method.getParameterNames() == null) {
                message.append('\'');
            } else {
                message.append("(");
                for (int x = 0; x < method.getParameterNames().length; ++x) {
                    if (x > 0) {
                        message.append(", ");
                    }
                    message.append(method.getParameterNames()[x]);
                }
                message.append(")'");
            }
            this.compilation.getContainer().getApplication().log(message.toString());
        }
    }

    private void appendFinalizer(ByteString out) {
        if (this.descriptor.isContainerManaged() && Compilation.iiopGen) {
            out.append("protected void finalize()\n");
            out.append("{\n");
            out.append("    if (this.context != null && this.getEntityBean() != null)\n");
            out.append("    {");
            out.append("        this.releaseContext(false);\n");
            out.append("    }\n");
            out.append("}\n");
        }
    }

    public MethodCompilation compileMethod(Method method) throws CompilationException {
        return this.compileMethod(method, this.local);
    }

    public MethodCompilation compileMethod(Method method, boolean local) throws CompilationException {
        Class clazz = local ? EJBLocalObject.class : EJBObject.class;
        if (method.getDeclaringClass() == clazz) {
            if (method.getName().equals("remove") && method.getParameterTypes().length == 0) {
                RemoveEntityBeanMethodCompilation methodWrapper = new RemoveEntityBeanMethodCompilation(this, method, local);
                ((MethodCompilation)methodWrapper).compile();
                return methodWrapper;
            }
            return null;
        }
        EntityBeanMethodCompilation methodWrapper = new EntityBeanMethodCompilation(this, method, method.getName(), local);
        ((MethodCompilation)methodWrapper).compile();
        return methodWrapper;
    }

    public void appendSetStateMethod() {
        this.source.append("public void setState() throws java.rmi.RemoteException {\n");
        this.source.append("this.context.setLazy(false);\n");
        this.source.append("this.getBeanDescriptor().getLifecycleManager().ejbLoad(this.context.getObject(), this.context);\n");
        if (this.home.beanCompilation.descriptor.getCommitOption().isCacheable()) {
            this.source.append("this._getObject()._setState(ExtendedContainerManagedObject.State.k_loaded, false);\n");
        }
        this.source.append("}\n\n");
    }

    public void appendLoadStateCorePKMethod() throws CompilationException {
        this.appendLoadStateCorePKPartialMethod();
        this.appendLoadStateCorePKNonPartialMethod();
    }

    public void appendLoadStateCorePKPartialMethod() throws CompilationException {
        this.source.append("// the _set passed in contained PK which, however, were parsed already\n");
        this.source.append("public void loadStateCorePKPartial (ResultSet _set, DataSourceConnection connection) throws java.sql.SQLException, java.io.IOException, java.lang.ClassNotFoundException, java.rmi.RemoteException {\n");
        this.appendCopyObjectPkFieldFromWrapper(this.source, "this");
        TableIteration getterTableIteration = this.getPKFromJDBCResultSet(new ByteString(2000), "key", false);
        Iterator iterator = this.persistenceManagerCompilation.table.getFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            EntityBeanCompilation.appendJDBCGetterMethod(this.local, "this._getObject()." + field.getName(), this.source, false, "_set", field, getterTableIteration, this, "context", false, false, null);
        }
        if (this.descriptor.isContainerManaged() && this.descriptor.getPrimaryKeyFieldName() == null && !this.descriptor.isAutomaticIdentity()) {
            this.source.append("__key = null; /* 2 */\n");
            this.source.append("getPrimaryKey();\n");
        }
        this.source.append("setState();\n");
        this.source.append("}\n\n");
    }

    public void appendLoadStateCorePKNonPartialMethod() throws CompilationException {
        this.source.append("// the _set passed in contained PK which, however, were parsed already\n");
        this.source.append("public void loadStateCorePKNonPartial (ResultSet _set, DataSourceConnection connection) throws java.sql.SQLException, java.io.IOException, java.lang.ClassNotFoundException, java.rmi.RemoteException {\n");
        this.appendCopyObjectPkFieldFromWrapper(this.source, "this");
        TableIteration getterTableIteration = this.getPKFromJDBCResultSet(new ByteString(2000), "key", false);
        Iterator iterator = this.persistenceManagerCompilation.table.getFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            EntityBeanCompilation.appendJDBCGetterMethod(this.local, "this._getObject()." + field.getName(), this.source, false, "_set", field, getterTableIteration, this, "context", true, false, null);
        }
        if (this.descriptor.isContainerManaged() && this.descriptor.getPrimaryKeyFieldName() == null && !this.descriptor.isAutomaticIdentity()) {
            this.source.append("__key = null; /* 3 */\n");
            this.source.append("getPrimaryKey();\n");
        }
        this.source.append("setState();\n");
        this.source.append("}\n\n");
    }

    public void appendLoadStateCoreNoPKMethod() throws CompilationException {
        this.source.append("public void loadStateCoreNoPK (ResultSet _set, DataSourceConnection connection) throws java.sql.SQLException, java.io.IOException, java.lang.ClassNotFoundException,  java.rmi.RemoteException  {\n");
        this.appendCopyObjectPkFieldFromWrapper(this.source, "this");
        TableIteration getterTableIteration = new TableIteration();
        Iterator iterator = this.descriptor.getContainerManagedFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            EntityBeanCompilation.appendJDBCGetterMethod(this.local, "this._getObject()." + field.getName(), this.source, false, "_set", field, getterTableIteration, this.home.beanCompilation, "context", null);
        }
        Iterator iterator2 = this.descriptor.getContainerManagedFields().iterator();
        while (iterator2.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator2.next();
            if (!field.isCMR() || !field.isOneToOne() || !field.isSlaveInUniDirectional() || field.isSynthetic()) continue;
            String fieldType = ClassUtils.getSourceNotation(field.getType(), 0);
            this.source.append("this._getObject()." + field.getName() + " = (" + fieldType + ") getOneToOneOwner" + field.getPeerName() + "_" + field.getPureName() + "(transaction);\n");
        }
        if (this.descriptor.isContainerManaged() && this.descriptor.getPrimaryKeyFieldName() == null && !this.descriptor.isAutomaticIdentity()) {
            this.source.append("__key = null; /* 4 */\n");
            this.source.append("getPrimaryKey();\n");
        }
        this.source.append("setState();\n");
        this.source.append("}\n\n");
    }

    public void appendLoadStateCoreNoPKWithColumnAliasMethod() throws CompilationException {
        this.source.append("public void loadStateCoreNoPKWithColumnAlias (ResultSet _set, boolean aFlag, DataSourceConnection connection) throws java.sql.SQLException, java.io.IOException, java.lang.ClassNotFoundException,  java.rmi.RemoteException  {\n");
        this.appendCopyObjectPkFieldFromWrapper(this.source, "this");
        TableIteration getterTableIteration = new TableIteration();
        Iterator iterator = this.descriptor.getContainerManagedFields().iterator();
        ContainerManagedField field = null;
        EntityBeanDescriptor descriptor = null;
        boolean aFlag = true;
        while (iterator.hasNext()) {
            field = (ContainerManagedField)iterator.next();
            if (field.isLazyLoading()) continue;
            descriptor = field.getEntity();
            field.setDatabaseColumnAlias(descriptor.getName());
            if (field.isOneToOne()) {
                aFlag = field.isMasterInUniDirectional();
            }
            EntityBeanCompilation.appendJDBCGetterMethod(this.local, "this._getObject()." + field.getName(), this.source, false, "_set", field, getterTableIteration, this.home.beanCompilation, "context", true, aFlag, null);
            field.setDatabaseColumnAlias(null);
        }
        Iterator iterator2 = this.descriptor.getContainerManagedFields().iterator();
        while (iterator2.hasNext()) {
            field = (ContainerManagedField)iterator2.next();
            if (!field.isCMR() || !field.isOneToOne() || !field.isSlaveInUniDirectional() || field.isSynthetic()) continue;
            String fieldType = ClassUtils.getSourceNotation(field.getType(), 0);
            this.source.append("this._getObject()." + field.getName() + " = (" + fieldType + ") getOneToOneOwner" + field.getPeerName() + "_" + field.getPureName() + "(transaction);\n");
        }
        if (this.descriptor.isContainerManaged() && this.descriptor.getPrimaryKeyFieldName() == null && !this.descriptor.isAutomaticIdentity()) {
            this.source.append("__key = null; /* 4 */\n");
            this.source.append("getPrimaryKey();\n");
        }
        this.source.append("setState();\n");
        this.source.append("}\n\n");
    }

    public void appendLoadStateMethod() throws CompilationException {
        boolean pessi = this.descriptor.getLockingMode() == 1;
        this.appendGetIfValidFromCache();
        this.source.append("public void loadStateCheckObject(ApplicationServerTransaction transaction) throws SQLException, ClassNotFoundException, java.io.IOException {\nif (this._getObject() == null) \n");
        if (this.local) {
            this.source.append("reActivateNewLocal();\n");
        } else {
            this.source.append("reActivateNew();\n");
        }
        this.source.append("if (context.isLazy())\nloadState(transaction, true);\n");
        this.source.append("}\n\n");
        this.source.append("public void loadState(ApplicationServerTransaction transaction) throws SQLException, ClassNotFoundException, java.io.IOException {\nloadState(transaction, true);\n}\n\n");
        if (this.descriptor.isContainerManaged()) {
            this.source.append("/*");
            this.source.append(this.persistenceManagerCompilation.table.getPreparedSelectStatement(true, null), true);
            this.source.append("*/\n");
        }
        this.source.append("public void loadState(ApplicationServerTransaction transaction, boolean _allowForUpdate) throws SQLException, ClassNotFoundException, java.io.IOException\n{\n");
        this.source.append("traceLog(\"In loadState method, transaction = \" + transaction);\n");
        if (this.descriptor.getValidityTimeout() > 0L) {
            this.source.append("this.validityCheck = OC4J_getCurrentTime() + " + this.descriptor.getValidityTimeout() + "l;\n");
        }
        this.source.append("if (this.isBeanUnRegistered()) \n");
        this.source.append("{\n");
        if (this.local) {
            this.source.append("throw new javax.ejb.NoSuchEntityException(\"Object is not registered\");\n");
        } else {
            this.source.append("throw new java.rmi.NoSuchObjectException(\"Object is not registered\");\n");
        }
        this.source.append("}\n");
        this.source.append("ThreadState state = ThreadState.getCurrentState();\nContextContainer previousContainer = state.contextContainer;\ntry {\nstate.contextContainer = this.getMyHome();\n");
        if (this.descriptor.isContainerManaged()) {
            if (this.cmp2_0) {
                this.source.append("if(this.context.getObject() !=null && (this._getObject().__dirtyBSet.length() > 0)) saveState(transaction); \n");
            } else {
                this.source.append("if(dirtyBSet.length() > 0) saveState(transaction);\n");
            }
            this.appendGetConnection(this.source);
            this.appendGetFromCache(this.source);
            this.source.append("String sqlStatement = \"\";\nPreparedStatement statement = null;\n");
            this.source.append("try\n{\n");
            this.source.append("traceLog(\"loadState: Just obtained the connection, connection = \" + connection);\n");
            this.source.append("Flag statementCached = new Flag(false);\n if (!_allowForUpdate || (transaction == null || finderSFUPessimisticFlag))\n{\nstatement = EJBPrivileged.getCustomStatement(connection, statementCached,\"");
            this.source.append(this.persistenceManagerCompilation.table.getPreparedSelectStatementOld(true, "statement", this.oneToOneFields, false), true);
            if (!this.persistenceManagerCompilation.table.getUniDirectionalOneToOneIsJoined(this.oneToOneFields) || this.persistenceManagerCompilation.table.getUniDirectionalOneToOneFields(this.oneToOneFields) == null) {
                this.source.append("\");\n");
            }
            this.source.append("sqlStatement = \"" + this.persistenceManagerCompilation.table.getPreparedSelectStatementOld(true, null, this.oneToOneFields, false) + "\";\n" + "}\n" + "else\n" + "{\n" + "statement = EJBPrivileged.getCustomStatement(connection, statementCached,\"");
            this.source.append(this.persistenceManagerCompilation.table.getPreparedSelectStatement(true, "statement", this.oneToOneFields, true), true);
            this.source.append("sqlStatement = \"" + this.persistenceManagerCompilation.table.getPreparedSelectStatement(true, null, this.oneToOneFields, true) + "\";\n" + "}\n");
            if (pessi) {
                this.source.append(" statement.setQueryTimeout(" + this.descriptor.getCallTimeout() / 1000L + ");\n");
            }
            this.source.append("traceLog(\"loadState: Just got the prepared statement method, statement = \" + statement);\n");
            TableIteration findTableIteration = new TableIteration();
            if (this.descriptor.getPrimaryKeyFieldName() != null || this.descriptor.isAutomaticIdentity()) {
                this.persistenceManagerCompilation.table.appendPreparedSet(this.source, false, "statement", this.descriptor.getPrimaryKey().getType(), findTableIteration, ClassUtils.getConvertSource("this.primaryKey", this.descriptor.getPrimaryKeyClass(), this.descriptor.getPrimaryKey().getType()), this.descriptor.getPrimaryKey(), "context", true);
            } else {
                Iterator iterator = this.descriptor.getPrimaryKey().getPropertyFields().iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    this.persistenceManagerCompilation.table.appendPreparedSet(this.source, false, "statement", field.getType(), findTableIteration, "__" + field.getName(), field, "context", true);
                }
            }
            this.source.append("ResultSet set = statement.executeQuery();\ntraceLog(\"loadState: executed the querry = \");\nif(!set.next())\n{\ntraceLog(\"loadState: execute returned no rows  \");\ntry { statement.close();\n} catch(java.sql.SQLException e) {}\nif(transaction == null)\n{\n" + "" + "connection.release();\n" + "}\n" + "connection = null;\n");
            if (!this.descriptor.hasExclusiveWriteAccess()) {
                this.source.append("this.connection = null;\n");
            }
            if (this.local) {
                this.source.append("throw new javax.ejb.NoSuchEntityException(String.valueOf(this.getPrimaryKey()));\n");
            } else {
                this.source.append("throw new java.rmi.NoSuchObjectException(String.valueOf(this.getPrimaryKey()));\n");
            }
            this.source.append("}\n\n");
            if (this.persistenceManagerCompilation.table.getUniDirectionalOneToOneFields(this.oneToOneFields) != null && this.persistenceManagerCompilation.table.getUniDirectionalOneToOneIsJoined(this.oneToOneFields)) {
                this.source.append("loadStateCoreNoPKWithColumnAlias ( set, true, connection );\n");
            } else {
                this.source.append("loadStateCoreNoPK ( set, connection );\n");
            }
            this.source.append("}\ncatch (java.sql.SQLException e)\n{\nString aMessage = null;\nif (SystemProperties.SQLLOG) \n{\naMessage = e.getMessage() +  sqlStatement;\n}\nelse \n{\naMessage = e.getMessage();\n}\nthrow new java.sql.SQLException(\"Error loading state: \" + aMessage);\n}\nfinally\n{\nif(statement != null) {\n try { statement.close();\n} catch(java.sql.SQLException e) {}\n }\nif(transaction == null && connection != null)\n{\n" + "" + "connection.release();\n" + "connection = null;\n");
            if (!this.exclusiveAccess) {
                this.source.append("this.connection = null;\n");
            }
            this.source.append("}\n}\n");
        } else {
            if (this.descriptor.isReadOnlyBMP() || this.descriptor.isBMP() && this.descriptor.getCommitOption().isCacheableOptionA()) {
                this.appendGetFromCache(this.source);
            }
            this.source.append("this.context.setLazy(false);\n");
            this.source.append("this.getBeanDescriptor().getLifecycleManager().ejbLoad(this.context.getObject(), this.context);\n");
        }
        this.source.append("} finally {\nstate.contextContainer = previousContainer;\n}\n");
        if (this.descriptor.isReadOnlyBMP() || this.descriptor.isBMP() && this.descriptor.getCommitOption().isCacheableOptionA()) {
            this.source.append("_cacheMgr.put(getPrimaryKey(), this);\n");
        }
        this.source.append("}\n\n");
    }

    private void appendGetFromCache(ByteString source) {
        if (this.descriptor.getCommitOption().isCacheable() || this.descriptor.isReadOnlyBMP()) {
            String aConnectionString = this.descriptor.isContainerManaged() ? "connection" : null;
            source.append("if(context.isLazy())\n");
            source.append("{\n");
            source.append("  " + this.getCMPClassName() + " obj = getIfValidFromCache(" + aConnectionString + ", transaction);\n");
            source.append("  if(obj != null)\n");
            source.append("  {\n");
            source.append("      context.setLazy(false);\n");
            if (!this.descriptor.isReadOnlyBMP() && !this.descriptor.getCommitOption().isCacheableOptionA()) {
                source.append("this.getBeanDescriptor().getLifecycleManager().ejbLoad(this.context.getObject(), this.context);\n");
            }
            source.append("      return;\n");
            source.append("  }\n");
            this.appendEjbActivate(source, "this");
            source.append("}\n");
        }
    }

    private void appendGetConnection(ByteString source) {
        source.append("DataSourceConnection connection;\n\n");
        source.append("// add the try block to catch NPE seen in trade2 example\ntry {\n");
        if (this.exclusiveAccess) {
            if (this.local) {
                source.append("connection = transaction == null ? ((EntityEJBHome)getMyHome()).dataSourceContainer.getLocalConnection() : transaction.getLocalConnection(((EntityEJBHome)getMyHome()).dataSourceContainer);\n");
            } else {
                source.append("connection = transaction == null ? ((EntityEJBHome)getMyHome()).dataSourceContainer.getConnection() : transaction.getConnection(((EntityEJBHome)getMyHome()).dataSourceContainer);\n");
            }
        } else {
            source.append("\nif(transaction == null)\n{\n");
            if (this.local) {
                source.append("connection = this.connection = ((EntityEJBHome) getMyHome()).dataSourceContainer.getLocalConnection();\n");
            } else {
                source.append("connection = this.connection = ((EntityEJBHome) getMyHome()).dataSourceContainer.getConnection();\n");
            }
            source.append("}\nelse\n{\n");
            if (this.local) {
                source.append("connection = transaction.getLocalConnection(((EntityEJBHome) getMyHome()).dataSourceContainer);\n");
            } else {
                source.append("connection = transaction.getConnection(((EntityEJBHome) getMyHome()).dataSourceContainer);\n");
            }
            source.append("}\n\n");
        }
        source.append("// the following are for catching NPE seen under stress\n} catch (NullPointerException npe) {\nthrow npe;\n}\n\n");
    }

    public void appendGetIfValidFromCache() throws CompilationException {
        CommitOptionDescriptor co = this.descriptor.getCommitOption();
        if (!co.isCacheable() && !this.descriptor.isReadOnlyBMP()) {
            return;
        }
        if (this.descriptor.isBMP()) {
            this.source.append("private static AbstractCacheManager _cacheMgr = BMPCacheManager.instance();\n");
        } else {
            this.source.append("private static AbstractCacheManager _cacheMgr = CMPCacheManager.instance();\n");
        }
        this.source.append("public boolean OC4J_isCacheable() { return true; }\n");
        if (!this.descriptor.isContainerManaged()) {
            this.source.append("public boolean _isBMP() { return " + this.descriptor.isBMP() + "; }\n");
        }
        this.source.append("private " + this.getCMPClassName() + " getIfValidFromCache(DataSourceConnection connection, ApplicationServerTransaction transaction) throws SQLException, java.rmi.NoSuchObjectException, java.rmi.RemoteException \n");
        this.source.append("{\n");
        this.source.append("    " + this.getCMPClassName() + " clone = (" + this.getCMPClassName() + ") _cacheMgr.clone(getPrimaryKey(),getBeanDescriptor(), context.getObject());\n");
        this.source.append("    if (clone != null)\n");
        this.source.append("    {\n");
        if (co.useOCA() && co.getOption() == 2 && this.descriptor.isContainerManaged()) {
            this.source.append("    " + co.getType() + " ocn = -1;\n");
            this.generateOCASelectStatement(this.source, co, "ocn", false, "clone.");
            this.source.append("    if (clone." + co.getName() + " != ocn)\n");
            this.source.append("        return null;\n");
        }
        this.source.append("        context.setObject(clone);\n");
        if (this.descriptor.isContainerManaged()) {
            this.source.append("        clone.__context = context;\n");
        } else {
            this.source.append("      getBeanDescriptor().getLifecycleManager().setContext(clone, context);\n");
        }
        this.source.append("    }\n");
        this.source.append("    return clone;\n");
        this.source.append("}\n");
    }

    public void generateOCASelectStatement(ByteString source, CommitOptionDescriptor co, String ocnVar, boolean doLock, String objectString) throws CompilationException {
        ContainerManagedField ocafiled;
        source.append("com.evermind.server.Flag statementCached = new com.evermind.server.Flag(false);\n");
        source.append("PreparedStatement statement = null;\n");
        if (doLock) {
            source.append("statement = EJBPrivileged.getCustomStatement(connection, statementCached, \"" + co.getOCASelectForUpdateStatement(this.descriptor) + "\");\n");
        } else {
            source.append("statement = EJBPrivileged.getCustomStatement(connection, statementCached, \"" + co.getOCASelectStatement(this.descriptor) + "\");\n");
        }
        ByteString tempBuffer = new ByteString();
        TableView table = this.persistenceManagerCompilation.table;
        source.append("int currentStatementPosition = 1;\n");
        TableIteration ti = new TableIteration("currentStatementPosition");
        String afield = this.descriptor.getPrimaryKey().getName();
        if (this.descriptor.getPrimaryKeyFieldName() != null || this.descriptor.isAutomaticIdentity()) {
            if (!doLock) {
                afield = "this._getObject()." + afield;
            }
            table.appendPreparedSet(source, false, "statement", this.descriptor.getPrimaryKey().getType(), ti, ClassUtils.getConvertSource(afield, this.descriptor.getPrimaryKeyClass(), this.descriptor.getPrimaryKey().getType()), this.descriptor.getPrimaryKey(), "context", true);
        } else {
            Iterator iterator = this.descriptor.getPrimaryKey().getPropertyFields().iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                afield = !doLock ? "this._getObject()." + field.getName() : objectString + field.getName();
                table.appendPreparedSet(source, false, "statement", field.getType(), ti, afield, field, "context", true);
            }
        }
        if (doLock) {
            ocafiled = this.descriptor.getCommitOption().getField();
            tempBuffer.append("// ocafield: " + ocafiled + "\n");
            if (ocafiled != null) {
                EntityBeanDescriptor bean = ocafiled.getEntity();
                if (bean.getCommitOption().getType().equalsIgnoreCase("int")) {
                    tempBuffer.append("statement.setInt(currentStatementPosition++, " + objectString + "_getBaseVersion());\n");
                } else {
                    tempBuffer.append("statement.setLong(currentStatementPosition++, " + objectString + "_getBaseVersion());\n");
                }
                source.append(tempBuffer);
            }
        }
        source.append("try {\n");
        source.append("        ResultSet set = statement.executeQuery();\n");
        if (doLock) {
            ocafiled = this.descriptor.getCommitOption().getField();
            source.append("boolean retCode = set.next();\n");
            source.append("if(retCode == false)\n{\n");
            source.append("traceLog(\"Lock Failed: \" + " + ocafiled.getName() + " + \" \" + " + ocafiled.getName() + "Changed);\n");
            source.append("}\n");
            source.append("return retCode;\n");
        } else {
            source.append("        if (!set.next())\n");
            source.append("        {\n");
            source.append("            throw new java.rmi.NoSuchObjectException(String.valueOf(this.getPrimaryKey()));\n");
            source.append("        }\n");
            if (co.getType().equalsIgnoreCase("int")) {
                source.append(ocnVar + " = set.getInt(1);\n");
            } else {
                source.append(ocnVar + " = set.getLong(1);\n");
            }
        }
        source.append("} finally { try { statement.close();\n} catch(java.sql.SQLException e) {}\n }\n");
    }

    public static void appendJDBCGetterMethod(boolean _local, String destination, ByteString source, boolean home, String setName, ContainerManagedField field, TableIteration tableIteration, EntityBeanCompilation compilation, String contextName, ORCompilation orCompilation) throws CompilationException {
        EntityBeanCompilation.appendJDBCGetterMethod(_local, destination, source, home, setName, field, tableIteration, compilation, contextName, false, false, orCompilation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void appendJDBCGetterMethod(boolean _local, String destination, ByteString source, boolean home, String setName, ContainerManagedField field, TableIteration tableIteration, EntityBeanCompilation compilation, String contextName, boolean byName, boolean preLoadCMRs, ORCompilation orCompilation) throws CompilationException {
        if (field.getType() == EntityContext.class) {
            return;
        }
        if (field.getPersistenceManager() != null) {
            Class type = field.getType();
            String castName = ClassUtils.getSourceNotation(type, 0);
            String varName = compilation.getFieldPersistenceManagerReference(field.getCompoundName());
            if (type.isPrimitive()) {
                boolean hasPrimitiveGetter = false;
                try {
                    Method method = field.getPersistenceManager().getClass().getMethod("getPrimitive", ResultSet.class);
                    if (type.isAssignableFrom(method.getReturnType())) {
                        hasPrimitiveGetter = true;
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (hasPrimitiveGetter) {
                    source.append(destination + " = (" + castName + ")" + compilation.home.getName() + "." + varName + ".getPrimitive(" + setName + ");\n");
                } else if (type == Boolean.TYPE) {
                    source.append(destination + " = ((Boolean)" + compilation.home.getName() + "." + varName + ".get(" + setName + ")).booleanValue();\n");
                } else if (type == Byte.TYPE) {
                    source.append(destination + " = ((Byte)" + compilation.home.getName() + "." + varName + ".get(" + setName + ")).byteValue();\n");
                } else if (type == Short.TYPE) {
                    source.append(destination + " = ((Short)" + compilation.home.getName() + "." + varName + ".get(" + setName + ")).shortValue();\n");
                } else if (type == Character.TYPE) {
                    source.append(destination + " = ((Character)" + compilation.home.getName() + "." + varName + ".get(" + setName + ")).charValue();\n");
                } else if (type == Integer.TYPE) {
                    source.append(destination + " = ((Integer)" + compilation.home.getName() + "." + varName + ".get(" + setName + ")).intValue();\n");
                } else if (type == Float.TYPE) {
                    source.append(destination + " = ((Float)" + compilation.home.getName() + "." + varName + ".get(" + setName + ")).floatValue();\n");
                } else if (type == Long.TYPE) {
                    source.append(destination + " = ((Long)" + compilation.home.getName() + "." + varName + ".get(" + setName + ")).longValue();\n");
                } else {
                    if (type != Double.TYPE) throw new InternalError("Unsupported type: " + type);
                    source.append(destination + " = ((Double)" + compilation.home.getName() + "." + varName + ".get(" + setName + ")).doubleValue();\n");
                }
            } else {
                source.append(destination + " = (" + castName + ")" + compilation.home.getName() + "." + varName + ".get(" + setName + ");\n");
            }
            if (field.getPersistenceManager().getColumns() == null) {
                return;
            }
            Iterator iterator = field.getPersistenceManager().getColumns().keySet().iterator();
            Iterator iterator2 = iterator;
            while (iterator2 != null) {
                if (!iterator2.hasNext()) return;
                tableIteration.getNextPos((String)iterator2.next(), 1);
            }
            return;
        }
        try {
            switch (field.getPersistenceType()) {
                case 2: {
                    Iterator iterator = field.getPropertyFields().iterator();
                    Class type = field.getType();
                    String className = type.getName();
                    source.append("{\n");
                    source.append(destination + " = new " + className + "();\n");
                    while (iterator.hasNext()) {
                        ContainerManagedField propertyField = (ContainerManagedField)iterator.next();
                        boolean handled = false;
                        if (orCompilation != null && orCompilation.mapping.peer != null && orCompilation.mapping.peer.getRelation() != null && propertyField.getName().equals(orCompilation.mapping.peer.getRelation().getName())) {
                            source.append(destination + "." + propertyField.getPropertyDescriptor().getWriteMethod().getName() + "((" + propertyField.getType().getName() + ")" + contextName + ".getEJBObject());\n");
                            handled = true;
                        }
                        if (handled) continue;
                        String tempInstanceName = "__propertyTemp" + ClassCompilation.getNextID();
                        source.append(propertyField.getType().getName() + " " + tempInstanceName + ";\n");
                        EntityBeanCompilation.appendJDBCGetterMethod(_local, tempInstanceName, source, home, setName, propertyField, tableIteration, compilation, contextName, null);
                        source.append(destination + "." + propertyField.getPropertyDescriptor().getWriteMethod().getName() + "(" + tempInstanceName + ");\n");
                    }
                    source.append("}\n\n");
                    break;
                }
                case 3: {
                    Iterator iterator = field.getPropertyFields().iterator();
                    String className = field.getType().getName();
                    source.append("{\n");
                    source.append(destination + " = new " + className + "();\n");
                    while (iterator.hasNext()) {
                        String tempInstanceName = "__fieldTemp" + ClassCompilation.getNextID();
                        ContainerManagedField propertyField = (ContainerManagedField)iterator.next();
                        source.append(propertyField.getType().getName() + " " + tempInstanceName + ";\n");
                        EntityBeanCompilation.appendJDBCGetterMethod(_local, tempInstanceName, source, home, setName, propertyField, tableIteration, compilation, contextName, null);
                        source.append(destination + "." + propertyField.getFieldDescriptor().getName() + " = " + tempInstanceName + ";\n");
                    }
                    source.append("}\n\n");
                    break;
                }
                case 7: {
                    source.append(destination + " = new " + field.getORMapping().getWrapperName() + "(" + contextName + ");\n");
                    break;
                }
                case 8: {
                    source.append(destination + " = new " + field.getORMapping().getWrapperName() + "(" + contextName + ");\n");
                    break;
                }
                case 4: {
                    BeanDescriptor genericDescriptor = compilation.compilation.getContainer().getBeanByLocation(field.getEJBReferenceHome());
                    if (!(genericDescriptor instanceof EntityBeanDescriptor)) {
                        field.setEJBReferenceHome(null);
                        if (!field.initializeEJBReferenceHome(compilation.compilation.getContainer())) {
                            EntityBeanCompilation.appendJDBCGetterMethod(_local, destination, source, home, setName, field, tableIteration, compilation, contextName, byName, false, orCompilation);
                            return;
                        }
                        genericDescriptor = compilation.container.getBeanByLocation(field.getEJBReferenceHome());
                    }
                    EntityBeanDescriptor descriptor = (EntityBeanDescriptor)genericDescriptor;
                    if (field.getType() != descriptor.getLocalInterface() && field.getType() != descriptor.getRemoteInterface()) {
                        throw new CompilationException(field.getName() + " cannot be an EJB reference to entity '" + descriptor.getName() + "', it's type must be either a local or remote interface of that entity, not: '" + field.getType().getName() + "'");
                    }
                    ContainerManagedField ejbReferenceField = field.getEJBReferenceField();
                    if (field.isSynthetic()) break;
                    Class primaryKeyType = descriptor.getPrimaryKey().getType();
                    String primaryKeyVar = "primaryKey" + ClassCompilation.getNextID();
                    if (field.isPersistedToAssociationTable() && field.isOneToMany_Many()) {
                        EntityBeanCompilation.appendAssociationTableLookup(_local, destination, source, home, field, ejbReferenceField, compilation, contextName, descriptor);
                        break;
                    }
                    source.append("try\n{\n");
                    source.append(primaryKeyType.getName() + " " + primaryKeyVar + " = " + ClassUtils.getDefaultValue(primaryKeyType) + ";\n");
                    EntityBeanCompilation.appendJDBCGetterMethod(_local, primaryKeyVar, source, home, setName, ejbReferenceField, tableIteration, compilation, contextName, true, preLoadCMRs, null);
                    if (primaryKeyType.isPrimitive() && !compilation.getContainer().getConfig().getTreatZeroAsNull()) {
                        source.append("if(!" + setName + ".wasNull()");
                    } else {
                        source.append("if(" + primaryKeyVar + " != " + ClassUtils.getDefaultValue(primaryKeyType));
                    }
                    if (ejbReferenceField.getPersistenceType() == 3 && !ejbReferenceField.getPropertyFields().isEmpty()) {
                        ContainerManagedField firstPropertyField = (ContainerManagedField)ejbReferenceField.getPropertyFields().iterator().next();
                        if (firstPropertyField.getType().isPrimitive() && !compilation.getContainer().getConfig().getTreatZeroAsNull()) {
                            source.append(" && !" + setName + ".wasNull()");
                        } else {
                            source.append(" && " + primaryKeyVar + "." + firstPropertyField.getName() + " != " + ClassUtils.getDefaultValue(firstPropertyField.getType()));
                        }
                    }
                    source.append(")\n{\n");
                    EntityBeanCompilation.genWrapperLoadWithPKey(source, home, field, destination, primaryKeyVar, primaryKeyType, descriptor);
                    EntityBeanCompilation.appendPreLoadCMRCode(preLoadCMRs, orCompilation, field, compilation, source, destination, descriptor, primaryKeyVar, setName);
                    source.append("}\n");
                    source.append("else\n{\n" + destination + " = null;\n" + "}\n");
                    source.append("}\ncatch(NullPointerException t)\n");
                    source.append("{\n" + destination + " = null;\n" + "}\n" + "\n");
                    break;
                }
                case 1: {
                    String columnType = field.getColumnType();
                    if (columnType != null && columnType.indexOf("WITH LOCAL TIME ZONE") != -1) {
                        source.append("try  {\n");
                        source.append("oracle.jdbc.OracleConnection tempConn = (oracle.jdbc.OracleConnection) connection.getConnection() ;\n ");
                        source.append("TimeZone tmz = TimeZone.getDefault();\n");
                        source.append("String tmz_str = tmz.getID();\n");
                        source.append("tempConn.setSessionTimeZone(tmz_str);\n");
                        source.append("} catch(ClassCastException ex) {\n // do nothing if not Oracle specific\n}");
                    }
                    source.append(destination);
                    source.append(" = ");
                    int pos = tableIteration.getNextPos(field.getDatabaseName(), 1);
                    String databaseName = byName ? field.getDatabaseName() : String.valueOf(pos);
                    String alias = field.getDatabaseColumnAlias();
                    if (byName && alias != null) {
                        databaseName = field.createDatabaseColumnAlias();
                    }
                    EntityBeanCompilation.appendJDBCGetterMethodCore(_local, source, home, setName, field, byName ? '\"' + databaseName + '\"' : databaseName, field.getType());
                    source.append(";\n");
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new CompilationException("Unknown persistence mode: " + field.getPersistenceType());
                }
            }
            if (!field.isOCA()) return;
            source.append(destination + "Changed = false;\n");
            return;
        }
        catch (InstantiationException e) {
            throw new CompilationException(e.getMessage());
        }
    }

    protected static void genWrapperLoadWithPKey(ByteString source, boolean home, ContainerManagedField field, String destination, String primaryKeyVar, Class primaryKeyType, EntityBeanDescriptor descriptor) {
        source.append("com.evermind.server.ejb.EntityContainer peerHome;\n");
        if (home) {
            source.append("peerHome = ");
            source.append("(com.evermind.server.ejb.EntityContainer) this.getHome(\"" + field.getEJBReferenceHome() + "\", " + EJBLocalObject.class.isAssignableFrom(field.getType()) + ");\n");
        } else {
            source.append("if (this.context.localHome != null) {\n");
            source.append("peerHome = ");
            source.append("(com.evermind.server.ejb.EntityContainer) this.context.localHome.getHome(\"" + field.getEJBReferenceHome() + "\", " + EJBLocalObject.class.isAssignableFrom(field.getType()) + ");\n");
            source.append("} else {\n");
            source.append("peerHome = ");
            source.append("(com.evermind.server.ejb.EntityContainer) this.context.remoteHome.getHome(\"" + field.getEJBReferenceHome() + "\", " + EJBLocalObject.class.isAssignableFrom(field.getType()) + ");\n");
            source.append("}\n");
        }
        source.append(destination + " = (" + ClassUtils.getSourceNotation(field.getType(), 0) + ")");
        source.append("peerHome.getWrapperByPK(transaction, " + ClassUtils.getConvertSource(primaryKeyVar, primaryKeyType, descriptor.getPrimaryKeyClass()) + ");\n");
    }

    private static void appendPreLoadCMRCode(boolean preLoadCMRs, ORCompilation orCompilation, ContainerManagedField field, EntityBeanCompilation compilation, ByteString source, String destination, EntityBeanDescriptor descriptor, String primaryKeyVar, String setName) throws CompilationException {
        if (preLoadCMRs && (orCompilation != null || field.isOneToOne())) {
            String cmrBeanName = orCompilation != null ? orCompilation.mapping.peer.getRoleSource().getName() : field.getPeer().getRelation().getResolved().getEntity().getName();
            EntityBeanCompilation cmrCompilation = (EntityBeanCompilation)compilation.compilation.getCompilation(cmrBeanName);
            String wrapperClass = cmrCompilation.className;
            String wrapperVar = "wrapper" + ClassCompilation.getNextID();
            source.append(wrapperClass + " " + wrapperVar + " = (" + wrapperClass + ") " + destination + ";\n");
            String aFlag = orCompilation == null ? "aFlag" : "true";
            source.append("if ( " + wrapperVar + ".context.getObject() != null && " + wrapperVar + ".context != null && " + wrapperVar + ".context.isLazy () && " + aFlag + " ) {\n");
            if (field.isOneToOne() && field.isMasterInUniDirectional() && field.getOneToOneOption().isJoined()) {
                source.append("aFlag = false;\n");
                source.append(wrapperVar + ".loadStateCoreNoPKWithColumnAlias (  " + setName + ", aFlag, connection);\n");
            } else {
                source.append(wrapperVar + ".loadStateCorePKNonPartial ( " + setName + ", connection);\n");
            }
            source.append("ThreadState thrState = ThreadState.getCurrentState();\nContextContainer priorContainer = thrState.contextContainer;\ntry {\nthrState.contextContainer = " + wrapperVar + ".context.getHome();\n");
            source.append(wrapperVar + ".getBeanDescriptor().getLifecycleManager().ejbLoad(" + wrapperVar + ".context.getObject()," + wrapperVar + ".context);\n");
            source.append("} finally {\nthrState.contextContainer = priorContainer;\n}\n");
            source.append("}");
        }
    }

    public static void appendAssociationTableLookup(boolean local, String primaryKeyVariable, ByteString source, boolean home, ContainerManagedField oneSideField, ContainerManagedField ejbReferenceField, EntityBeanCompilation compilation, String contextName, EntityBeanDescriptor descriptor) throws CompilationException {
        ContainerManagedField manySideField = oneSideField.getPeer().getRelation().getResolved();
        ORMapping manySideORMapping = manySideField.getORMapping();
        Table assocTable = compilation.compilation.getTable(manySideORMapping);
        TreeSet<ContainerManagedField> fieldsForWhereClause = new TreeSet<ContainerManagedField>();
        ArraySet fieldsForSelectClause = new ArraySet();
        fieldsForWhereClause.add(manySideORMapping.getValueField());
        fieldsForSelectClause.add(manySideORMapping.getKeyField());
        ContainerManagedField artificialPrimaryKey = new ContainerManagedField(null, (PrimaryKeyContext)descriptor, "");
        artificialPrimaryKey.setProperties(fieldsForWhereClause);
        artificialPrimaryKey.setPersistenceType(3);
        TableView tableView = new TableView(assocTable, artificialPrimaryKey, fieldsForSelectClause, false, compilation);
        tableView.setEnvironment(compilation.getContainer(), compilation.getSchema());
        String assocTableSelect = tableView.getPreparedSelectStatement(false, null);
        source.append("/*" + assocTableSelect + "*/\n" + "try\n" + "{\n" + "if (connection == null ) { \n" + "EntityEJBHome theHome = (context.localHome==null) " + "  ? (EntityEJBHome)context.remoteHome " + "  : (EntityEJBHome)context.localHome;\n" + "ApplicationServerTransaction transaction = " + EJBCompilationUtils.getTransactionString() + ";\n" + "connection = transaction == null " + "  ? theHome.dataSourceContainer.getConnection() " + "  : transaction.getConnection(theHome.dataSourceContainer);\n" + "}\n" + "ResultSet assocTableSet = null;\n");
        source.append("PreparedStatement statement = null;\n");
        source.append("try\n{\nFlag statementCached = new Flag(false);\n statement = EJBPrivileged.getCustomStatement(connection, statementCached,");
        source.append("\"");
        source.append(assocTableSelect, true);
        source.append("\");\n");
        tableView.appendPreparedSet(source, home, "statement", manySideORMapping.getValueField().getType(), new TableIteration(), "this", manySideORMapping.getValueField(), contextName, true);
        source.append("assocTableSet = statement.executeQuery();\nif( assocTableSet.next() )\n{\n");
        EntityBeanCompilation.appendJDBCGetterMethod(local, primaryKeyVariable, source, home, "assocTableSet", manySideORMapping.getKeyField(), new TableIteration(), compilation, contextName, null);
        source.append("}\n}\ncatch(SQLException sqle)\n{\nif (context.localHome != null)\ncontext.localHome.OC4J_log(\"Database Error\", sqle);\nelse\ncontext.remoteHome.OC4J_log(\"Database Error\", sqle);\n" + BeanMethodCompilation.getRollbackTransaction("\"Database error: \" + sqle", "sqle", "transaction", "context.") + "throw com.evermind.server.ejb.EJBUtils.createEJBException(\"Database error: \" + sqle.getMessage(), sqle);\n" + "}\n");
        source.append("finally\n{\nif(assocTableSet != null) assocTableSet.close();\nif(statement !=null) {\n try { statement.close();\n} catch(java.sql.SQLException e) {}\n }\nif(transaction == null && connection != null)\nconnection.release();\n}\n");
        source.append("}\ncatch(java.rmi.RemoteException re)\n{\nthrow com.evermind.server.ejb.EJBUtils.createEJBException(re);\n}\ncatch(java.lang.Exception ge)\n{\nthrow com.evermind.server.ejb.EJBUtils.createEJBException(ge);\n}\n\n");
    }

    public static void appendJDBCGetterMethodCore(boolean _local, ByteString source, boolean home, String setName, ContainerManagedField field, String databaseName, Class propertyType) {
        boolean wasObject = false;
        if (propertyType == Integer.TYPE) {
            source.append(setName + ".getInt(");
        } else if (propertyType == Character.TYPE) {
            source.append("com.evermind.server.ejb.EJBUtils.getChar(" + setName + ", " + databaseName + ")");
            wasObject = true;
        } else if (propertyType == Short.TYPE) {
            source.append(setName + ".getShort(");
        } else if (propertyType == Long.TYPE) {
            source.append(setName + ".getLong(");
        } else if (propertyType == Float.TYPE) {
            source.append(setName + ".getFloat(");
        } else if (propertyType == Double.TYPE) {
            source.append(setName + ".getDouble(");
        } else if (propertyType == Byte.TYPE) {
            source.append(setName + ".getByte(");
        } else if (propertyType == Boolean.TYPE) {
            source.append(setName + ".getBoolean(");
        } else if (propertyType == String.class) {
            if (field.getColumnType() == null) {
                source.append(setName + ".getString(");
            } else if (field.getColumnType().equalsIgnoreCase("CLOB")) {
                source.append("EJBUtils.clobToString(" + setName + ",");
            } else {
                source.append(setName + ".getString(");
            }
        } else if (propertyType == java.util.Date.class) {
            source.append("com.evermind.util.ObjectUtils.toDate(" + setName + ".getTimestamp(" + databaseName + "))");
            wasObject = true;
        } else if (propertyType == InternetAddress.class) {
            source.append("com.evermind.util.ObjectUtils.toInternetAddress(" + setName + ".getString(" + databaseName + "))");
            wasObject = true;
        } else if (propertyType == Date.class) {
            source.append(setName + ".getDate(");
        } else if (propertyType == Timestamp.class) {
            source.append(setName + ".getTimestamp(");
        } else if (propertyType == Time.class) {
            source.append(setName + ".getTime(");
        } else if (propertyType == BigDecimal.class) {
            source.append(setName + ".getBigDecimal(");
        } else if (propertyType == Blob.class) {
            source.append(setName + ".getBlob(");
        } else if (propertyType == Clob.class) {
            source.append(setName + ".getClob(");
        } else if (propertyType == Locale.class) {
            source.append("com.evermind.util.ObjectUtils.toLocale(" + setName + ".getString(" + databaseName + "))");
            wasObject = true;
        } else if (propertyType == BigInteger.class) {
            source.append("com.evermind.util.ObjectUtils.toBigInteger(" + setName + ".getString(" + databaseName + "))");
            wasObject = true;
        } else if (propertyType == Integer.class) {
            source.append("EJBUtils.getInteger(" + setName + ", ");
        } else if (propertyType == Character.class) {
            source.append("EJBUtils.getCharacter(" + setName + ", ");
        } else if (propertyType == Short.class) {
            source.append("EJBUtils.getShort(" + setName + ", ");
        } else if (propertyType == Long.class) {
            source.append("EJBUtils.getLong(" + setName + ", ");
        } else if (propertyType == Float.class) {
            source.append("EJBUtils.getFloat(" + setName + ", ");
        } else if (propertyType == Double.class) {
            source.append("EJBUtils.getDouble(" + setName + ", ");
        } else if (propertyType == Byte.class) {
            source.append("EJBUtils.getByte(" + setName + ", ");
        } else if (propertyType == Boolean.class) {
            source.append("EJBUtils.getBoolean(" + setName + ", ");
        } else if (propertyType == [B.class) {
            if (field.getColumnType() != null && field.getColumnType().equalsIgnoreCase("BLOB")) {
                source.append("EJBUtils.blobToByteArray(" + setName + ",");
            } else {
                source.append("EJBUtils.getContent(" + setName + ".getBinaryStream(" + databaseName + "))");
                wasObject = true;
            }
        } else if (propertyType == [C.class) {
            if (field.getColumnType() != null && field.getColumnType().equalsIgnoreCase("CLOB")) {
                source.append("EJBUtils.clobToCharArray(" + setName + ",");
            } else {
                source.append("EJBUtils.getContent(" + setName + ".getCharacterStream(" + databaseName + "))");
                wasObject = true;
            }
        } else {
            if (_local) {
                source.append("(" + ClassUtils.getSourceNotation(propertyType, 0) + ")com.evermind.server.ejb.EntityEJBObject.deSerialize(" + (home ? "this" : "this.context.localHome") + ", " + setName + ".getBinaryStream(" + databaseName + "))");
            } else {
                source.append("(" + ClassUtils.getSourceNotation(propertyType, 0) + ")com.evermind.server.ejb.EntityEJBObject.deSerialize(" + (home ? "this" : "this.context.remoteHome") + ", " + setName + ".getBinaryStream(" + databaseName + "))");
            }
            wasObject = true;
        }
        if (!wasObject) {
            source.append(databaseName + ")");
        }
    }

    public void appendSaveStateMethod() throws CompilationException {
        ByteString fieldStoreCode;
        StringBuffer sb;
        boolean onlyUpdateEffected = this.descriptor.getUpdateChangedFieldsOnly();
        boolean forceUpdate = this.descriptor.getForceUpdate();
        String quickHome = this.local ? "((EntityEJBHome)context.localHome)" : "((EntityEJBHome)context.remoteHome)";
        boolean generateSaveFieldsCode = true;
        if (this.descriptor.isContainerManaged() && this.persistenceManagerCompilation.table.getFieldCount(false) == 0 && !this.containsORMapping) {
            generateSaveFieldsCode = false;
        }
        if (this.descriptor.isContainerManaged() && this.persistenceManagerCompilation.table.getFieldCount(false) > 0) {
            this.source.append("// ");
            this.source.append(this.persistenceManagerCompilation.table.getPreparedUpdateStatement(true), true);
            this.source.append("\n");
        }
        this.source.append("public void saveState(ApplicationServerTransaction transaction) throws java.rmi.RemoteException\n");
        if (!this.getEntityBeanDescriptor().isContainerManaged() && this.getEntityBeanDescriptor().getLockingMode() == 3) {
            this.source.append("{\nreturn;\n}\n");
            return;
        }
        this.source.append("{\ntraceLog(\"In saveState method, transaction = \" + transaction);\n// isLazy is true only when wrapper acquired from getWrapperByPK and loadState is not invoked.\nif (this.context == null) return;\nif (this.context.isLazy()) return;\nif(this.context.getObject() == null) return;\n");
        if (this.hasIsModifiedMethod) {
            this.source.append("if(((" + this.getCMPClassName() + ")this.context.getObject()).isModified())\n" + "{\n");
            this.source.append("getBeanDescriptor().getLifecycleManager().ejbStore(this.context.getObject(), this.context);\n");
            if (this.descriptor.isContainerManaged()) {
                int fieldCountTot = this.persistenceManagerCompilation.table.getFieldCount(true);
                this.source.append("int fieldCountTot = " + fieldCountTot + " ;\n");
                if (this.cmp2_0) {
                    this.source.append("\n int iSet = 0; \n   while (iSet < fieldCountTot) \n   { \n     this._getObject().__dirtyBSet.set(iSet) ; \n     iSet++ ; \n   }\n");
                } else {
                    this.source.append("\n   int iSet = 0;\n   while (iSet < fieldCountTot) \n   { \n     this.dirtyBSet.set(iSet) ; \n     iSet++ ; \n   }\n");
                }
            }
            this.source.append("}\n\n");
        } else {
            if (this.descriptor.isBMP() && this.descriptor.getCommitOption().isCacheable()) {
                this.appendOCAField(this.source, "this");
            }
            this.source.append("getBeanDescriptor().getLifecycleManager().ejbStore(this.context.getObject(), this.context);\n");
            this.source.append("\n");
        }
        if (!this.descriptor.isReadOnlyBMP() && this.descriptor.isBMP() && this.descriptor.getCommitOption().isCacheableOptionA()) {
            this.source.append("if (transaction == null) {");
            this.source.append("   _cacheMgr.put(getPrimaryKey(), this);");
            this.source.append("\n }");
        }
        if (this.descriptor.isContainerManaged()) {
            if (!forceUpdate) {
                if (this.cmp2_0) {
                    this.source.append("if(this._getObject().__dirtyBSet.length() == 0)\n");
                } else {
                    this.source.append("if(this.dirtyBSet.length() == 0)\n");
                }
                this.source.append("\treturn;\n\n");
            }
            if (this.local) {
                this.source.append("if(context.localHome.getLockingMode() == 3)\n");
            } else {
                this.source.append("if(context.remoteHome.getLockingMode() == 3)\n");
            }
            this.source.append("  throw new java.lang.UnsupportedOperationException(\"You are not supposed to change anything in a read-only bean\");\n\n");
        }
        if (!this.hasIsModifiedMethod && this.descriptor.isContainerManaged()) {
            if (this.cmp2_0) {
                this.source.append("\nBitSet dirtyBSet = (BitSet)this._getObject().__dirtyBSet.clone();\nint i ; \n   while ((i = this._getObject().__dirtyBSet.length()) !=0) \n   { \n     this._getObject().__dirtyBSet.clear(i-1) ; \n   }\n");
            } else {
                this.source.append("\nBitSet dirtyBSet = (BitSet)this.dirtyBSet.clone();\nint i ; \n   while ((i = this.dirtyBSet.length()) !=0) \n   { \n     this.dirtyBSet.clear(i-1) ; \n   }\n");
            }
        }
        if (generateSaveFieldsCode && this.descriptor.isContainerManaged()) {
            Vector _lobVariables = new Vector();
            sb = new StringBuffer("");
            this.persistenceManagerCompilation.appendLOBDeclareCode(sb, _lobVariables);
            this.source.append(sb.toString());
            fieldStoreCode = new ByteString();
            if (this.persistenceManagerCompilation.appendEJBStoreCode(fieldStoreCode, onlyUpdateEffected, _lobVariables)) {
                if (this.local) {
                    this.source.append("DataSourceConnection connection = transaction == null ? ((EntityEJBHome)context.localHome).dataSourceContainer.getLocalConnection() : transaction.getLocalConnection(((EntityEJBHome)context.localHome).dataSourceContainer);\n");
                } else {
                    this.source.append("DataSourceConnection connection = transaction == null ? ((EntityEJBHome)context.remoteHome).dataSourceContainer.getConnection() : transaction.getConnection(((EntityEJBHome)context.remoteHome).dataSourceContainer);\n");
                }
                this.source.append("String sqlStatement = \"\";");
                this.source.append("\ntry\n{\n");
                this.source.append(fieldStoreCode);
                this.source.append("if(transaction == null)\n{\nconnection.release();\nconnection = null;\n");
                if (!this.descriptor.hasExclusiveWriteAccess()) {
                    this.source.append("this.connection = null;\n");
                }
                this.source.append("}\n}\ncatch(SQLException e)\n{\n");
                this.source.append("throw new java.rmi.RemoteException( \"SQLException in update\", e );\n");
                this.source.append("}\n");
            }
        }
        this.source.append("stateChanged(transaction);\n\n}\n");
        this.source.append("public void updateFieldsBeforeLoadState() \n");
        this.source.append("{\nString sqlStatement = \"\";\nDataSourceConnection connection = null;\ntraceLog(\"In insertCMR method, transaction = \" + transaction);\nif(this.context == null) return;\nif(this.context.getObject() == null) return;\n");
        if (this.descriptor.isContainerManaged()) {
            if (!forceUpdate) {
                if (this.cmp2_0) {
                    this.source.append("if(this._getObject().__dirtyBSet.length() == 0)\n");
                } else {
                    this.source.append("if(this.dirtyBSet.length() == 0)\n");
                }
                this.source.append("\treturn;\n\n");
            }
            this.source.append("if (" + quickHome + ".getLockingMode() == " + 3 + ")\n" + "  throw new java.lang.UnsupportedOperationException(\"You are not supposed to change anything in a read-only bean\");\n" + "\n");
        }
        if (!this.hasIsModifiedMethod && this.descriptor.isContainerManaged()) {
            if (this.cmp2_0) {
                this.source.append("\nBitSet dirtyBSet = (BitSet)_getObject().__dirtyBSet.clone();\nint i ; \n   while ((i = this._getObject().__dirtyBSet.length()) !=0) \n   { \n     this._getObject().__dirtyBSet.clear(i-1) ; \n   }\n");
            } else {
                this.source.append("\nBitSet dirtyBSet = (BitSet)this.dirtyBSet.clone();\nint i ; \n   while ((i = this.dirtyBSet.length()) !=0) \n   { \n     this.dirtyBSet.clear(i-1) ; \n   }\n");
            }
        }
        if (generateSaveFieldsCode && this.descriptor.isContainerManaged()) {
            Vector _lobVariables = new Vector();
            sb = new StringBuffer("");
            this.persistenceManagerCompilation.appendLOBDeclareCode(sb, _lobVariables);
            this.source.append(sb.toString());
            fieldStoreCode = new ByteString();
            if (this.persistenceManagerCompilation.appendEJBStoreCode(fieldStoreCode, onlyUpdateEffected, _lobVariables)) {
                this.source.append("ApplicationServerTransaction transaction=" + EJBCompilationUtils.getTransactionString() + ";\n");
                if (!this.local) {
                    this.source.append("try{\n");
                }
                this.source.append("connection = transaction == null ? " + quickHome + ".dataSourceContainer.get" + (this.local ? "Local" : "") + "Connection() : transaction.get" + (this.local ? "Local" : "") + "Connection(" + quickHome + ".dataSourceContainer);\n");
                if (!this.local) {
                    this.source.append("}catch(java.rmi.RemoteException re){\nre.printStackTrace();\n}\n");
                }
                this.source.append("try\n{\n");
                this.source.append(fieldStoreCode);
                this.source.append("}\ncatch(SQLException e)\n{\nString aMessage = null;\nif (SystemProperties.SQLLOG) \n{\naMessage = e.getMessage() +  sqlStatement;\n}\nelse \n{\naMessage = e.getMessage();\n}\nthrow com.evermind.server.ejb.EJBUtils.createEJBException(\"Error saving state: \" + aMessage);\n}\n");
                this.source.append("finally\n{\nif(transaction == null && connection != null)\n{\nconnection.release();\nconnection = null;\n}\n}\n");
            }
        }
        this.source.append("}\n");
    }

    public void appendGetPrimaryKeyMethod() {
        this.source.append("\npublic Object getPrimaryKey()\n{\n");
        if (!this.descriptor.isContainerManaged() || this.descriptor.getPrimaryKeyFieldName() != null || this.descriptor.isAutomaticIdentity()) {
            this.source.append("if(this.primaryKey == null) com.evermind.server.ejb.EJBUtils.throwGetPrimaryKeyInEJBCreateException();\nreturn this.primaryKey;\n");
        } else {
            boolean first = true;
            Iterator iterator = this.descriptor.getPrimaryKey().getPropertyFields().iterator();
            ByteString fillSource = new ByteString(100);
            ByteString pkCheckString = new ByteString("if(");
            this.source.append("if(__key == null) {\n");
            this.source.append(this.descriptor.getPrimaryKeyClassName() + " __tempkey = new " + this.descriptor.getPrimaryKeyClassName() + "();\n");
            boolean isAlreadyAppended = false;
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                if (!first && !isAlreadyAppended) {
                    pkCheckString.append(" || ");
                    isAlreadyAppended = true;
                }
                if (!ServerProperties.getAllowZeroInPK()) {
                    pkCheckString.append("__" + field.getName() + " == " + ClassUtils.getDefaultValue(field.getType()));
                    first = false;
                    isAlreadyAppended = false;
                } else if (ClassUtils.getDefaultValue(field.getType()).compareTo("null") == 0) {
                    pkCheckString.append("__" + field.getName() + " == null");
                    first = false;
                    isAlreadyAppended = false;
                }
                fillSource.append("__tempkey." + field.getName() + " = __" + field.getName() + ";\n");
            }
            if (!first) {
                String pkCheckStr = pkCheckString.toString().trim();
                if (pkCheckStr.endsWith("||")) {
                    pkCheckStr = pkCheckStr.substring(0, pkCheckStr.lastIndexOf("||") - 1);
                }
                this.source.append(pkCheckStr);
                this.source.append(") throw new IllegalStateException(\"Invalid PK field value in getPrimaryKey()\");\n");
            }
            this.source.append(this.descriptor.getPrimaryKeyClassName() + " key = new " + this.descriptor.getPrimaryKeyClassName() + "();\n");
            this.source.append(fillSource);
            this.source.append("__key = __tempkey;\n");
            this.source.append("}\n");
            this.source.append("return this.__key;\n");
        }
        this.source.append("}\n\n");
    }

    public void checkPrimaryKeyIntegrity() throws CompilationException {
        Class primaryKeyClass = this.descriptor.getPrimaryKeyClass();
        Class beanClass = this.descriptor.getEJBClass();
        if (primaryKeyClass == null) {
            throw new CompilationException("PrimaryKey class not found/specified");
        }
    }

    public void addGetTrailMethod() {
        this.source.append("\npublic com.evermind.server.ejb.EntityEJBObject __getTrail()\n{\nreturn this.trail;\n}\n");
    }

    public void addReActivateNewMethod() {
        if (this.local) {
            this.source.append("public void reActivateNew(boolean aLoadRequired) throws java.rmi.RemoteException {\n");
            this.source.append("    reActivateNewLocal(aLoadRequired);\n");
            this.source.append("}\n");
        }
        this.source.append("protected void OC4J_reActivateNew(ThreadState state, boolean aLoadRequired) throws Exception {\n");
        this.source.append("boolean contextCreated = false;\n");
        this.source.append("EvermindEntityContext context = ((" + this.home.getName() + ")this.getMyHome()).findContextInstanceTx(state, getPrimaryKey(), this);\n");
        this.source.append("if (context == null) {\n");
        this.source.append("context = ((" + this.home.getName() + ")this.getMyHome()).getContextInstance();\n");
        this.source.append("contextCreated = true;\n");
        this.source.append("}\n");
        if (this.local) {
            this.source.append("context.localWrapper = this;\n");
        } else {
            this.source.append("context.remoteWrapper = this;\n");
        }
        this.source.append("this.context = context;\n");
        this.appendCopyObjectPkFieldFromWrapper(this.source, "this");
        this.source.append("if (contextCreated) {\n");
        if (!(this.descriptor.isReadOnlyBMP() || this.descriptor.isBMP() && this.descriptor.getCommitOption().isCacheableOptionA())) {
            this.appendEjbActivate(this.source, "this");
        }
        this.source.append("com.evermind.server.ApplicationServerTransaction transaction = (com.evermind.server.ApplicationServerTransaction)" + EJBCompilationUtils.getTransactionString() + ";\n");
        this.source.append("if (transaction != null) " + EJBCompilationUtils.getRegisterBeanString("this") + ";\n");
        this.source.append("if(aLoadRequired && this.context.isLazy()) loadState(" + EJBCompilationUtils.getTransactionString() + ");\n");
        this.source.append("}\n");
        this.source.append("else if (transaction != null)\n");
        this.source.append(EJBCompilationUtils.getRegisterBeanString("this") + ";\n");
        this.source.append("}\n");
    }

    public void addIsIdenticalMethod() {
        if (this.local) {
            this.source.append("public boolean isIdentical(EJBObject other)\n{\nreturn other instanceof EJBLocalObject ? isIdentical((EJBLocalObject)other) : false;\n}\n\n");
        }
        if (this.local) {
            this.source.append("public boolean isIdentical(EJBLocalObject other)\n");
            this.source.append("{\nif(other == null) return false;\nreturn this.getClass() == other.getClass() && ((EntityEJBHome)getMyHome()).equalKeys(other.getPrimaryKey(), this.getPrimaryKey());\n}\n\n");
        } else {
            this.source.append("public boolean isIdentical(EJBObject other) throws java.rmi.RemoteException\n");
            this.source.append("{\nif(other == null) return false;\nif(other instanceof javax.rmi.CORBA.Stub)\nreturn getMyHome().getApplication().getTransportManager().isIdentical( this, (javax.rmi.CORBA.Stub) other );\nelse \nreturn this.getClass() == other.getClass() && ((EntityEJBHome)getMyHome()).equalKeys(other.getPrimaryKey(), this.getPrimaryKey());\n}\n\n");
        }
    }

    public void addIsRecursiveMethod() {
        this.source.append("public boolean OC4J_isRecursive()\n{\nreturn " + this.descriptor.isReentrant() + ";\n" + "}\n" + "\n");
    }

    protected ByteString createStateKeepers() {
        ByteString _source = new ByteString(300);
        if (this.descriptor.isContainerManaged() && !this.hasIsModifiedMethod) {
            Iterator iterator = this.persistenceManagerCompilation.table.getFields().iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                if (field.getORMapping() != null && !field.getType().isArray()) continue;
                Class type = field.getType();
                _source.append("");
                _source.append(ClassUtils.getSourceNotation(type, 0));
                _source.append(" _" + field.getName() + " = ");
                this.compilation.appendCloneSource("", false, _source, "this._getObject()", "this.context", field, "_" + field.getName(), this.local);
            }
        }
        return _source;
    }

    protected ByteString createCheckStateKeepers() {
        ByteString _source = new ByteString(300);
        if (this.descriptor.isContainerManaged() && !this.hasIsModifiedMethod) {
            int currentIndex = 0;
            boolean firstField = true;
            Iterator iterator = this.persistenceManagerCompilation.table.getFields().iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                firstField = false;
                _source.append("if(");
                if (field.getORMapping() != null && !field.getType().isArray()) {
                    if (field.getORMapping() instanceof CollectionORMapping) {
                        CollectionORMapping collectionMapping = (CollectionORMapping)field.getORMapping();
                        if (field.getType() == (class$java$util$Collection == null ? EntityBeanCompilation.class$("java.util.Collection") : class$java$util$Collection)) {
                            _source.append("(!(this._getObject()." + field.getName() + " instanceof ORCollection) || ((ORCollection)this._getObject()." + field.getName() + ").isDirty())");
                        } else if (field.getType() == (class$java$util$Set == null ? EntityBeanCompilation.class$("java.util.Set") : class$java$util$Set)) {
                            _source.append("(!(this._getObject()." + field.getName() + " instanceof ORSet) || ((ORSet)this._getObject()." + field.getName() + ").isDirty())");
                        } else {
                            boolean isVector;
                            boolean bl = isVector = field.getType() == (class$java$util$Vector == null ? EntityBeanCompilation.class$("java.util.Vector") : class$java$util$Vector);
                            if (isVector) {
                                _source.append("(!(this._getObject()." + field.getName() + " instanceof ORVector) || ((ORVector)this._getObject()." + field.getName() + ").list.isDirty())");
                            } else {
                                _source.append("(!(this._getObject()." + field.getName() + " instanceof ORList) || ((ORList)this._getObject()." + field.getName() + ").isDirty())");
                            }
                        }
                    }
                } else if (field.getType().isPrimitive()) {
                    _source.append("_" + field.getName() + " != this._getObject()." + field.getName());
                } else {
                    _source.append("((_" + field.getName() + " == null) != (this._getObject()." + field.getName() + " == null)) || (_" + field.getName() + " != null && !_" + field.getName() + ".equals(this._getObject()." + field.getName() + "))");
                }
                if (this.cmp2_0) {
                    _source.append(") this._getObject().__dirtyBSet.set(" + currentIndex + ");\n");
                } else {
                    _source.append(") dirtyBSet.set(" + currentIndex + ");\n");
                }
                ++currentIndex;
            }
        }
        return _source;
    }

    public void appendSetObjectMethod() {
        this.source.append("public void setEntityBean(EntityBean bean)\n{\nif (com.evermind.util.ServerProperties.getEjbAssert()){\n if(bean == null && this.context.getObject() != null && ThreadState.getCurrentState() != currentCaller)\n {\n  System.err.println(\"Current:\\n\" + ThreadState.dump(ThreadState.getCurrentState()));\n  System.err.println(\"Caller :\\n\" + ThreadState.dump(currentCaller));\n  throw new InternalError(\"Werent current caller, server stacktrace (to disable this message, use -Dejb.assert=false at startup): \" + com.evermind.server.ejb.EJBUtils.toString(new Throwable(\"Werent current caller\")));\n }\n}\nthis.context.setObject((" + this.getCMPClassName() + ")bean);\n" + "}\n" + "\n");
    }

    public void appendGetObjectMethod() {
        this.source.append("public EntityBean getEntityBean()\n{\nreturn this.context.getObject();\n}\n\n");
        this.source.append("public " + this.getCMPClassName() + " _getObject()\n" + "{\n" + "return (" + this.getCMPClassName() + ") this.context.getObject();\n" + "}\n" + "\n");
    }

    public void appendFieldReset(ByteString buffer, String variable) {
        Iterator iterator = this.descriptor.getContainerManagedFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            buffer.append(variable + "." + field.getName() + " = " + ClassUtils.getDefaultValue(field.getType()) + ";\n");
            if (!this.descriptor.isContainerManaged() || !field.isOCA()) continue;
            buffer.append(variable + "." + field.getName() + "Changed = false;\n");
        }
        if (this.descriptor.getContainerManagedFields().size() > 0) {
            String dirtyString = variable + ".__dirtyBSet";
            buffer.append("int i; \nwhile ((i = " + dirtyString + ".length()) !=0) \n" + "{ \n" + "" + dirtyString + ".clear(i-1) ; \n" + "}\n");
        }
    }

    private void appendOCAField(ByteString buffer, String aVariable) {
        Iterator iterator = this.descriptor.getContainerManagedFields().iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (this.descriptor.isContainerManaged() || !field.isOCA()) continue;
            buffer.append("if (this._cacheMgr.allowToUpdate(" + aVariable + ", \"" + field.getName() + "\"))\n");
        }
    }

    public void appendSerialization() {
        this.source.append("// Begin Serialization Code\n");
        this.appendSerialVersionUID();
        this.source.append("// End Serialization Code\n");
    }

    private void appendSerialVersionUID() {
        this.source.append("static final long serialVersionUID = ApplicationServer.computeSerialVersionUID(\"" + this.className + "\");\n");
    }

    public DatabaseSchema getSchema() {
        return this.schema;
    }

    public EJBContainer getContainer() {
        return this.container;
    }

    public String getCMPClassName() {
        if (this.persistenceManagerCompilation != null) {
            return this.persistenceManagerCompilation.getName();
        }
        return this.descriptor.getEJBClassName();
    }

    public void appendCopyObjectPkFieldFromWrapper(ByteString source, String wrapperName) {
        if (this.descriptor.isContainerManaged()) {
            if (this.descriptor.getPrimaryKeyFieldName() != null) {
                source.append("");
                source.append(wrapperName);
                source.append("._getObject().");
                source.append(this.descriptor.getPrimaryKeyFieldName());
                source.append(" = ");
                source.append(ClassUtils.getConvertSource(wrapperName + ".primaryKey", this.descriptor.getPrimaryKeyClass(), this.descriptor.getPrimaryKey().getType()));
                source.append(";\n");
            } else if (!this.descriptor.isAutomaticIdentity()) {
                Iterator iterator = this.descriptor.getPrimaryKey().getPropertyFields().iterator();
                while (iterator.hasNext()) {
                    ContainerManagedField field = (ContainerManagedField)iterator.next();
                    source.append("");
                    source.append(wrapperName);
                    source.append("._getObject().");
                    source.append(field.getName());
                    source.append(" = ");
                    source.append(wrapperName);
                    source.append(".__");
                    source.append(field.getName());
                    source.append(";\n");
                }
            }
        }
    }

    private void appendEjbActivate(ByteString source, String wrapperName) {
        source.append("getBeanDescriptor().getLifecycleManager().postActivate(" + wrapperName + ".context.getObject(), " + wrapperName + ".context);\n");
    }

    public String getFieldPersistenceManagerReference(String name) {
        String varName;
        if (this.fieldPersistenceManagers == null) {
            this.fieldPersistenceManagers = new HashMap();
        }
        if ((varName = (String)this.fieldPersistenceManagers.get(name)) == null) {
            varName = "_FIELD_PERSISTENCEMANAGER" + this.fieldPersistenceManagers.size();
            this.fieldPersistenceManagers.put(name, varName);
        }
        return varName;
    }

    public ORCompilation createORCompilation(ContainerManagedField field, ORCompilation slave) throws CompilationException {
        if (field.getORMapping() instanceof CollectionORMapping) {
            ORCompilation orCompilation = field.getPersistenceType() == 7 ? new ORSetCompilation(slave, this.local) : new ORCollectionCompilation(slave, this.local);
            return orCompilation;
        }
        throw new InternalError("Unsupported OR type: " + field.getORMapping().getClass());
    }

    public void appendUpdateOneToOneMethod() {
        this.source.append("public void __updateOneToOneCore(String name, Object newValue)\n{\n");
        Iterator iterator = this.oneToOneFields.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (!first) {
                this.source.append("else ");
            }
            this.source.append("if(name.equals(\"" + field.getName() + "\"))\n" + "{\n" + "String token = \"white\";\n" + this.persistenceManagerCompilation.getName() + " instance = (" + this.persistenceManagerCompilation.getName() + ")context.getObject();\n");
            this.source.append(ClassUtils.getSourceNotation(field.getType(), 0) + " oldValue = instance." + field.getName() + ";\n");
            this.source.append("com.evermind.server.ejb.EJBUtils.confirmAlive(oldValue);\n");
            this.source.append("if(newValue instanceof String && ((String)newValue).equals(\"gray\")){\ntoken = \"black\";\nnewValue = null;\n}\n");
            this.source.append("if(newValue instanceof String && ((String)newValue).equals(\"white\")){\ntoken = \"gray\";\nnewValue = null;\n}\n");
            if (field.getPeer().getRelation() != null) {
                this.source.append("if(!token.equals(\"black\") && oldValue != null && !((AbstractEJBObject)oldValue).isIdentical_Y((AbstractEJBObject)newValue)) ((com.evermind.server.ejb.EntityEJBObject)oldValue).__updateOneToOne(\"" + field.getPeer().getRelation().getName() + "\", token);\n");
            }
            this.source.append("instance." + field.getName() + " = (" + ClassUtils.getSourceNotation(field.getType(), 0) + ")newValue;\n");
            if (!field.isCMRPK()) {
                this.source.append("instance.__setDirty(\"" + field.getName() + "\");\n");
                this.source.append("updateFieldsBeforeLoadState();\n");
            }
            this.source.append("}\n");
            first = false;
        }
        this.source.append("else throw com.evermind.server.ejb.EJBUtils.createEJBException(\"Unknown field: \" + name);\n}\n");
    }

    private void appendOneToOneGetMasterInSlaveBean(ContainerManagedField field) {
        this.source.append("\npublic AbstractEJBObject getOneToOneOwner" + field.getPeerName() + "_" + field.getPureName() + "(ApplicationServerTransaction _tx) {\n");
        this.source.append("// getHomeLocal_or_Remote is a kludge because I did not know the peer bean is local or remote...\n");
        this.source.append("com.evermind.server.ejb.EntityEJBHome peerHome =  (com.evermind.server.ejb.EntityEJBHome) getMyHome().getHomeLocal_or_Remote(\"" + field.getEJBReferenceHome() + "\");\n");
        this.source.append("return peerHome.getOneToOneOwnerFor(\"" + this.getDescriptor().getName() + "_" + field.getPureName() + "\", getPrimaryKey(), _tx);\n");
        this.source.append("}\n\n");
    }

    private void appendOneToOneGetMasterInSlaveBean() {
        Iterator iterator = this.oneToOneFields.iterator();
        while (iterator.hasNext()) {
            ContainerManagedField field = (ContainerManagedField)iterator.next();
            if (!field.isUniDirectional() || field.isMasterInUniDirectional()) continue;
            this.appendOneToOneGetMasterInSlaveBean(field);
        }
    }

    public void appendGetDelayUpdateUntilCommit() {
        this.source.append("public boolean getDelayUpdatesUntilCommit()\n{\nreturn " + this.descriptor.getDelayUpdatesUntilCommit() + ";\n" + "}\n" + "\n");
    }

    public void reset() {
        if (this.containerManagedFields != null) {
            for (int i = 0; i < this.containerManagedFields.length; ++i) {
                ContainerManagedField field = this.containerManagedFields[i];
                if (field.getORMapping() == null) continue;
                field.getORMapping().compilation = null;
            }
        }
        this.descriptor.setEntityBeanCompilation(null, true);
        this.descriptor.setEntityBeanCompilation(null, false);
    }

    public void cleanSource() {
        this.resetSource();
        if (this.beanClassSerialization != null) {
            this.beanClassSerialization = null;
        }
        if (this.beanClassData != null) {
            this.beanClassData = null;
        }
    }
}

